/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service;

import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.impl.MigrationSettingsType;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;

public abstract class DefaultTypeSettings {
    private final Supplier<PluginSettings> pluginSettingsSupplier = () -> ((PluginSettingsFactory)pluginSettingsFactory).createGlobalSettings();
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final MigrationSettingsType migrationSettingsType;
    private String settingsTypeKey;

    protected DefaultTypeSettings(PluginSettingsFactory pluginSettingsFactory, MigrationAgentConfiguration migrationAgentConfiguration, MigrationSettingsType migrationSettingsType) {
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.migrationSettingsType = migrationSettingsType;
    }

    @PostConstruct
    public void initialize() {
        this.settingsTypeKey = String.format("%s:%s", new Object[]{this.migrationAgentConfiguration.getPluginKey(), this.migrationSettingsType});
        if (this.getSettings() == null) {
            this.putSettings(this.getDefaultPluginSettings());
        }
    }

    public Object getSettings() {
        String settingsTypeValue = (String)this.pluginSettingsSupplier.get().get(this.settingsTypeKey);
        if (settingsTypeValue == null) {
            return null;
        }
        return this.mapStringToObject(settingsTypeValue);
    }

    public void putSettings(Object settingsTypeValue) {
        if (!this.isValidSettings(settingsTypeValue)) {
            throw new IllegalArgumentException("Invalid settings for " + (Object)((Object)this.migrationSettingsType));
        }
        this.pluginSettingsSupplier.get().put(this.settingsTypeKey, (Object)Jsons.valueAsString(settingsTypeValue));
    }

    protected abstract boolean isValidSettings(Object var1);

    public Object mapStringToObject(String settingsTypeValue) {
        return settingsTypeValue;
    }

    protected abstract Object getDefaultPluginSettings();
}

