/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import org.slf4j.Logger;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class InlineTaskStore {
    private static final Logger log = ContextLoggerFactory.getLogger(InlineTaskStore.class);
    public static final String INLINE_TASKS_PLUGIN_TABLENAME = "AO_BAF3AA_AOINLINE_TASK";
    private static final String[] COLUMN_NAMES = new String[]{"ASSIGNEE_USER_KEY", "BODY", "COMPLETE_DATE", "COMPLETE_USER_KEY", "CONTENT_ID", "CREATE_DATE", "CREATOR_USER_KEY", "DUE_DATE", "GLOBAL_ID", "ID", "TASK_STATUS", "UPDATE_DATE"};
    private static final CsvPreference DEFAULT_PREFERENCE = new CsvPreference.Builder(CsvPreference.EXCEL_PREFERENCE).useQuoteMode((csvColumn, csvContext, csvPreference) -> Objects.nonNull(csvColumn)).build();
    private final EntityManagerTemplate tmpl;
    private final MigrationAgentConfiguration config;
    private final BootstrapManager bootstrapManager;

    public InlineTaskStore(EntityManagerTemplate tmpl, MigrationAgentConfiguration config, BootstrapManager bootstrapManager) {
        this.tmpl = tmpl;
        this.config = config;
        this.bootstrapManager = bootstrapManager;
    }

    public void exportTasksToStream(List<Long> contentIds, OutputStream os) throws IOException {
        CsvListWriter csvWriter = new CsvListWriter((Writer)new OutputStreamWriter(os, StandardCharsets.UTF_8), DEFAULT_PREFERENCE);
        csvWriter.writeHeader(COLUMN_NAMES);
        HashSet<Long> uniqueIds = new HashSet<Long>(contentIds);
        Iterable partitions = Iterables.partition(uniqueIds, (int)this.config.getDBQueryParameterLimit());
        for (List partition : partitions) {
            List<Tuple> tasksBatch = this.tmpl.nativeQuery(Tuple.class, this.selectTasksQuery()).param("contentIds", (Object)partition).list();
            for (Tuple tuple : tasksBatch) {
                csvWriter.write(Arrays.stream(COLUMN_NAMES).map(column -> this.getObject(tuple, (String)column)).collect(Collectors.toList()));
            }
        }
        csvWriter.flush();
    }

    private Object getObject(Tuple tuple, String column) {
        try {
            if ("BODY".equals(column)) {
                Clob clob = (Clob)tuple.get("BODY", Clob.class);
                return clob.getSubString(1L, (int)clob.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tuple.get(column);
    }

    private String selectTasksQuery() {
        try {
            ApplicationConfiguration applicationConfig = this.bootstrapManager.getApplicationConfig();
            String dialect = (String)applicationConfig.getProperty((Object)"hibernate.dialect");
            log.debug("Resolved hibernate dialect: {}", (Object)dialect);
            if (dialect != null && dialect.toLowerCase().contains("mysql")) {
                return "select * from AO_BAF3AA_AOINLINE_TASK entity where CONTENT_ID in (:contentIds)";
            }
            if (dialect != null && dialect.toLowerCase().contains("sqlserver")) {
                return "SELECT ASSIGNEE_USER_KEY,\nCAST(BODY AS NVARCHAR(max)) as BODY,\nCOMPLETE_DATE,\nCOMPLETE_USER_KEY,\nCONTENT_ID,\nCREATE_DATE,\nCREATOR_USER_KEY,\nDUE_DATE,\nGLOBAL_ID,\nID,\nTASK_STATUS,\nUPDATE_DATE\nFROM \"AO_BAF3AA_AOINLINE_TASK\" entity where \"CONTENT_ID\" in (:contentIds)";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "select * from \"AO_BAF3AA_AOINLINE_TASK\" entity where \"CONTENT_ID\" in (:contentIds)";
    }
}

