/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.encryption;

import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.service.encryption.EncryptionConfigHandler;
import com.atlassian.migration.agent.service.encryption.SecretStoreLocationType;
import com.atlassian.migration.agent.service.encryption.exception.EncryptionException;
import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionSecretManager {
    private final MigrationAgentConfiguration configuration;
    private final EncryptionConfigHandler encryptionConfigHandler;
    private final String encryptionAlgorithm = "AES";

    public EncryptionSecretManager(MigrationAgentConfiguration migrationAgentConfiguration, EncryptionConfigHandler configSecretGeneratorRetriever) {
        this.configuration = migrationAgentConfiguration;
        this.encryptionConfigHandler = configSecretGeneratorRetriever;
    }

    public SecretKey getEncryptionSecret() throws EncryptionException {
        try {
            byte[] secret;
            byte[] byArray = secret = this.encryptionConfigHandler.doesStorageTypeExist() ? this.getEncryptionSecretWhenLocationTypeIsConfigured() : this.getEncryptionSecretWhenLocationTypeIsNotConfigured();
            if (secret.length == 0) {
                throw new EncryptionException("Key Length is Zero");
            }
            return new SecretKeySpec(secret, "AES");
        }
        catch (Exception e) {
            throw new EncryptionException(e.getMessage());
        }
    }

    private byte[] getEncryptionSecretWhenLocationTypeIsConfigured() throws EncryptionException {
        return this.getEncryptionSecretByStorage(this.encryptionConfigHandler.getKeyLocationFromConfig());
    }

    private byte[] getEncryptionSecretWhenLocationTypeIsNotConfigured() throws EncryptionException {
        SecretStoreLocationType secretStoreLocationType = this.isEncryptionKeyFromEnvEmpty() ? SecretStoreLocationType.CCMA_GENENRATED : SecretStoreLocationType.ENV_VAR;
        this.encryptionConfigHandler.setKeyLocationInConfig(secretStoreLocationType);
        return this.getEncryptionSecretByStorage(secretStoreLocationType);
    }

    private byte[] getEncryptionSecretByStorage(SecretStoreLocationType secretStoreLocationType) throws EncryptionException {
        try {
            switch (secretStoreLocationType) {
                case CCMA_GENENRATED: {
                    return this.encryptionConfigHandler.getKeyFromConfig();
                }
                case ENV_VAR: {
                    if (this.isEncryptionKeyFromEnvEmpty()) {
                        throw new EncryptionException("Encryption Key is Empty");
                    }
                    return this.configuration.getEncryptionKeyFromEnv().getBytes(StandardCharsets.UTF_8);
                }
            }
            throw new EncryptionException("Unsupported Storage Type");
        }
        catch (Exception e) {
            throw new EncryptionException(e.getMessage());
        }
    }

    private boolean isEncryptionKeyFromEnvEmpty() {
        return this.configuration.getEncryptionKeyFromEnv() == null || this.configuration.getEncryptionKeyFromEnv().trim().isEmpty();
    }
}

