/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.email;

import com.atlassian.migration.agent.dto.DuplicateEmailsConfigDto;
import com.atlassian.migration.agent.dto.InvalidEmailsConfigDto;
import com.atlassian.migration.agent.service.email.DuplicateEmailsFixResult;
import com.atlassian.migration.agent.service.email.GlobalEmailFixesConfigService;
import com.atlassian.migration.agent.service.email.InvalidEmailsFixResult;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class GlobalUnsupportedUserHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalUnsupportedUserHandler.class);
    private final GlobalEmailFixesConfigService fixesConfigService;

    public GlobalUnsupportedUserHandler(GlobalEmailFixesConfigService fixesConfigService) {
        this.fixesConfigService = fixesConfigService;
    }

    public InvalidEmailsFixResult applyInvalidEmailsStrategy(List<MigrationUser> invalidUsers) {
        InvalidEmailsConfigDto config = this.fixesConfigService.getInvalidEmailsConfig();
        switch (config.getActionOnMigration()) {
            case DO_NOTHING: {
                return new InvalidEmailsFixResult.Builder().invalidUsers(invalidUsers).build();
            }
            case TOMBSTONE_ALL: {
                return new InvalidEmailsFixResult.Builder().tombstoneUsers(invalidUsers).build();
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)config.getActionOnMigration()));
    }

    public DuplicateEmailsFixResult applyDuplicateEmailsStrategy(List<MigrationUser> duplicateUsers) {
        DuplicateEmailsConfigDto config = this.fixesConfigService.getDuplicateEmailsConfig();
        switch (config.getActionOnMigration()) {
            case DO_NOTHING: {
                return new DuplicateEmailsFixResult.Builder().duplicateUsers(duplicateUsers).build();
            }
            case MERGE_ALL: {
                return new DuplicateEmailsFixResult.Builder().mergeUsers(duplicateUsers).build();
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)config.getActionOnMigration()));
    }
}

