/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.encryption;

import com.atlassian.migration.agent.service.encryption.EncryptionSecretManager;
import com.atlassian.migration.agent.service.encryption.exception.EncryptionException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public class EncryptionService {
    private final EncryptionSecretManager encryptionSecretManager;
    private static final int IV_LENGTH = 12;
    private static final String PREFIX = "encrypted_";

    public EncryptionService(EncryptionSecretManager encryptionSecretManager) {
        this.encryptionSecretManager = encryptionSecretManager;
    }

    public String encrypt(String token) throws EncryptionException {
        try {
            if (this.verifyEncrypted(token)) {
                return token;
            }
            byte[] plainText = token.getBytes(StandardCharsets.UTF_8);
            byte[] iv = EncryptionService.generateIV();
            SecretKey secretKey = this.encryptionSecretManager.getEncryptionSecret();
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)secretKey, parameterSpec);
            byte[] encryptedtext = cipher.doFinal(plainText);
            byte[] mergedEncryptedtext = EncryptionService.merge(iv, encryptedtext);
            byte[] finalEncryptedText = Base64.getEncoder().encode(mergedEncryptedtext);
            byte[] finaloutput = this.addPrefix(finalEncryptedText, PREFIX);
            return new String(finaloutput, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new EncryptionException(e.getMessage());
        }
    }

    public String decrypt(String crypticText) throws EncryptionException {
        try {
            if (!this.verifyEncrypted(crypticText)) {
                throw new EncryptionException("Trying to decrypt unencrypted text");
            }
            byte[] encryptedText = crypticText.getBytes(StandardCharsets.UTF_8);
            encryptedText = this.removePrefix(encryptedText, PREFIX.length());
            encryptedText = Base64.getDecoder().decode(encryptedText);
            SecretKey secretKey = this.encryptionSecretManager.getEncryptionSecret();
            String[] splitText = new String(encryptedText, StandardCharsets.UTF_8).split("-");
            byte[] retrievedIV = Base64.getDecoder().decode(splitText[0]);
            byte[] retrievedEncryptedText = Base64.getDecoder().decode(splitText[1]);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, retrievedIV);
            cipher.init(2, (Key)secretKey, parameterSpec);
            byte[] decryptedBytes = cipher.doFinal(retrievedEncryptedText);
            return new String(decryptedBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new EncryptionException(e.getMessage());
        }
    }

    private static byte[] generateIV() throws NoSuchAlgorithmException {
        SecureRandom random = SecureRandom.getInstanceStrong();
        byte[] iv = new byte[12];
        random.nextBytes(iv);
        return iv;
    }

    private boolean verifyEncrypted(String encryptedText) {
        return encryptedText.startsWith(PREFIX);
    }

    private static byte[] merge(byte[] iv, byte[] encryptedtext) {
        String encodedIV = Base64.getEncoder().encodeToString(iv);
        String encodedEncryptedText = Base64.getEncoder().encodeToString(encryptedtext);
        String concatenatedText = encodedIV + "-" + encodedEncryptedText;
        return concatenatedText.getBytes(StandardCharsets.UTF_8);
    }

    private byte[] addPrefix(byte[] array, String prefix) {
        byte[] prefixBytes = prefix.getBytes(StandardCharsets.UTF_8);
        byte[] prefixedArray = new byte[prefixBytes.length + array.length];
        System.arraycopy(prefixBytes, 0, prefixedArray, 0, prefixBytes.length);
        System.arraycopy(array, 0, prefixedArray, prefixBytes.length, array.length);
        return prefixedArray;
    }

    private byte[] removePrefix(byte[] array, int prefixLength) {
        byte[] removedPrefixArray = new byte[array.length - prefixLength];
        System.arraycopy(array, prefixLength, removedPrefixArray, 0, array.length - prefixLength);
        return removedPrefixArray;
    }
}

