/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.encryption;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.service.encryption.SecretStoreLocationType;
import com.atlassian.migration.agent.service.encryption.exception.EncryptionException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionConfigHandler {
    private final BootstrapManager bootstrapManager;
    private static final String FILENAME = "key.xml";
    private static final String FOLDERNAME = "migration-settings";
    private final Path filePath;
    private final Path folderPath;
    private static final Logger log = LoggerFactory.getLogger(EncryptionConfigHandler.class);

    public EncryptionConfigHandler(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
        this.folderPath = Paths.get(this.bootstrapManager.getSharedHome().getAbsolutePath(), FOLDERNAME);
        this.filePath = this.folderPath.resolve(FILENAME);
    }

    public boolean doesStorageTypeExist() throws EncryptionException {
        return this.doesTagValueExistInConfig("secretLocation");
    }

    public byte[] getKeyFromConfig() throws IOException {
        if (!this.doesTagValueExistInConfig("secret")) {
            this.generateKeyInConfig();
        }
        String xmlFromFile = this.readConfig();
        String encodedBytesFromXml = xmlFromFile.substring(xmlFromFile.indexOf("<secret>") + 8, xmlFromFile.indexOf("</secret>"));
        return Base64.getDecoder().decode(encodedBytesFromXml);
    }

    public SecretStoreLocationType getKeyLocationFromConfig() throws EncryptionException {
        try {
            String xmlFromFile = this.readConfig();
            String encodedBytesFromXml = xmlFromFile.substring(xmlFromFile.indexOf("<secretLocation>") + 16, xmlFromFile.indexOf("</secretLocation>"));
            return SecretStoreLocationType.valueOf(encodedBytesFromXml);
        }
        catch (IllegalArgumentException e) {
            throw new EncryptionException("Unsupported EncryptionKeyLocation");
        }
        catch (Exception e) {
            throw new EncryptionException("Encryption Config has gone corrupt");
        }
    }

    public void setKeyLocationInConfig(SecretStoreLocationType secretStoreLocationType) throws EncryptionException {
        String xml = String.format("<secretLocation>%s</secretLocation>", new Object[]{secretStoreLocationType});
        this.writeConfig(xml);
    }

    private void generateKeyInConfig() throws EncryptionException {
        int numBytes = 32;
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[numBytes];
        random.nextBytes(bytes);
        String encodedBytes = Base64.getEncoder().encodeToString(bytes);
        String xml = String.format("<secret>%s</secret>", encodedBytes);
        this.writeConfig(xml);
    }

    private String readConfig() throws IOException {
        return new String(Files.readAllBytes(this.filePath));
    }

    private void writeConfig(String xml) throws EncryptionException {
        try {
            Files.createDirectories(this.folderPath, new FileAttribute[0]);
            Files.write(this.filePath, xml.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new EncryptionException(e.getMessage());
        }
    }

    private boolean doesTagValueExistInConfig(String tagName) {
        if (!this.filePath.toFile().exists()) {
            return false;
        }
        String startTag = String.format("<%s>", tagName);
        String endTag = String.format("</%s>", tagName);
        try {
            String xmlFromFile = this.readConfig();
            int startIndex = xmlFromFile.indexOf(startTag);
            int endIndex = xmlFromFile.indexOf(endTag);
            if (startIndex == -1 || endIndex == -1) {
                return false;
            }
            String encodedBytesFromXml = xmlFromFile.substring(xmlFromFile.indexOf(startTag) + startTag.length(), xmlFromFile.indexOf(endTag));
            if (encodedBytesFromXml.isEmpty()) {
                this.removeEmptyTagFromConfig(xmlFromFile, startTag, endTag);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.error("Error reading encryption config", (Throwable)e);
            return false;
        }
    }

    private void removeEmptyTagFromConfig(String xml, String startTag, String endTag) throws EncryptionException {
        try {
            String emptyTag = startTag + endTag;
            xml = xml.replace(emptyTag, "");
            Files.createDirectories(this.folderPath, new FileAttribute[0]);
            Files.write(this.filePath, xml.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new EncryptionException(e.getMessage());
        }
    }
}

