/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.migration.agent.dto.util.MissingConfigurationException;
import com.atlassian.migration.agent.entity.Config;
import com.atlassian.migration.agent.store.ConfigStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.time.Instant;
import java.util.Optional;

public class ConfigStoreImpl
implements ConfigStore {
    public static final String GET_CONFIG = "select config from Config config where id=1";
    private final EntityManagerTemplate entityManagerTemplate;

    public ConfigStoreImpl(EntityManagerTemplate template) {
        this.entityManagerTemplate = template;
    }

    @Override
    public Config getConfig() {
        Optional<Config> result = this.entityManagerTemplate.query(Config.class, GET_CONFIG).first();
        if (result.isPresent()) {
            return result.get();
        }
        throw new MissingConfigurationException("No Configuration Found");
    }

    @Override
    public void updateConfig(Config config) {
        config.setLastUpdate(Instant.now());
        this.entityManagerTemplate.merge(config);
    }

    @Override
    public void createEmptyConfig() {
        this.updateConfig(new Config());
    }
}

