/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.user;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.domain.Product;
import com.atlassian.cmpt.domain.ProductType;
import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.extract.UserGroupExtractFacade;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.impl.UserService;
import com.atlassian.migration.agent.service.user.GlobalEmailFixesService;
import com.atlassian.migration.agent.service.user.GroupPermission;
import com.atlassian.migration.agent.service.user.MigrationUserDto;
import com.atlassian.migration.agent.service.user.UsersMigrationException;
import com.atlassian.migration.agent.service.user.request.v2.GroupProductPermission;
import com.atlassian.migration.agent.service.user.request.v2.MigrationGroupV2Dto;
import com.atlassian.migration.agent.service.user.request.v2.UsersMigrationV2FilePayload;
import com.atlassian.migration.agent.service.user.request.v2.UsersMigrationV2Request;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class UsersMigrationRequestBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UsersMigrationRequestBuilder.class);
    private final UserService userService;
    private final GroupManager groupManager;
    private final SpacePermissionManager spacePermissionManager;
    private final UserGroupExtractFacade userGroupExtractFacade;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final SENSupplier senSupplier;
    private final PluginVersionManager pluginVersionManager;
    private final SystemInformationService systemInformationService;
    private final GlobalEmailFixesService globalEmailFixesService;

    public UsersMigrationRequestBuilder(GroupManager groupManager, SpacePermissionManager spacePermissionManager, UserService userService, UserGroupExtractFacade userGroupExtractFacade, MigrationDarkFeaturesManager migrationDarkFeaturesManager, SENSupplier senSupplier, PluginVersionManager pluginVersionManager, SystemInformationService systemInformationService, GlobalEmailFixesService globalEmailFixesService) {
        this.groupManager = groupManager;
        this.spacePermissionManager = spacePermissionManager;
        this.userService = userService;
        this.userGroupExtractFacade = userGroupExtractFacade;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.senSupplier = senSupplier;
        this.pluginVersionManager = pluginVersionManager;
        this.systemInformationService = systemInformationService;
        this.globalEmailFixesService = globalEmailFixesService;
    }

    public UsersMigrationV2FilePayload createUsersMigrationRequestV2FilePayload(String cloudId) {
        return this.createUsersMigrationRequestV2FilePayload(Collections.emptySet(), cloudId);
    }

    public UsersMigrationV2FilePayload createUsersMigrationRequestV2FilePayload(Set<String> spaceKeys, String cloudId) {
        if (spaceKeys.isEmpty()) {
            return this.createMigrateAllUsersMigrationRequestV2(cloudId);
        }
        return this.createScopedUsersMigrationRequestV2(spaceKeys, cloudId);
    }

    public UsersMigrationV2FilePayload createContextForInvalidEmailChecker(Set<String> spaceKeys) {
        if (spaceKeys.isEmpty()) {
            return this.createInvalidEmailCheckerPayload();
        }
        return this.createScopedInvalidEmailCheckerPayload(spaceKeys);
    }

    public UsersMigrationV2Request createUsersMigrationRequestV2(String migrationScopeId, String migrationId, String planId, String cloudId, UsersMigrationV2FilePayload usersMigrationV2FilePayload) {
        try {
            String userMigrationUploadedUrl = this.userService.saveUsersMigrationV2PayloadToFileAndFetchDownloadUrl(migrationId, planId, cloudId, usersMigrationV2FilePayload);
            return new UsersMigrationV2Request(this.senSupplier.get(), ProductType.CONFLUENCE, migrationScopeId, new URL(userMigrationUploadedUrl), this.pluginVersionManager.getPluginVersion(), this.systemInformationService.getConfluenceInfo().getVersion(), this.systemInformationService.getDatabaseInfo().getVersion());
        }
        catch (UncheckedInterruptedException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new UsersMigrationException("Error while creating user migration request for migration: " + migrationId, exception);
        }
    }

    private UsersMigrationV2FilePayload createMigrateAllUsersMigrationRequestV2(String cloudId) {
        Collection<MigrationUser> users = this.getUsersForMigration(cloudId);
        Collection<Group> serverGroups = this.getAllServerGroups();
        if (this.migrationDarkFeaturesManager.shouldHandleGlobalEmailFixes()) {
            return this.createUsersMigrationRequestV2ForGlobalEmailFixes(users, serverGroups);
        }
        return new UsersMigrationV2FilePayload(this.toMigrationRequestUsers(users), this.toMigrationRequestGroupsV2(serverGroups), this.getGroupsMembership(serverGroups, users));
    }

    private UsersMigrationV2FilePayload createInvalidEmailCheckerPayload() {
        List<MigrationUser> users = this.userService.getAllUsers();
        Collection<Group> serverGroups = this.getAllServerGroups();
        return new UsersMigrationV2FilePayload(this.toMigrationRequestUsers(users), this.toMigrationRequestGroupsV2(serverGroups), this.getGroupsMembership(serverGroups, users));
    }

    private UsersMigrationV2FilePayload createScopedUsersMigrationRequestV2(Set<String> spaceKeys, String cloudId) {
        ArrayList<String> spaceKeyList = new ArrayList<String>(spaceKeys);
        Collection<MigrationUser> users = this.getMigrationUsersForSpaces(spaceKeyList, cloudId);
        List<Group> filteredGroups = this.getFilteredGroups(spaceKeyList);
        if (this.migrationDarkFeaturesManager.shouldHandleGlobalEmailFixes()) {
            return this.createUsersMigrationRequestV2ForGlobalEmailFixes(users, filteredGroups);
        }
        return new UsersMigrationV2FilePayload(this.toMigrationRequestUsers(users), this.toMigrationRequestGroupsV2(filteredGroups), this.getGroupsMembership(filteredGroups, users));
    }

    private UsersMigrationV2FilePayload createUsersMigrationRequestV2ForGlobalEmailFixes(Collection<MigrationUser> users, Collection<Group> groups) {
        Map<MigrationUser, List<MigrationUser>> distinctUsers = this.mergeDuplicateUsers(users);
        Collection<MigrationUserDto> distinctMigrationRequestUsers = this.toMigrationRequestUsersWithAdditionalMappings(distinctUsers);
        List<MigrationUser> migrationUsers = this.fixEmailCasingForDuplicateEmails(distinctUsers.keySet(), users);
        return new UsersMigrationV2FilePayload(distinctMigrationRequestUsers, this.toMigrationRequestGroupsV2(groups), this.getGroupsMembership(groups, migrationUsers));
    }

    private UsersMigrationV2FilePayload createScopedInvalidEmailCheckerPayload(Set<String> spaceKeys) {
        ArrayList<String> spaceKeyList = new ArrayList<String>(spaceKeys);
        Collection<MigrationUser> users = this.getMigrationUsersForInvalidEmailsChecker(spaceKeyList);
        List<Group> filteredGroups = this.getFilteredGroups(spaceKeyList);
        return new UsersMigrationV2FilePayload(this.toMigrationRequestUsers(users), this.toMigrationRequestGroupsV2(filteredGroups), this.getGroupsMembership(filteredGroups, users));
    }

    private List<Group> getFilteredGroups(List<String> spaceKeyList) {
        Set<String> groupsFromSpaces = this.userGroupExtractFacade.getGroupsFromSpaces(spaceKeyList);
        return this.getFilteredGroupsForSpaces(groupsFromSpaces);
    }

    private Collection<MigrationUser> getMigrationUsersForSpaces(List<String> spaceKeyList, String cloudId) {
        Set<String> userKeys = this.userGroupExtractFacade.getUsersFromSpaces(spaceKeyList);
        return this.getUsersForMigration(cloudId).stream().filter(migrationUser -> userKeys.contains(migrationUser.getUserKey())).collect(Collectors.toList());
    }

    private Collection<MigrationUser> getMigrationUsersForInvalidEmailsChecker(List<String> spaceKeyList) {
        Set<String> userKeys = this.userGroupExtractFacade.getUsersFromSpaces(spaceKeyList);
        return this.userService.getAllUsers().stream().filter(migrationUser -> userKeys.contains(migrationUser.getUserKey())).collect(Collectors.toList());
    }

    private List<Group> getFilteredGroupsForSpaces(Set<String> groupsFromSpaces) {
        Collection<Group> serverGroups = this.getAllServerGroups();
        return serverGroups.stream().filter(serverGroup -> groupsFromSpaces.contains(serverGroup.getName())).collect(Collectors.toList());
    }

    @VisibleForTesting
    Collection<MigrationUser> getUsersForMigration(String cloudId) {
        List<MigrationUser> allUsers = this.userService.getAllUsers();
        if (this.migrationDarkFeaturesManager.shouldHandleGlobalEmailFixes()) {
            return this.globalEmailFixesService.getUsersForGlobalEmailFixes(allUsers, cloudId);
        }
        if (!this.migrationDarkFeaturesManager.shouldHandleGlobalEmailFixes() && this.migrationDarkFeaturesManager.shouldHandleInvalidAndDuplicateEmailUsers()) {
            return this.userService.getAllUsersExcludingInvalidEmailUsers().stream().collect(Collectors.toMap(user -> IdentityAcceptedEmailValidator.cleanse((String)user.getEmail()), Function.identity(), (older, newer) -> older)).values();
        }
        return allUsers;
    }

    private Collection<MigrationGroupV2Dto> toMigrationRequestGroupsV2(Collection<Group> groups) {
        return groups.stream().map(group -> {
            Collection groupPermissions = this.spacePermissionManager.getAllPermissionsForGroup(group.getName()).stream().flatMap(UsersMigrationRequestBuilder::mapSpacePermissionToGroupPermissions).collect(Collectors.toSet());
            List<GroupProductPermission> groupProductPermissions = Collections.emptyList();
            if (!groupPermissions.isEmpty()) {
                groupProductPermissions = Collections.singletonList(new GroupProductPermission(Product.CONFLUENCE, groupPermissions));
            }
            return new MigrationGroupV2Dto(group.getName(), groupProductPermissions);
        }).collect(Collectors.toList());
    }

    private Map<String, Collection<String>> getGroupsMembership(Collection<Group> groups, Collection<MigrationUser> users) {
        return groups.stream().collect(Collectors.toMap(Entity::getName, group -> {
            try {
                HashSet userIdsOfGroup = Sets.newHashSet((Iterable)this.groupManager.getMemberNames(group));
                return users.stream().filter(it -> userIdsOfGroup.contains(it.getUsername())).map(MigrationUser::getEmail).collect(Collectors.toSet());
            }
            catch (EntityException e) {
                throw new RuntimeException(String.format("Couldn't retrieve members of group %s", group.getName()), e);
            }
        }));
    }

    private Collection<Group> getAllServerGroups() {
        ArrayList serverGroups;
        try {
            serverGroups = Lists.newArrayList((Iterable)this.groupManager.getGroups());
        }
        catch (EntityException e) {
            throw new RuntimeException("Couldn't retrieve groups", e);
        }
        return serverGroups;
    }

    private Collection<MigrationUserDto> toMigrationRequestUsers(Collection<MigrationUser> users) {
        return users.stream().map(MigrationUserDto::from).collect(Collectors.toList());
    }

    private Collection<MigrationUserDto> toMigrationRequestUsersWithAdditionalMappings(Map<MigrationUser, List<MigrationUser>> users) {
        return users.entrySet().stream().map(user -> MigrationUserDto.from((MigrationUser)user.getKey(), (List)user.getValue())).collect(Collectors.toList());
    }

    private Map<MigrationUser, List<MigrationUser>> mergeDuplicateUsers(Collection<MigrationUser> users) {
        return users.stream().sorted(Comparator.comparing(MigrationUser::isActive, Comparator.reverseOrder())).collect(Collectors.groupingBy(v -> UsersMigrationRequestBuilder.sanitizeDuplicatedEmailForMerge(v.getEmail()))).entrySet().stream().collect(Collectors.toMap(e -> (MigrationUser)((List)e.getValue()).get(0), e -> ((List)e.getValue()).size() > 1 ? ((List)e.getValue()).subList(1, ((List)e.getValue()).size()) : Collections.emptyList()));
    }

    private List<MigrationUser> fixEmailCasingForDuplicateEmails(Collection<MigrationUser> distinctUsers, Collection<MigrationUser> allUsers) {
        Map<String, String> distinctUsersEmailMap = distinctUsers.stream().collect(Collectors.toMap(user -> UsersMigrationRequestBuilder.sanitizeDuplicatedEmailForMerge(user.getEmail()), MigrationUser::getEmail));
        return allUsers.stream().map(user -> new MigrationUser(user.getUserKey(), user.getUsername(), user.getFullName(), (String)distinctUsersEmailMap.get(UsersMigrationRequestBuilder.sanitizeDuplicatedEmailForMerge(user.getEmail())), user.isActive())).collect(Collectors.toList());
    }

    private static String sanitizeDuplicatedEmailForMerge(String email) {
        return IdentityAcceptedEmailValidator.cleanse((String)email.toLowerCase(Locale.ENGLISH));
    }

    private static Stream<GroupPermission> mapSpacePermissionToGroupPermissions(SpacePermission spacePermission) {
        switch (spacePermission.getType()) {
            case "USECONFLUENCE": {
                return Stream.of(GroupPermission.HAS_PRODUCT_ACCESS);
            }
            case "ADMINISTRATECONFLUENCE": {
                return Stream.of(GroupPermission.PRODUCT_ADMIN);
            }
            case "SYSTEMADMINISTRATOR": {
                return Stream.of(GroupPermission.SYSTEM_ADMIN);
            }
        }
        return Stream.empty();
    }
}

