/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.planning;

import com.atlassian.migration.agent.entity.MigrateUsersTask;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.entity.TaskType;
import com.atlassian.migration.agent.store.TaskStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TaskPlanningEngine {
    private final TaskStore taskStore;

    public TaskPlanningEngine(TaskStore taskStore) {
        this.taskStore = taskStore;
    }

    public List<Task> getFirstTasks(String planId) {
        List<Task> tasks = this.taskStore.getTasksForPlan(planId);
        tasks = this.filterOutTasks(tasks, Collections.singletonList(TaskType.APPS));
        Optional<Task> migrateUsers = tasks.stream().filter(task -> task instanceof MigrateUsersTask).findFirst();
        return migrateUsers.map(Collections::singletonList).orElse(tasks);
    }

    public List<Task> getNextTasks(Task task) {
        if (task.getType() == TaskType.USERS) {
            List<Task> tasks = this.taskStore.getTasksForPlan(task.getPlan().getId());
            return this.filterOutTasks(tasks, Arrays.asList(TaskType.USERS, TaskType.APPS));
        }
        return Collections.emptyList();
    }

    public boolean hasReachedTerminalState(String planId) {
        return this.taskStore.areTasksInTerminalState(planId);
    }

    private List<Task> filterOutTasks(List<Task> tasks, List<TaskType> taskTypes) {
        return tasks.stream().filter(task -> !taskTypes.contains((Object)task.getType())).collect(Collectors.toList());
    }
}

