/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.confluence.api.model.content.SpaceType;
import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.dto.SpaceDto;
import com.atlassian.migration.agent.dto.SpaceSearchResultDto;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.Space;
import com.atlassian.migration.agent.model.stats.ContentSummary;
import com.atlassian.migration.agent.model.stats.SpaceStats;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.impl.MigrationTimeEstimationUtils;
import com.atlassian.migration.agent.service.impl.SpaceTypeFilter;
import com.atlassian.migration.agent.store.ConfluenceSpaceTaskStore;
import com.atlassian.migration.agent.store.impl.SpaceStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SpaceCatalogService {
    private final PluginTransactionTemplate ptx;
    private final SpaceStore spaceStore;
    private final ConfluenceSpaceTaskStore confluenceSpaceTaskStore;
    private final StatisticsService statisticsService;
    @VisibleForTesting
    public static final long AVG_ESTIMATION_SECONDS = 30L;

    public SpaceCatalogService(PluginTransactionTemplate ptx, SpaceStore spaceStore, ConfluenceSpaceTaskStore confluenceSpaceTaskStore, StatisticsService statisticsService) {
        this.ptx = ptx;
        this.spaceStore = spaceStore;
        this.confluenceSpaceTaskStore = confluenceSpaceTaskStore;
        this.statisticsService = statisticsService;
    }

    public Collection<SpaceDto> getSpacesSummaryForPlan(String planId) {
        List spaces = this.ptx.read(() -> this.spaceStore.getSpaces(planId));
        return spaces.stream().map(space -> this.spaceToDto((Space)space, Collections.emptyMap(), Collections.emptyMap())).collect(Collectors.toList());
    }

    public SpaceSearchResultDto getSpaces(String cloudId, String query, SpaceTypeFilter spaceTypeFilter, int startIndex, int pageSize) {
        int spaceCount = this.ptx.read(() -> this.spaceStore.getSpacesCount(query, spaceTypeFilter));
        int totalSpaces = this.ptx.read(this.spaceStore::getTotalSpaces);
        List pagedSpaces = this.ptx.read(() -> this.spaceStore.getSpacesPaged(cloudId, query, spaceTypeFilter, startIndex, pageSize));
        if (pageSize == Integer.MAX_VALUE) {
            return new SpaceSearchResultDto(spaceCount, startIndex, pageSize, this.createSpaceDtosWithoutSummaryProgress(pagedSpaces), totalSpaces);
        }
        if (pagedSpaces.isEmpty()) {
            return new SpaceSearchResultDto(spaceCount, startIndex, pageSize, Collections.emptyList(), totalSpaces);
        }
        return new SpaceSearchResultDto(spaceCount, startIndex, pageSize, this.getSpaceDtos(cloudId, pagedSpaces), totalSpaces);
    }

    private Collection<SpaceDto> createSpaceDtosWithoutSummaryProgress(List<Space> spaces) {
        List<String> spaceKeys = spaces.stream().map(Space::getKey).collect(Collectors.toList());
        Map<String, ContentSummary> spaceKeyToSummary = this.generateSpaceKeyToSummary(spaceKeys);
        return spaces.stream().map(space -> this.spaceToDtoWithOutProgress((Space)space, spaceKeyToSummary)).collect(Collectors.toList());
    }

    private SpaceDto spaceToDtoWithOutProgress(Space space, Map<String, ContentSummary> spaceKeyToSummary) {
        String spaceKey = space.getKey();
        return new SpaceDto(spaceKey, space.getId(), space.getName(), spaceKeyToSummary.getOrDefault(spaceKey, ContentSummary.ZERO), null, 30L, Optional.ofNullable(space.getType()).map(SpaceType::forName).orElse(null));
    }

    private Map<String, ContentSummary> generateSpaceKeyToSummary(List<String> spaceKeys) {
        return this.statisticsService.loadSpaceStatistics(spaceKeys).stream().collect(Collectors.toMap(SpaceStats::getSpaceKey, SpaceStats::getSummary));
    }

    private Collection<SpaceDto> getSpaceDtos(String cloudId, List<Space> spaces) {
        List<String> spaceKeys = spaces.stream().map(Space::getKey).collect(Collectors.toList());
        Map spaceKeyToProgress = this.ptx.read(() -> this.confluenceSpaceTaskStore.getLatestSpaceProgress(cloudId, spaceKeys));
        Map<String, ContentSummary> spaceKeyToSummary = this.generateSpaceKeyToSummary(spaceKeys);
        return spaces.stream().map(space -> this.spaceToDto((Space)space, spaceKeyToSummary, spaceKeyToProgress)).collect(Collectors.toList());
    }

    private SpaceDto spaceToDto(Space space, Map<String, ContentSummary> spaceKeyToSummary, Map<String, Progress> spaceKeyToProgress) {
        String spaceKey = space.getKey();
        ContentSummary spaceSummary = spaceKeyToSummary.getOrDefault(spaceKey, ContentSummary.ZERO);
        long estimationSeconds = MigrationTimeEstimationUtils.estimateSpaceMigrationTime(spaceSummary).getSeconds();
        return new SpaceDto(spaceKey, space.getId(), space.getName(), spaceSummary, Optional.ofNullable(spaceKeyToProgress.get(spaceKey)).map(ProgressDto::fromPlanEntity).orElse(null), estimationSeconds, Optional.ofNullable(space.getType()).map(SpaceType::forName).orElse(null));
    }
}

