/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.model.stats.ContentSummary;
import java.time.Duration;
import java.util.Collection;

public final class MigrationTimeEstimationUtils {
    private static final long SPACE_TIME_MS = 0L;
    private static final long USER_GROUP_TIME_MS = 597L;
    private static final long CONTENT_TIME_MS = 833L;
    private static final long BASE_MIGRATION_TIME_MS = 261480L;
    private static final long GLOBAL_ENTITIES_MS = 800L;
    private static final long MS_PER_MB = 169L;
    private static final long BYTES_TO_MB = 1000000L;

    private MigrationTimeEstimationUtils() {
    }

    public static Duration getBaseMigrationTime() {
        return Duration.ofMillis(261480L);
    }

    private static long calculateContentTime(ContentSummary contentSummary) {
        return (contentSummary.getNumberOfBlogs() + contentSummary.getNumberOfDrafts() + contentSummary.getNumberOfPages()) * 833L;
    }

    private static long calculateAttachmentsTime(ContentSummary contentSummary) {
        return contentSummary.getAttachments().getTotalSize() * 169L / 1000000L;
    }

    public static Duration estimateTotalUserGroupMigrationTime(int numberOfUsers, int numberOfGroups) {
        return Duration.ofMillis((long)(numberOfUsers + numberOfGroups) * 597L);
    }

    public static Duration estimateSpaceMigrationTime(ContentSummary contentSummary) {
        return Duration.ofMillis(MigrationTimeEstimationUtils.calculateContentTime(contentSummary) + MigrationTimeEstimationUtils.calculateAttachmentsTime(contentSummary) + 0L);
    }

    public static Duration estimateTotalSpaceMigrationTime(Collection<ContentSummary> spaces) {
        return spaces.stream().map(MigrationTimeEstimationUtils::estimateSpaceMigrationTime).reduce(Duration.ZERO, Duration::plus);
    }

    public static Duration estimateGlobalEntitiesMigrationTime(long numGlobalEntities) {
        return Duration.ofMillis(numGlobalEntities * 800L);
    }
}

