/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.confluence.status.service.systeminfo.UsageInfo;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.util.UserMigrationType;
import com.atlassian.migration.agent.entity.GlobalEntityStatName;
import com.atlassian.migration.agent.entity.GlobalEntityType;
import com.atlassian.migration.agent.entity.Stats;
import com.atlassian.migration.agent.entity.StatsType;
import com.atlassian.migration.agent.model.stats.ContentSummary;
import com.atlassian.migration.agent.model.stats.GlobalEntitiesStats;
import com.atlassian.migration.agent.model.stats.InstanceStats;
import com.atlassian.migration.agent.model.stats.ServerStats;
import com.atlassian.migration.agent.model.stats.SpaceStats;
import com.atlassian.migration.agent.model.stats.UsersGroupsStats;
import com.atlassian.migration.agent.service.FailedToLoadStatsException;
import com.atlassian.migration.agent.service.NetworkStatisticsService;
import com.atlassian.migration.agent.service.NonSpaceTemplateConflictsInfo;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.StatsStoringService;
import com.atlassian.migration.agent.service.cloud.LegalService;
import com.atlassian.migration.agent.service.confluence.ConfluenceCloudService;
import com.atlassian.migration.agent.service.extract.UserGroupExtractFacade;
import com.atlassian.migration.agent.service.impl.MigrationTimeEstimationUtils;
import com.atlassian.migration.agent.service.impl.SingleJobExecutor;
import com.atlassian.migration.agent.store.ContentStatisticsStore;
import com.atlassian.migration.agent.store.StatsStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStatisticsService
implements StatisticsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultStatisticsService.class);
    private final SystemInformationService systemInformationService;
    private final StatsStoringService statsStoringService;
    private final ContentStatisticsStore contentStatisticsStore;
    private final ConfluenceCloudService confluenceCloudService;
    private final PluginTransactionTemplate ptx;
    private final SingleJobExecutor<ServerStats> executor;
    private final SpaceManager spaceManager;
    private final NetworkStatisticsService networkStatisticsService;
    private final LegalService legalService;
    private final UserGroupExtractFacade userGroupExtractFacade;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final StatsStore statsStore;
    private static final Duration SPACE_STATS_CACHE_TIME = Duration.of(3L, ChronoUnit.DAYS);
    private final LoadingCache<String, SpaceStats> spaceStatisticsLoadingCache;
    private static final Duration GLOBAL_ENTITIES_STATS_CACHE_TIME = Duration.of(30L, ChronoUnit.MINUTES);
    private final LoadingCache<String, GlobalEntitiesStats> globalEntitiesStatsLoadingCache;

    public DefaultStatisticsService(SystemInformationService systemInformationService, StatsStoringService statsStoringService, ContentStatisticsStore contentStatisticsStore, ConfluenceCloudService confluenceCloudService, PluginTransactionTemplate ptx, SpaceManager spaceManager, NetworkStatisticsService networkStatisticsService, LegalService legalService, UserGroupExtractFacade userGroupExtractFacade, MigrationDarkFeaturesManager migrationDarkFeaturesManager, StatsStore statsStore) {
        this(systemInformationService, statsStoringService, contentStatisticsStore, confluenceCloudService, ptx, new SingleJobExecutor<ServerStats>("SiteSummaryCalculator"), spaceManager, networkStatisticsService, legalService, userGroupExtractFacade, migrationDarkFeaturesManager, statsStore);
    }

    @VisibleForTesting
    DefaultStatisticsService(SystemInformationService systemInformationService, StatsStoringService statsStoringService, final ContentStatisticsStore contentStatisticsStore, ConfluenceCloudService confluenceCloudService, final PluginTransactionTemplate ptx, SingleJobExecutor<ServerStats> singleJobExecutor, SpaceManager spaceManager, NetworkStatisticsService networkStatisticsService, LegalService legalService, UserGroupExtractFacade userGroupExtractFacade, MigrationDarkFeaturesManager migrationDarkFeaturesManager, StatsStore statsStore) {
        this.systemInformationService = systemInformationService;
        this.statsStoringService = statsStoringService;
        this.contentStatisticsStore = contentStatisticsStore;
        this.confluenceCloudService = confluenceCloudService;
        this.ptx = ptx;
        this.executor = singleJobExecutor;
        this.spaceManager = spaceManager;
        this.networkStatisticsService = networkStatisticsService;
        this.legalService = legalService;
        this.userGroupExtractFacade = userGroupExtractFacade;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.statsStore = statsStore;
        this.spaceStatisticsLoadingCache = CacheBuilder.newBuilder().expireAfterWrite(SPACE_STATS_CACHE_TIME.toMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, SpaceStats>(){

            public SpaceStats load(String spaceKey) {
                return ptx.read(() -> contentStatisticsStore.loadSpaceStatistics(spaceKey));
            }

            public Map<String, SpaceStats> loadAll(Iterable<? extends String> spaceKeys) throws Exception {
                return ptx.read(() -> contentStatisticsStore.loadSpaceStatistics((Collection<String>)ImmutableList.copyOf((Iterable)spaceKeys))).stream().collect(Collectors.toMap(SpaceStats::getSpaceKey, spaceStats -> spaceStats));
            }
        });
        this.globalEntitiesStatsLoadingCache = CacheBuilder.newBuilder().expireAfterWrite(GLOBAL_ENTITIES_STATS_CACHE_TIME.toMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, GlobalEntitiesStats>(){

            public GlobalEntitiesStats load(String cloudId) {
                return DefaultStatisticsService.this.getRuntimeGlobalEntitiesStats(cloudId);
            }
        });
    }

    private static boolean nonZeroSpaces(StatsStoringService.Stored<ServerStats> serverStatsStored) {
        return serverStatsStored.getData().getInstanceStats().getNumberOfSpaces() != 0;
    }

    private static boolean isStoredStatsStale(Instant storedTime) {
        return storedTime.isBefore(Instant.now().minus(5L, ChronoUnit.MINUTES));
    }

    @PostConstruct
    public void initialize() {
        this.executor.execute(this::calculateServerStats);
    }

    @Override
    public ServerStats loadServerStatistics() {
        ServerStats serverStats;
        Optional<StatsStoringService.Stored<ServerStats>> maybeStoredStats = this.statsStoringService.loadServerStats(() -> ((SystemInformationService)this.systemInformationService).getConfluenceInfo());
        if (maybeStoredStats.isPresent() && DefaultStatisticsService.nonZeroSpaces(maybeStoredStats.get())) {
            StatsStoringService.Stored<ServerStats> storedStats = maybeStoredStats.get();
            if (DefaultStatisticsService.isStoredStatsStale(storedStats.getStoredTime())) {
                this.executor.execute(this::calculateServerStats);
            }
            serverStats = storedStats.getData();
        } else {
            CompletableFuture<ServerStats> future = this.executor.execute(this::calculateServerStats);
            try {
                serverStats = future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new FailedToLoadStatsException("Failed to load server statistics", e);
            }
        }
        return serverStats;
    }

    @Override
    public Collection<SpaceStats> loadSpaceStatistics(Collection<String> spaceKeys) {
        try {
            return this.spaceStatisticsLoadingCache.getAll(spaceKeys).values().asList();
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException((Throwable)e);
        }
    }

    @Override
    public SpaceStats loadSpaceStatistics(String spaceKey) {
        return (SpaceStats)this.spaceStatisticsLoadingCache.getUnchecked((Object)spaceKey);
    }

    @Override
    public UsersGroupsStats getUsersGroupsStatistics(UserMigrationType userMigrationType, Collection<String> spaceKeys) {
        int numGroups;
        int numUsers;
        if (userMigrationType.equals((Object)UserMigrationType.NONE)) {
            return new UsersGroupsStats(0, 0, Duration.ofMillis(0L));
        }
        if (userMigrationType.equals((Object)UserMigrationType.ALL)) {
            UsageInfo usageInfo = this.systemInformationService.getUsageInfo();
            numUsers = usageInfo.getLocalUsers();
            numGroups = this.userGroupExtractFacade.getAllGroupNames().size();
        } else {
            numUsers = this.userGroupExtractFacade.getUsersFromSpaces(spaceKeys).size();
            numGroups = this.userGroupExtractFacade.getGroupsFromSpaces(spaceKeys).size();
        }
        Duration totalMigrationTime = MigrationTimeEstimationUtils.estimateTotalUserGroupMigrationTime(numUsers, numGroups);
        return new UsersGroupsStats(numUsers, numGroups, totalMigrationTime);
    }

    @Override
    public GlobalEntitiesStats getGlobalEntitiesStatistics(String cloudId, String planId) {
        Optional<GlobalEntitiesStats> planGlobalEntitiesStats = this.getGlobalEntitiesStatsForPlan(planId);
        return planGlobalEntitiesStats.orElseGet(() -> (GlobalEntitiesStats)this.globalEntitiesStatsLoadingCache.getUnchecked((Object)cloudId));
    }

    private Optional<GlobalEntitiesStats> getGlobalEntitiesStatsForPlan(String planId) {
        if (Objects.nonNull(planId)) {
            try {
                List<Stats> stats = this.statsStore.getByTypeAndPlan(StatsType.GLOBAL_ENTITIES, planId);
                if (!CollectionUtils.isEmpty(stats)) {
                    Map<GlobalEntityStatName, Long> statNameMap = stats.stream().collect(Collectors.toMap(s -> GlobalEntityStatName.valueOf(s.getName()), Stats::getValue));
                    return Optional.of(new GlobalEntitiesStats(statNameMap.getOrDefault((Object)GlobalEntityStatName.TOTAL_GLOBAL_PAGE_TEMPLATES, 0L), statNameMap.getOrDefault((Object)GlobalEntityStatName.TOTAL_EDITED_SYSTEM_TEMPLATES, 0L), statNameMap.getOrDefault((Object)GlobalEntityStatName.SKIPPED_GLOBAL_PAGE_TEMPLATES, 0L), statNameMap.getOrDefault((Object)GlobalEntityStatName.SKIPPED_EDITED_SYSTEM_TEMPLATES, 0L)));
                }
            }
            catch (Exception e) {
                log.error("Error while fetching plan stats from DB: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return Optional.empty();
    }

    private GlobalEntitiesStats getRuntimeGlobalEntitiesStats(String cloudId) {
        NonSpaceTemplateConflictsInfo allNonSpaceTemplateConflictsInfo = this.confluenceCloudService.getNonSpaceTemplateConflictsInfo(GlobalEntityType.GLOBAL_SYSTEM_TEMPLATES, cloudId);
        return new GlobalEntitiesStats(allNonSpaceTemplateConflictsInfo.getTotalNumOfServerTemplates(GlobalEntityType.GLOBAL_TEMPLATES), allNonSpaceTemplateConflictsInfo.getTotalNumOfServerTemplates(GlobalEntityType.SYSTEM_TEMPLATES), allNonSpaceTemplateConflictsInfo.getTotalNumOfConflictingTemplates(GlobalEntityType.GLOBAL_TEMPLATES), allNonSpaceTemplateConflictsInfo.getTotalNumOfConflictingTemplates(GlobalEntityType.SYSTEM_TEMPLATES));
    }

    @VisibleForTesting
    ServerStats calculateServerStats() {
        ConfluenceInfo confluenceInfo = this.systemInformationService.getConfluenceInfo();
        UsageInfo usageInfo = this.systemInformationService.getUsageInfo();
        InstanceStats instanceStats = InstanceStats.builder().version(confluenceInfo.getVersion()).buildNumber(confluenceInfo.getBuildNumber()).numberOfSpaces(usageInfo.getTotalSpaces()).numberOfUsers(usageInfo.getLocalUsers()).numberOfGroups(usageInfo.getLocalGroups()).build();
        Collection<SpaceStats> spaceStats = this.loadSpaceStatistics(this.spaceManager.getAllSpaces().stream().map(Space::getKey).collect(Collectors.toList()));
        List<ContentSummary> spaceSummaries = spaceStats.stream().map(SpaceStats::getSummary).collect(Collectors.toList());
        ContentSummary contentSummary = this.ptx.read(this.contentStatisticsStore::loadContentSummary);
        Duration userGroupMigrationTime = MigrationTimeEstimationUtils.estimateTotalUserGroupMigrationTime(instanceStats.getNumberOfUsers(), instanceStats.getNumberOfGroups());
        Duration spaceMigrationTime = MigrationTimeEstimationUtils.estimateTotalSpaceMigrationTime(spaceSummaries);
        long bandwidthKBPS = NetworkStatisticsService.getUncalculatedBandwidthKBPS();
        if (this.legalService.getRememberLegalOptIn()) {
            bandwidthKBPS = this.networkStatisticsService.measureBandwidthKBPS();
        }
        ServerStats serverStats = new ServerStats(instanceStats, contentSummary, userGroupMigrationTime, spaceMigrationTime, MigrationTimeEstimationUtils.getBaseMigrationTime(), bandwidthKBPS);
        this.statsStoringService.storeServerStats(serverStats);
        return serverStats;
    }
}

