/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.template;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.cmpt.check.mapper.AbstractMapper;
import com.atlassian.migration.agent.service.NonSpaceTemplateConflictsInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GlobalDataTemplateConflictMapper
extends AbstractMapper {
    public static final String VIOLATIONS_KEY = "violations";
    public static final String ERROR_DESCRIPTION = "Global Data Templates already exist in your cloud site";
    public static final String SUCCESS_DESCRIPTION = "No conflicting Global Data Templates found";
    public static final String RUNNING_DESCRIPTION = "Checking for Global Data Template conflicts in your cloud site";
    public static final String EXECUTION_ERROR_DESCRIPTION = "We couldn\u2019t check for Global Data Template conflicts";
    public static final String WARNING_DESCRIPTION = "Conflicting Global Data Templates will be skipped from migration";

    protected void inject(CheckResultDto dto, CheckResult checkResult) {
        String description;
        switch (dto.getStatus()) {
            case SUCCESS: {
                description = SUCCESS_DESCRIPTION;
                break;
            }
            case WARNING: 
            case ERROR: {
                description = ERROR_DESCRIPTION;
                CheckDetailsDto details = new CheckDetailsDto();
                details.setListOfOccurrences(GlobalDataTemplateConflictMapper.retrieveConflictingTemplates(checkResult.details));
                dto.setDetails(details);
                break;
            }
            case RUNNING: {
                description = RUNNING_DESCRIPTION;
                break;
            }
            case EXECUTION_ERROR: {
                description = EXECUTION_ERROR_DESCRIPTION;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported status.");
            }
        }
        dto.setDescription(description);
    }

    static List<NonSpaceTemplateConflictsInfo.Conflict> retrieveConflictingTemplates(Map<String, Object> details) {
        return details.getOrDefault(VIOLATIONS_KEY, Collections.emptyList());
    }

    public static void changeStatusToWarning(CheckResultDto checkResultDto) {
        checkResultDto.setStatus(Status.WARNING);
        checkResultDto.setDescription(WARNING_DESCRIPTION);
    }
}

