/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.newexport;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.newexport.DescriptorBuilder;
import com.atlassian.migration.agent.newexport.Queries;
import com.atlassian.migration.agent.newexport.Query;
import com.atlassian.migration.agent.newexport.RapidExporter;
import com.atlassian.migration.agent.newexport.SpaceCSVExportTaskContext;
import com.atlassian.migration.agent.newexport.processor.RowProcessor;
import com.atlassian.migration.agent.newexport.processor.UserKeyXmlExtractor;
import com.atlassian.migration.agent.newexport.store.JdbcConfluenceStore;
import com.atlassian.migration.agent.newexport.util.FileUtil;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.user.UserMappingsFileManager;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceRapidExporter
extends RapidExporter<SpaceCSVExportTaskContext> {
    private static final Logger log = LoggerFactory.getLogger(SpaceRapidExporter.class);
    private static final Supplier<String> DEFAULT_NAME_GENERATOR = () -> "mig_contentid_" + UUID.randomUUID().toString().replace("-", "");
    private final Supplier<String> nameGenerator;
    private static final String SPACE_ID = "spaceid";
    private static final String CLOUD_ID = "cloudid";
    public static final String SPACE_KEY = "spaceKey";

    public SpaceRapidExporter(JdbcConfluenceStore confluenceStore, DescriptorBuilder descriptorBuilder, MigrationAgentConfiguration migrationAgentConfiguration, UserMappingsFileManager userMappingsFileManager, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder) {
        super(confluenceStore, descriptorBuilder, migrationAgentConfiguration, userMappingsFileManager, analyticsEventService, analyticsEventBuilder);
        this.nameGenerator = DEFAULT_NAME_GENERATOR;
    }

    @VisibleForTesting
    public SpaceRapidExporter(JdbcConfluenceStore confluenceStore, DescriptorBuilder descriptorBuilder, MigrationAgentConfiguration migrationAgentConfiguration, UserMappingsFileManager userMappingsFileManager, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, Supplier<Instant> instantSupplier, Supplier<String> nameGenerator) {
        super(confluenceStore, descriptorBuilder, migrationAgentConfiguration, userMappingsFileManager, analyticsEventService, analyticsEventBuilder, instantSupplier);
        this.nameGenerator = nameGenerator;
    }

    @Override
    protected void logResults(String tableName, SpaceCSVExportTaskContext taskContext, long totalTime) {
        log.info("Serialized results of query on table [{}] for space [{}] in [{} ms].", new Object[]{tableName, taskContext.getSpaceKey(), totalTime});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String export(SpaceCSVExportTaskContext taskContext) {
        String exportDir = FileUtil.createExportDirectory(taskContext.getSpaceKey(), taskContext.getTempDirFilePath());
        log.info("Starting CSV export of space: {} to path: {}", (Object)taskContext.getSpaceKey(), (Object)exportDir);
        long startTime = ((Instant)this.instantSupplier.get()).toEpochMilli();
        HashSet<String> discoveredUserKeys = new HashSet<String>();
        String contentIdTable = this.createAndPopulateContentIdsTable(taskContext.getSpaceId());
        log.info("Try to get user mappings from file for planId: {}", (Object)taskContext.getPlanId());
        Map<String, String> emailToAAID = this.userMappingsFileManager.getUserMappingsFromFile(taskContext.getPlanId());
        try {
            this.exportEntitiesDirectlyRelatedToSpace(exportDir, discoveredUserKeys, taskContext);
            this.exportBodyContents(exportDir, discoveredUserKeys, taskContext, contentIdTable);
            this.exportContentRelatedEntities(exportDir, discoveredUserKeys, taskContext, contentIdTable);
            this.exportOsProperties(exportDir, taskContext, contentIdTable);
            this.exportUserMappings(exportDir, discoveredUserKeys, taskContext, emailToAAID);
            this.descriptorBuilder.generateSpaceDescriptor(taskContext.getSpaceKey(), exportDir, taskContext.isUsersCreatedInUMS(), taskContext.getTotalRowCount());
        }
        finally {
            this.tryDropContentIdTable(contentIdTable);
        }
        log.info("Completed CSV export of space: {} in {}ms", (Object)taskContext.getSpaceKey(), (Object)(((Instant)this.instantSupplier.get()).toEpochMilli() - startTime));
        log.info("Exported CSV files of space: {} are located in directory {}", (Object)taskContext.getSpaceKey(), (Object)exportDir);
        return exportDir;
    }

    private String createAndPopulateContentIdsTable(long spaceId) {
        String tableName = this.nameGenerator.get();
        this.confluenceStore.mutate(Queries.CREATE_CONTENT_ID_TABLE_QUERY.toQuery(this.getDbType(), tableName));
        log.info("Created contentId table {}", (Object)tableName);
        int numRows = this.confluenceStore.mutate(Queries.POPULATE_CONTENT_ID_TABLE_QUERY.toQuery(this.getDbType(), tableName), Collections.singletonMap(SPACE_ID, spaceId));
        log.info("Populated contentId table {} with {} rows", (Object)tableName, (Object)numRows);
        return tableName;
    }

    private void tryDropContentIdTable(String tableName) {
        try {
            this.confluenceStore.mutate(Queries.DROP_CONTENT_ID_TABLE_QUERY.toQuery(this.getDbType(), tableName));
        }
        catch (Exception e) {
            log.warn("Failed to drop CSV export temp table: {}", (Object)tableName, (Object)e);
        }
    }

    private void exportOsProperties(String exportDir, SpaceCSVExportTaskContext taskConfig, String contentIdTable) {
        this.runQueries(Queries.osPropertyQuery.toQueries(this.getDbType(), contentIdTable), this.createQueryRunner(Collections.singletonMap(SPACE_ID, taskConfig.getSpaceId())), exportDir, taskConfig);
    }

    private void exportContentRelatedEntities(String exportDir, Set<String> extractedUserKeys, SpaceCSVExportTaskContext taskConfig, String contentIdTable) {
        this.runQueries(Queries.contentQueries.toQueries(this.getDbType(), contentIdTable), this.createQueryRunner((Map<String, ?>)ImmutableMap.of((Object)CLOUD_ID, (Object)taskConfig.getCloudId(), (Object)SPACE_ID, (Object)taskConfig.getSpaceId())), exportDir, taskConfig);
        if (this.confluenceBefore7_0_1()) {
            this.runQueries(Queries.contentQueriesLegacyTables.toQueries(this.getDbType(), contentIdTable), this.createQueryRunner(Collections.singletonMap(SPACE_ID, taskConfig.getSpaceId())), exportDir, taskConfig);
        }
        this.runQueries(Queries.contentQueriesWithUserKeys.toQueries(this.getDbType(), contentIdTable), this.createQueryRunner(Collections.singletonMap(SPACE_ID, taskConfig.getSpaceId()), extractedUserKeys), exportDir, taskConfig);
        this.runQueries(Queries.AOBAF3AA_QUERY.toQueries(this.getDbType(), contentIdTable), this.createQueryRunner(Collections.singletonMap(SPACE_ID, taskConfig.getSpaceId()), extractedUserKeys), exportDir, taskConfig);
    }

    private void exportEntitiesDirectlyRelatedToSpace(String exportDir, Set<String> extractedUserKeys, SpaceCSVExportTaskContext taskConfig) {
        this.runQueries(Queries.spaceIdQueries, this.createQueryRunner(Collections.singletonMap(SPACE_ID, taskConfig.getSpaceId()), extractedUserKeys), exportDir, taskConfig);
        this.runQueries(Queries.spaceKeyQueries.toQueries(this.getDbType(), new String[0]), this.createQueryRunner(Collections.singletonMap(SPACE_KEY, taskConfig.getSpaceKey()), extractedUserKeys), exportDir, taskConfig);
        this.runQueries(Queries.AO187_QUERY.toQueries(this.getDbType(), new String[0]), this.createQueryRunner(Collections.singletonMap(SPACE_KEY, taskConfig.getSpaceKey()), extractedUserKeys), exportDir, taskConfig);
    }

    private void exportBodyContents(String exportDir, Set<String> extractedUserKeys, SpaceCSVExportTaskContext taskConfig, String contentIdTable) {
        this.runQueries(Queries.bodycontentQueriesWithUsersInContent.toQueries(this.getDbType(), contentIdTable), this.createQueryRunner(Collections.singletonMap(SPACE_ID, taskConfig.getTaskId()), (Query query, RowProcessor processor) -> new UserKeyXmlExtractor((RowProcessor)processor, extractedUserKeys)), exportDir, taskConfig);
    }

    private boolean confluenceBefore7_0_1() {
        return this.descriptorBuilder.getBuildNumber() < 8201;
    }

    @Override
    public void reportExportTablePerformance(SpaceCSVExportTaskContext taskContext, boolean success, String tableName, String query, String dbType, long totalTimeTaken, long timeToFirstRow, long rowsExported, long totalContentChars) {
        EventDto tableExportEvent = this.analyticsEventBuilder.buildSpaceTableExportedToCSVTimerEvent(success, totalTimeTaken, taskContext.getSpaceKey(), taskContext.getPlanId(), taskContext.getTaskId(), tableName, query, dbType, timeToFirstRow, rowsExported, totalContentChars);
        this.analyticsEventService.saveAnalyticsEventAsync(() -> tableExportEvent);
    }
}

