/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.store.guardrails.GrQuery;
import com.atlassian.migration.agent.store.guardrails.L1AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.results.MembershipPerGroupOverLimitQueryResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;

public class MembershipPerGroupOverLimitQuery
implements GrQuery<MembershipPerGroupOverLimitQueryResult>,
L1AssessmentQuery<MembershipPerGroupOverLimitQueryResult> {
    private static final String MEMBERSHIP_PER_GROUP_30K = "MEMBERSHIPS_PER_GROUP_WITH_MORE_THAN_30K_USERS";
    private static final long LIMIT = 30000L;
    private final EntityManagerTemplate tmpl;

    public MembershipPerGroupOverLimitQuery(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    @Override
    public String getQueryId() {
        return MEMBERSHIP_PER_GROUP_30K;
    }

    @Override
    public MembershipPerGroupOverLimitQueryResult execute() {
        String query = "select cg.id, count(cm.id) from CrowdMembership cm join CrowdGroup cg on cg.id=cm.parent group by cg.id having count(cm.id)>=30000";
        List<Object[]> groups = this.tmpl.query(Object[].class, query).list();
        return new MembershipPerGroupOverLimitQueryResult(groups);
    }
}

