/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.user;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.domain.Product;
import com.atlassian.cmpt.domain.ProductType;
import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.extract.UserGroupExtractFacade;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.impl.UserService;
import com.atlassian.migration.agent.service.user.GroupPermission;
import com.atlassian.migration.agent.service.user.MigrationUserDto;
import com.atlassian.migration.agent.service.user.UsersMigrationException;
import com.atlassian.migration.agent.service.user.request.v2.GroupProductPermission;
import com.atlassian.migration.agent.service.user.request.v2.MigrationGroupV2Dto;
import com.atlassian.migration.agent.service.user.request.v2.UsersMigrationV2FilePayload;
import com.atlassian.migration.agent.service.user.request.v2.UsersMigrationV2Request;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class UsersMigrationRequestBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UsersMigrationRequestBuilder.class);
    private final UserService userService;
    private final GroupManager groupManager;
    private final SpacePermissionManager spacePermissionManager;
    private final UserGroupExtractFacade userGroupExtractFacade;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final SENSupplier senSupplier;
    private final PluginVersionManager pluginVersionManager;
    private final SystemInformationService systemInformationService;

    public UsersMigrationRequestBuilder(GroupManager groupManager, SpacePermissionManager spacePermissionManager, UserService userService, UserGroupExtractFacade userGroupExtractFacade, MigrationDarkFeaturesManager migrationDarkFeaturesManager, SENSupplier senSupplier, PluginVersionManager pluginVersionManager, SystemInformationService systemInformationService) {
        this.groupManager = groupManager;
        this.spacePermissionManager = spacePermissionManager;
        this.userService = userService;
        this.userGroupExtractFacade = userGroupExtractFacade;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.senSupplier = senSupplier;
        this.pluginVersionManager = pluginVersionManager;
        this.systemInformationService = systemInformationService;
    }

    public UsersMigrationV2FilePayload createUsersMigrationRequestV2FilePayload() {
        return this.createUsersMigrationRequestV2FilePayload(Collections.emptySet());
    }

    public UsersMigrationV2FilePayload createUsersMigrationRequestV2FilePayload(Set<String> spaceKeys) {
        if (spaceKeys.isEmpty()) {
            return this.createMigrateAllUsersMigrationRequestV2();
        }
        return this.createScopedUsersMigrationRequestV2(spaceKeys);
    }

    public UsersMigrationV2Request createUsersMigrationRequestV2(String migrationScopeId, String migrationId, String planId, String cloudId, UsersMigrationV2FilePayload usersMigrationV2FilePayload) {
        try {
            String userMigrationUploadedUrl = this.userService.saveUsersMigrationV2PayloadToFileAndFetchDownloadUrl(migrationId, planId, cloudId, usersMigrationV2FilePayload);
            return new UsersMigrationV2Request(this.senSupplier.get(), ProductType.CONFLUENCE, migrationScopeId, new URL(userMigrationUploadedUrl), this.pluginVersionManager.getPluginVersion(), this.systemInformationService.getConfluenceInfo().getVersion(), this.systemInformationService.getDatabaseInfo().getVersion());
        }
        catch (UncheckedInterruptedException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new UsersMigrationException("Error while creating user migration request for migration: " + migrationId, exception);
        }
    }

    private UsersMigrationV2FilePayload createMigrateAllUsersMigrationRequestV2() {
        Collection<MigrationUser> users = this.getUsersForMigration();
        Collection<Group> serverGroups = this.getAllServerGroups();
        return new UsersMigrationV2FilePayload(UsersMigrationRequestBuilder.toMigrationRequestUsers(users), this.toMigrationRequestGroupsV2(serverGroups), this.getGroupsMembership(serverGroups, users));
    }

    private UsersMigrationV2FilePayload createScopedUsersMigrationRequestV2(Set<String> spaceKeys) {
        ArrayList<String> spaceKeyList = new ArrayList<String>(spaceKeys);
        Collection<MigrationUser> users = this.getMigrationUsersForSpaces(spaceKeyList);
        Set<String> groupsFromSpaces = this.userGroupExtractFacade.getGroupsFromSpaces(spaceKeyList);
        List<Group> filteredGroups = this.getFilteredGroupsForSpaces(groupsFromSpaces);
        return new UsersMigrationV2FilePayload(UsersMigrationRequestBuilder.toMigrationRequestUsers(users), this.toMigrationRequestGroupsV2(filteredGroups), this.getGroupsMembership(filteredGroups, users));
    }

    private Collection<MigrationUser> getMigrationUsersForSpaces(List<String> spaceKeyList) {
        Set<String> userKeys = this.userGroupExtractFacade.getUsersFromSpaces(spaceKeyList);
        return this.getUsersForMigration().stream().filter(migrationUser -> userKeys.contains(migrationUser.getUserKey())).collect(Collectors.toList());
    }

    private List<Group> getFilteredGroupsForSpaces(Set<String> groupsFromSpaces) {
        Collection<Group> serverGroups = this.getAllServerGroups();
        return serverGroups.stream().filter(serverGroup -> groupsFromSpaces.contains(serverGroup.getName())).collect(Collectors.toList());
    }

    @VisibleForTesting
    Collection<MigrationUser> getUsersForMigration() {
        if (this.migrationDarkFeaturesManager.shouldHandleInvalidAndDuplicateEmailUsers()) {
            return this.userService.getAllUsersExcludingInvalidEmailUsers().stream().collect(Collectors.toMap(user -> IdentityAcceptedEmailValidator.cleanse((String)user.getEmail()), Function.identity(), (older, newer) -> older)).values();
        }
        return this.userService.getAllUsers();
    }

    private Collection<MigrationGroupV2Dto> toMigrationRequestGroupsV2(Collection<Group> groups) {
        return groups.stream().map(group -> {
            Collection groupPermissions = this.spacePermissionManager.getAllPermissionsForGroup(group.getName()).stream().flatMap(UsersMigrationRequestBuilder::mapSpacePermissionToGroupPermissions).collect(Collectors.toSet());
            List<GroupProductPermission> groupProductPermissions = Collections.emptyList();
            if (!groupPermissions.isEmpty()) {
                groupProductPermissions = Collections.singletonList(new GroupProductPermission(Product.CONFLUENCE, groupPermissions));
            }
            return new MigrationGroupV2Dto(group.getName(), groupProductPermissions);
        }).collect(Collectors.toList());
    }

    private Map<String, Collection<String>> getGroupsMembership(Collection<Group> groups, Collection<MigrationUser> users) {
        return groups.stream().collect(Collectors.toMap(Entity::getName, group -> {
            try {
                HashSet userIdsOfGroup = Sets.newHashSet((Iterable)this.groupManager.getMemberNames(group));
                return users.stream().filter(it -> userIdsOfGroup.contains(it.getUsername())).map(MigrationUser::getEmail).collect(Collectors.toList());
            }
            catch (EntityException e) {
                throw new RuntimeException(String.format("Couldn't retrieve members of group %s", group.getName()), e);
            }
        }));
    }

    private Collection<Group> getAllServerGroups() {
        ArrayList serverGroups;
        try {
            serverGroups = Lists.newArrayList((Iterable)this.groupManager.getGroups());
        }
        catch (EntityException e) {
            throw new RuntimeException("Couldn't retrieve groups", e);
        }
        return serverGroups;
    }

    private static Collection<MigrationUserDto> toMigrationRequestUsers(Collection<MigrationUser> users) {
        return users.stream().map(user -> new MigrationUserDto(user.getUserKey(), user.getUsername(), user.getEmail(), user.getFullName(), user.isActive())).collect(Collectors.toList());
    }

    private static Stream<GroupPermission> mapSpacePermissionToGroupPermissions(SpacePermission spacePermission) {
        switch (spacePermission.getType()) {
            case "USECONFLUENCE": {
                return Stream.of(GroupPermission.HAS_PRODUCT_ACCESS);
            }
            case "ADMINISTRATECONFLUENCE": {
                return Stream.of(GroupPermission.PRODUCT_ADMIN);
            }
            case "SYSTEMADMINISTRATOR": {
                return Stream.of(GroupPermission.SYSTEM_ADMIN);
            }
        }
        return Stream.empty();
    }
}

