/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.queue.QueueConsumer;
import com.atlassian.migration.agent.queue.QueueConsumerConfiguration;
import com.atlassian.migration.agent.service.ExportDirManager;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.execution.SpaceBoundStepExecutor;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.StepSchedulerService;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class SpaceUsersMigrationExecutor
implements QueueConsumer,
JobRunner,
SpaceBoundStepExecutor {
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceUsersMigrationExecutor.class);
    private static final Duration POLLING_PERIOD = Duration.ofSeconds(5L);
    @VisibleForTesting
    static final JobRunnerKey SPACE_USERS_EXECUTOR_RUNNER_KEY = JobRunnerKey.of((String)"migration-plugin:space-users-migrate-executor");
    @VisibleForTesting
    static final String STEP_ID_PARAMS_KEY = "stepId";
    private final StepSchedulerService stepSchedulerService;
    private final SchedulerService schedulerService;
    private final StepStore stepStore;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final PluginTransactionTemplate ptx;
    private final ExportDirManager exportDirManager;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final SpaceManager spaceManager;
    private final Supplier<Instant> instantSupplier;

    public SpaceUsersMigrationExecutor(StepSchedulerService stepSchedulerService, SchedulerService schedulerService, StepStore stepStore, PluginTransactionTemplate ptx, MigrationAgentConfiguration migrationAgentConfiguration, MigrationDarkFeaturesManager migrationDarkFeaturesManager, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, SpaceManager spaceManager, ExportDirManager exportDirManager) {
        this(stepSchedulerService, schedulerService, stepStore, ptx, migrationAgentConfiguration, migrationDarkFeaturesManager, analyticsEventService, analyticsEventBuilder, spaceManager, exportDirManager, Instant::now);
    }

    @VisibleForTesting
    SpaceUsersMigrationExecutor(StepSchedulerService stepSchedulerService, SchedulerService schedulerService, StepStore stepStore, PluginTransactionTemplate ptx, MigrationAgentConfiguration migrationAgentConfiguration, MigrationDarkFeaturesManager migrationDarkFeaturesManager, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, SpaceManager spaceManager, ExportDirManager exportDirManager, Supplier<Instant> instantSupplier) {
        this.schedulerService = schedulerService;
        this.stepSchedulerService = stepSchedulerService;
        this.stepStore = stepStore;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.ptx = ptx;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.spaceManager = spaceManager;
        this.exportDirManager = exportDirManager;
        this.instantSupplier = instantSupplier;
    }

    @PostConstruct
    public void initialize() {
        this.schedulerService.registerJobRunner(SPACE_USERS_EXECUTOR_RUNNER_KEY, (JobRunner)this);
    }

    @PreDestroy
    public void cleanup() {
        this.schedulerService.unregisterJobRunner(SPACE_USERS_EXECUTOR_RUNNER_KEY);
    }

    @Override
    public QueueConsumerConfiguration getConsumerConfiguration() {
        return QueueConsumerConfiguration.builder(StepType.SPACE_USERS_MIGRATION.name()).withConcurrencyLevel(this.migrationAgentConfiguration.getSpaceUsersMigrationExecutorConcurrency()).build();
    }

    @Override
    public void consume(String stepId, String jobId) {
        this.stepSchedulerService.consumeStep(stepId, StepType.SPACE_USERS_MIGRATION, () -> this.consumeStep(stepId, jobId));
    }

    @VisibleForTesting
    Optional<StepResult> consumeStep(String stepId, String jobId) {
        ImmutableMap jobParams = ImmutableMap.of((Object)STEP_ID_PARAMS_KEY, (Object)stepId);
        this.stepSchedulerService.scheduleStepOnce(stepId, SPACE_USERS_EXECUTOR_RUNNER_KEY, JobId.of((String)jobId), StepType.SPACE_USERS_MIGRATION, (Map<String, Serializable>)jobParams);
        return Optional.empty();
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        String stepId = (String)request.getJobConfig().getParameters().get(STEP_ID_PARAMS_KEY);
        this.stepSchedulerService.runScheduledStep(request.getJobId(), StepType.SPACE_USERS_MIGRATION, stepId, () -> this.getSpaceUsersMigrationStepResult(stepId));
        return JobRunnerResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Optional<StepResult> doSpaceUserMigration(String stepId, String fileId) {
        long elapsedTime;
        Optional<StepResult> optional;
        if (!this.migrationDarkFeaturesManager.isSpaceUsersMigrationStepEnabled() || this.migrationDarkFeaturesManager.isEnableOriginalXMLExport()) {
            log.info("Space users migration has been skipped.");
            return Optional.of(StepResult.succeeded("Space users migration has been skipped.", fileId));
        }
        long startTime = this.instantSupplier.get().toEpochMilli();
        boolean success = false;
        log.info("Space users migration step has started with stepId: {}.", (Object)stepId);
        try {
            Path exportFilePath = this.exportDirManager.getExportFilePath(fileId);
            Optional<StepResult> result = Optional.of(StepResult.succeeded("Space users migration successful.", fileId));
            log.info("Space users migration has finished with export filePath: {}", (Object)exportFilePath.getFileName());
            success = true;
            optional = result;
            elapsedTime = this.instantSupplier.get().toEpochMilli() - startTime;
        }
        catch (Throwable throwable) {
            long elapsedTime2 = this.instantSupplier.get().toEpochMilli() - startTime;
            log.debug("Space users migration step is completed with success: {} for stepId: {} and fileId: {}, with elapsed time (in ms): {}.", new Object[]{success, stepId, fileId, elapsedTime2});
            throw throwable;
        }
        log.debug("Space users migration step is completed with success: {} for stepId: {} and fileId: {}, with elapsed time (in ms): {}.", new Object[]{success, stepId, fileId, elapsedTime});
        return optional;
    }

    @Override
    public StepType getStepType() {
        return StepType.SPACE_USERS_MIGRATION;
    }

    @Override
    public StepResult runStep(String stepId) {
        Optional<StepResult> result;
        try {
            while (!(result = this.getSpaceUsersMigrationStepResult(stepId)).isPresent()) {
                Thread.sleep(POLLING_PERIOD.toMillis());
            }
        }
        catch (UncheckedInterruptedException | InterruptedException e) {
            log.info("Space import was stopped. StepId={}", (Object)stepId);
            return StepResult.stopped();
        }
        return result.get();
    }

    private Optional<StepResult> getSpaceUsersMigrationStepResult(String stepId) {
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        String spaceKey = ((ConfluenceSpaceTask)step.getTask()).getSpaceKey();
        return Optional.ofNullable(this.wrapStepResultSupplier(this.analyticsEventBuilder, this.analyticsEventService, step, spaceKey, this.spaceManager, () -> this.doSpaceUserMigration(stepId, step.getConfig()).orElse(null)));
    }
}

