/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.UploadDestinationType;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.media.MediaFileUploader;
import com.atlassian.migration.agent.media.MediaFileUploaderFactory;
import com.atlassian.migration.agent.media.MediaUploadException;
import com.atlassian.migration.agent.queue.QueueConsumer;
import com.atlassian.migration.agent.queue.QueueConsumerConfiguration;
import com.atlassian.migration.agent.service.ExportDirManager;
import com.atlassian.migration.agent.service.MigrationErrorCode;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.ErrorEvent;
import com.atlassian.migration.agent.service.catalogue.MigrationCatalogueStorageService;
import com.atlassian.migration.agent.service.catalogue.model.MigrationCatalogueStorageFile;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.execution.SpaceBoundStepExecutor;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepExecutionException;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.StepSchedulerService;
import com.atlassian.migration.agent.service.util.StopConditionCheckingUtil;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class SpaceUploadExecutor
implements QueueConsumer,
JobRunner,
SpaceBoundStepExecutor {
    @VisibleForTesting
    static final String UPLOAD_STATUS_JOB_PARAMS_KEY = "uploadStatusJobParams";
    @VisibleForTesting
    static final StepType UPLOAD_STEP_TYPE = StepType.DATA_UPLOAD;
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceUploadExecutor.class);
    private static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"migration-plugin:upload-executor");
    private static final int UPLOAD_WORK_THREAD_COUNT = 5;
    private final ProgressTracker progressTracker;
    private final MediaFileUploaderFactory mediaFileUploaderFactory;
    private final StepSchedulerService stepSchedulerService;
    private final SchedulerService schedulerService;
    private final ExportDirManager exportDirManager;
    private final CloudSiteService cloudSiteService;
    private final StepStore stepStore;
    private final PluginTransactionTemplate ptx;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final MigrationCatalogueStorageService migrationCatalogueStorageService;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final SpaceManager spaceManager;

    public SpaceUploadExecutor(ProgressTracker progressTracker, StepSchedulerService stepSchedulerService, SchedulerService schedulerService, MediaFileUploaderFactory mediaFileUploaderFactory, ExportDirManager exportDirManager, CloudSiteService cloudSiteService, StepStore stepStore, PluginTransactionTemplate ptx, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, MigrationDarkFeaturesManager migrationDarkFeaturesManager, MigrationCatalogueStorageService migrationCatalogueStorageService, MigrationAgentConfiguration migrationAgentConfiguration, SpaceManager spaceManager) {
        this(progressTracker, stepSchedulerService, schedulerService, mediaFileUploaderFactory, exportDirManager, cloudSiteService, stepStore, ptx, Instant::now, analyticsEventService, analyticsEventBuilder, migrationDarkFeaturesManager, migrationCatalogueStorageService, migrationAgentConfiguration, spaceManager);
    }

    @VisibleForTesting
    SpaceUploadExecutor(ProgressTracker progressTracker, StepSchedulerService stepSchedulerService, SchedulerService schedulerService, MediaFileUploaderFactory mediaFileUploaderFactory, ExportDirManager exportDirManager, CloudSiteService cloudSiteService, StepStore stepStore, PluginTransactionTemplate ptx, Supplier<Instant> instantSupplier, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, MigrationDarkFeaturesManager migrationDarkFeaturesManager, MigrationCatalogueStorageService migrationCatalogueStorageService, MigrationAgentConfiguration migrationAgentConfiguration, SpaceManager spaceManager) {
        this.progressTracker = progressTracker;
        this.stepSchedulerService = stepSchedulerService;
        this.schedulerService = schedulerService;
        this.cloudSiteService = cloudSiteService;
        this.mediaFileUploaderFactory = mediaFileUploaderFactory;
        this.exportDirManager = exportDirManager;
        this.stepStore = stepStore;
        this.ptx = ptx;
        this.instantSupplier = instantSupplier;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.migrationCatalogueStorageService = migrationCatalogueStorageService;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.spaceManager = spaceManager;
    }

    @PostConstruct
    public void initialize() {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
    }

    @PreDestroy
    public void cleanup() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
    }

    @Override
    public QueueConsumerConfiguration getConsumerConfiguration() {
        return QueueConsumerConfiguration.builder(UPLOAD_STEP_TYPE.name()).withConcurrencyLevel(this.migrationAgentConfiguration.getSpaceUploadExecutorConcurrency()).build();
    }

    @Override
    public void consume(String stepId, String jobId) {
        this.stepSchedulerService.consumeStep(stepId, UPLOAD_STEP_TYPE, () -> {
            Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
            ConfluenceSpaceTask task = (ConfluenceSpaceTask)step.getTask();
            Plan plan = step.getPlan();
            String fileId = step.getConfig();
            ImmutableMap jobParams = ImmutableMap.of((Object)UPLOAD_STATUS_JOB_PARAMS_KEY, (Object)Jsons.valueAsString(new UploadStatusJobParameters(stepId, fileId, plan.getCloudSite().getCloudId(), plan.getMigrationId(), task.getSpaceKey(), plan.getId(), task.getId())));
            this.stepSchedulerService.scheduleStepOnce(stepId, RUNNER_KEY, JobId.of((String)jobId), UPLOAD_STEP_TYPE, (Map<String, Serializable>)jobParams);
            return Optional.empty();
        });
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        UploadStatusJobParameters jobParams = Jsons.readValue((String)request.getJobConfig().getParameters().get(UPLOAD_STATUS_JOB_PARAMS_KEY), UploadStatusJobParameters.class);
        Step step = this.ptx.read(() -> this.stepStore.getStep(jobParams.stepId));
        this.stepSchedulerService.runStep(jobParams.stepId, UPLOAD_STEP_TYPE, () -> this.wrapStepResultSupplier(this.analyticsEventBuilder, this.analyticsEventService, step, jobParams.spaceKey, this.spaceManager, () -> this.doSpaceUpload(jobParams.stepId, jobParams.fileId, jobParams.cloudId, jobParams.migrationId, jobParams.spaceKey, jobParams.planId, jobParams.taskId)));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    StepResult doSpaceUpload(String stepId, String fileId, String cloudId, String migrationId, String spaceKey, String planId, String taskId) {
        UploadDestinationType uploadType = this.getUploadType();
        long startTime = this.instantSupplier.get().toEpochMilli();
        long freeHeapSizeAtStart = Runtime.getRuntime().freeMemory();
        long combinedUploadSize = -1L;
        boolean success = false;
        Step step = this.stepStore.getStep(stepId);
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildSpaceUploadStartEvent(step, startTime, uploadType, fileId, spaceKey));
        log.info("Migration {} Space {} upload started with uploadType {}", new Object[]{migrationId, spaceKey, uploadType});
        try {
            if (uploadType.equals((Object)UploadDestinationType.MCS)) {
                List<MigrationCatalogueStorageFile> uploadedFiles = this.uploadFilesToMCS(cloudId, migrationId, fileId, spaceKey, step);
                String jsonAsString = Jsons.valueAsString(uploadedFiles);
                combinedUploadSize = uploadedFiles.stream().mapToLong(MigrationCatalogueStorageFile::getSize).sum();
                success = true;
                StepResult stepResult = StepResult.succeeded("Data upload successful", jsonAsString);
                return stepResult;
            }
            String containerToken = this.cloudSiteService.getByStepId(stepId).getContainerToken();
            MediaFileUploader uploader = this.mediaFileUploaderFactory.create(containerToken);
            combinedUploadSize = this.exportDirManager.getExportSize(fileId);
            String mediaFileId = this.exportDirManager.consumeExportFileSafely(fileId, exportFile -> this.uploadFileToMedia((File)exportFile, uploader, stepId, fileId, migrationId));
            success = true;
            StepResult additionalAttributes = StepResult.succeeded("Data upload successful", mediaFileId);
            return additionalAttributes;
        }
        catch (UncheckedInterruptedException e) {
            log.info("Space Upload was stopped - spacekey [{}] | stepId [{}] | fileId [{}] | migrationId [{}]", new Object[]{spaceKey, stepId, fileId, migrationId});
            StepResult uploader = StepResult.stopped();
            return uploader;
        }
        catch (StepExecutionException e) {
            String failureReason = "Failed to upload file with ID " + fileId;
            success = this.checkIfGoodEventAndLoggingAnalyticEvents(migrationId, cloudId, e.getErrorCode(), e.getMessage(), spaceKey, failureReason, uploadType);
            StepResult stepResult = StepResult.failed(failureReason, e);
            return stepResult;
        }
        catch (Exception e) {
            String failureReason = "Failed to upload file with ID " + fileId;
            success = this.checkIfGoodEventAndLoggingAnalyticEvents(migrationId, cloudId, MigrationErrorCode.SPACE_UPLOAD_FAILED, e.getMessage(), spaceKey, failureReason, uploadType);
            StepResult stepResult = StepResult.failed(failureReason, e);
            return stepResult;
        }
        finally {
            ImmutableMap additionalAttributes = ImmutableMap.of((Object)"stepSuccessful", (Object)String.valueOf(success), (Object)"uploadType", (Object)uploadType.name());
            this.analyticsEventService.saveAnalyticsEvents(() -> this.lambda$doSpaceUpload$8(step, (Map)additionalAttributes, freeHeapSizeAtStart));
            this.saveStepCounterMetric(uploadType, success);
            this.saveStepTimerEvent(success, this.instantSupplier.get().toEpochMilli() - startTime, spaceKey, step, combinedUploadSize, uploadType);
        }
    }

    @VisibleForTesting
    UploadDestinationType getUploadType() {
        if (this.migrationDarkFeaturesManager.isEnableOriginalXMLExport()) {
            return UploadDestinationType.MEDIA;
        }
        if (this.migrationAgentConfiguration.isDBTypeSupportedForRapidExport() && !this.migrationDarkFeaturesManager.newExportEnabled()) {
            return UploadDestinationType.MCS;
        }
        if (this.migrationDarkFeaturesManager.newExportEnabled() || this.migrationDarkFeaturesManager.isXMLToCSVAndUploadToMCSEnabled()) {
            return UploadDestinationType.MCS;
        }
        return UploadDestinationType.MEDIA;
    }

    @VisibleForTesting
    String uploadFileToMedia(File exportFile, MediaFileUploader uploader, String stepId, String fileId, String migrationId) {
        try {
            String mediaFileId = uploader.uploadExportZip(exportFile, this.generateUploadTracker(stepId, exportFile.length()));
            if (StringUtils.isBlank((CharSequence)mediaFileId)) {
                throw new StepExecutionException(MigrationErrorCode.MEDIA_UPLOAD_ERROR, UPLOAD_STEP_TYPE, migrationId, "Failed to retrieve a valid mediaFileId.");
            }
            log.debug("Done uploading exported file: {} for step: {}, media file id: {}", new Object[]{fileId, stepId, mediaFileId});
            return mediaFileId;
        }
        catch (MediaUploadException e) {
            throw new StepExecutionException(MigrationErrorCode.MEDIA_UPLOAD_ERROR, UPLOAD_STEP_TYPE, migrationId, e.getMessage(), e);
        }
    }

    @VisibleForTesting
    MediaFileUploader.Tracker generateUploadTracker(String stepId, long fileSize) {
        return uploadedBytes -> {
            int percentageComplete = fileSize == 0L ? 100 : (int)(uploadedBytes * 100L / fileSize);
            this.progressTracker.progress(stepId, percentageComplete, String.format("Uploaded %s of %s", FileUtils.byteCountToDisplaySize((long)uploadedBytes), FileUtils.byteCountToDisplaySize((long)fileSize)));
        };
    }

    private List<MigrationCatalogueStorageFile> uploadFilesToMCS(String cloudId, String migrationId, String fileId, String spaceKey, Step step) {
        Path exportFilePath = this.exportDirManager.getExportFilePath(fileId);
        ForkJoinPool customThreadPool = new ForkJoinPool(5);
        try {
            long spaceId = this.spaceManager.getSpace(spaceKey).getId();
            List list = (List)((ForkJoinTask)customThreadPool.submit(() -> new ArrayList(FileUtils.listFiles((File)exportFilePath.toFile(), null, (boolean)false)).parallelStream().map(file -> this.upload(cloudId, migrationId, (File)file, spaceKey, step, String.valueOf(spaceId))).collect(Collectors.toList()))).get();
            return list;
        }
        catch (InterruptedException | ExecutionException e) {
            if (StopConditionCheckingUtil.isStoppingExceptionInCausalChain(e)) {
                log.warn("File upload was stopped - spaceKey [{}] | fileId [{}] | planId [{}]", new Object[]{spaceKey, fileId, step.getPlan().getId()});
                throw new UncheckedInterruptedException(e);
            }
            throw new StepExecutionException(MigrationErrorCode.MCS_API_ERROR, UPLOAD_STEP_TYPE, migrationId, e.getMessage(), e);
        }
        catch (Exception e) {
            log.error("Error in uploading files to MCS", (Throwable)e);
            throw new StepExecutionException(MigrationErrorCode.MCS_API_ERROR, UPLOAD_STEP_TYPE, migrationId, e.getMessage(), e);
        }
        finally {
            this.exportDirManager.cleanupExportFile(exportFilePath);
            customThreadPool.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MigrationCatalogueStorageFile upload(String cloudId, String migrationId, File file, String spaceKey, Step step, String spaceId) {
        long startTime = this.instantSupplier.get().toEpochMilli();
        boolean success = false;
        try {
            MigrationCatalogueStorageFile fileUpload = this.migrationCatalogueStorageService.uploadFileToMCS(cloudId, migrationId, file.toPath(), spaceId);
            log.info("File uploaded to MCS fileId: {}, name: {}, size: {}", new Object[]{fileUpload.getFileId(), fileUpload.getName(), fileUpload.getSize()});
            success = true;
            MigrationCatalogueStorageFile migrationCatalogueStorageFile = fileUpload;
            long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime;
            this.saveMCSFileUploadTimerEvent(success, timeTaken, spaceKey, step, file.canRead() ? file.length() : -1L, file.getName());
            return migrationCatalogueStorageFile;
        }
        catch (Throwable throwable) {
            long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime;
            this.saveMCSFileUploadTimerEvent(success, timeTaken, spaceKey, step, file.canRead() ? file.length() : -1L, file.getName());
            throw throwable;
        }
    }

    private void saveStepTimerEvent(boolean successful, long timeTaken, String spaceKey, Step step, long uploadSize, UploadDestinationType uploadType) {
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildSpaceUploadStepTimerEvent(successful, timeTaken, spaceKey, step, uploadSize, uploadType));
    }

    private void saveMCSFileUploadTimerEvent(boolean successful, long timeTaken, String spaceKey, Step step, long uploadSize, String filename) {
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildMCSFileUploadTimerEvent(successful, timeTaken, spaceKey, step, uploadSize, filename));
    }

    private void saveStepCounterMetric(UploadDestinationType uploadDestinationType, boolean success) {
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildUploadStepCounterEvent(uploadDestinationType, success));
    }

    private boolean checkIfGoodEventAndLoggingAnalyticEvents(String migrationId, String cloudId, MigrationErrorCode errorCode, String response, String spaceKey, String failureReason, UploadDestinationType uploadType) {
        log.error("Migration: {} Steptype: DATA_UPLOAD spaceKey: {} error: {}", new Object[]{migrationId, spaceKey, failureReason});
        return this.checkIfGoodEventAndSaveStepErrorAnalyticEvents(migrationId, cloudId, errorCode, response, spaceKey, uploadType);
    }

    private boolean checkIfGoodEventAndSaveStepErrorAnalyticEvents(String migrationId, String cloudId, MigrationErrorCode errorCode, String response, String spaceKey, UploadDestinationType uploadType) {
        boolean isSloGoodEvent = errorCode.shouldBeTreatedAsGoodEventInReliabilitySlo();
        ErrorEvent errorEvent = new ErrorEvent.ErrorEventBuilder(errorCode, errorCode.getContainerType(), migrationId, UPLOAD_STEP_TYPE).setCloudid(cloudId).setReason(response).setSpaceKey(spaceKey).build();
        this.analyticsEventService.sendAnalyticsEvents(() -> ImmutableList.of((Object)this.analyticsEventBuilder.buildFailedSpaceMigration(UPLOAD_STEP_TYPE, errorCode), (Object)this.analyticsEventBuilder.buildErrorOperationalEventForSpaceUpload(errorEvent, uploadType)));
        return isSloGoodEvent;
    }

    @Override
    public StepType getStepType() {
        return StepType.DATA_UPLOAD;
    }

    @Override
    public StepResult runStep(String stepId) {
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        String spaceKey = ((ConfluenceSpaceTask)step.getTask()).getSpaceKey();
        return this.wrapStepResultSupplier(this.analyticsEventBuilder, this.analyticsEventService, step, spaceKey, this.spaceManager, () -> this.doSpaceUpload(step.getId(), step.getConfig(), step.getPlan().getCloudSite().getCloudId(), step.getPlan().getMigrationId(), spaceKey, step.getPlan().getId(), step.getTask().getId()));
    }

    private /* synthetic */ Collection lambda$doSpaceUpload$8(Step step, Map additionalAttributes, long freeHeapSizeAtStart) {
        return ImmutableList.of((Object)this.analyticsEventBuilder.buildCompletedStepAnalyticsEvent(step, () -> additionalAttributes), (Object)this.analyticsEventBuilder.buildStepLevelHeapSizeAnalyticsEvent(step, freeHeapSizeAtStart, this.migrationAgentConfiguration.getSpaceUploadExecutorConcurrency()));
    }

    @VisibleForTesting
    static class UploadStatusJobParameters
    implements Serializable {
        private String stepId;
        private String fileId;
        private String cloudId;
        private String migrationId;
        private String spaceKey;
        private String planId;
        private String taskId;

        @JsonCreator
        UploadStatusJobParameters(@JsonProperty(value="stepId") String stepId, @JsonProperty(value="stepConfig") String stepConfig, @JsonProperty(value="cloudId") String cloudId, @JsonProperty(value="migrationId") String migrationId, @JsonProperty(value="spaceKey") String spaceKey, @JsonProperty(value="planId") String planId, @JsonProperty(value="taskId") String taskId) {
            this.stepId = stepId;
            this.fileId = stepConfig;
            this.cloudId = cloudId;
            this.migrationId = migrationId;
            this.spaceKey = spaceKey;
            this.planId = planId;
            this.taskId = taskId;
        }

        @Generated
        public String getStepId() {
            return this.stepId;
        }

        @Generated
        public String getFileId() {
            return this.fileId;
        }

        @Generated
        public String getCloudId() {
            return this.cloudId;
        }

        @Generated
        public String getMigrationId() {
            return this.migrationId;
        }

        @Generated
        public String getSpaceKey() {
            return this.spaceKey;
        }

        @Generated
        public String getPlanId() {
            return this.planId;
        }

        @Generated
        public String getTaskId() {
            return this.taskId;
        }

        @Generated
        public void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Generated
        public void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Generated
        public void setCloudId(String cloudId) {
            this.cloudId = cloudId;
        }

        @Generated
        public void setMigrationId(String migrationId) {
            this.migrationId = migrationId;
        }

        @Generated
        public void setSpaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
        }

        @Generated
        public void setPlanId(String planId) {
            this.planId = planId;
        }

        @Generated
        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UploadStatusJobParameters)) {
                return false;
            }
            UploadStatusJobParameters other = (UploadStatusJobParameters)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$stepId = this.getStepId();
            String other$stepId = other.getStepId();
            if (this$stepId == null ? other$stepId != null : !this$stepId.equals(other$stepId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
                return false;
            }
            String this$cloudId = this.getCloudId();
            String other$cloudId = other.getCloudId();
            if (this$cloudId == null ? other$cloudId != null : !this$cloudId.equals(other$cloudId)) {
                return false;
            }
            String this$migrationId = this.getMigrationId();
            String other$migrationId = other.getMigrationId();
            if (this$migrationId == null ? other$migrationId != null : !this$migrationId.equals(other$migrationId)) {
                return false;
            }
            String this$spaceKey = this.getSpaceKey();
            String other$spaceKey = other.getSpaceKey();
            if (this$spaceKey == null ? other$spaceKey != null : !this$spaceKey.equals(other$spaceKey)) {
                return false;
            }
            String this$planId = this.getPlanId();
            String other$planId = other.getPlanId();
            if (this$planId == null ? other$planId != null : !this$planId.equals(other$planId)) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            return !(this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UploadStatusJobParameters;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $stepId = this.getStepId();
            result = result * 59 + ($stepId == null ? 43 : $stepId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            String $cloudId = this.getCloudId();
            result = result * 59 + ($cloudId == null ? 43 : $cloudId.hashCode());
            String $migrationId = this.getMigrationId();
            result = result * 59 + ($migrationId == null ? 43 : $migrationId.hashCode());
            String $spaceKey = this.getSpaceKey();
            result = result * 59 + ($spaceKey == null ? 43 : $spaceKey.hashCode());
            String $planId = this.getPlanId();
            result = result * 59 + ($planId == null ? 43 : $planId.hashCode());
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SpaceUploadExecutor.UploadStatusJobParameters(stepId=" + this.getStepId() + ", fileId=" + this.getFileId() + ", cloudId=" + this.getCloudId() + ", migrationId=" + this.getMigrationId() + ", spaceKey=" + this.getSpaceKey() + ", planId=" + this.getPlanId() + ", taskId=" + this.getTaskId() + ")";
        }
    }
}

