/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.ImportType;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.json.JsonSerializingException;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.queue.QueueConsumer;
import com.atlassian.migration.agent.queue.QueueConsumerConfiguration;
import com.atlassian.migration.agent.service.ConfluenceImportExportTaskStatus;
import com.atlassian.migration.agent.service.MigrationErrorCode;
import com.atlassian.migration.agent.service.SpaceImportContextDto;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.ErrorEvent;
import com.atlassian.migration.agent.service.catalogue.model.MigrationCatalogueStorageFile;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.confluence.ConfluenceCloudService;
import com.atlassian.migration.agent.service.confluence.exception.ConfluenceCloudServiceException;
import com.atlassian.migration.agent.service.execution.SpaceBoundStepExecutor;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepExecutionException;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.StepSchedulerService;
import com.atlassian.migration.agent.service.util.StopConditionCheckingUtil;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.impl.MigratedSpaceStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class SpaceImportExecutor
implements QueueConsumer,
JobRunner,
SpaceBoundStepExecutor {
    private static final String CONF_TASK_ID_JOB_PARAM = "confTaskId";
    private static final String STEP_ID_JOB_PARAM = "stepId";
    private static final StepType IMPORT_STEP_TYPE = StepType.CONFLUENCE_IMPORT;
    private static final Duration POLLING_PERIOD = Duration.ofSeconds(5L);
    private static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"migration-plugin:import-progress-tracker");
    private static final Pattern SPACE_EXISTS_PATTERN = Pattern.compile("A space with key (.+) already exists\\.");
    private static final Pattern PERSONAL_SPACE_EXISTS_PATTERN = Pattern.compile("A personal space already exists for user (.+)\\.");
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceImportExecutor.class);
    private final ProgressTracker progressTracker;
    private final StepStore stepStore;
    private final SchedulerService schedulerService;
    private final StepSchedulerService stepSchedulerService;
    private final CloudSiteService cloudSiteService;
    private final ConfluenceCloudService confluenceCloudService;
    private final PluginTransactionTemplate ptx;
    private final SpaceManager spaceManager;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final MigratedSpaceStore migratedSpaceStore;
    private final MigrationDarkFeaturesManager darkFeaturesManager;
    private final Supplier<Instant> instantSupplier;
    private final MigrationAgentConfiguration migrationAgentConfiguration;

    public SpaceImportExecutor(ProgressTracker progressTracker, StepStore stepStore, StepSchedulerService stepSchedulerService, SchedulerService schedulerService, CloudSiteService cloudSiteService, PluginTransactionTemplate ptx, SpaceManager spaceManager, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, MigratedSpaceStore migratedSpaceStore, MigrationDarkFeaturesManager darkFeaturesManager, MigrationAgentConfiguration migrationAgentConfiguration, ConfluenceCloudService confluenceCloudService) {
        this(progressTracker, stepStore, stepSchedulerService, schedulerService, cloudSiteService, ptx, spaceManager, analyticsEventService, analyticsEventBuilder, migratedSpaceStore, darkFeaturesManager, Instant::now, migrationAgentConfiguration, confluenceCloudService);
    }

    @VisibleForTesting
    SpaceImportExecutor(ProgressTracker progressTracker, StepStore stepStore, StepSchedulerService stepSchedulerService, SchedulerService schedulerService, CloudSiteService cloudSiteService, PluginTransactionTemplate ptx, SpaceManager spaceManager, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, MigratedSpaceStore migratedSpaceStore, MigrationDarkFeaturesManager darkFeaturesManager, Supplier<Instant> instantSupplier, MigrationAgentConfiguration migrationAgentConfiguration, ConfluenceCloudService confluenceCloudService) {
        this.progressTracker = progressTracker;
        this.stepStore = stepStore;
        this.stepSchedulerService = stepSchedulerService;
        this.schedulerService = schedulerService;
        this.cloudSiteService = cloudSiteService;
        this.ptx = ptx;
        this.spaceManager = spaceManager;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.migratedSpaceStore = migratedSpaceStore;
        this.darkFeaturesManager = darkFeaturesManager;
        this.instantSupplier = instantSupplier;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.confluenceCloudService = confluenceCloudService;
    }

    @PostConstruct
    public void initialize() {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
    }

    @PreDestroy
    public void cleanup() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
    }

    @Override
    public QueueConsumerConfiguration getConsumerConfiguration() {
        return QueueConsumerConfiguration.builder(IMPORT_STEP_TYPE.name()).withConcurrencyLevel(this.migrationAgentConfiguration.getSpaceImportExecutorConcurrency()).build();
    }

    @Override
    public void consume(String stepId, String jobId) {
        this.stepSchedulerService.consumeStep(stepId, IMPORT_STEP_TYPE, () -> this.scheduleStep(stepId, jobId));
    }

    @VisibleForTesting
    Optional<StepResult> scheduleStep(String stepId, String jobId) {
        String importTaskId = this.initiateConfluenceSpaceImport(stepId);
        ImmutableMap jobParams = ImmutableMap.of((Object)STEP_ID_JOB_PARAM, (Object)stepId, (Object)CONF_TASK_ID_JOB_PARAM, (Object)importTaskId);
        Schedule schedule = Schedule.forInterval((long)POLLING_PERIOD.toMillis(), (Date)new Date(System.currentTimeMillis() + 5000L));
        this.stepSchedulerService.scheduleStep(stepId, RUNNER_KEY, JobId.of((String)jobId), IMPORT_STEP_TYPE, (Map<String, Serializable>)jobParams, schedule);
        return Optional.empty();
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        String stepId = (String)request.getJobConfig().getParameters().get(STEP_ID_JOB_PARAM);
        String confTaskId = (String)request.getJobConfig().getParameters().get(CONF_TASK_ID_JOB_PARAM);
        Step step = this.stepStore.getStep(stepId);
        this.stepSchedulerService.runScheduledStep(request.getJobId(), IMPORT_STEP_TYPE, stepId, () -> Optional.ofNullable(this.wrapStepResultSupplier(this.analyticsEventBuilder, this.analyticsEventService, step, ((ConfluenceSpaceTask)step.getTask()).getSpaceKey(), this.spaceManager, () -> this.doProgressCheck(step, confTaskId).orElse(null))));
        return null;
    }

    @VisibleForTesting
    String initiateConfluenceSpaceImport(String stepId) {
        Step step = this.stepStore.getStep(stepId);
        if (Objects.isNull(this.spaceManager.getSpace(((ConfluenceSpaceTask)step.getTask()).getSpaceKey()))) {
            log.info("Skipping initiating confluence space import as space cannot be found in server");
            return "SKIPPED";
        }
        log.info("Initiate confluence space import with stepId: {}", (Object)stepId);
        long freeHeapSizeAtStart = Runtime.getRuntime().freeMemory();
        SpaceImportContextDto ctx = this.createSpaceImportContext(stepId);
        CloudSite cloudSite = this.cloudSiteService.getByStepId(stepId);
        String cloudId = cloudSite.getCloudId();
        String containerToken = cloudSite.getContainerToken();
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildSpaceImportStartEvent(step, this.instantSupplier.get().toEpochMilli()));
        ImportType importType = this.getImportType(ctx);
        ConfluenceImportExportTaskStatus response = this.confluenceCloudService.initiateConfluenceSpaceImport(cloudId, containerToken, importType, ctx);
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildStepLevelHeapSizeAnalyticsEvent(step, freeHeapSizeAtStart, this.migrationAgentConfiguration.getSpaceImportExecutorConcurrency()));
        log.info("Initiated import task. Response: {}", (Object)response);
        return response.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Optional<StepResult> doProgressCheck(Step step, String confTaskId) {
        String spaceKey = ((ConfluenceSpaceTask)step.getTask()).getSpaceKey();
        StopConditionCheckingUtil.throwIfStopConditionWasReached();
        String stepId = step.getId();
        String migrationId = step.getPlan().getMigrationId();
        String cloudId = step.getPlan().getCloudSite().getCloudId();
        if (this.stepIsInCompleteStatus(stepId)) {
            log.warn("Step {} already in complete status, no need to do progress check.", (Object)stepId);
            return Optional.empty();
        }
        SpaceImportContextDto spaceImportContextDto = this.createSpaceImportContext(stepId);
        CloudSite cloudSite = this.cloudSiteService.getByStepId(stepId);
        ImportType importType = this.getImportType(spaceImportContextDto);
        ConfluenceImportExportTaskStatus response = null;
        boolean success = false;
        try {
            response = this.confluenceCloudService.getConfluenceSpaceImportProgress(cloudId, cloudSite.getContainerToken(), confTaskId, importType, spaceImportContextDto);
        }
        catch (ConfluenceCloudServiceException exception) {
            this.checkIfGoodEventAndLoggingErrorAnalyticEvents(migrationId, cloudId, exception.getMessage(), spaceKey, importType, confTaskId);
            this.saveCompletedStepAnalyticsEvent(success, importType, step, spaceImportContextDto);
            return Optional.of(SpaceImportExecutor.getStepResultForFailure(exception.getMessage()));
        }
        log.debug("Got progress for task {}: {}", (Object)confTaskId, (Object)response);
        if (!response.isComplete()) {
            this.progressTracker.progress(stepId, response.getPercentageComplete(), "Importing to Confluence Cloud");
            return Optional.empty();
        }
        try {
            if (!response.isSuccessful()) {
                success = this.checkIfGoodEventAndLoggingErrorAnalyticEvents(migrationId, cloudId, response.getMessage(), spaceKey, importType, confTaskId);
                Optional<StepResult> optional = Optional.of(SpaceImportExecutor.getStepResultForFailure(response.getMessage()));
                return optional;
            }
            this.analyticsEventService.sendAnalyticsEvents(() -> ImmutableList.of((Object)this.analyticsEventBuilder.buildSuccessfulSpaceMigration(), (Object)this.analyticsEventBuilder.buildImportStepCounterEvent(importType, true)));
            if (this.darkFeaturesManager.spaceFiltersEnabled()) {
                this.migratedSpaceStore.addSpace(this.spaceManager.getSpace(spaceImportContextDto.getSpaceId().longValue()), cloudSite.getCloudId());
            }
            success = true;
            Optional<StepResult> optional = Optional.of(StepResult.succeeded("Migration complete"));
            return optional;
        }
        finally {
            this.saveCompletedStepAnalyticsEvent(success, importType, step, spaceImportContextDto);
        }
    }

    private boolean checkIfGoodEventAndLoggingErrorAnalyticEvents(String migrationId, String cloudId, String failureReason, String spaceKey, ImportType importType, String importTaskId) {
        ErrorEvent errorEvent = new ErrorEvent.ErrorEventBuilder(MigrationErrorCode.SPACE_IMPORT_FAILED, MigrationErrorCode.SPACE_IMPORT_FAILED.getContainerType(), migrationId, IMPORT_STEP_TYPE).setCloudid(cloudId).setReason(failureReason).setSpaceKey(spaceKey).build();
        ImmutableList events = ImmutableList.of((Object)this.analyticsEventBuilder.buildFailedSpaceMigration(IMPORT_STEP_TYPE, MigrationErrorCode.SPACE_IMPORT_FAILED), (Object)this.analyticsEventBuilder.buildImportStepCounterEvent(importType, false), (Object)this.analyticsEventBuilder.buildErrorOperationalEventForSpaceImport(errorEvent, importType, importTaskId));
        this.analyticsEventService.sendAnalyticsEvents(() -> SpaceImportExecutor.lambda$checkIfGoodEventAndLoggingErrorAnalyticEvents$6((List)events));
        return MigrationErrorCode.SPACE_IMPORT_FAILED.shouldBeTreatedAsGoodEventInReliabilitySlo();
    }

    private void saveCompletedStepAnalyticsEvent(boolean success, ImportType importType, Step step, SpaceImportContextDto spaceImportContextDto) {
        ImmutableMap additionalAttributes = ImmutableMap.of((Object)"stepSuccessful", (Object)String.valueOf(success), (Object)"importType", (Object)importType.name());
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.lambda$saveCompletedStepAnalyticsEvent$8(step, (Map)additionalAttributes));
        this.saveStepTimerEvent(step, spaceImportContextDto, success);
    }

    private void saveStepTimerEvent(Step step, SpaceImportContextDto importContext, boolean success) {
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildSpaceImportTimerEvent(success, this.getStepTime(step), importContext.getSpaceKey(), step));
    }

    private long getStepTime(Step step) {
        Progress progress = step.getProgress();
        if (progress != null && progress.getStartTime().isPresent()) {
            return this.instantSupplier.get().toEpochMilli() - progress.getStartTime().get().toEpochMilli();
        }
        return -1L;
    }

    private boolean stepIsInCompleteStatus(String stepId) {
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        return step.getProgress().getStatus().isCompleted();
    }

    @VisibleForTesting
    static StepResult getStepResultForFailure(@Nullable String message) {
        if (message == null) {
            return StepResult.failed("Cloud import failed with no message");
        }
        Matcher spaceExistsMatcher = SPACE_EXISTS_PATTERN.matcher(message);
        Matcher personalSpaceExistsMatcher = PERSONAL_SPACE_EXISTS_PATTERN.matcher(message);
        if (spaceExistsMatcher.find() || personalSpaceExistsMatcher.find()) {
            return StepResult.failed("Cloud site already has this space");
        }
        return StepResult.failed(String.format("Import to cloud failed. Message: %s", message));
    }

    private SpaceImportContextDto createSpaceImportContext(String stepId) {
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        Plan plan = step.getPlan();
        String migrationId = step.getPlan().getMigrationId();
        String stepConfig = step.getConfig();
        if (StringUtils.isBlank((String)stepConfig)) {
            throw new StepExecutionException(MigrationErrorCode.SPACE_IMPORT_MISSING_CONFIG, IMPORT_STEP_TYPE, migrationId, "Received a blank stepConfig for upload file or files. Process cannot proceed.");
        }
        if (!(step.getTask() instanceof ConfluenceSpaceTask)) {
            throw new StepExecutionException(MigrationErrorCode.SPACE_IMPORT_TASK_NOT_CONFLUENCE, IMPORT_STEP_TYPE, migrationId, "Cannot proceed because task is not an instance of ConfluenceSpaceTask");
        }
        ConfluenceSpaceTask task = (ConfluenceSpaceTask)step.getTask();
        Space space = Optional.ofNullable(this.spaceManager.getSpace(task.getSpaceKey())).orElseThrow(() -> new StepExecutionException(MigrationErrorCode.SPACE_IMPORT_MISSING_SPACE_KEY, IMPORT_STEP_TYPE, migrationId, "Cannot proceed because can't find any space with spaceKey: " + task.getSpaceKey()));
        if (this.isV2Endpoint()) {
            try {
                List files = (List)Jsons.readValue(stepConfig, (TypeReference)new TypeReference<List<MigrationCatalogueStorageFile>>(){});
                return new SpaceImportContextDto(plan.getId(), task.getId(), null, space.getId(), space.getKey(), plan.getMigrationScopeId(), plan.getMigrationId(), files);
            }
            catch (JsonSerializingException e) {
                throw new StepExecutionException(MigrationErrorCode.SPACE_IMPORT_UNFORMATTED_JSON, IMPORT_STEP_TYPE, migrationId, "Unexpected json format for step config.", e);
            }
        }
        return new SpaceImportContextDto(plan.getId(), task.getId(), stepConfig, space.getId(), space.getKey(), plan.getMigrationScopeId(), null, null);
    }

    @VisibleForTesting
    boolean isV2Endpoint() {
        if (this.darkFeaturesManager.isEnableOriginalXMLExport()) {
            return false;
        }
        return this.migrationAgentConfiguration.isDBTypeSupportedForRapidExport() || this.darkFeaturesManager.newExportEnabled() || this.darkFeaturesManager.isXMLToCSVAndUploadToMCSEnabled();
    }

    private ImportType getImportType(SpaceImportContextDto contextDto) {
        if (contextDto.getFileId() != null) {
            return ImportType.XML;
        }
        return ImportType.CSV;
    }

    @Override
    public StepType getStepType() {
        return StepType.CONFLUENCE_IMPORT;
    }

    @Override
    public StepResult runStep(String stepId) {
        Optional<StepResult> result;
        String importTaskId;
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        String spaceKey = ((ConfluenceSpaceTask)step.getTask()).getSpaceKey();
        try {
            String executionState = step.getExecutionState();
            if (ObjectUtils.isNotEmpty((Object)executionState)) {
                importTaskId = executionState;
            } else {
                importTaskId = this.initiateConfluenceSpaceImport(stepId);
                this.ptx.write(() -> step.setExecutionState(importTaskId));
            }
        }
        catch (UncheckedInterruptedException e) {
            log.info("Space import was stopped while initiating Confluence Space Import. StepId={}", (Object)stepId);
            return StepResult.stopped();
        }
        try {
            while (!(result = Optional.ofNullable(this.wrapStepResultSupplier(this.analyticsEventBuilder, this.analyticsEventService, step, spaceKey, this.spaceManager, () -> this.doProgressCheck(step, importTaskId).orElse(null)))).isPresent()) {
                Thread.sleep(POLLING_PERIOD.toMillis());
            }
        }
        catch (UncheckedInterruptedException | InterruptedException e) {
            log.info("Space import was stopped. StepId={}", (Object)stepId);
            return StepResult.stopped();
        }
        return result.get();
    }

    private /* synthetic */ EventDto lambda$saveCompletedStepAnalyticsEvent$8(Step step, Map additionalAttributes) {
        return this.analyticsEventBuilder.buildCompletedStepAnalyticsEvent(step, () -> additionalAttributes);
    }

    private static /* synthetic */ Collection lambda$checkIfGoodEventAndLoggingErrorAnalyticEvents$6(List events) {
        return events;
    }
}

