/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.catalogue;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.OKHttpProxyBuilder;
import com.atlassian.migration.agent.okhttp.ServiceErrorCodeHandler;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.codehaus.jackson.type.TypeReference;

public class HttpServiceWrapper {
    private static final Integer CONNECTION_TIMEOUT_SECONDS = 5;
    private static final boolean SHOULD_FOLLOW_REDIRECTS = true;
    private static final boolean SHOULD_FOLLOW_SSL_REDIRECTS = true;
    private static final Integer READ_TIMEOUT_SECONDS = 60;
    private static final Integer DEFAULT_MAX_IDLE_CONNECTIONS = 5;
    private static final Long ATLASSIAN_KEEP_ALIVE_DURATION_SECONDS = 55L;
    private final HttpService httpService;
    private final HttpService httpServiceWithCustomKeepAliveTimeout;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    public HttpServiceWrapper(UserAgentInterceptor userAgentInterceptor, OKHttpProxyBuilder okHttpProxyBuilder, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.httpService = new HttpService(() -> HttpServiceWrapper.buildHttpClient(userAgentInterceptor, okHttpProxyBuilder), new ServiceErrorCodeHandler());
        this.httpServiceWithCustomKeepAliveTimeout = new HttpService(() -> HttpServiceWrapper.buildHttpClientWithCustomKeepAliveTimeout(userAgentInterceptor, okHttpProxyBuilder), new ServiceErrorCodeHandler());
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    @VisibleForTesting
    HttpServiceWrapper(HttpService httpService, HttpService httpServiceWithCustomKeepAliveTimeout, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.httpService = httpService;
        this.httpServiceWithCustomKeepAliveTimeout = httpServiceWithCustomKeepAliveTimeout;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    public Response call(Request request) {
        return this.getHttpService().call(request);
    }

    public <T> T callGson(Request request, Class<T> bodyType) {
        return this.getHttpService().callGson(request, bodyType);
    }

    public <T> T callJson(Request request, TypeReference<T> bodyType) {
        return this.getHttpService().callJson(request, bodyType);
    }

    @VisibleForTesting
    static OkHttpClient buildHttpClient(UserAgentInterceptor userAgentInterceptor, OKHttpProxyBuilder okHttpProxyBuilder) {
        return okHttpProxyBuilder.getProxyBuilder().connectTimeout((long)CONNECTION_TIMEOUT_SECONDS.intValue(), TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout((long)READ_TIMEOUT_SECONDS.intValue(), TimeUnit.SECONDS).addInterceptor((Interceptor)userAgentInterceptor).build();
    }

    @VisibleForTesting
    static OkHttpClient buildHttpClientWithCustomKeepAliveTimeout(UserAgentInterceptor userAgentInterceptor, OKHttpProxyBuilder okHttpProxyBuilder) {
        return okHttpProxyBuilder.getProxyBuilder().connectTimeout((long)CONNECTION_TIMEOUT_SECONDS.intValue(), TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout((long)READ_TIMEOUT_SECONDS.intValue(), TimeUnit.SECONDS).addInterceptor((Interceptor)userAgentInterceptor).connectionPool(new ConnectionPool(DEFAULT_MAX_IDLE_CONNECTIONS.intValue(), ATLASSIAN_KEEP_ALIVE_DURATION_SECONDS.longValue(), TimeUnit.SECONDS)).build();
    }

    @VisibleForTesting
    HttpService getHttpService() {
        if (this.migrationDarkFeaturesManager.isDisabledHttpCustomKeepAliveTimeout()) {
            return this.httpService;
        }
        return this.httpServiceWithCustomKeepAliveTimeout;
    }
}

