/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.okhttp;

import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.okhttp.ErrorCode;
import com.atlassian.migration.agent.okhttp.HttpServiceException;
import com.atlassian.migration.agent.okhttp.IOHttpException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jodah.failsafe.RetryPolicy;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;

public class RetryPolicyBuilder {
    private static final Logger log = ContextLoggerFactory.getLogger(RetryPolicyBuilder.class);
    public static final String MEDIA_ERROR = "Declared content hash does not match actual content hash";
    private RetryPolicy policy;
    private Collection<Predicate<Throwable>> predicates = new ArrayList<Predicate<Throwable>>();

    private RetryPolicyBuilder(RetryPolicy policy) {
        this.policy = policy;
    }

    public static RetryPolicy policyForMigrationServices() {
        return RetryPolicyBuilder.defaultPolicy().withErrorCode(ErrorCode.GENERIC, ErrorCode.UNHANDLED_COMMUNICATION_ERROR_WITH_DOWNSTREAM_SERVER, ErrorCode.FAILED_TO_START_MIGRATION).retryOn(Collections.singletonList(IOHttpException.class)).build();
    }

    public static RetryPolicy policyForInitiateUsersAndGroups() {
        return new RetryPolicyBuilder(new RetryPolicy().withMaxRetries(5).withBackoff(1L, 20L, TimeUnit.SECONDS)).withErrorCode(ErrorCode.GENERIC, ErrorCode.UNHANDLED_COMMUNICATION_ERROR_WITH_DOWNSTREAM_SERVER, ErrorCode.FAILED_TO_START_MIGRATION).build();
    }

    public static RetryPolicyBuilder defaultPolicy() {
        return new RetryPolicyBuilder(new RetryPolicy().withMaxRetries(5).withBackoff(1L, 20L, TimeUnit.SECONDS)).withStatusCode(HttpStatus.Series.SERVER_ERROR).retryOn(Arrays.asList(IOHttpException.class, IOException.class));
    }

    public static RetryPolicyBuilder enterpriseGatekeeperClientRetryPolicy() {
        return new RetryPolicyBuilder(new RetryPolicy().withMaxRetries(5).withBackoff(10L, 120L, TimeUnit.SECONDS)).withStatusCode(HttpStatus.Series.SERVER_ERROR).withStatusCode(HttpStatus.TOO_MANY_REQUESTS.value()).retryOn(Arrays.asList(IOHttpException.class, IOException.class));
    }

    public static RetryPolicyBuilder amsClientPolicy() {
        return new RetryPolicyBuilder(new RetryPolicy().withMaxRetries(5).withBackoff(1L, 30L, TimeUnit.SECONDS)).retryOn(Arrays.asList(IOHttpException.class, IOException.class)).withStatusCode(HttpStatus.TOO_MANY_REQUESTS.value()).withStatusCode(HttpStatus.Series.SERVER_ERROR);
    }

    public static RetryPolicyBuilder maaClientPolicy() {
        return new RetryPolicyBuilder(new RetryPolicy().withMaxRetries(5).withBackoff(1L, 20L, TimeUnit.SECONDS)).retryOn(Arrays.asList(IOHttpException.class, IOException.class)).withStatusCode(HttpStatus.Series.SERVER_ERROR).withStatusCode(HttpStatus.TOO_MANY_REQUESTS.value());
    }

    public static RetryPolicyBuilder mediaRateLimitPolicy() {
        return new RetryPolicyBuilder(new RetryPolicy().retryOn(IOHttpException.class).withMaxRetries(6).withBackoff(30L, 120L, TimeUnit.SECONDS, 2.0)).withStatusCode(403, 404, 408, 429).withStatusCode(HttpStatus.Series.SERVER_ERROR).withStatusCodeAndMsg(HttpStatus.BAD_REQUEST.value(), MEDIA_ERROR);
    }

    public static RetryPolicyBuilder s3policy() {
        return new RetryPolicyBuilder(new RetryPolicy().withMaxRetries(5).withBackoff(1L, 30L, TimeUnit.SECONDS)).retryOn(Arrays.asList(IOHttpException.class, IOException.class)).withStatusCode(HttpStatus.TOO_MANY_REQUESTS.value()).withStatusCode(HttpStatus.Series.SERVER_ERROR);
    }

    public static RetryPolicyBuilder createFromBase(RetryPolicy baseRetryPolicy) {
        return new RetryPolicyBuilder(baseRetryPolicy);
    }

    public RetryPolicyBuilder withStatusCode(Integer ... allowRetryCodes) {
        return this.withStatusCode(Stream.of(allowRetryCodes).collect(Collectors.toSet()));
    }

    public RetryPolicyBuilder withStatusCode(Set<Integer> retryStatusCodes) {
        this.predicates.add(exception -> {
            if (exception instanceof HttpServiceException) {
                Integer statusCode = ((HttpServiceException)exception).getStatusCode();
                return retryStatusCodes.contains(statusCode);
            }
            return false;
        });
        return this;
    }

    public RetryPolicyBuilder withErrorCode(ErrorCode ... retryErrorCodes) {
        this.predicates.add(exception -> {
            if (exception instanceof HttpServiceException) {
                Integer errorCode = ((HttpServiceException)exception).getErrorCode();
                return Arrays.stream(retryErrorCodes).map(ErrorCode::getCode).anyMatch(code -> code.equals(errorCode));
            }
            return false;
        });
        return this;
    }

    public RetryPolicyBuilder withStatusCodeAndMsg(Integer retryCode, String errorMsg) {
        this.predicates.add(exception -> {
            if (exception instanceof HttpServiceException) {
                Integer statusCode = ((HttpServiceException)exception).getStatusCode();
                String exceptionMsg = exception.getMessage();
                return retryCode.equals(statusCode) && exceptionMsg.contains(errorMsg);
            }
            return false;
        });
        return this;
    }

    public RetryPolicy build() {
        this.policy.retryIf((o, exception) -> this.evaluatePredicates((Throwable)exception));
        return this.policy;
    }

    private boolean evaluatePredicates(Throwable exception) {
        return !this.predicates.isEmpty() && this.predicates.stream().anyMatch(predicate -> predicate.test(exception));
    }

    public RetryPolicyBuilder retryOn(List<Class<? extends Throwable>> asList) {
        this.policy.retryOn(asList);
        return this;
    }

    public RetryPolicyBuilder retryOn(Class<? extends Throwable> exceptionClass) {
        this.policy.retryOn(exceptionClass);
        return this;
    }

    public RetryPolicyBuilder withPredicate(Predicate<Throwable> predicate) {
        this.predicates.add(predicate);
        return this;
    }

    public RetryPolicyBuilder withStatusCode(HttpStatus.Series statusSeries) {
        this.predicates.add(exception -> {
            if (exception instanceof HttpServiceException) {
                int statusCode = ((HttpServiceException)exception).getStatusCode();
                try {
                    return HttpStatus.Series.valueOf((int)statusCode) == statusSeries;
                }
                catch (IllegalArgumentException e) {
                    log.warn("Unknown HTTP code: {}", (Object)statusCode);
                    return false;
                }
            }
            return false;
        });
        return this;
    }
}

