/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.newexport;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.export.MigrationExportException;
import com.atlassian.migration.agent.newexport.DbType;
import com.atlassian.migration.agent.newexport.DescriptorBuilder;
import com.atlassian.migration.agent.newexport.Queries;
import com.atlassian.migration.agent.newexport.Query;
import com.atlassian.migration.agent.newexport.processor.CsvSerializingProcessor;
import com.atlassian.migration.agent.newexport.processor.RowProcessor;
import com.atlassian.migration.agent.newexport.processor.UserKeyColumnExtractor;
import com.atlassian.migration.agent.newexport.processor.UserKeyXmlExtractor;
import com.atlassian.migration.agent.newexport.processor.UserWithEmailSerializingProcessor;
import com.atlassian.migration.agent.newexport.store.JdbcConfluenceStore;
import com.atlassian.migration.agent.newexport.util.FileUtil;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.user.UserMappingsFileManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceRapidExporter {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceRapidExporter.class);
    private static final int BATCH_SIZE = 1000;
    private static final String SPACE_ID = "spaceid";
    private static final String CLOUD_ID = "cloudid";
    public static final String SPACE_KEY = "spaceKey";
    private static final Supplier<Instant> DEFAULT_INSTANT_SUPPLER = Instant::now;
    private static final Supplier<String> DEFAULT_NAME_GENERATOR = () -> "mig_contentid_" + UUID.randomUUID().toString().replace("-", "");
    private final JdbcConfluenceStore confluenceStore;
    private final DescriptorBuilder descriptorBuilder;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final Supplier<String> nameGenerator;
    private DbType dbType;
    private UserMappingsFileManager userMappingsFileManager;

    public ConfluenceRapidExporter(JdbcConfluenceStore confluenceStore, DescriptorBuilder descriptorBuilder, MigrationAgentConfiguration migrationAgentConfiguration, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, UserMappingsFileManager userMappingsFileManager) {
        this(confluenceStore, descriptorBuilder, migrationAgentConfiguration, analyticsEventService, analyticsEventBuilder, DEFAULT_INSTANT_SUPPLER, DEFAULT_NAME_GENERATOR, userMappingsFileManager);
    }

    @VisibleForTesting
    public ConfluenceRapidExporter(JdbcConfluenceStore confluenceStore, DescriptorBuilder descriptorBuilder, MigrationAgentConfiguration migrationAgentConfiguration, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, Supplier<Instant> instantSupplier, Supplier<String> nameGenerator, UserMappingsFileManager userMappingsFileManager) {
        this.confluenceStore = confluenceStore;
        this.descriptorBuilder = descriptorBuilder;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.instantSupplier = instantSupplier;
        this.nameGenerator = nameGenerator;
        this.dbType = null;
        this.userMappingsFileManager = userMappingsFileManager;
        this.dbType = migrationAgentConfiguration.getDBType();
    }

    public DbType getDbType() {
        return this.dbType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String export(CSVExportTaskContext taskContext) {
        String exportDir = FileUtil.createExportDirectory(taskContext.getSpaceKey(), taskContext.getTempDirFilePath());
        log.info("Starting CSV export of space: {} to path: {}", (Object)taskContext.getSpaceKey(), (Object)exportDir);
        long startTime = this.instantSupplier.get().toEpochMilli();
        HashSet<String> discoveredUserKeys = new HashSet<String>();
        String contentIdTable = this.createAndPopulateContentIdsTable(taskContext.getSpaceId());
        log.info("Try to get user mappings from file for planId: {}", (Object)taskContext.getPlanId());
        Map<String, String> emailToAAID = this.userMappingsFileManager.getUserMappingsFromFile(taskContext.getPlanId());
        try {
            this.exportEntitiesDirectlyRelatedToSpace(exportDir, discoveredUserKeys, taskContext);
            this.exportBodyContents(exportDir, discoveredUserKeys, taskContext, contentIdTable);
            this.exportContentRelatedEntities(exportDir, discoveredUserKeys, taskContext, contentIdTable);
            this.exportOsProperties(exportDir, taskContext, contentIdTable);
            this.exportUserMappings(exportDir, discoveredUserKeys, taskContext, emailToAAID);
            this.descriptorBuilder.generateDescriptor(taskContext.getSpaceKey(), exportDir, taskContext.isUsersCreatedInUMS(), taskContext.getTotalRowCount());
        }
        finally {
            this.tryDropContentIdTable(contentIdTable);
        }
        log.info("Completed CSV export of space: {} in {}ms", (Object)taskContext.spaceKey, (Object)(this.instantSupplier.get().toEpochMilli() - startTime));
        log.info("Exported CSV files of space: {} are located in directory {}", (Object)taskContext.spaceKey, (Object)exportDir);
        return exportDir;
    }

    private String createAndPopulateContentIdsTable(long spaceId) {
        String tableName = this.nameGenerator.get();
        this.confluenceStore.mutate(Queries.CREATE_CONTENT_ID_TABLE_QUERY.toQuery(this.getDbType(), tableName));
        log.info("Created contentId table {}", (Object)tableName);
        int numRows = this.confluenceStore.mutate(Queries.POPULATE_CONTENT_ID_TABLE_QUERY.toQuery(this.getDbType(), tableName), Collections.singletonMap(SPACE_ID, spaceId));
        log.info("Populated contentId table {} with {} rows", (Object)tableName, (Object)numRows);
        return tableName;
    }

    private void tryDropContentIdTable(String tableName) {
        try {
            this.confluenceStore.mutate(Queries.DROP_CONTENT_ID_TABLE_QUERY.toQuery(this.getDbType(), tableName));
        }
        catch (Exception e) {
            log.warn("Failed to drop CSV export temp table: {}", (Object)tableName, (Object)e);
        }
    }

    private void exportOsProperties(String exportDir, CSVExportTaskContext taskConfig, String contentIdTable) {
        this.runQueries(Queries.osPropertyQuery.toQueries(this.getDbType(), contentIdTable), this.createQueryRunner(Collections.singletonMap(SPACE_ID, taskConfig.getSpaceId())), exportDir, taskConfig);
    }

    private void exportContentRelatedEntities(String exportDir, Set<String> extractedUserKeys, CSVExportTaskContext taskConfig, String contentIdTable) {
        this.runQueries(Queries.contentQueries.toQueries(this.getDbType(), contentIdTable), this.createQueryRunner((Map<String, ?>)ImmutableMap.of((Object)CLOUD_ID, (Object)taskConfig.cloudId, (Object)SPACE_ID, (Object)taskConfig.getSpaceId())), exportDir, taskConfig);
        if (this.confluenceBefore7_0_1()) {
            this.runQueries(Queries.contentQueriesLegacyTables.toQueries(this.getDbType(), contentIdTable), this.createQueryRunner(Collections.singletonMap(SPACE_ID, taskConfig.getSpaceId()), extractedUserKeys), exportDir, taskConfig);
        }
        this.runQueries(Queries.contentQueriesWithUserKeys.toQueries(this.getDbType(), contentIdTable), this.createQueryRunner(Collections.singletonMap(SPACE_ID, taskConfig.getSpaceId()), extractedUserKeys), exportDir, taskConfig);
        this.runQueries(Queries.AOBAF3AA_QUERY.toQueries(this.getDbType(), contentIdTable), this.createQueryRunner(Collections.singletonMap(SPACE_ID, taskConfig.getSpaceId()), extractedUserKeys), exportDir, taskConfig);
    }

    private void exportEntitiesDirectlyRelatedToSpace(String exportDir, Set<String> extractedUserKeys, CSVExportTaskContext taskConfig) {
        this.runQueries(Queries.spaceIdQueries, this.createQueryRunner(Collections.singletonMap(SPACE_ID, taskConfig.getSpaceId()), extractedUserKeys), exportDir, taskConfig);
        this.runQueries(Queries.spaceKeyQueries.toQueries(this.getDbType(), new String[0]), this.createQueryRunner(Collections.singletonMap(SPACE_KEY, taskConfig.getSpaceKey()), extractedUserKeys), exportDir, taskConfig);
        this.runQueries(Queries.AO187_QUERY.toQueries(this.getDbType(), new String[0]), this.createQueryRunner(Collections.singletonMap(SPACE_KEY, taskConfig.getSpaceKey()), extractedUserKeys), exportDir, taskConfig);
    }

    private void exportBodyContents(String exportDir, Set<String> extractedUserKeys, CSVExportTaskContext taskConfig, String contentIdTable) {
        this.runQueries(Queries.bodycontentQueriesWithUsersInContent.toQueries(this.getDbType(), contentIdTable), this.createQueryRunner(Collections.singletonMap(SPACE_ID, taskConfig.getTaskId()), (Query query, RowProcessor processor) -> new UserKeyXmlExtractor((RowProcessor)processor, extractedUserKeys)), exportDir, taskConfig);
    }

    private void exportUserMappings(String exportDir, Set<String> discoveredUserKeys, CSVExportTaskContext taskConfig, Map<String, String> emailToAAid) {
        Query userMappingQuery = new Query(this.getUserMappingQueryString(discoveredUserKeys), "user_mapping", "user_mapping");
        this.runQueries(new Query[]{userMappingQuery}, this.createQueryRunner(Collections.emptyMap(), (Query query, RowProcessor processor) -> new UserWithEmailSerializingProcessor((RowProcessor)processor, emailToAAid)), exportDir, taskConfig);
    }

    @VisibleForTesting
    String getUserMappingQueryString(Set<String> discoveredUserKeys) {
        discoveredUserKeys.removeIf(String::isEmpty);
        if (!discoveredUserKeys.stream().allMatch(e -> e.matches("[a-zA-Z\\d:-]*"))) {
            throw new RuntimeException("Invalid characters in userKeys . Only alphanumeric characters are allowed.");
        }
        ArrayList userKeyBatches = Lists.newArrayList((Iterable)Iterables.partition(discoveredUserKeys, (int)1000));
        ArrayList clauses = Lists.newArrayList((Object[])new String[]{"1=0"});
        for (List userKeyBatch : userKeyBatches) {
            StringBuilder sb = new StringBuilder();
            for (String key : userKeyBatch) {
                sb.append(String.format("'%s',", key));
            }
            sb.deleteCharAt(sb.length() - 1);
            clauses.add(String.format("user_key in (%s)", sb));
        }
        return String.format(Queries.userMappingsQueryString(this.dbType), String.join((CharSequence)" or ", clauses));
    }

    private boolean confluenceBefore7_0_1() {
        return this.descriptorBuilder.getBuildNumber() < 8201;
    }

    private void runQueries(Query[] queries, BiConsumer<Query, RowProcessor> queryRunner, String exportDir, CSVExportTaskContext taskConfig) {
        for (Query query : queries) {
            long start = this.instantSupplier.get().toEpochMilli();
            String filePath = exportDir + query.exportName + ".csv.gz";
            try (OutputStreamWriter outputStreamWriter = this.createOutputStreamWriter(filePath);){
                CsvSerializingProcessor csvProcessor = new CsvSerializingProcessor(outputStreamWriter, this.instantSupplier);
                queryRunner.accept(query, csvProcessor);
                long totalTime = this.instantSupplier.get().toEpochMilli() - start;
                long timeToFirstRecord = csvProcessor.getTimeOfFirstRecord() > 0L ? csvProcessor.getTimeOfFirstRecord() - start : totalTime;
                taskConfig.increaseTotalRowCount(csvProcessor.getRowCount());
                taskConfig.increaseTotalCharactersExported(csvProcessor.getTotalContentCharacters());
                this.reportExportTablePerformance(taskConfig, true, query.exportName, query.sql, this.dbType.name(), totalTime, timeToFirstRecord, csvProcessor.getRowCount(), csvProcessor.getTotalContentCharacters());
                log.info("Serialized results of query on table [{}] for space [{}] in [{} ms].", new Object[]{query.tableName, taskConfig.spaceKey, totalTime});
            }
            catch (UncheckedInterruptedException e) {
                throw new UncheckedInterruptedException(e);
            }
            catch (Exception e) {
                log.error("Failed to execute export for query " + query.sql, (Throwable)e);
                this.reportExportTablePerformance(taskConfig, false, query.exportName, query.sql, this.dbType.name(), this.instantSupplier.get().toEpochMilli() - start, -1L, -1L, -1L);
                throw new MigrationExportException("Failed to execute export for query", e);
            }
        }
    }

    private OutputStreamWriter createOutputStreamWriter(String filePath) throws IOException {
        boolean existed = Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0]);
        if (!existed) {
            Files.createFile(Paths.get(filePath, new String[0]), new FileAttribute[0]);
        }
        FileOutputStream outputStream = new FileOutputStream(filePath, true);
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
        return new OutputStreamWriter((OutputStream)gzipOutputStream, StandardCharsets.UTF_8);
    }

    private BiConsumer<Query, RowProcessor> createQueryRunner(Map<String, ?> queryParams, Set<String> extractedUserKeys) {
        return (query, processor) -> this.confluenceStore.queryAndProcess((Query)query, queryParams, new UserKeyColumnExtractor((RowProcessor)processor, extractedUserKeys, query.userkeyColums));
    }

    private BiConsumer<Query, RowProcessor> createQueryRunner(Map<String, ?> queryParams, BiFunction<Query, RowProcessor, RowProcessor> rowProcessorFactory) {
        return (query, processor) -> this.confluenceStore.queryAndProcess((Query)query, queryParams, (RowProcessor)rowProcessorFactory.apply((Query)query, (RowProcessor)processor));
    }

    private BiConsumer<Query, RowProcessor> createQueryRunner(Map<String, ?> queryParams) {
        return (query, processor) -> this.confluenceStore.queryAndProcess((Query)query, queryParams, (RowProcessor)processor);
    }

    private void reportExportTablePerformance(CSVExportTaskContext taskConfig, boolean success, String tableName, String query, String dbType, long totalTimeTaken, long timeToFirstRow, long rowsExported, long totalContentChars) {
        EventDto tableExportEvent = this.analyticsEventBuilder.buildTableExportedToCSVTimerEvent(success, totalTimeTaken, taskConfig.spaceKey, taskConfig.planId, taskConfig.taskId, tableName, query, dbType, timeToFirstRow, rowsExported, totalContentChars);
        this.analyticsEventService.saveAnalyticsEventAsync(() -> tableExportEvent);
    }

    public static final class CSVExportTaskContext {
        private final long spaceId;
        private final String spaceKey;
        private final String cloudId;
        private final String planId;
        private final String taskId;
        private final String tempDirFilePath;
        private final boolean usersCreatedInUMS;
        private long totalRowCount;
        private long totalCharactersExported;

        public CSVExportTaskContext(long spaceId, String spaceKey, String cloudId, String planId, String taskId, String tempDirFilePath, boolean usersCreatedInUMS) {
            this.spaceId = spaceId;
            this.spaceKey = spaceKey;
            this.cloudId = cloudId;
            this.planId = planId;
            this.taskId = taskId;
            this.tempDirFilePath = tempDirFilePath;
            this.usersCreatedInUMS = usersCreatedInUMS;
            this.totalRowCount = 0L;
            this.totalCharactersExported = 0L;
        }

        void increaseTotalRowCount(long rowCount) {
            this.totalRowCount += rowCount;
        }

        void increaseTotalCharactersExported(long totalCharacterContentsExported) {
            this.totalCharactersExported += totalCharacterContentsExported;
        }

        @Generated
        public long getSpaceId() {
            return this.spaceId;
        }

        @Generated
        public String getSpaceKey() {
            return this.spaceKey;
        }

        @Generated
        public String getCloudId() {
            return this.cloudId;
        }

        @Generated
        public String getPlanId() {
            return this.planId;
        }

        @Generated
        public String getTaskId() {
            return this.taskId;
        }

        @Generated
        public String getTempDirFilePath() {
            return this.tempDirFilePath;
        }

        @Generated
        public boolean isUsersCreatedInUMS() {
            return this.usersCreatedInUMS;
        }

        @Generated
        public long getTotalRowCount() {
            return this.totalRowCount;
        }

        @Generated
        public long getTotalCharactersExported() {
            return this.totalCharactersExported;
        }

        @Generated
        public void setTotalRowCount(long totalRowCount) {
            this.totalRowCount = totalRowCount;
        }

        @Generated
        public void setTotalCharactersExported(long totalCharactersExported) {
            this.totalCharactersExported = totalCharactersExported;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CSVExportTaskContext)) {
                return false;
            }
            CSVExportTaskContext other = (CSVExportTaskContext)o;
            if (this.getSpaceId() != other.getSpaceId()) {
                return false;
            }
            String this$spaceKey = this.getSpaceKey();
            String other$spaceKey = other.getSpaceKey();
            if (this$spaceKey == null ? other$spaceKey != null : !this$spaceKey.equals(other$spaceKey)) {
                return false;
            }
            String this$cloudId = this.getCloudId();
            String other$cloudId = other.getCloudId();
            if (this$cloudId == null ? other$cloudId != null : !this$cloudId.equals(other$cloudId)) {
                return false;
            }
            String this$planId = this.getPlanId();
            String other$planId = other.getPlanId();
            if (this$planId == null ? other$planId != null : !this$planId.equals(other$planId)) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
                return false;
            }
            String this$tempDirFilePath = this.getTempDirFilePath();
            String other$tempDirFilePath = other.getTempDirFilePath();
            if (this$tempDirFilePath == null ? other$tempDirFilePath != null : !this$tempDirFilePath.equals(other$tempDirFilePath)) {
                return false;
            }
            if (this.isUsersCreatedInUMS() != other.isUsersCreatedInUMS()) {
                return false;
            }
            if (this.getTotalRowCount() != other.getTotalRowCount()) {
                return false;
            }
            return this.getTotalCharactersExported() == other.getTotalCharactersExported();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $spaceId = this.getSpaceId();
            result = result * 59 + (int)($spaceId >>> 32 ^ $spaceId);
            String $spaceKey = this.getSpaceKey();
            result = result * 59 + ($spaceKey == null ? 43 : $spaceKey.hashCode());
            String $cloudId = this.getCloudId();
            result = result * 59 + ($cloudId == null ? 43 : $cloudId.hashCode());
            String $planId = this.getPlanId();
            result = result * 59 + ($planId == null ? 43 : $planId.hashCode());
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            String $tempDirFilePath = this.getTempDirFilePath();
            result = result * 59 + ($tempDirFilePath == null ? 43 : $tempDirFilePath.hashCode());
            result = result * 59 + (this.isUsersCreatedInUMS() ? 79 : 97);
            long $totalRowCount = this.getTotalRowCount();
            result = result * 59 + (int)($totalRowCount >>> 32 ^ $totalRowCount);
            long $totalCharactersExported = this.getTotalCharactersExported();
            result = result * 59 + (int)($totalCharactersExported >>> 32 ^ $totalCharactersExported);
            return result;
        }

        @Generated
        public String toString() {
            return "ConfluenceRapidExporter.CSVExportTaskContext(spaceId=" + this.getSpaceId() + ", spaceKey=" + this.getSpaceKey() + ", cloudId=" + this.getCloudId() + ", planId=" + this.getPlanId() + ", taskId=" + this.getTaskId() + ", tempDirFilePath=" + this.getTempDirFilePath() + ", usersCreatedInUMS=" + this.isUsersCreatedInUMS() + ", totalRowCount=" + this.getTotalRowCount() + ", totalCharactersExported=" + this.getTotalCharactersExported() + ")";
        }
    }
}

