/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app;

import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.okhttp.HttpException;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.HttpServiceException;
import com.atlassian.migration.agent.okhttp.MediaTypes;
import com.atlassian.migration.agent.okhttp.OKHttpProxyBuilder;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.okhttp.ServiceErrorCodeHandler;
import com.atlassian.migration.agent.service.check.app.webhook.AppWebhookEndpointCheckServiceClient;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.impl.StargateHelper;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import com.atlassian.migration.app.AppAssessmentClient;
import com.atlassian.migration.app.AppMigrationServiceClient;
import com.atlassian.migration.app.AppMigrationServiceClientKt;
import com.atlassian.migration.app.ContainerType;
import com.atlassian.migration.app.MigrationDetailsV1;
import com.atlassian.migration.app.dto.AppWebhookEndpointCheckRequest;
import com.atlassian.migration.app.dto.AppWebhookEndpointCheckResponse;
import com.atlassian.migration.app.dto.AppsCloudSiteResponse;
import com.atlassian.migration.app.dto.AppsLicenseResponseDto;
import com.atlassian.migration.app.dto.CloudFeedbackResponse;
import com.atlassian.migration.app.dto.ContainersByPageResponse;
import com.atlassian.migration.app.dto.FinalizeUploadRequest;
import com.atlassian.migration.app.dto.GetUploadUrlRequest;
import com.atlassian.migration.app.dto.InitializeUploadResponse;
import com.atlassian.migration.app.dto.MigrationMappingResponse;
import com.atlassian.migration.app.dto.RegisterTransferRequest;
import com.atlassian.migration.app.dto.TransferErrorRequest;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.RetryPolicy;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.ByteString;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.util.UriComponentsBuilder;

@ParametersAreNonnullByDefault
public class DefaultAppMigrationServiceClient
implements AppMigrationServiceClient,
AppAssessmentClient,
AppWebhookEndpointCheckServiceClient {
    private static final String TRANSFER_ID_PATH_SEGMENT = "{transferId}";
    private final HttpService httpService;
    private final HttpService s3UploadHttpService;
    private final MigrationAgentConfiguration configuration;
    private final CloudSiteService cloudSiteService;
    private final boolean bypassStargate;
    private final RetryPolicy retryPolicy;
    private final Gson gson = new Gson();

    public DefaultAppMigrationServiceClient(MigrationAgentConfiguration configuration, UserAgentInterceptor userAgentInterceptor, CloudSiteService cloudSiteService, OKHttpProxyBuilder okHttpProxyBuilder) {
        this(new HttpService(() -> DefaultAppMigrationServiceClient.buildHttpClient(userAgentInterceptor, okHttpProxyBuilder).build(), new ServiceErrorCodeHandler()), new HttpService(() -> DefaultAppMigrationServiceClient.buildHttpClient(userAgentInterceptor, okHttpProxyBuilder).connectTimeout(90L, TimeUnit.SECONDS).readTimeout(90L, TimeUnit.SECONDS).writeTimeout(90L, TimeUnit.SECONDS).build(), new ServiceErrorCodeHandler()), configuration, cloudSiteService, RetryPolicyBuilder.amsClientPolicy().build());
    }

    @VisibleForTesting
    DefaultAppMigrationServiceClient(HttpService httpService, HttpService s3UploadHttpService, MigrationAgentConfiguration configuration, CloudSiteService cloudSiteService, RetryPolicy retryPolicy) {
        this.bypassStargate = configuration.isBypassStargate();
        this.httpService = httpService;
        this.s3UploadHttpService = s3UploadHttpService;
        this.configuration = configuration;
        this.cloudSiteService = cloudSiteService;
        this.retryPolicy = retryPolicy;
    }

    private static OkHttpClient.Builder buildHttpClient(UserAgentInterceptor userAgentInterceptor, OKHttpProxyBuilder okHttpProxyBuilder) {
        return okHttpProxyBuilder.getProxyBuilder().connectTimeout(5L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout(10L, TimeUnit.SECONDS).addInterceptor((Interceptor)userAgentInterceptor);
    }

    public UUID registerTransfer(String cloudId, String containerId, RegisterTransferRequest registerTransfer) {
        UriComponentsBuilder uri = this.getUriBuilder().pathSegment(new String[]{"{containerId}"}).path("/transfer");
        Request request = this.getJsonBuilder(cloudId).url(uri.buildAndExpand(new Object[]{containerId}).encode().toUriString()).post(RequestBody.create((String)this.gson.toJson((Object)registerTransfer), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callGsonWithRetries(request, UUID.class);
    }

    public MigrationMappingResponse getMigrationMappingByPage(String cloudId, String transferId, String namespace, @Nullable String lastEntity, int pageSize) {
        UriComponentsBuilder uri = this.getUriBuilder().path("/mapping").pathSegment(new String[]{TRANSFER_ID_PATH_SEGMENT}).path("page").queryParam("namespace", new Object[]{namespace}).queryParam("pageSize", new Object[]{pageSize});
        if (StringUtils.isNotEmpty((CharSequence)lastEntity)) {
            uri.queryParam("lastEntity", new Object[]{lastEntity});
        }
        Request request = this.getJsonBuilder(cloudId).url(uri.buildAndExpand(new Object[]{transferId, namespace}).encode().toUriString()).get().build();
        return this.callGsonWithRetries(request, MigrationMappingResponse.class);
    }

    public Map<String, String> getMappingById(String cloudId, String transferId, String namespace, Set<String> ids) {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder().path("/mapping").pathSegment(new String[]{TRANSFER_ID_PATH_SEGMENT}).path("find").queryParam("namespace", new Object[]{namespace}).buildAndExpand(new Object[]{transferId}).toUriString()).post(RequestBody.create((String)Jsons.valueAsString(ids), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callGsonWithRetries(request, Map.class);
    }

    public ContainersByPageResponse getContainersByPage(String cloudId, String transferId, ContainerType containerType, @Nullable String lastEntity, int pageSize) {
        UriComponentsBuilder uri = this.getUriBuilder().path("/container").pathSegment(new String[]{TRANSFER_ID_PATH_SEGMENT}).path("page").queryParam("containerType", new Object[]{containerType}).queryParam("pageSize", new Object[]{pageSize});
        if (StringUtils.isNotEmpty((CharSequence)lastEntity)) {
            uri.queryParam("lastEntity", new Object[]{lastEntity});
        }
        Request request = this.getJsonBuilder(cloudId).url(uri.buildAndExpand(new Object[]{transferId}).encode().toUriString()).get().build();
        return this.callGsonWithRetries(request, ContainersByPageResponse.class);
    }

    public CloudFeedbackResponse getCloudFeedback(String cloudId, String transferId) {
        UriComponentsBuilder uri = this.getUriBuilder().path("/feedback").pathSegment(new String[]{TRANSFER_ID_PATH_SEGMENT});
        Request request = this.getJsonBuilder(cloudId).url(uri.buildAndExpand(new Object[]{transferId}).encode().toUriString()).get().build();
        return this.callGsonWithRetries(request, CloudFeedbackResponse.class);
    }

    @Override
    public AppsCloudSiteResponse getAppInfoForSite(String cloudId, List<String> appKeys) {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder().path("/confluence/appsinfo").toUriString()).post(RequestBody.create((String)Jsons.valueAsString(ImmutableMap.of((Object)"appKeys", appKeys)), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callGsonWithRetries(request, AppsCloudSiteResponse.class);
    }

    @Override
    public AppsLicenseResponseDto getAppsLicense(String cloudId, List<String> appKeys) {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder().path("/check/confluence/license").toUriString()).post(RequestBody.create((String)Jsons.valueAsString(ImmutableMap.of((Object)"appKeys", appKeys)), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callGsonWithRetries(request, AppsLicenseResponseDto.class);
    }

    public InitializeUploadResponse initializeUpload(String cloudId, String transferId, Optional<String> label) {
        UriComponentsBuilder uri = this.getUriBuilder().path("/upload/initialize").pathSegment(new String[]{transferId});
        label.ifPresent(s -> uri.queryParam("label", new Object[]{s}));
        Request request = this.getJsonBuilder(cloudId).url(uri.toUriString()).post(RequestBody.create((String)"", (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callGsonWithRetries(request, InitializeUploadResponse.class);
    }

    public String getMultipartUploadUrl(String cloudId, GetUploadUrlRequest getUploadUrl) {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder().path("/upload/url").toUriString()).post(RequestBody.create((String)this.gson.toJson((Object)getUploadUrl), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callGsonWithRetries(request, String.class);
    }

    public String uploadToS3(String s3SignedUrl, String contentMd5, byte[] bytes) {
        Request request = new Request.Builder().url(s3SignedUrl).put(RequestBody.create((byte[])bytes, (MediaType)MediaTypes.APPLICATION_STREAM_TYPE)).addHeader("Content-MD5", contentMd5).build();
        Response response = this.getResponseForS3Upload(request);
        return response.header("ETag");
    }

    public void finalizeUpload(String cloudId, FinalizeUploadRequest finalizeUpload) {
        Request request = this.getRequestBuilder(cloudId).url(this.getUriBuilder().path("/upload/finalize").toUriString()).post(RequestBody.create((String)this.gson.toJson((Object)finalizeUpload), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        this.callWithRetries(request);
    }

    public MigrationDetailsV1 getMigrationDetailsV1(String cloudId, String migrationId) {
        UriComponentsBuilder uri = this.getUriBuilder().path("/details").pathSegment(new String[]{"{migrationId}"});
        Request request = this.getJsonBuilder(cloudId).url(uri.buildAndExpand(new Object[]{migrationId}).encode().toUriString()).get().build();
        return this.callGsonWithRetries(request, MigrationDetailsV1.class);
    }

    public void recordTransferError(@NotNull String cloudId, @NotNull String transferId, @NotNull TransferErrorRequest transferErrorRequest) {
        UriComponentsBuilder uri = this.getUriBuilder().path("/error").pathSegment(new String[]{TRANSFER_ID_PATH_SEGMENT});
        Request request = this.getJsonBuilder(cloudId).url(uri.buildAndExpand(new Object[]{transferId}).encode().toUriString()).post(RequestBody.create((String)this.gson.toJson((Object)transferErrorRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        this.callGsonWithRetries(request, TransferErrorRequest.class);
    }

    public void notifyListenerTriggered(@NotNull String cloudId, @NotNull String transferId) {
        UriComponentsBuilder uri = this.getUriBuilder().path("/transfer").pathSegment(new String[]{TRANSFER_ID_PATH_SEGMENT, "notify", "listener-triggered"});
        Request request = this.getJsonBuilder(cloudId).url(uri.buildAndExpand(new Object[]{transferId}).encode().toUriString()).post(RequestBody.create((ByteString)ByteString.EMPTY, (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        this.callGsonWithRetries(request, Void.class);
    }

    @Override
    public AppWebhookEndpointCheckResponse retrieveRegisteredWebhooks(@NotNull String cloudId, @NotNull AppWebhookEndpointCheckRequest appWebhookEndpointCheckRequest) throws HttpException {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder().path("/check/webhook/available").toUriString()).post(RequestBody.create((String)this.gson.toJson((Object)appWebhookEndpointCheckRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callGsonWithRetries(request, AppWebhookEndpointCheckResponse.class);
    }

    private Request.Builder getRequestBuilder(String cloudId) {
        return StargateHelper.requestBuilder(this.getContainerToken(cloudId), this.bypassStargate).addHeader("Cloud-Id", cloudId);
    }

    private Request.Builder getJsonBuilder(String cloudId) {
        return this.getRequestBuilder(cloudId).addHeader("Accept", "application/json");
    }

    private UriComponentsBuilder getUriBuilder() {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getAppMigrationServiceBaseUrl());
    }

    private String getContainerToken(String cloudId) {
        return this.cloudSiteService.getByCloudId(cloudId).get().getContainerToken();
    }

    private Response callWithRetries(Request request) {
        try {
            return (Response)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.httpService.call(request));
        }
        catch (HttpServiceException httpServiceException) {
            throw AppMigrationServiceClientKt.handleHttpServiceException((int)httpServiceException.getStatusCode(), (RuntimeException)httpServiceException);
        }
    }

    private <T> T callGsonWithRetries(Request request, Class<T> bodyType) {
        try {
            return (T)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.httpService.callGson(request, bodyType));
        }
        catch (HttpServiceException httpServiceException) {
            throw AppMigrationServiceClientKt.handleHttpServiceException((int)httpServiceException.getStatusCode(), (RuntimeException)httpServiceException);
        }
    }

    private Response getResponseForS3Upload(Request request) {
        try {
            return (Response)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.s3UploadHttpService.call(request));
        }
        catch (HttpServiceException httpServiceException) {
            throw AppMigrationServiceClientKt.handleHttpServiceException((int)httpServiceException.getStatusCode(), (RuntimeException)httpServiceException);
        }
    }
}

