/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.extract;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.migration.agent.newexport.processor.UserKeyXmlExtractor;
import com.atlassian.migration.agent.service.extract.ExtractionAnalyticsService;
import com.atlassian.migration.agent.service.extract.UserExtractionService;
import com.atlassian.migration.agent.store.impl.SpacePermissionStore;
import com.atlassian.migration.agent.store.jpa.impl.ConfluenceWrapperDataSource;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.Group;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

@ParametersAreNonnullByDefault
public class UserExtractionServiceImpl
implements UserExtractionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserExtractionServiceImpl.class);
    private static final String USER_EXTRACTION_METRIC_NAME = "migration.sli.user.extraction";
    @VisibleForTesting
    static final String SPACE_ID_QUERY = "SELECT spaceid FROM spaces WHERE spacekey = :spaceKey";
    @VisibleForTesting
    static final String CONTENT_IDS_QUERY = "SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))\nUNION\nSELECT CONTENTID FROM CONTENT WHERE SPACEID is null AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))";
    @VisibleForTesting
    static final String SPACE_USERS_QUERY = "SELECT CREATOR, LASTMODIFIER FROM SPACES WHERE SPACEID = :spaceId";
    @VisibleForTesting
    static final String NOTIFICATIONS_USERS_QUERY = String.format("SELECT USERNAME, CREATOR, LASTMODIFIER\nFROM NOTIFICATIONS\nWHERE SPACEID = :spaceId OR CONTENTID IN (%s)", "SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))\nUNION\nSELECT CONTENTID FROM CONTENT WHERE SPACEID is null AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))");
    @VisibleForTesting
    static final String SPACE_PERMISSIONS_USERS_QUERY = "SELECT PERMUSERNAME, CREATOR, LASTMODIFIER FROM SPACEPERMISSIONS WHERE SPACEID = :spaceId";
    @VisibleForTesting
    static final String PAGE_TEMPLATES_USERS_QUERY = "SELECT CREATOR, LASTMODIFIER FROM PAGETEMPLATES WHERE SPACEID = :spaceId";
    @VisibleForTesting
    static final String LIKES_USERS_QUERY = String.format("SELECT USERNAME FROM LIKES WHERE CONTENTID IN (%s)", "SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))\nUNION\nSELECT CONTENTID FROM CONTENT WHERE SPACEID is null AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))");
    @VisibleForTesting
    static final String USERCONTENT_RELATION_USERS_QUERY = String.format("SELECT SOURCEUSER, CREATOR, LASTMODIFIER FROM USERCONTENT_RELATION WHERE TARGETCONTENTID IN (%s)", "SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))\nUNION\nSELECT CONTENTID FROM CONTENT WHERE SPACEID is null AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))");
    @VisibleForTesting
    static final String CONTENT_RELATION_USERS_QUERY = String.format("SELECT CREATOR, LASTMODIFIER FROM CONTENT_RELATION WHERE TARGETCONTENTID IN (%s)", "SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))\nUNION\nSELECT CONTENTID FROM CONTENT WHERE SPACEID is null AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))");
    @VisibleForTesting
    static final String LABEL_USERS_QUERY = String.format("SELECT OWNER from LABEL WHERE LABELID in (SELECT LABELID FROM CONTENT_LABEL WHERE LABELID IN (%s) OR PAGETEMPLATEID IN (SELECT TEMPLATEID FROM PAGETEMPLATES WHERE SPACEID = :spaceId))", "SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))\nUNION\nSELECT CONTENTID FROM CONTENT WHERE SPACEID is null AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))");
    @VisibleForTesting
    static final String CONTENT_LABEL_USERS_QUERY = String.format("SELECT OWNER FROM CONTENT_LABEL WHERE CONTENTID IN (%s)", "SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))\nUNION\nSELECT CONTENTID FROM CONTENT WHERE SPACEID is null AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))");
    @VisibleForTesting
    static final String CONTENT_USERS_QUERY = String.format("SELECT CREATOR, LASTMODIFIER, USERNAME FROM CONTENT WHERE CONTENTID IN (%s)", "SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))\nUNION\nSELECT CONTENTID FROM CONTENT WHERE SPACEID is null AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))");
    @VisibleForTesting
    static final String LINKS_USERS_QUERY = String.format("SELECT CREATOR, LASTMODIFIER FROM LINKS WHERE CONTENTID IN (%s)", "SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))\nUNION\nSELECT CONTENTID FROM CONTENT WHERE SPACEID is null AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))");
    @VisibleForTesting
    static final String CONTENT_PERM_USERS_QUERY = String.format("SELECT USERNAME, CREATOR, LASTMODIFIER \nFROM CONTENT_PERM \nWHERE CPS_ID IN (SELECT ID FROM CONTENT_PERM_SET WHERE CONTENT_ID IN (%s))", "SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))\nUNION\nSELECT CONTENTID FROM CONTENT WHERE SPACEID is null AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))");
    @VisibleForTesting
    static final String EMBEDDED_USERS_QUERY = String.format("SELECT BODY FROM BODYCONTENT WHERE BODY LIKE '%%ri:userkey%%' AND CONTENTID IN (%s)", "SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))\nUNION\nSELECT CONTENTID FROM CONTENT WHERE SPACEID is null AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId)\nUNION\nSELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PREVVER IN (SELECT CONTENTID FROM CONTENT WHERE CONTENTTYPE = 'COMMENT' AND PAGEID IN (SELECT CONTENTID FROM CONTENT WHERE SPACEID = :spaceId))");
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final SpaceManager spaceManager;
    private final SpacePermissionManager spacePermissionsManager;
    private final UserAccessor userAccessor;
    private final TransactionTemplate transactionTemplate;
    private final ExtractionAnalyticsService extractionAnalyticsService;
    private final SpacePermissionStore spacePermissionStore;

    public UserExtractionServiceImpl(ConfluenceWrapperDataSource dataSource, SpaceManager spaceManager, SpacePermissionManager spacePermissionsManager, UserAccessor userAccessor, TransactionTemplate transactionTemplate, ExtractionAnalyticsService extractionAnalyticsService, SpacePermissionStore spacePermissionStore) {
        this.jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)((Object)dataSource));
        this.spaceManager = spaceManager;
        this.spacePermissionsManager = spacePermissionsManager;
        this.userAccessor = userAccessor;
        this.transactionTemplate = transactionTemplate;
        this.extractionAnalyticsService = extractionAnalyticsService;
        this.spacePermissionStore = spacePermissionStore;
    }

    @VisibleForTesting
    UserExtractionServiceImpl(NamedParameterJdbcTemplate jdbcTemplate, SpaceManager spaceManager, SpacePermissionManager spacePermissionsManager, UserAccessor userAccessor, TransactionTemplate transactionTemplate, ExtractionAnalyticsService extractionAnalyticsService, SpacePermissionStore spacePermissionStore) {
        this.jdbcTemplate = jdbcTemplate;
        this.spaceManager = spaceManager;
        this.spacePermissionsManager = spacePermissionsManager;
        this.userAccessor = userAccessor;
        this.transactionTemplate = transactionTemplate;
        this.extractionAnalyticsService = extractionAnalyticsService;
        this.spacePermissionStore = spacePermissionStore;
    }

    @Override
    public Map<String, Set<String>> getUsersFromSpaces(List<String> spaceKeys) {
        return spaceKeys.stream().collect(Collectors.toMap(space -> space, this::getUsersFromSpace));
    }

    @Override
    public Set<String> getUsersFromSpace(String spaceKey) {
        log.info("Get users from space with spaceKey: {}", (Object)spaceKey);
        Instant start = Instant.now();
        Set usersWithPermission = (Set)this.transactionTemplate.execute(() -> {
            Space space = this.spaceManager.getSpace(spaceKey);
            if (space == null) {
                throw new IllegalArgumentException("Space [" + spaceKey + "] not found!");
            }
            Set<String> userKeys = this.extractUsersFromQueryResults(space.getId(), SPACE_USERS_QUERY, NOTIFICATIONS_USERS_QUERY, SPACE_PERMISSIONS_USERS_QUERY, PAGE_TEMPLATES_USERS_QUERY, LIKES_USERS_QUERY, USERCONTENT_RELATION_USERS_QUERY, CONTENT_RELATION_USERS_QUERY, LABEL_USERS_QUERY, CONTENT_LABEL_USERS_QUERY, CONTENT_USERS_QUERY, LINKS_USERS_QUERY, CONTENT_PERM_USERS_QUERY);
            userKeys.addAll(this.extractUsersEmbeddedInContent(space.getId()));
            userKeys.addAll(this.getUsersFromGroupsWithSpacePermission(space));
            return userKeys;
        });
        long elapsedTime = start.until(Instant.now(), ChronoUnit.MILLIS);
        this.extractionAnalyticsService.sendExtractionAnalytics(USER_EXTRACTION_METRIC_NAME, elapsedTime, usersWithPermission.size());
        return usersWithPermission;
    }

    @Override
    public Set<String> getUsersWithPermissionFromSpaces(@Nonnull Set<String> spaceKeys) {
        Instant start = Instant.now();
        log.info("Get users with permissions from {} spaces", (Object)spaceKeys.size());
        HashSet<String> usersWithPermissions = new HashSet<String>();
        usersWithPermissions.addAll(this.spacePermissionStore.getUsersWithSpacePermissions(spaceKeys));
        usersWithPermissions.addAll(this.spacePermissionStore.getMembersUnderGroupsWithSpacePermissions(spaceKeys));
        Instant end = Instant.now();
        log.info("Took {} to retrieve {} users with space permissions from {} spaces", new Object[]{Duration.between(start, end).toMillis(), usersWithPermissions.size(), spaceKeys.size()});
        return usersWithPermissions;
    }

    private Set<String> getUsersFromGroupsWithSpacePermission(Space space) {
        HashSet<String> userKeys = new HashSet<String>();
        for (Group group : this.spacePermissionsManager.getGroupsWithPermissions(space)) {
            for (ConfluenceUser user : this.userAccessor.getMembers(group)) {
                userKeys.add(user.getKey().getStringValue());
            }
        }
        return userKeys;
    }

    private Set<String> extractUsersEmbeddedInContent(long spaceId) {
        HashSet<String> userKeys = new HashSet<String>();
        UserKeyXmlExtractor userExtractor = new UserKeyXmlExtractor(row -> {}, userKeys);
        return (Set)this.jdbcTemplate.query(EMBEDDED_USERS_QUERY, Collections.singletonMap("spaceId", spaceId), rs -> {
            while (rs.next()) {
                userExtractor.process(rs);
            }
            return userKeys;
        });
    }

    private Set<String> extractUsersFromQueryResults(long spaceId, String ... queries) {
        HashSet<String> userKeys = new HashSet<String>();
        for (String query : queries) {
            Set<String> newUsers = this.extractUsersFromQuery(query, Collections.singletonMap("spaceId", spaceId));
            userKeys.addAll(newUsers);
        }
        return userKeys;
    }

    private <T> Set<String> extractUsersFromQuery(String query, Map<String, T> params) {
        HashSet<String> users = new HashSet<String>();
        for (Map row : this.jdbcTemplate.queryForList(query, params)) {
            for (Object value : row.values()) {
                if (value == null) continue;
                users.add(value.toString());
            }
        }
        return users;
    }
}

