/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.catalogue;

import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.ImportType;
import com.atlassian.migration.agent.entity.MigrationStatus;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.media.MediaTokenConfig;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.MediaTypes;
import com.atlassian.migration.agent.okhttp.OKHttpProxyBuilder;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.okhttp.ServiceErrorCodeHandler;
import com.atlassian.migration.agent.service.ConfluenceImportExportTaskStatus;
import com.atlassian.migration.agent.service.MCSUploadPath;
import com.atlassian.migration.agent.service.SpaceImportContextDto;
import com.atlassian.migration.agent.service.catalogue.ContainerCreateRequest;
import com.atlassian.migration.agent.service.catalogue.ContainersFetchResponse;
import com.atlassian.migration.agent.service.catalogue.ContainersUpdateRequest;
import com.atlassian.migration.agent.service.catalogue.MigrationCreateRequest;
import com.atlassian.migration.agent.service.catalogue.MigrationDetails;
import com.atlassian.migration.agent.service.catalogue.MigrationScopeCreateRequest;
import com.atlassian.migration.agent.service.catalogue.MigrationScopeDetails;
import com.atlassian.migration.agent.service.catalogue.Space;
import com.atlassian.migration.agent.service.catalogue.model.AbstractContainer;
import com.atlassian.migration.agent.service.catalogue.model.CompleteMultipartFileUploadRequest;
import com.atlassian.migration.agent.service.catalogue.model.CreateFileRequest;
import com.atlassian.migration.agent.service.catalogue.model.CreateSinglepartFileResponse;
import com.atlassian.migration.agent.service.catalogue.model.MigrationDomainsAllowlistResponse;
import com.atlassian.migration.agent.service.catalogue.model.MigrationMappingPage;
import com.atlassian.migration.agent.service.catalogue.model.SpaceResponse;
import com.atlassian.migration.agent.service.catalogue.model.StorageFileDownloadResponse;
import com.atlassian.migration.agent.service.catalogue.model.StorageFileResponse;
import com.atlassian.migration.agent.service.catalogue.model.UploadFilePart;
import com.atlassian.migration.agent.service.catalogue.model.UploadFilePartResponse;
import com.atlassian.migration.agent.service.check.email.InvalidEmailCheckRequest;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.confluence.request.AbstractSpaceImportPayload;
import com.atlassian.migration.agent.service.confluence.request.SpaceImportPayload;
import com.atlassian.migration.agent.service.confluence.request.SpaceImportV2Payload;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.impl.StargateHelper;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import com.atlassian.migration.agent.service.user.EmailCheckStatusResponse;
import com.atlassian.migration.agent.service.user.LicenceCheckRequest;
import com.atlassian.migration.agent.service.user.LicenceCheckStatusResponse;
import com.atlassian.migration.agent.service.user.MigrationResponse;
import com.atlassian.migration.agent.service.util.StopConditionCheckingUtil;
import com.atlassian.migration.app.ContainerType;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.RetryPolicy;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.type.TypeReference;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

@ParametersAreNonnullByDefault
public class EnterpriseGatekeeperClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnterpriseGatekeeperClient.class);
    private static final String ENTITY_TYPE_KEY = "entityType";
    private static final String ID_PREFIX_FILTER_KEY = "idPrefixFilter";
    private static final String LAST_ENTITY_KEY = "lastEntity";
    private static final String PAGE_SIZE_KEY = "pageSize";
    private static final int PAGE_SIZE = 1000;
    private static final String MULTIPART = "MULTIPART";
    private static final String SINGLEPART = "SINGLEPART";
    public static final int LARGE_FILE_SIZE = 0x6400000;
    private static final String ETAG_HEADER = "ETag";
    private static final String MIGRATION_PATH = "/migration";
    public static final String MIGRATION_ALLOWLIST_PATH = "/migration/allowlist/CONFLUENCE";
    private static final String STORAGE_FILE_PATH = "/storage/file/";
    private static final String CONTAINER_PATH = "/container";
    private static final String SCOPE_PATH = "/scope";
    private static final String STATUS_PATH = "/status";
    public static final String CLOUD_ID_HEADER = "Cloud-Id";
    private static final String CLOUD_ID = "cloudid";
    private static final String IMPORT_PATH = "import";
    private static final String V1 = "v1";
    private static final String V2 = "v2";
    private static final int SPACES_BATCH_SIZE = 1000;
    private static final String SPACE_PATH = "space";
    private static final String CONFLUENCE_LIMIT_QUERY_PARAM = "limit";
    private static final String CONFLUENCE_START_QUERY_PARAM = "start";
    private static final String EMPTY_PREFIX = "";
    private final HttpService httpService;
    private final MigrationAgentConfiguration configuration;
    private final CloudSiteService cloudSiteService;
    private final boolean bypassStargate;
    private final RetryPolicy retryPolicy;
    private final Gson gson = new Gson();

    public EnterpriseGatekeeperClient(MigrationAgentConfiguration configuration, UserAgentInterceptor userAgentInterceptor, CloudSiteService cloudSiteService, OKHttpProxyBuilder okHttpProxyBuilder) {
        this(new HttpService(() -> EnterpriseGatekeeperClient.buildHttpClient(userAgentInterceptor, okHttpProxyBuilder), new ServiceErrorCodeHandler()), configuration, cloudSiteService, RetryPolicyBuilder.enterpriseGatekeeperClientRetryPolicy().build());
    }

    @VisibleForTesting
    EnterpriseGatekeeperClient(HttpService httpService, MigrationAgentConfiguration configuration, CloudSiteService cloudSiteService, RetryPolicy retryPolicy) {
        this.bypassStargate = configuration.isBypassStargate();
        this.httpService = httpService;
        this.configuration = configuration;
        this.cloudSiteService = cloudSiteService;
        this.retryPolicy = retryPolicy;
    }

    @VisibleForTesting
    static OkHttpClient buildHttpClient(UserAgentInterceptor userAgentInterceptor, OKHttpProxyBuilder okHttpProxyBuilder) {
        return okHttpProxyBuilder.getProxyBuilder().connectTimeout(5L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout(60L, TimeUnit.SECONDS).addInterceptor((Interceptor)userAgentInterceptor).build();
    }

    MigrationDetails createMigration(String cloudId, MigrationCreateRequest migrationCreateRequest) {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(MIGRATION_PATH).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)this.gson.toJson((Object)migrationCreateRequest))).build();
        return this.callGsonWithRetries(request, MigrationDetails.class);
    }

    void createContainers(String cloudId, String migrationId, ContainerCreateRequest containerCreateRequest) {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(MIGRATION_PATH).pathSegment(new String[]{migrationId}).path(CONTAINER_PATH).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)this.gson.toJson((Object)containerCreateRequest))).build();
        this.callWithRetries(request);
    }

    public ConfluenceImportExportTaskStatus initiateConfluenceSpaceImport(String cloudId, String containerToken, ImportType importType, SpaceImportContextDto spaceImportContext) {
        UriComponentsBuilder importEndpointUriBuilder;
        AbstractSpaceImportPayload spaceImportPayload;
        if (importType != ImportType.CSV) {
            spaceImportPayload = new SpaceImportPayload(spaceImportContext.getFileId(), spaceImportContext.getMigrationScopeId(), spaceImportContext.getMigrationId(), spaceImportContext.getFiles());
            importEndpointUriBuilder = this.getConfluenceUriBuilder(V1);
        } else {
            spaceImportPayload = new SpaceImportV2Payload(spaceImportContext.getFileId(), spaceImportContext.getMigrationScopeId(), spaceImportContext.getMigrationId(), spaceImportContext.getFiles());
            importEndpointUriBuilder = this.getConfluenceUriBuilder(V2);
        }
        Request request = this.getJsonBuilder(cloudId, containerToken).url(importEndpointUriBuilder.pathSegment(new String[]{CLOUD_ID, cloudId, IMPORT_PATH}).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)Jsons.valueAsString(spaceImportPayload))).build();
        return this.callJsonWithRetries(request, new TypeReference<ConfluenceImportExportTaskStatus>(){});
    }

    public ConfluenceImportExportTaskStatus getConfluenceSpaceImportProgress(String cloudId, String containerToken, String confTaskId, ImportType importType) {
        Objects.requireNonNull(confTaskId);
        UriComponentsBuilder importEndpointUriBuilder = importType == ImportType.XML ? this.getConfluenceUriBuilder(V1) : this.getConfluenceUriBuilder(V2);
        Request request = this.getJsonBuilder(cloudId, containerToken).url(importEndpointUriBuilder.pathSegment(new String[]{CLOUD_ID, cloudId, IMPORT_PATH, "taskid", confTaskId}).toUriString()).get().build();
        return this.callJsonWithRetries(request, new TypeReference<ConfluenceImportExportTaskStatus>(){});
    }

    public Map<String, String> getMappings(String cloudId, String migrationScopeId, String entityType, String idPrefixFilter) {
        MigrationMappingPage page;
        String lastEntity = null;
        HashMap<String, String> mappings = new HashMap<String, String>();
        do {
            page = this.getMappingsPage(cloudId, migrationScopeId, entityType, idPrefixFilter, lastEntity);
            lastEntity = page.getMeta().getLastEntity();
            mappings.putAll(page.getItems());
        } while (lastEntity != null && !lastEntity.isEmpty() && page.getMeta().isHasNext());
        return mappings;
    }

    public MigrationScopeDetails createMigrationScope(String cloudId, MigrationScopeCreateRequest migrationScopeCreateRequest) {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(SCOPE_PATH).toUriString()).post(RequestBody.create((String)this.gson.toJson((Object)migrationScopeCreateRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callGsonWithRetries(request, MigrationScopeDetails.class);
    }

    private MigrationMappingPage getMappingsPage(String cloudId, String migrationScopeId, String entityType, String idPrefixFilter, @Nullable String lastEntity) {
        UriComponentsBuilder builder = this.getMmsUriBuilder(V1).path(SCOPE_PATH).pathSegment(new String[]{migrationScopeId}).path("/mapping/page").queryParam(ENTITY_TYPE_KEY, new Object[]{entityType}).queryParam(ID_PREFIX_FILTER_KEY, new Object[]{idPrefixFilter}).queryParam(PAGE_SIZE_KEY, new Object[]{1000});
        if (lastEntity != null) {
            builder = builder.queryParam(LAST_ENTITY_KEY, new Object[]{lastEntity});
        }
        Request request = this.getJsonBuilder(cloudId).url(builder.toUriString()).get().build();
        return this.callGsonWithRetries(request, MigrationMappingPage.class);
    }

    ContainersFetchResponse getContainersForMigration(String cloudId, String migrationId, AbstractContainer.Type type, int pageSize, @Nullable String nextId, boolean expand) {
        UriComponentsBuilder uri = this.getUriBuilder(V1).path(MIGRATION_PATH).pathSegment(new String[]{migrationId}).path(CONTAINER_PATH).queryParam("containerType", new Object[]{type}).queryParam(PAGE_SIZE_KEY, new Object[]{pageSize});
        if (expand) {
            uri.queryParam("expand", new Object[]{"TRANSFERS"});
        }
        if (StringUtils.isNotEmpty((CharSequence)nextId)) {
            uri.queryParam("nextId", new Object[]{nextId});
        }
        Request request = this.getJsonBuilder(cloudId).url(uri.toUriString()).get().build();
        return this.callGsonWithRetries(request, ContainersFetchResponse.class);
    }

    ContainersFetchResponse getContainersByStatusForMigration(String cloudId, String migrationId, ContainerType type, AbstractContainer.ContainerStatus status, int pageSize, @Nullable String nextId) {
        UriComponentsBuilder uri = this.getUriBuilder(V1).path(MIGRATION_PATH).pathSegment(new String[]{migrationId}).path(CONTAINER_PATH).queryParam("containerType", new Object[]{type}).queryParam("status", new Object[]{status}).queryParam(PAGE_SIZE_KEY, new Object[]{pageSize});
        if (StringUtils.isNotEmpty((CharSequence)nextId)) {
            uri.queryParam("nextId", new Object[]{nextId});
        }
        Request request = this.getJsonBuilder(cloudId).url(uri.toUriString()).get().build();
        return this.callGsonWithRetries(request, ContainersFetchResponse.class);
    }

    void updateMigrationStatusForContainers(String cloudId, String migrationId, String containerId, AbstractContainer.ContainerStatus status, @Nullable String statusMessage) {
        ContainersUpdateRequest containersUpdateRequest = new ContainersUpdateRequest(status, statusMessage);
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(MIGRATION_PATH).pathSegment(new String[]{migrationId}).path(CONTAINER_PATH).pathSegment(new String[]{containerId}).path(STATUS_PATH).toUriString()).put(RequestBody.create((String)this.gson.toJson((Object)containersUpdateRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        this.callWithRetries(request);
    }

    public StorageFileResponse createStorageFileInMCS(String cloudId, String migrationId, String fileName, MCSUploadPath mcsUploadPath) {
        return this.createStorageFileInMCS(cloudId, migrationId, fileName, mcsUploadPath, EMPTY_PREFIX);
    }

    public StorageFileResponse createStorageFileInMCS(String cloudId, String migrationId, String fileName, MCSUploadPath mcsUploadPath, String prefix) {
        log.info("MULTIPART - Creating file in MCS cloudId: {} for {}: {} fileName: {}", new Object[]{cloudId, mcsUploadPath.getValue(), migrationId, fileName});
        Request request = this.buildCreateStorageFileRequest(cloudId, migrationId, fileName, MULTIPART, mcsUploadPath, prefix);
        return this.callGsonWithRetries(request, StorageFileResponse.class);
    }

    public CreateSinglepartFileResponse createStorageFileInMCSSinglePart(String cloudId, String migrationId, String fileName, MCSUploadPath mcsUploadPath) {
        return this.createStorageFileInMCSSinglePart(cloudId, migrationId, fileName, mcsUploadPath, EMPTY_PREFIX);
    }

    public CreateSinglepartFileResponse createStorageFileInMCSSinglePart(String cloudId, String migrationId, String fileName, MCSUploadPath mcsUploadPath, String prefix) {
        log.info("SINGLEPART - Creating file in MCS cloudId: {} for {} : {} fileName: {}", new Object[]{cloudId, mcsUploadPath.getValue(), migrationId, fileName});
        Request request = this.buildCreateStorageFileRequest(cloudId, migrationId, fileName, SINGLEPART, mcsUploadPath, prefix);
        return this.callGsonWithRetries(request, CreateSinglepartFileResponse.class);
    }

    @NotNull
    private Request buildCreateStorageFileRequest(String cloudId, String migrationId, String fileName, String uploadMethod, MCSUploadPath mcsUploadPath, String prefix) {
        return this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(this.getMigrationOrScopePathSegment(mcsUploadPath)).pathSegment(new String[]{migrationId}).path("/storage/file").queryParam("uploadMethod", new Object[]{uploadMethod}).toUriString()).post(RequestBody.create((String)this.gson.toJson((Object)new CreateFileRequest(fileName, prefix)), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
    }

    public StorageFileDownloadResponse getFileDownloadUrlFromMCS(String cloudId, String migrationId, String fileId, MCSUploadPath mcsUploadPath) {
        log.info("Get file download url in MCS cloudId: {} for {} : {} fileId: {}", new Object[]{cloudId, mcsUploadPath.getValue(), migrationId, fileId});
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(this.getMigrationOrScopePathSegment(mcsUploadPath)).pathSegment(new String[]{migrationId}).path(STORAGE_FILE_PATH).pathSegment(new String[]{fileId}).toUriString()).get().build();
        return this.callGsonWithRetries(request, StorageFileDownloadResponse.class);
    }

    public String getMediaToken(String cloudId, Duration ttl, String containerToken) {
        Request request = StargateHelper.requestBuilder(containerToken, this.bypassStargate).addHeader("Accept", "text/plain").addHeader(CLOUD_ID_HEADER, cloudId).url(this.getConfluenceUriBuilder(V1).pathSegment(new String[]{CLOUD_ID, cloudId}).path("/upload/media/token").queryParam("expiryDuration", new Object[]{ttl.toMinutes()}).toUriString()).get().build();
        return this.callGsonWithRetries(request, String.class);
    }

    public MediaTokenConfig getMediaTokenConfig(String cloudId, String containerToken) {
        Request request = this.getJsonBuilder(cloudId, containerToken).url(this.getConfluenceUriBuilder(V1).pathSegment(new String[]{CLOUD_ID, cloudId}).path("/media/config").toUriString()).get().build();
        return this.callGsonWithRetries(request, MediaTokenConfig.class);
    }

    public MigrationResponse startEmailCheck(String cloudId, String migrationScopeId, InvalidEmailCheckRequest invalidEmailCheckRequest) {
        Request request = this.getJsonBuilder(cloudId).url(this.buildInvalidEmailsCheckUrl(migrationScopeId).toUriString()).post(RequestBody.create((String)this.gson.toJson((Object)invalidEmailCheckRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callGsonWithRetries(request, MigrationResponse.class);
    }

    public EmailCheckStatusResponse getInvalidEmailsCheckStatus(String cloudId, String migrationScopeId, String taskId) {
        Request request = this.getJsonBuilder(cloudId).url(this.buildInvalidEmailsCheckUrl(migrationScopeId).pathSegment(new String[]{taskId}).toUriString()).get().build();
        return this.callGsonWithRetries(request, EmailCheckStatusResponse.class);
    }

    public LicenceCheckStatusResponse getLicenceCheckStatus(String cloudId, String migrationScopeId, String taskId) {
        Request request = this.getJsonBuilder(cloudId).url(this.buildLicenceCheckUrl(migrationScopeId).pathSegment(new String[]{taskId}).toUriString()).get().build();
        return this.callGsonWithRetries(request, LicenceCheckStatusResponse.class);
    }

    public MigrationResponse startLicenceCheck(String cloudId, String migrationScopeId, LicenceCheckRequest licenceCheckRequest) {
        Request request = this.getJsonBuilder(cloudId).url(this.buildLicenceCheckUrl(migrationScopeId).toUriString()).post(RequestBody.create((String)this.gson.toJson((Object)licenceCheckRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callGsonWithRetries(request, MigrationResponse.class);
    }

    public MigrationDomainsAllowlistResponse getDomainAllowlist(String cloudId) {
        Request request = this.getJsonBuilder(cloudId).url(this.buildDomainAllowlistUrl().toUriString()).get().build();
        return this.callGsonWithRetries(request, MigrationDomainsAllowlistResponse.class);
    }

    private UriComponentsBuilder getUserMigrationUriBuilder(String version) {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getUserMigrationServiceViaEGBaseUrl(version));
    }

    private UriComponentsBuilder buildInvalidEmailsCheckUrl(String migrationScopeId) {
        return this.getUserMigrationUriBuilder(V1).path(SCOPE_PATH).pathSegment(new String[]{migrationScopeId}).path("/confluence/check/emails");
    }

    private UriComponentsBuilder buildLicenceCheckUrl(String migrationScopeId) {
        return this.getUserMigrationUriBuilder(V1).path(SCOPE_PATH).pathSegment(new String[]{migrationScopeId}).path("check/licence/");
    }

    public void uploadFileToMCS(String cloudId, String migrationId, String fileId, String uploadId, Path filePath, MCSUploadPath mcsUploadPath) {
        try {
            log.info("Uploading file cloudId: {} migrationId: {} fileId: {} uploadId: {} filename: {}", new Object[]{cloudId, migrationId, fileId, uploadId, filePath.toAbsolutePath()});
            try (FileInputStream inputStream = new FileInputStream(filePath.toFile());){
                this.uploadFile(cloudId, migrationId, fileId, uploadId, inputStream, mcsUploadPath);
            }
        }
        catch (UncheckedInterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read file: " + filePath.getFileName(), e);
        }
        catch (Exception e) {
            log.error("Error occurred when uploading file to MCS", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void uploadFile(String cloudId, String migrationId, String fileId, String uploadId, FileInputStream inputStream, MCSUploadPath mcsUploadPath) {
        try {
            long fileSize = inputStream.getChannel().size();
            long partSize = 0x6400000L;
            long bytesRemaining = fileSize;
            ArrayList<UploadFilePart> fileParts = new ArrayList<UploadFilePart>();
            int index = 1;
            while (bytesRemaining > 0L) {
                if (bytesRemaining < partSize) {
                    partSize = bytesRemaining;
                }
                long offSet = (long)(index - 1) * 0x6400000L;
                StopConditionCheckingUtil.throwIfStopConditionWasReached();
                Response uploadResponse = this.uploadFilePart(cloudId, migrationId, fileId, uploadId, offSet, index, partSize, inputStream, mcsUploadPath);
                UploadFilePart filePart = this.createUploadFilePart(index, uploadResponse);
                fileParts.add(filePart);
                bytesRemaining -= partSize;
                ++index;
            }
            this.completeMultipartUpload(cloudId, migrationId, fileId, uploadId, fileParts, mcsUploadPath);
        }
        catch (UncheckedInterruptedException | ClosedByInterruptException e) {
            throw new UncheckedInterruptedException(e);
        }
        catch (Exception e) {
            log.error("Error uploading file, fileId: {}, migrationId: {}", new Object[]{fileId, migrationId, e});
            throw new RuntimeException(e);
        }
    }

    private Response uploadFilePart(String cloudId, String migrationId, String fileId, String uploadId, long offSet, int index, long partSize, FileInputStream inputStream, MCSUploadPath mcsUploadPath) throws IOException {
        Request request = this.buildUploadFilePartRequest(cloudId, migrationId, fileId, uploadId, index, mcsUploadPath);
        UploadFilePartResponse uploadFilePartResponse = this.callGsonWithRetries(request, UploadFilePartResponse.class);
        return this.uploadFilePart(uploadFilePartResponse, offSet, partSize, inputStream);
    }

    private Response uploadFilePart(UploadFilePartResponse result, long offSet, final long partSize, final FileInputStream inputStream) throws IOException {
        try {
            inputStream.getChannel().position(offSet);
            Request uploadRequest = new Request.Builder().url(result.getUploadUrl()).put(new RequestBody(){

                public long contentLength() {
                    return partSize;
                }

                public MediaType contentType() {
                    return MediaTypes.APPLICATION_STREAM_TYPE;
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    sink.write(Okio.source((InputStream)inputStream), partSize);
                }
            }).build();
            return this.callWithRetriesAndReturnResponse(uploadRequest);
        }
        catch (IllegalArgumentException exception) {
            log.error("Error while uploading the stream and with offset: " + offSet, (Throwable)exception);
            throw exception;
        }
    }

    private String getMigrationOrScopePathSegment(MCSUploadPath mcsUploadPath) {
        return mcsUploadPath == MCSUploadPath.MIGRATION_ID ? MIGRATION_PATH : SCOPE_PATH;
    }

    @NotNull
    private UploadFilePart createUploadFilePart(int index, Response uploadResponse) {
        String etag = uploadResponse.header(ETAG_HEADER);
        if (etag == null) {
            throw new RuntimeException("No ETag found in header during upload file part in index: " + index);
        }
        return new UploadFilePart(index, etag);
    }

    private Request buildUploadFilePartRequest(String cloudId, String migrationId, String fileId, String uploadId, int index, MCSUploadPath mcsUploadPath) {
        return this.getJsonBuilder(cloudId).url(this.buildUploadFilePartUrl(migrationId, fileId, uploadId, index, mcsUploadPath).toUriString()).post(RequestBody.create(null, (byte[])new byte[0])).build();
    }

    private UriComponentsBuilder buildUploadFilePartUrl(String migrationId, String fileId, String uploadId, int index, MCSUploadPath mcsUploadPath) {
        return this.getUriBuilder(V1).path(this.getMigrationOrScopePathSegment(mcsUploadPath)).pathSegment(new String[]{migrationId}).path(STORAGE_FILE_PATH).pathSegment(new String[]{fileId}).path("/upload").pathSegment(new String[]{uploadId}).path("/part/").pathSegment(new String[]{Integer.toString(index)});
    }

    Response completeMultipartUpload(String cloudId, String migrationId, String fileId, String uploadId, List<UploadFilePart> fileParts, MCSUploadPath mcsUploadPath) {
        log.info("Complete multipart upload for cloudId: {} for {} : {}, fileId: {}, # of file parts: {}", new Object[]{cloudId, mcsUploadPath.getValue(), migrationId, fileId, fileParts.size()});
        CompleteMultipartFileUploadRequest completeMultipartFileUploadRequest = new CompleteMultipartFileUploadRequest(fileParts);
        Request completeUploadRequest = this.getJsonBuilder(cloudId).url(this.buildCompleteUploadUrl(migrationId, fileId, uploadId, mcsUploadPath)).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)this.gson.toJson((Object)completeMultipartFileUploadRequest))).build();
        Response completeMultipartUploadResponse = this.callWithRetriesAndReturnResponse(completeUploadRequest);
        if (completeMultipartUploadResponse.code() != 204) {
            throw new RuntimeException("Error while completing multipart file upload in MCS status code: " + completeMultipartUploadResponse.code());
        }
        return completeMultipartUploadResponse;
    }

    private String buildCompleteUploadUrl(String migrationId, String fileId, String uploadId, MCSUploadPath mcsUploadPath) {
        return this.getUriBuilder(V1).path(this.getMigrationOrScopePathSegment(mcsUploadPath)).pathSegment(new String[]{migrationId}).path(STORAGE_FILE_PATH).pathSegment(new String[]{fileId}).path("/upload").pathSegment(new String[]{uploadId}).path("/complete").toUriString();
    }

    private UriComponentsBuilder buildDomainAllowlistUrl() {
        return this.getUriBuilder(V1).path(MIGRATION_ALLOWLIST_PATH);
    }

    private UriComponentsBuilder getUriBuilder(String version) {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getMigrationCatalogueServiceUrl(version));
    }

    private UriComponentsBuilder getConfluenceUriBuilder(String version) {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getConfluenceCloudUrl(version));
    }

    private UriComponentsBuilder getMmsUriBuilder(String version) {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getMigrationMappingServiceBaseUrl(version));
    }

    private Request.Builder getJsonBuilder(String cloudId) {
        return StargateHelper.requestBuilder(this.getContainerToken(cloudId), this.bypassStargate).addHeader(CLOUD_ID_HEADER, cloudId).addHeader("Accept", "application/json");
    }

    private Request.Builder getJsonBuilder(String cloudId, String containerToken) {
        return StargateHelper.requestBuilder(containerToken, this.bypassStargate).addHeader(CLOUD_ID_HEADER, cloudId).addHeader("Accept", "application/json");
    }

    private String getContainerToken(String cloudId) {
        Optional<CloudSite> cloudSite = this.cloudSiteService.getByCloudId(cloudId);
        if (!cloudSite.isPresent()) {
            throw new IllegalStateException(String.format("Failed to find cloudSite entry for requested cloudId: %s", cloudId));
        }
        return cloudSite.get().getContainerToken();
    }

    private void callWithRetries(Request request) {
        this.withStopConditionExceptionHandling(() -> (Response)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.httpService.call(request)));
    }

    private <T> T callGsonWithRetries(Request request, Class<T> bodyType) {
        return (T)this.withStopConditionExceptionHandling(() -> Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.httpService.callGson(request, bodyType)));
    }

    private Response callWithRetriesAndReturnResponse(Request request) {
        return this.withStopConditionExceptionHandling(() -> (Response)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.httpService.call(request)));
    }

    private <T> T callJsonWithRetries(Request request, TypeReference<T> bodyType) {
        return (T)this.withStopConditionExceptionHandling(() -> Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.httpService.callJson(request, bodyType)));
    }

    private <T> T withStopConditionExceptionHandling(Callable<T> callable) {
        try {
            StopConditionCheckingUtil.throwIfStopConditionWasReached();
            return callable.call();
        }
        catch (FailsafeException e) {
            if (StopConditionCheckingUtil.isStoppingExceptionInCausalChain((Exception)((Object)e))) {
                throw new UncheckedInterruptedException(e);
            }
            throw new FailsafeException((Throwable)e);
        }
        catch (UncheckedInterruptedException | InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        catch (Exception e) {
            if (StopConditionCheckingUtil.isStoppingExceptionInCausalChain(e)) {
                throw new UncheckedInterruptedException(e);
            }
            throw new RuntimeException(e);
        }
    }

    public void sendMigrationStatusToMCS(String migrationId, String cloudId, MigrationStatus migrationStatus, String statusMessage) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("status", (Object)migrationStatus);
        body.put("statusMessage", statusMessage);
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(MIGRATION_PATH).pathSegment(new String[]{migrationId}).path(STATUS_PATH).toUriString()).put(RequestBody.create((String)Jsons.valueAsString(body), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        this.callWithRetries(request);
    }

    public void uploadFileToMCSSinglePart(String uploadUrl, File file) {
        String contentDisposition = "attachment; filename*=UTF-8''" + file.getName();
        Request request = new Request.Builder().addHeader("Content-Disposition", contentDisposition).url(uploadUrl).put(RequestBody.create((File)file, (MediaType)MediaTypes.APPLICATION_STREAM_TYPE)).build();
        this.callWithRetries(request);
    }

    public Set<Space> getAllSpaces(CloudSite cloudSite) {
        HashSet<Space> spaceResults = new HashSet<Space>();
        String cloudId = cloudSite.getCloudId();
        String containerToken = cloudSite.getContainerToken();
        int pageNum = 1;
        int start = 0;
        while (true) {
            UriComponentsBuilder uriBuilder = this.getConfluenceUriBuilder(V1).pathSegment(new String[]{CLOUD_ID, cloudId, SPACE_PATH}).queryParam(CONFLUENCE_LIMIT_QUERY_PARAM, new Object[]{1000}).queryParam(CONFLUENCE_START_QUERY_PARAM, new Object[]{start});
            Request request = this.getJsonBuilder(cloudId, containerToken).url(uriBuilder.toUriString()).get().build();
            SpaceResponse spaceResult = this.callJsonWithRetries(request, new TypeReference<SpaceResponse>(){});
            spaceResults.addAll(spaceResult.results);
            log.info("FetchAllCloudSpaces: Fetched page [" + pageNum + " ], results = " + spaceResult.size);
            ++pageNum;
            if (spaceResult.size < 1000) break;
            start += 1000;
        }
        return spaceResults;
    }
}

