/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.agent.export.SpaceNoAttachmentsXmlExporter;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.newexport.ConfluenceRapidExporter;
import com.atlassian.migration.agent.newexport.XmlIdExtractor;
import com.atlassian.migration.agent.newexport.store.JdbcConfluenceStore;
import com.atlassian.migration.agent.service.stepexecutor.export.SpaceExportCacheService;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.slf4j.Logger;

@Path(value="export")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ResourceFilters(value={AdminOnlyResourceFilter.class})
public class ExportDebugResource {
    private static final Logger log = ContextLoggerFactory.getLogger(ExportDebugResource.class);
    private static final String VALID_SPACE_PATTERN = "^~?\\w+";
    private final ConfluenceRapidExporter rapidExporter;
    private final JdbcConfluenceStore confluenceStore;
    private final SpaceNoAttachmentsXmlExporter spaceNoAttachmentsXmlExporter;
    private final SpaceExportCacheService spaceExportCacheService;
    private final XmlIdExtractor xmlIdExtractor;

    public ExportDebugResource(ConfluenceRapidExporter rapidExporter, JdbcConfluenceStore confluenceStore, SpaceNoAttachmentsXmlExporter spaceNoAttachmentsXmlExporter, SpaceExportCacheService spaceExportCacheService, XmlIdExtractor xmlIdExtractor) {
        this.rapidExporter = rapidExporter;
        this.confluenceStore = confluenceStore;
        this.spaceNoAttachmentsXmlExporter = spaceNoAttachmentsXmlExporter;
        this.spaceExportCacheService = spaceExportCacheService;
        this.xmlIdExtractor = xmlIdExtractor;
    }

    @POST
    @Path(value="/new/{spaceKey}")
    public Response newExport(@PathParam(value="spaceKey") String spaceKey) {
        this.validateSpaceKey(spaceKey);
        log.info("Running new export for space {}", (Object)spaceKey);
        ConfluenceRapidExporter.CSVExportTaskContext config = new ConfluenceRapidExporter.CSVExportTaskContext(this.confluenceStore.getSpaceId(spaceKey), spaceKey, "cloudId", "debug-plan", "debug-task", "/tmp", false);
        String outputFile = this.rapidExporter.export(config);
        return Response.ok(this.responsePayloadMap(String.format("New export finished for space: %s", spaceKey), outputFile)).build();
    }

    @POST
    @Path(value="/classic/{spaceKey}")
    public Response classicExport(@PathParam(value="spaceKey") String spaceKey) throws ExecutionException, InterruptedException {
        this.validateSpaceKey(spaceKey);
        log.info("Running classic export for space {}", (Object)spaceKey);
        String exportedFile = this.spaceNoAttachmentsXmlExporter.doExport(spaceKey, UUID.randomUUID().toString()).get();
        return Response.ok(this.responsePayloadMap(String.format("Classic export finished for space: %s", spaceKey), exportedFile)).build();
    }

    @POST
    @Path(value="/classic/extractids")
    public Response extractIdsFromEntitiesXml(FilePayload payload) throws FileNotFoundException, XMLStreamException {
        String outputFile = "/tmp/ids-out-" + System.currentTimeMillis();
        this.xmlIdExtractor.extractIdsAndKeys(payload.file, outputFile);
        return Response.ok(this.responsePayloadMap(String.format("Extracted exported ids from : %s to : %s", payload.file, outputFile), outputFile)).build();
    }

    @GET
    @Path(value="/cache/stale/{spaceKey}/{cloudId}")
    public Response getCacheEntry(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="cloudId") String cloudId) {
        boolean result = this.spaceExportCacheService.debugCacheEntry(spaceKey, cloudId);
        return Response.ok((Object)result).build();
    }

    private Map<String, String> responsePayloadMap(String message, String file) {
        return ImmutableMap.of((Object)"message", (Object)message, (Object)"file", (Object)file);
    }

    private void validateSpaceKey(String spaceKey) {
        if (StringUtils.isEmpty((CharSequence)spaceKey) || !spaceKey.matches(VALID_SPACE_PATTERN)) {
            throw new IllegalArgumentException("Invalid space key");
        }
    }

    static class FilePayload {
        @JsonProperty
        public String file;

        @JsonCreator
        public FilePayload(@JsonProperty(value="file") String file) {
            this.file = file;
        }
    }
}

