/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.media.impl;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.migration.agent.media.MediaClientToken;
import com.atlassian.migration.agent.media.MediaClientTokenSupplier;
import com.atlassian.migration.agent.service.confluence.ConfluenceCloudService;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class CachedMediaClientTokenSupplier
implements MediaClientTokenSupplier {
    private static final Duration DEFAULT_MEDIA_TOKEN_CACHE_EXPIRY_TTL = Duration.ofMinutes(8L);
    @VisibleForTesting
    static final Duration DEFAULT_MEDIA_TOKEN_TTL = Duration.ofMinutes(15L);
    private final LoadingCache<String, MediaClientToken> clientTokens;

    public CachedMediaClientTokenSupplier(final ConfluenceCloudService confluenceCloudService, Ticker ticker) {
        this.clientTokens = CacheBuilder.newBuilder().ticker(ticker).expireAfterWrite(DEFAULT_MEDIA_TOKEN_CACHE_EXPIRY_TTL.toMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, MediaClientToken>(){

            public MediaClientToken load(String containerToken) {
                return confluenceCloudService.getMediaClientToken(containerToken, DEFAULT_MEDIA_TOKEN_TTL);
            }
        });
    }

    @Override
    @Nonnull
    public MediaClientToken getToken(String containerToken) {
        try {
            return (MediaClientToken)this.clientTokens.get((Object)containerToken);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new IllegalStateException("Failed to load media token from container token", e);
        }
    }

    @Override
    @Nonnull
    public MediaClientToken getRefreshedToken(String containerToken) {
        this.clientTokens.invalidate((Object)containerToken);
        return this.getToken(containerToken);
    }
}

