/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.dto;

import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Progress;
import java.time.Instant;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonProperty;

public class ProgressDto {
    @JsonProperty
    private int completionPercent;
    @JsonProperty
    private Status status;
    @JsonProperty
    private Instant startTime;
    @JsonProperty
    private Instant endTime;
    @JsonProperty
    private String message;

    public ProgressDto(int completionPercent, Status status, String message, Instant startTime, Instant endTime) {
        this.completionPercent = completionPercent;
        this.status = status;
        this.message = message;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public ProgressDto(int completionPercent, Status status, String message) {
        this.completionPercent = completionPercent;
        this.status = status;
        this.message = message;
    }

    public int getCompletionPercent() {
        return this.completionPercent;
    }

    public String getMessage() {
        return this.message;
    }

    public Status getStatus() {
        return this.status;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public static ProgressDto fromPlanEntity(Progress progress) {
        Objects.requireNonNull(progress);
        return ProgressDto.fromEntity(progress, null, false);
    }

    public static ProgressDto fromTaskEntity(Progress progress, ExecutionStatus planStatus) {
        return ProgressDto.fromTaskEntity(progress, planStatus, false);
    }

    public static ProgressDto fromTaskEntity(Progress progress, ExecutionStatus planStatus, boolean omitStartAndEndTime) {
        Objects.requireNonNull(progress);
        Objects.requireNonNull(planStatus);
        return ProgressDto.fromEntity(progress, planStatus, omitStartAndEndTime);
    }

    private static ProgressDto fromEntity(Progress progress, @Nullable ExecutionStatus parentStatus, boolean omitStartAndEndTime) {
        return new ProgressDto(progress.getPercent(), ProgressDto.convertStatus(progress.getStatus(), parentStatus), progress.getMessage(), omitStartAndEndTime ? null : (Instant)progress.getStartTime().orElse(null), omitStartAndEndTime ? null : (Instant)progress.getEndTime().orElse(null));
    }

    public static Status convertStatus(ExecutionStatus execStatus, @Nullable ExecutionStatus parentStatus) {
        switch (execStatus) {
            case CREATED: {
                return Status.READY;
            }
            case DONE: {
                return Status.FINISHED;
            }
            case FAILED: {
                return Status.FAILED;
            }
            case STOPPED: {
                return Status.STOPPED;
            }
            case VALIDATING: 
            case RUNNING: {
                return parentStatus == ExecutionStatus.STOPPING ? Status.STOPPING : Status.RUNNING;
            }
            case STOPPING: {
                return Status.STOPPING;
            }
            case INCOMPLETE: {
                return Status.INCOMPLETE;
            }
        }
        throw new IllegalArgumentException("Unknown execution status " + execStatus.name());
    }

    public static enum Status {
        READY,
        RUNNING,
        STOPPING,
        FINISHED,
        STOPPED,
        FAILED,
        INCOMPLETE;


        public static Set<Status> finishedStatus() {
            return EnumSet.of(STOPPED, FINISHED, FAILED, INCOMPLETE);
        }
    }
}

