/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.config;

import com.atlassian.migration.agent.dto.ConfigDto;
import com.atlassian.migration.agent.newexport.DbType;
import com.atlassian.migration.agent.service.impl.ConfigurationService;
import com.atlassian.migration.agent.store.jpa.impl.DialectResolver;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;

public class MigrationAgentConfiguration {
    private static final String MIN_CONFLUENCE_SUPPORTED_VERSION = "6.15";
    private static final String MIGRATIONS_URL = "https://api-private.atlassian.com/migrations";
    private final DbType dbType;
    private final ConfigurationService configurationService;
    private static final List<DbType> supportedDBTypesForRapidExport = ImmutableList.of((Object)((Object)DbType.POSTGRES), (Object)((Object)DbType.MYSQL), (Object)((Object)DbType.H2));

    public MigrationAgentConfiguration(DialectResolver dialectResolver, ConfigurationService configurationService) {
        this.dbType = dialectResolver.getDbType();
        this.configurationService = configurationService;
    }

    public String getPluginKey() {
        return System.getProperty("migration.plugin.key", "com.atlassian.migration.agent");
    }

    public String getPluginVersion() {
        return System.getProperty("migration.plugin.version", "");
    }

    public boolean isFrontEndDevModeEnabled() {
        return Boolean.getBoolean("fe.dev.mode");
    }

    public String getMediaServiceUrl() {
        return System.getProperty("media.service.url", "https://api.media.atlassian.com");
    }

    public String getServerTimezone() {
        return TimeZone.getDefault().getID();
    }

    public String getMigrationAppAggregatorUrl() {
        return System.getProperty("migration.aggregator.base.url", "https://api.atlassian.com/migration/aggregator");
    }

    public String getMigrationServiceBaseUrl() {
        return System.getProperty("migration.service.base.url", "https://api-private.atlassian.com/migration");
    }

    public String getUserMigrationServiceViaEGBaseUrl(String version) {
        return System.getProperty("users.migration.service.via.eg.base.url", MIGRATIONS_URL) + "/" + version;
    }

    public String getUserMigrationServiceBaseUrl() {
        return System.getProperty("users.migration.service.base.url", "https://api-private.atlassian.com/migration/users");
    }

    public String getMigrationMappingServiceBaseUrl(String version) {
        return System.getProperty("migration.mapping.service.base.url", MIGRATIONS_URL) + "/" + version;
    }

    public String getMigrationAnalyticsServiceBaseUrl() {
        return System.getProperty("migration.analytics.base.url", "https://api-private.atlassian.com/migration/analytics");
    }

    public String getAppMigrationServiceBaseUrl() {
        return System.getProperty("app.migration.service.base.url", "https://api.atlassian.com/app/migration");
    }

    public String getMigrationCatalogueServiceUrl(String version) {
        return System.getProperty("migration.catalogue.service.base.url", MIGRATIONS_URL) + "/" + version;
    }

    public String getMigrationGatewayUrl() {
        return System.getProperty("migration.gateway.url", "https://migration.atlassian.com");
    }

    public String getConfluenceCloudUrl(String version) {
        return System.getProperty("confluence.cloud.service.base.url", "https://api-private.atlassian.com/migrations/confluence") + "/" + version;
    }

    public Integer getDBQueryParameterLimit() {
        return Integer.getInteger("migration.service.db.queryparamlimit", 1000);
    }

    public boolean isBypassStargate() {
        return Boolean.getBoolean("stargate.service.bypass");
    }

    public boolean isSkipNonceCheck() {
        return Boolean.getBoolean("skip.nonce.check");
    }

    public int getAttachmentMigrationExecutorConcurrency() {
        return Integer.getInteger("attachment.migration.executor.concurrency", 1);
    }

    public int getAttachmentMigrationConcurrencyPerNode() {
        return Integer.getInteger("attachment.migration.concurrency.per.node", 1);
    }

    public int getSpaceExportExecutorConcurrency() {
        return Integer.getInteger("space.export.executor.concurrency", 1);
    }

    public Optional<Integer> getSpaceExportConcurrencyNodeMaximum() {
        return Optional.ofNullable(this.getConfig().getSpaceExportConcurrencyNodeMaximum());
    }

    public Optional<Integer> getSpaceExportConcurrencyClusterMaximum() {
        return Optional.ofNullable(this.getConfig().getSpaceExportConcurrencyClusterMaximum());
    }

    public int getSpaceUploadExecutorConcurrency() {
        return Integer.getInteger("space.upload.executor.concurrency", 2);
    }

    public int getSpaceUploadConcurrencyPerNode() {
        return Integer.getInteger("space.upload.concurrency.per.node", 2);
    }

    public int getSpaceImportExecutorConcurrency() {
        return Integer.getInteger("space.import.executor.concurrency", 2);
    }

    public int getSpaceImportConcurrencyPerNode() {
        return Integer.getInteger("space.import.concurrency.per.node", 2);
    }

    public int getAttachmentUploadBatchSize() {
        return Integer.getInteger("attachment.upload.batch.size", 1000);
    }

    public int getAttachmentUploadConcurrency() {
        return Integer.getInteger("attachment.upload.concurrency", 5);
    }

    public int getAttachmentPrepareBatchSize() {
        return Integer.getInteger("attachment.prepare.batch.size", 1000);
    }

    public int getAnalyticsSenderJobIntervalInSeconds() {
        return Integer.getInteger("migration.analytics.job.interval", 120);
    }

    public int getAnalyticsSenderBatchSize() {
        return Integer.getInteger("migration.analytics.batch.size", 100);
    }

    public int getAnalyticsSenderMaxWaitInMinutes() {
        return Integer.getInteger("migration.analytics.sender.max.wait", 45);
    }

    public int getAnalyticsSenderMaxEventLength() {
        return Integer.getInteger("migration.analytics.event.max.length", 10000);
    }

    public int getLimitPerPageRequest() {
        return Integer.getInteger("app.usage.limit.per.page.request", 100);
    }

    public int getBatchSizePerQuery() {
        return Integer.getInteger("app.usage.batch.size.per.query", 999);
    }

    public boolean isAnalyticsSenderDisabled() {
        return Boolean.getBoolean("migration.analytics.sender.disabled");
    }

    public int getDetectedUserEmailAnalyticsEventUsersBatchSize() {
        return Integer.getInteger("migration.analytics.detected.email.users.batch.size", 100);
    }

    public Duration getIntervalBetweenDetectedUserEmailAnalyticsRuns() {
        long days = Long.getLong("migration.analytics.detected.email.interval.days", 5L);
        return Duration.ofDays(days);
    }

    public String getMinConfluenceSupportedVersion() {
        return MIN_CONFLUENCE_SUPPORTED_VERSION;
    }

    public int getMaxTaskAllocationsPerNode() {
        return Integer.getInteger("migration.max.task.allocation.per.node", 50);
    }

    public int getMaxConcurrentSpaceImportsPerPlan() {
        return Integer.getInteger("migration.max.space.imports.per.plan", 1);
    }

    public DbType getDBType() {
        return this.dbType;
    }

    public boolean isDBTypeSupportedForRapidExport() {
        return supportedDBTypesForRapidExport.contains((Object)this.getDBType());
    }

    private ConfigDto getConfig() {
        return this.configurationService.getCachedConfig();
    }
}

