/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.confluence;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.ImportType;
import com.atlassian.migration.agent.media.MediaClientToken;
import com.atlassian.migration.agent.media.MediaTokenConfig;
import com.atlassian.migration.agent.service.ConfluenceImportExportTaskStatus;
import com.atlassian.migration.agent.service.SpaceConflict;
import com.atlassian.migration.agent.service.SpaceImportContextDto;
import com.atlassian.migration.agent.service.catalogue.EnterpriseGatekeeperClient;
import com.atlassian.migration.agent.service.catalogue.Space;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.confluence.exception.ConfluenceCloudServiceException;
import com.atlassian.migration.agent.service.impl.MigrationPlatformService;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

@ParametersAreNonnullByDefault
public class ConfluenceCloudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfluenceCloudService.class);
    private final EnterpriseGatekeeperClient enterpriseGatekeeperClient;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final MigrationPlatformService migrationPlatformService;
    private final CloudSiteService cloudSiteService;

    public ConfluenceCloudService(EnterpriseGatekeeperClient enterpriseGatekeeperClient, MigrationDarkFeaturesManager migrationDarkFeaturesManager, MigrationPlatformService migrationPlatformService, CloudSiteService cloudSiteService) {
        this.enterpriseGatekeeperClient = enterpriseGatekeeperClient;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.migrationPlatformService = migrationPlatformService;
        this.cloudSiteService = cloudSiteService;
    }

    public ConfluenceImportExportTaskStatus initiateConfluenceSpaceImport(String cloudId, String containerToken, ImportType importType, SpaceImportContextDto spaceImportContext) {
        try {
            if (this.migrationDarkFeaturesManager.isProxyViaMigrationServiceEnabled()) {
                return this.migrationPlatformService.initiateConfluenceSpaceImport(containerToken, importType, spaceImportContext);
            }
            return this.enterpriseGatekeeperClient.initiateConfluenceSpaceImport(cloudId, containerToken, importType, spaceImportContext);
        }
        catch (Exception e) {
            log.error("Error initiating space import for cloudId: {}", (Object)cloudId, (Object)e);
            throw new ConfluenceCloudServiceException(String.format("Error occurred when initiating space import for cloudId: %s, cause: %s", cloudId, e.getMessage()), e);
        }
    }

    public ConfluenceImportExportTaskStatus getConfluenceSpaceImportProgress(String cloudId, String containerToken, String confTaskId, ImportType importType, SpaceImportContextDto spaceImportContext) {
        try {
            if (this.migrationDarkFeaturesManager.isProxyViaMigrationServiceEnabled()) {
                return this.migrationPlatformService.getConfluenceSpaceImportProgress(containerToken, confTaskId, spaceImportContext);
            }
            return this.enterpriseGatekeeperClient.getConfluenceSpaceImportProgress(cloudId, containerToken, confTaskId, importType);
        }
        catch (Exception e) {
            log.error("Error getting space import progress for for taskId: {}", (Object)confTaskId, (Object)e);
            throw new ConfluenceCloudServiceException(String.format("Error getting space import progress for for taskId: %s, cause: %s", confTaskId, e.getMessage()), e);
        }
    }

    public MediaClientToken getMediaClientToken(String containerToken, Duration expiryDuration) {
        try {
            if (this.migrationDarkFeaturesManager.isProxyViaMigrationServiceEnabled()) {
                log.debug("Requesting mediaToken via MS");
                return this.migrationPlatformService.getMediaToken(containerToken);
            }
            log.debug("Requesting Media Token via EG");
            String cloudId = this.cloudSiteService.getByContainerToken(containerToken).map(CloudSite::getCloudId).orElseThrow(() -> new IllegalStateException("Failed to find cloudSite entry for containerToken"));
            MediaTokenConfig mediaConfig = this.enterpriseGatekeeperClient.getMediaTokenConfig(cloudId, containerToken);
            String mediaToken = this.enterpriseGatekeeperClient.getMediaToken(cloudId, expiryDuration, containerToken);
            return new MediaClientToken(mediaConfig.getClientId(), mediaToken);
        }
        catch (Exception e) {
            log.error("Error getting Media Token", (Throwable)e);
            throw new IllegalStateException("Failed to get media token", e);
        }
    }

    public Set<SpaceConflict> getConflictingSpaces(CloudSite cloudSite, Set<String> spaceKeys) {
        Set<SpaceConflict> getSpaceResult;
        try {
            if (this.migrationDarkFeaturesManager.isProxyViaMigrationServiceEnabled()) {
                log.debug("Requesting spaces via MS");
                String containerToken = cloudSite.getContainerToken();
                getSpaceResult = this.migrationPlatformService.getSpaceConflicts(containerToken, spaceKeys);
            } else {
                log.debug("Requesting spaces via EG");
                getSpaceResult = this.getConflictingSpacesInCloud(cloudSite, spaceKeys);
            }
        }
        catch (Exception ex) {
            log.error("Error getting spaces: {}", (Object)ex.getMessage());
            throw new IllegalStateException("Failed to get spaces", ex);
        }
        return getSpaceResult;
    }

    public Set<SpaceConflict> getConflictingSpacesInCloud(CloudSite cloudSite, Set<String> spaceKeys) {
        Set<Space> allSpaces = this.enterpriseGatekeeperClient.getAllSpaces(cloudSite);
        Set conflictSpaces = allSpaces.stream().filter(space -> spaceKeys.contains(space.key)).collect(Collectors.toSet());
        log.info("SpaceConflictCheck: Found [" + conflictSpaces.size() + "] conflicts from [" + spaceKeys.size() + "] spacesToMigrate");
        return new SpaceConflictCheckResponse(conflictSpaces.stream().map(space -> ConfluenceCloudService.spaceToSpaceConflict(space, cloudSite)).collect(Collectors.toSet())).spaceConflicts;
    }

    private static SpaceConflict spaceToSpaceConflict(Space space, CloudSite site) {
        return new SpaceConflict(space.key, space.name, UriComponentsBuilder.fromUriString((String)site.getCloudUrl()).path("wiki").path(space._links.webui).toUriString());
    }

    @VisibleForTesting
    static class SpaceConflictCheckResponse {
        private Set<SpaceConflict> spaceConflicts;

        @JsonCreator
        SpaceConflictCheckResponse(@JsonProperty(value="spaceConflicts") Set<SpaceConflict> spaceConflicts) {
            this.spaceConflicts = spaceConflicts;
        }
    }
}

