/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics;

import com.atlassian.cmpt.analytics.events.CounterMetricEvent;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.cmpt.analytics.events.GenericScreenEvent;
import com.atlassian.cmpt.analytics.events.GenericTrackEvent;
import com.atlassian.cmpt.analytics.events.GenericUiEvent;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.check.email.EmailDuplicate;
import com.atlassian.confluence.cluster.ClusterInformation;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.confluence.status.service.systeminfo.DatabaseInfo;
import com.atlassian.confluence.status.service.systeminfo.UsageInfo;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.migration.agent.dto.ConfluenceSpaceTaskDto;
import com.atlassian.migration.agent.dto.MigrateUsersTaskDto;
import com.atlassian.migration.agent.dto.MigrationDetailsDto;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.dto.analytics.ScreenAnalyticsEventDto;
import com.atlassian.migration.agent.dto.analytics.TrackAnalyticsEventDto;
import com.atlassian.migration.agent.dto.analytics.UIAnalyticsEventDto;
import com.atlassian.migration.agent.dto.util.PlanDtoUtil;
import com.atlassian.migration.agent.dto.util.UserMigrationType;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.DomainRuleBehaviour;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.ExportType;
import com.atlassian.migration.agent.entity.ImportType;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.UploadDestinationType;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.model.stats.ContentSummary;
import com.atlassian.migration.agent.model.stats.InstanceStats;
import com.atlassian.migration.agent.model.stats.ServerStats;
import com.atlassian.migration.agent.model.stats.SpaceStats;
import com.atlassian.migration.agent.model.stats.UsersGroupsStats;
import com.atlassian.migration.agent.service.MigrationErrorCode;
import com.atlassian.migration.agent.service.MigrationMetric;
import com.atlassian.migration.agent.service.NetworkStatisticsService;
import com.atlassian.migration.agent.service.SpaceAttachmentCount;
import com.atlassian.migration.agent.service.SpaceConflict;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.UploadState;
import com.atlassian.migration.agent.service.analytics.AnalyticsMessageHandler;
import com.atlassian.migration.agent.service.analytics.ErrorEvent;
import com.atlassian.migration.agent.service.analytics.FeatureFlagActionSubject;
import com.atlassian.migration.agent.service.analytics.ProgressStatus;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.network.NetworkCheckResult;
import com.atlassian.migration.agent.service.impl.MigrationTimeEstimationUtils;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.migration.app.dto.check.CheckDetail;
import com.atlassian.migration.app.dto.check.CheckStatus;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.sal.api.license.LicenseHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class AnalyticsEventBuilder {
    private static final EnumSet<DirectoryType> LDAP_DIRECTORY_TYPES = EnumSet.of(DirectoryType.CONNECTOR, DirectoryType.DELEGATING, DirectoryType.CUSTOM);
    private static final String CONTAINER_TYPE_KEY = "containerType";
    private static final String CONFLUENCE_SPACE = "CONFLUENCE_SPACE";
    private static final String COMPONENT_KEY = "component";
    private static final String PHASE_KEY = "phase";
    private static final String OPERATION_KEY = "operationKey";
    private static final String SPACE_COMPONENT = "Space";
    private static final Logger log = ContextLoggerFactory.getLogger(AnalyticsEventBuilder.class);
    private static final Map<String, String> mediaUploadEventAttributesMap = ImmutableMap.of((Object)"containerType", (Object)"CONFLUENCE_SPACE", (Object)"component", (Object)"Media", (Object)"phase", (Object)"Upload", (Object)"operationKey", (Object)"confluenceAttachmentUpload");
    private static final Map<String, String> spaceImportEventAttributesMap = ImmutableMap.of((Object)"containerType", (Object)"CONFLUENCE_SPACE", (Object)"component", (Object)"Space", (Object)"phase", (Object)"Import", (Object)"operationKey", (Object)"confluenceImport");
    private static final Map<String, String> spaceExportEventAttributesMap = ImmutableMap.of((Object)"containerType", (Object)"CONFLUENCE_SPACE", (Object)"component", (Object)"Space", (Object)"phase", (Object)"Export", (Object)"operationKey", (Object)"confluenceSpaceUpload");
    private static final Map<String, String> userImportEventAttributesMap = ImmutableMap.of((Object)"containerType", (Object)"SITE", (Object)"component", (Object)"User", (Object)"phase", (Object)"Import", (Object)"operationKey", (Object)"allUserImport");
    private static final Map<String, String> userExportEventAttributesMap = ImmutableMap.of((Object)"containerType", (Object)"SITE", (Object)"component", (Object)"User", (Object)"phase", (Object)"Export", (Object)"operationKey", (Object)"allUserExport");
    private static final Map<String, Map<String, String>> stepCompletionEventAttributesMap = AnalyticsEventBuilder.populateStepCompletionEventAttributesMap();
    private static final String STOPPED = "stopped";
    private static final String RESULT = "result";
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    private static final String PRODUCT = "product";
    private static final String VERSION = "version";
    private static final String IS_INTERNAL_SEN = "isInternalSen";
    private static final String PLUGIN_VERSION = "pluginVersion";
    private static final String REASON = "reason";
    private static final String CONFIGURED_HEAP_SIZE = "configuredHeapSize";
    private static final String FREE_HEAP_SIZE = "freeHeapSize";
    private static final String USED_HEAP_SIZE = "usedHeapSize";
    private static final String ERROR_CODES = "errorCodes";
    private static final String ESTIMATED_TIME = "estimatedTime";
    private static final String TOTAL_ATTACHMENTS_SIZE = "totalAttachmentsSize";
    private static final String STATUS = "status";
    private static final String EXECUTED = "executed";
    private static final String CHECK_SCREEN = "checkScreen";
    private static final String NUMBER_OF_APPS = "numberOfApps";
    private static final String NUMBER_OF_SPACES = "numberOfSpaces";
    private static final String MIGRATION = "migration";
    private static final String MIGRATION_ID = "migrationId";
    private static final String MIGRATION_TAG = "migrationTag";
    private static final String TENANT_ID = "tenantId";
    private static final String TIME_TAKEN = "timeTaken";
    private static final String SPACE_EXPORT_TYPE = "spaceExportType";
    private static final String SPACE_IMPORT_TYPE = "spaceImportType";
    private static final String SPACE_EXPORT_ACTION_NAME = "exportedAndPostProcessed";
    private static final String ATTACHMENT_UPLOAD_ACTION_NAME = "attachmentsUploaded";
    private static final String LOGGED_ACTION_NAME = "logged";
    private static final String XML_TO_CSV_CONVERSION_ACTION_NAME = "xmlToCsvConversion";
    private static final String SPACE_IMPORTED_ACTION_NAME = "spaceImported";
    private static final String EXPORT_POST_PROCESSED_ACTION_NAME = "postProcessed";
    private static final String SPACE_UPLOADED_ACTION_NAME = "spaceUploaded";
    private static final String MCS_FILE_UPLOADED_ACTION_NAME = "fileUploadedToMCS";
    private static final String TABLE_EXPORTED_TO_CSV_ACTION_NAME = "tableExportedToCSV";
    private static final String FEATURE_FLAG_ACTION_ITEM = "featureFlag";
    private static final String UPLOAD_SIZE_ATTRIBUTE_NAME = "uploadSize";
    private static final String UPLOAD_TYPE_ATTRIBUTE_NAME = "uploadDestinationType";
    private static final String FILE_NAME_ATTRIBUTE_NAME = "fileName";
    private static final String TABLE_NAME_ATTRIBUTE_NAME = "tableName";
    private static final String TIME_TO_FIRST_RECORD_ATTRIBUTE_NAME = "timeToFirstRecord";
    private static final String ROWS_EXPORTED_ATTRIBUTE_NAME = "rowsExported";
    private static final String CHARS_EXPORTED_ATTRIBUTE_NAME = "charactersExported";
    private static final String EXPORT_QUERY_HASH_ATTRIBUTE_NAME = "exportQueryHash";
    private static final String ERROR_CODE_ATTRIBUTE_NAME = "errorCode";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String SPACE_UPLOAD_TYPE = "spaceUploadType";
    private static final String DB_TYPE = "dbType";
    private static final String OBJECT_FAILURE_SUBJECT_NAME = "objectFailure";
    private static final String SKIPPED_STEP_SUBJECT_NAME = "skippedStep";
    private static final String FEATURE_FLAG_ATTRIBUTE_NAME = "featureFlagKey";
    private static final String KNOWN_SOURCE = "knownSource";
    private static final String NUMBER_OF_USERS = "numberOfUsers";
    private static final String NUMBER_OF_PAGES = "numberOfPages";
    private static final String NUMBER_OF_BLOGS = "numberOfBlogs";
    private static final String NUMBER_OF_GROUPS = "numberOfGroups";
    private static final String PLAN_ID = "planId";
    private static final String SPACE_ID = "spaceId";
    protected static final String IMPORT_TASK_ID = "importTaskId";
    protected static final String TASK_ID = "taskId";
    protected static final String START_TIME = "startTime";
    protected static final String STOP_TIME = "stopTime";
    protected static final String EXPORT_TYPE = "exportType";
    protected static final String FILE_ID = "fileId";
    protected static final String STEP_TYPE = "stepType";
    protected static final String STEP_ID = "stepId";
    protected static final String TASK_TYPE = "taskType";
    protected static final String CONFLUENCE = "confluence";
    protected static final String CONFLUENCE_PRODUCT_FAMILY = "CONFLUENCE";
    protected static final String MIGRATION_TYPE = "migrationType";
    protected static final String PRODUCT_FAMILY = "productFamily";
    protected static final String S2C_MIGRATION = "S2C_MIGRATION";
    protected static final String CREATED = "created";
    protected static final String STARTED = "started";
    protected static final String COMPLETED = "completed";
    protected static final String STEP = "step";
    protected static final String PLAN = "plan";
    protected static final String SPACE = "space";
    protected static final String PLATFORM_EVENT = "platformEvent";
    protected static final String FAILED = "failed";
    protected static final String NUMBER_OF_FAILED_DOMAINS = "numberOfFailedDomains";
    protected static final String FAILED_DOMAINS_BY_SERVICE_NAME = "failedDomainsByServiceName";
    protected static final String NETWORK_HEALTH_CHECK_EVENT = "networkHealthCheck";
    protected static final String NETWORK_HEALTH_PRE_MIGRATION_CHECK_EVENT = "networkHealthPreMigrationCheck";
    public static final String USER_EXPORT = "USER_EXPORT";
    @VisibleForTesting
    static final String INTERNAL_SEN = "SEN-500";
    private final SENSupplier senSupplier;
    private final Supplier<Instant> instantSupplier;
    private final StatisticsService statisticsService;
    private final SystemInformationService systemInformationService;
    private final PluginMetadataManager pluginMetadataManager;
    private final CrowdDirectoryService crowdDirectoryService;
    private final SpaceManager spaceManager;
    private final PluginVersionManager pluginVersionManager;
    private final ClusterManager clusterManager;
    private final LicenseHandler licenseHandler;

    public AnalyticsEventBuilder(SENSupplier senSupplier, StatisticsService statisticsService, SystemInformationService systemInformationService, PluginMetadataManager pluginMetadataManager, CrowdDirectoryService crowdDirectoryService, SpaceManager spaceManager, PluginVersionManager pluginVersionManager, ClusterManager clusterManager, LicenseHandler licenseHandler) {
        this(senSupplier, Instant::now, statisticsService, systemInformationService, pluginMetadataManager, crowdDirectoryService, spaceManager, pluginVersionManager, clusterManager, licenseHandler);
    }

    @VisibleForTesting
    AnalyticsEventBuilder(SENSupplier senSupplier, Supplier<Instant> instantSupplier, StatisticsService statisticsService, SystemInformationService systemInformationService, PluginMetadataManager pluginMetadataManager, CrowdDirectoryService crowdDirectoryService, SpaceManager spaceManager, PluginVersionManager pluginVersionManager, ClusterManager clusterManager, LicenseHandler licenseHandler) {
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
        this.statisticsService = statisticsService;
        this.systemInformationService = systemInformationService;
        this.pluginMetadataManager = pluginMetadataManager;
        this.crowdDirectoryService = crowdDirectoryService;
        this.spaceManager = spaceManager;
        this.pluginVersionManager = pluginVersionManager;
        this.clusterManager = clusterManager;
        this.licenseHandler = licenseHandler;
    }

    private static Map<String, Map<String, String>> populateStepCompletionEventAttributesMap() {
        HashMap<String, Map<String, String>> stepCompletionEventAttributesMap = new HashMap<String, Map<String, String>>();
        stepCompletionEventAttributesMap.put(StepType.ATTACHMENT_UPLOAD.name(), mediaUploadEventAttributesMap);
        stepCompletionEventAttributesMap.put(StepType.DATA_UPLOAD.name(), spaceExportEventAttributesMap);
        stepCompletionEventAttributesMap.put(StepType.CONFLUENCE_IMPORT.name(), spaceImportEventAttributesMap);
        stepCompletionEventAttributesMap.put(StepType.CONFLUENCE_EXPORT.name(), spaceExportEventAttributesMap);
        stepCompletionEventAttributesMap.put(StepType.USERS_MIGRATION.name(), userImportEventAttributesMap);
        stepCompletionEventAttributesMap.put(USER_EXPORT, userExportEventAttributesMap);
        return stepCompletionEventAttributesMap;
    }

    public EventDto buildUIAnalyticsEvent(UIAnalyticsEventDto eventDto, ConfluenceUser confluenceUser) {
        return ((GenericUiEvent.Builder)((GenericUiEvent.Builder)((GenericUiEvent.Builder)((GenericUiEvent.Builder)((GenericUiEvent.Builder)((GenericUiEvent.Builder)((GenericUiEvent.Builder)new GenericUiEvent.Builder(eventDto.getTimestamp()).email(confluenceUser.getEmail())).sen(this.senSupplier.get())).source(eventDto.getSource())).contextContainer(eventDto.getContainerType(), eventDto.getContainerId())).actionSubject(eventDto.getActionSubject(), eventDto.getActionSubjectId())).action(eventDto.getAction())).withAttributes(this.addPluginVersionInAttributes(eventDto.getAttributes()))).build();
    }

    public EventDto buildScreenAnalyticsEvent(ScreenAnalyticsEventDto eventDto, ConfluenceUser confluenceUser) {
        return ((GenericScreenEvent.Builder)((GenericScreenEvent.Builder)((GenericScreenEvent.Builder)((GenericScreenEvent.Builder)new GenericScreenEvent.Builder(eventDto.getTimestamp()).name(eventDto.getName())).sen(this.senSupplier.get())).email(confluenceUser.getEmail())).withAttributes(this.addPluginVersionInAttributes(eventDto.getAttributes()))).build();
    }

    public EventDto buildCompletedInstanceAnalysisAnalyticsEvent(ServerStats serverStats, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        DatabaseInfo databaseInfo = this.systemInformationService.getDatabaseInfo();
        attributes.put((Object)"database", (Object)ImmutableMap.of((Object)TYPE_ATTRIBUTE_NAME, (Object)databaseInfo.getName(), (Object)VERSION, (Object)databaseInfo.getVersion()));
        long configuredHeapSize = Runtime.getRuntime().maxMemory();
        ConfluenceInfo confluenceInfo = this.systemInformationService.getConfluenceInfo();
        attributes.put((Object)"apps", (Object)confluenceInfo.getEnabledPlugins().stream().filter(arg_0 -> ((PluginMetadataManager)this.pluginMetadataManager).isUserInstalled(arg_0)).map(Plugin::getKey).collect(Collectors.toCollection(LinkedList::new)));
        List directories = this.crowdDirectoryService.findAllDirectories();
        boolean ldap = directories.stream().filter(Directory::isActive).map(Directory::getType).anyMatch(LDAP_DIRECTORY_TYPES::contains);
        attributes.put((Object)"LDAP", (Object)ldap);
        attributes.put((Object)ESTIMATED_TIME, (Object)Long.toString(serverStats.getTotalSpaceMigrationTime().plus(serverStats.getTotalUserGroupMigrationTime()).plus(MigrationTimeEstimationUtils.getBaseMigrationTime()).getSeconds()));
        attributes.put((Object)"bandwidthKBS", (Object)(serverStats.getBandwidthKBS() == NetworkStatisticsService.getUncalculatedBandwidthKBPS() ? "" : Long.toString(serverStats.getBandwidthKBS())));
        InstanceStats instanceStats = serverStats.getInstanceStats();
        attributes.put((Object)VERSION, (Object)instanceStats.getVersion());
        attributes.put((Object)NUMBER_OF_SPACES, (Object)Long.toString(instanceStats.getNumberOfSpaces()));
        attributes.put((Object)NUMBER_OF_USERS, (Object)Long.toString(instanceStats.getNumberOfUsers()));
        attributes.put((Object)NUMBER_OF_GROUPS, (Object)Long.toString(instanceStats.getNumberOfGroups()));
        ContentSummary contentSummary = serverStats.getContentSummary();
        attributes.put((Object)TOTAL_ATTACHMENTS_SIZE, (Object)Long.toString(contentSummary.getAttachments().getTotalSize()));
        attributes.put((Object)NUMBER_OF_PAGES, (Object)Long.toString(contentSummary.getNumberOfPages()));
        attributes.put((Object)NUMBER_OF_BLOGS, (Object)Long.toString(contentSummary.getNumberOfBlogs()));
        ClusterInformation clusterInformation = this.clusterManager.getClusterInformation();
        attributes.put((Object)"clustered", (Object)this.clusterManager.isClustered());
        attributes.put((Object)"numberOfNodes", (Object)Integer.toString(clusterInformation.getMemberCount()));
        attributes.put((Object)CONFIGURED_HEAP_SIZE, (Object)Long.toString(configuredHeapSize));
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).email(confluenceUser.getEmail())).sen(this.senSupplier.get())).action(COMPLETED)).actionSubject("instanceAnalysis")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildCompletedPlanAnalyticsEvent(PlanDto planDto) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        long configuredHeapSize = Runtime.getRuntime().maxMemory();
        long freeHeapSize = Runtime.getRuntime().freeMemory();
        attributes.put((Object)STATUS, (Object)planDto.getProgress().getStatus());
        attributes.put((Object)"numberOfObjects", (Object)Long.toString(planDto.getTasks().size()));
        Map<String, Long> taskCounts = this.getTaskCounts(planDto);
        attributes.putAll(taskCounts);
        Duration userGroupMigrationTime = this.getUserGroupMigrationTime(planDto);
        long spaceMigrationTime = PlanDtoUtil.calculateTotalSpaceTaskDuration(planDto);
        attributes.put((Object)ESTIMATED_TIME, (Object)Long.toString(userGroupMigrationTime.plus(MigrationTimeEstimationUtils.getBaseMigrationTime()).getSeconds() + spaceMigrationTime));
        attributes.put((Object)"actualTime", (Object)Long.toString(PlanDtoUtil.totalElapsedTimeInSeconds(planDto)));
        attributes.put((Object)START_TIME, (Object)planDto.getProgress().getStartTime());
        attributes.put((Object)STOP_TIME, (Object)planDto.getProgress().getEndTime());
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"migrateAllUsers", (Object)(!PlanDtoUtil.hasScopedUserTask(planDto) ? 1 : 0));
        attributes.put((Object)"attachmentsOnly", (Object)PlanDtoUtil.containsAttachmentsOnlyTask(planDto));
        attributes.put((Object)"migrateUserType", (Object)PlanDtoUtil.userMigrationType(planDto).name());
        attributes.put((Object)MIGRATION_ID, (Object)planDto.getMigrationId());
        attributes.put((Object)TENANT_ID, (Object)planDto.getCloudSite().getCloudId());
        attributes.put((Object)CONFIGURED_HEAP_SIZE, (Object)Long.toString(configuredHeapSize));
        attributes.put((Object)FREE_HEAP_SIZE, (Object)Long.toString(freeHeapSize));
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(COMPLETED)).sen(this.senSupplier.get())).actionSubject(PLAN, planDto.getId())).source("monitorScreen")).withAttributes((Map)attributes.build())).build();
    }

    private Map<String, Long> getTaskCounts(PlanDto planDto) {
        return planDto.getTasks().stream().collect(Collectors.groupingBy(task -> String.format("%s%sTaskCount", task.isSuccessful() ? "successful" : FAILED, task.getTaskTypeSingularTitleCase()), Collectors.counting()));
    }

    public EventDto buildPlatformPlanCompletionOperationalEvent(PlanDto planDto, String migrationScopeId, ExecutionStatus status) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)PRODUCT_FAMILY, (Object)CONFLUENCE_PRODUCT_FAMILY);
        attributes.put((Object)MIGRATION_TYPE, (Object)S2C_MIGRATION);
        attributes.put((Object)PLATFORM_EVENT, (Object)true);
        attributes.put((Object)MIGRATION_ID, (Object)planDto.getMigrationId());
        attributes.put((Object)"migrationScopeId", (Object)migrationScopeId);
        HashMap<String, String> sourceLocation = new HashMap<String, String>();
        sourceLocation.put("serverId", this.licenseHandler.getServerId());
        sourceLocation.put("confluenceSen", this.senSupplier.get());
        attributes.put((Object)"sourceLocation", sourceLocation);
        HashMap<String, String> destinationLocation = new HashMap<String, String>();
        destinationLocation.put("cloudId", planDto.getCloudSite().getCloudId());
        attributes.put((Object)"destinationLocation", destinationLocation);
        attributes.put((Object)PLAN_ID, (Object)planDto.getId());
        attributes.put((Object)VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)STATUS, (Object)this.convertToProgressStatus(status).getStatusName());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(COMPLETED)).actionSubject(MIGRATION, planDto.getMigrationId())).contextContainer(MIGRATION, planDto.getMigrationId())).cloudId(planDto.getCloudSite().getCloudId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildUpdatedPlanStatusAnalyticEvent(PlanDto planDto, ProgressDto.Status fromStatus) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"oldStatus", (Object)fromStatus.name());
        attributes.put((Object)"newStatus", (Object)planDto.getProgress().getStatus().name());
        attributes.put((Object)MIGRATION_ID, (Object)planDto.getMigrationId());
        attributes.put((Object)TENANT_ID, (Object)planDto.getCloudSite().getCloudId());
        List<String> spaceKeys = this.getSpaceKeysByPlan(planDto);
        this.feedSpaceStatsCollectionIfPresent(spaceKeys, spaceStatsCollection -> {
            long totalAttachmentsSize = spaceStatsCollection.stream().mapToLong(spaceStat -> spaceStat.getSummary().getAttachments().getTotalSize()).sum();
            attributes.put((Object)TOTAL_ATTACHMENTS_SIZE, (Object)totalAttachmentsSize);
        });
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("updated")).sen(this.senSupplier.get())).actionSubject("planStatus", planDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildStartPlanAnalyticsEvent(PlanDto planDto) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        long configuredHeapSize = Runtime.getRuntime().maxMemory();
        long freeHeapSize = Runtime.getRuntime().freeMemory();
        attributes.put((Object)STATUS, (Object)"RUNNING");
        attributes.put((Object)"numberOfObjects", (Object)Long.toString(planDto.getTasks().size()));
        attributes.put((Object)START_TIME, (Object)planDto.getProgress().getStartTime());
        attributes.put((Object)MIGRATION_ID, (Object)planDto.getMigrationId());
        attributes.put((Object)TENANT_ID, (Object)planDto.getCloudSite().getCloudId());
        UsageInfo usageInfo = this.systemInformationService.getUsageInfo();
        Duration userGroupMigrationTime = MigrationTimeEstimationUtils.estimateTotalUserGroupMigrationTime(usageInfo.getLocalUsers(), usageInfo.getLocalGroups());
        List<String> spaceKeys = this.getSpaceKeysByPlan(planDto);
        this.feedSpaceStatsCollectionIfPresent(spaceKeys, spaceStatsCollection -> {
            long spaceMigrationTime = this.calculateSpaceMigrationTime((Collection<SpaceStats>)spaceStatsCollection);
            attributes.put((Object)ESTIMATED_TIME, (Object)Long.toString(userGroupMigrationTime.getSeconds() + spaceMigrationTime));
        });
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)CONFIGURED_HEAP_SIZE, (Object)Long.toString(configuredHeapSize));
        attributes.put((Object)FREE_HEAP_SIZE, (Object)Long.toString(freeHeapSize));
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(STARTED)).sen(this.senSupplier.get())).actionSubject(PLAN, planDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildUpdatedTaskStatusAnalyticEvent(String planId, String taskId, String type, ProgressDto.Status fromStatus, ProgressDto.Status toStatus, String spaceKey) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"oldStatus", (Object)fromStatus.name());
        attributes.put((Object)"newStatus", (Object)toStatus);
        attributes.put((Object)TYPE_ATTRIBUTE_NAME, (Object)type);
        attributes.put((Object)PLAN_ID, (Object)planId);
        if (StringUtils.isNotEmpty((String)spaceKey)) {
            this.feedSpaceIdIfPresent(spaceKey, spaceId -> attributes.put((Object)SPACE_ID, (Object)Long.toString(spaceId)));
            this.feedSpaceStatsIfPresent(spaceKey, spaceStats -> attributes.put((Object)TOTAL_ATTACHMENTS_SIZE, (Object)spaceStats.getSummary().getAttachments().getTotalSize()));
        }
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("updated")).sen(this.senSupplier.get())).actionSubject("objectStatus", taskId)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildStepSkipAnalyticEvent(Step step, String reason) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)STEP_TYPE, (Object)step.getType());
        attributes.put((Object)STEP_ID, (Object)step.getId());
        attributes.put((Object)REASON, (Object)reason);
        attributes.put((Object)MIGRATION_ID, (Object)step.getPlan().getMigrationId());
        attributes.put((Object)TASK_ID, (Object)step.getTask().getId());
        attributes.put((Object)TASK_TYPE, (Object)step.getTask().getAnalyticsEventType());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(LOGGED_ACTION_NAME)).sen(this.senSupplier.get())).actionSubject(SKIPPED_STEP_SUBJECT_NAME)).cloudId(step.getPlan().getCloudSite().getCloudId())).withAttributes((Map)attributes.build())).build();
    }

    public List<EventDto> buildCreatePlanAndTasksAnalyticsEvents(PlanDto planDto, ConfluenceUser confluenceUser) {
        long now = this.instantSupplier.get().toEpochMilli();
        LongAdder numberOfSpaces = new LongAdder();
        LongAdder estimatedTime = new LongAdder();
        ArrayList<EventDto> analyticsEventModels = new ArrayList<EventDto>();
        String planId = planDto.getId();
        planDto.getTasks().forEach(task -> {
            if (task instanceof ConfluenceSpaceTaskDto) {
                ConfluenceSpaceTaskDto confluenceSpaceTaskDto = (ConfluenceSpaceTaskDto)task;
                this.feedSpaceStatsIfPresent(confluenceSpaceTaskDto.getSpace(), spaceStats -> {
                    numberOfSpaces.increment();
                    long thisEstimatedTime = MigrationTimeEstimationUtils.estimateSpaceMigrationTime(spaceStats.getSummary()).getSeconds();
                    estimatedTime.add(thisEstimatedTime);
                    analyticsEventModels.add(this.buildAddedSpaceAnalyticsEvent(now, planId, confluenceSpaceTaskDto, thisEstimatedTime, (SpaceStats)spaceStats, confluenceUser));
                });
            } else if (task instanceof MigrateUsersTaskDto) {
                MigrateUsersTaskDto migrateUsersTaskDto = (MigrateUsersTaskDto)task;
                List<String> spaceKeys = PlanDtoUtil.getSpaceKeysForScope(planDto);
                UserMigrationType userMigrationType = migrateUsersTaskDto.isScoped() ? UserMigrationType.SCOPED : UserMigrationType.ALL;
                UsersGroupsStats usersStats = this.statisticsService.getUsersGroupsStatistics(userMigrationType, spaceKeys);
                estimatedTime.add(usersStats.getTotalMigrationTime().getSeconds());
                analyticsEventModels.add(this.buildAddedUserGroupsAnalyticsEvent(now, planId, migrateUsersTaskDto, usersStats.getTotalMigrationTime().getSeconds(), usersStats, confluenceUser));
            }
        });
        analyticsEventModels.add(0, this.buildCreatedPlanAnalyticsEvent(now, planDto, numberOfSpaces.longValue(), estimatedTime.longValue(), confluenceUser));
        return analyticsEventModels;
    }

    EventDto buildCreatedPlanAnalyticsEvent(long now, PlanDto planDto, long numberOfSpaces, long estimatedTime, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)STATUS, (Object)planDto.getProgress().getStatus());
        attributes.put((Object)NUMBER_OF_SPACES, (Object)Long.toString(numberOfSpaces));
        attributes.put((Object)ESTIMATED_TIME, (Object)Long.toString(estimatedTime));
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)MIGRATION_TAG, (Object)planDto.getMigrationTag());
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(now).action(CREATED)).sen(this.senSupplier.get())).email(confluenceUser.getEmail())).source("reviewScreen")).actionSubject(PLAN, planDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    EventDto buildAddedSpaceAnalyticsEvent(long now, String planId, ConfluenceSpaceTaskDto confluenceSpaceTaskDto, long estimatedTime, SpaceStats spaceStats, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        this.feedSpaceIdIfPresent(spaceStats.getSpaceKey(), spaceId -> attributes.put((Object)SPACE_ID, (Object)Long.toString(spaceId)));
        attributes.put((Object)PLAN_ID, (Object)planId);
        attributes.put((Object)STATUS, (Object)confluenceSpaceTaskDto.getProgress().getStatus());
        attributes.put((Object)TYPE_ATTRIBUTE_NAME, (Object)"confluence-space");
        attributes.put((Object)ESTIMATED_TIME, (Object)Long.toString(estimatedTime));
        attributes.put((Object)NUMBER_OF_PAGES, (Object)Long.toString(spaceStats.getSummary().getNumberOfPages()));
        attributes.put((Object)NUMBER_OF_BLOGS, (Object)Long.toString(spaceStats.getSummary().getNumberOfBlogs()));
        attributes.put((Object)"numberOfDrafts", (Object)Long.toString(spaceStats.getSummary().getNumberOfDrafts()));
        attributes.put((Object)"numberOfAttachments", (Object)Long.toString(spaceStats.getSummary().getNumberOfAttachments()));
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(now).action("added")).sen(this.senSupplier.get())).email(confluenceUser.getEmail())).source("reviewScreen")).actionSubject("object", confluenceSpaceTaskDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    EventDto buildAddedUserGroupsAnalyticsEvent(long now, String planId, MigrateUsersTaskDto migrateUsersTaskDto, long estimatedTime, UsersGroupsStats usersStats, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)PLAN_ID, (Object)planId);
        attributes.put((Object)STATUS, (Object)migrateUsersTaskDto.getProgress().getStatus());
        attributes.put((Object)TYPE_ATTRIBUTE_NAME, (Object)"users-and-groups");
        attributes.put((Object)ESTIMATED_TIME, (Object)Long.toString(estimatedTime));
        attributes.put((Object)NUMBER_OF_USERS, (Object)Long.toString(usersStats.getNumberOfUsers()));
        attributes.put((Object)NUMBER_OF_GROUPS, (Object)Long.toString(usersStats.getNumberOfGroups()));
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(now).action("added")).sen(this.senSupplier.get())).email(confluenceUser.getEmail())).source("reviewScreen")).actionSubject("object", migrateUsersTaskDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildTrackAnalyticsEvent(TrackAnalyticsEventDto eventDto, PlanDto planDto, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        String action = eventDto.getAction();
        if (STOPPED.equals(action)) {
            attributes.put((Object)STATUS, (Object)planDto.getProgress().getStatus());
            attributes.put((Object)STOP_TIME, (Object)planDto.getProgress().getEndTime());
        }
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(eventDto.getTimestamp()).action(eventDto.getAction())).sen(this.senSupplier.get())).email(confluenceUser.getEmail())).source(eventDto.getSource())).actionSubject(eventDto.getActionSubject(), eventDto.getActionSubjectId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightDuplicateEmails(boolean success, List<EmailDuplicate> duplicateEmails, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        LongAdder numberOfEmails = new LongAdder();
        LongAdder numberOfUsers = new LongAdder();
        duplicateEmails.forEach(duplicateEmail -> {
            numberOfEmails.increment();
            numberOfUsers.add(duplicateEmail.ids.size());
        });
        attributes.put((Object)"numberOfSharedEmails", (Object)Long.toString(numberOfEmails.longValue()));
        attributes.put((Object)NUMBER_OF_USERS, (Object)Long.toString(numberOfUsers.longValue()));
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(EXECUTED)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject("sharedEmailsCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightInvalidEmails(boolean success, List<EmailData> invalidEmails, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfInvalidEmails", (Object)Long.toString(invalidEmails.size()));
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(EXECUTED)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject("invalidEmailsCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightGroupNamesConflict(boolean success, List<String> groups, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)NUMBER_OF_GROUPS, (Object)Long.toString(groups.size()));
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(EXECUTED)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject("cloudExistantGroupsCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightSpaceKeysConflict(boolean success, List<SpaceConflict> conflicts, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)NUMBER_OF_SPACES, (Object)Long.toString(conflicts.size()));
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(EXECUTED)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject("spaceConflictCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightAppOutdated(boolean success, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(EXECUTED)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject("migrationAssistantOutdatedCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightConfluenceSupportedVersionCheck(boolean success, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(EXECUTED)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject(CheckType.CONFLUENCE_SUPPORTED_VERSION.value())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightCloudFreeUsersCheck(boolean success, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(EXECUTED)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject("cloudFreeUsersConflictCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightSpaceAnonymousAccess(boolean success, Integer numberOfSpaces, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)NUMBER_OF_SPACES, (Object)Integer.toString(numberOfSpaces));
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(EXECUTED)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject("spaceAnonymousPermissionCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreFlightContainerTokenExpiration(boolean success, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(EXECUTED)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject("containerTokenExpirationCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightAppAssessmentComplete(boolean success, int apps, long totalTime) {
        return this.buildPreflightAppsDefault("appAssessmentCompleteCheck", success, apps, totalTime);
    }

    public EventDto buildPreflightAppDataConsent(boolean success, int apps, long totalTime) {
        return this.buildPreflightAppsDefault("appDataMigrationConsentCheck", success, apps, totalTime);
    }

    public EventDto buildPreflightAppReliability(boolean success, int apps, long totalTime) {
        return this.buildPreflightAppsDefault("appReliabilityCheck", success, apps, totalTime);
    }

    public EventDto buildPreflightServerAppOutdated(boolean success, int apps, long totalTime) {
        return this.buildPreflightAppsDefault("serverAppOutdatedCheck", success, apps, totalTime);
    }

    public EventDto buildPreflightAppsNotInstalledOnCloud(boolean success, int apps, long totalTime) {
        return this.buildPreflightAppsDefault("appsNotInstalledOnCloudCheck", success, apps, totalTime);
    }

    public EventDto buildPreflightAppLicenseCheck(boolean success, int apps, long totalTime) {
        return this.buildPreflightAppsDefault("appLicenseCheck", success, apps, totalTime);
    }

    public EventDto buildPreflightAppsDefault(String subject, boolean success, int apps, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)NUMBER_OF_APPS, (Object)Integer.toString(apps));
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(EXECUTED)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject(subject)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightAppVendorCheck(CheckResult checkResult, long totalTime) {
        if (Checker.retrieveExecutionErrorCode((CheckResult)checkResult) != null) {
            ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
            attributes.put((Object)"atlassianException", (Object)true);
            this.addCommonAttributesInPreflightCheck(checkResult.success, totalTime, attributes);
            return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(EXECUTED)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject("appVendorCheck")).withAttributes((Map)attributes.build())).build();
        }
        Map appVendorCheckResult = checkResult.details;
        int totalNumberOfApps = appVendorCheckResult.size();
        Set resultDtos = appVendorCheckResult.values().stream().flatMap(checkIdToCheckResultMap -> ((HashMap)checkIdToCheckResultMap).values().stream()).collect(Collectors.toSet());
        int totalChecksExecuted = resultDtos.size();
        int totalFailedChecks = (int)resultDtos.stream().filter(checkResultDto -> checkResultDto.status != CheckStatus.SUCCESS).count();
        List checksWithStatusWarning = resultDtos.stream().filter(checkResultDto -> checkResultDto.status == CheckStatus.WARNING).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List checksWithStatusBlocked = resultDtos.stream().filter(checkResultDto -> checkResultDto.status == CheckStatus.BLOCKING).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List checksWithStatusCheckExecutionError = resultDtos.stream().filter(checkResultDto -> checkResultDto.status == CheckStatus.CHECK_EXECUTION_ERROR).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List unsuccessfulChecksWithCsvContent = resultDtos.stream().filter(checkResultDto -> checkResultDto.showCsv).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List checksWithException = resultDtos.stream().filter(checkResultDto -> checkResultDto.getCheckDetails() != null && checkResultDto.getCheckDetails().contains(CheckDetail.EXCEPTION)).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List checksWithTimeout = resultDtos.stream().filter(checkResultDto -> checkResultDto.getCheckDetails() != null && checkResultDto.getCheckDetails().contains(CheckDetail.TIMEOUT)).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List checksWithCsvTruncation = resultDtos.stream().filter(checkResultDto -> checkResultDto.getCheckDetails() != null && checkResultDto.getCheckDetails().contains(CheckDetail.CSV_TRUNCATED)).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)NUMBER_OF_APPS, (Object)Integer.toString(totalNumberOfApps));
        attributes.put((Object)"numberOfChecksExecuted", (Object)Integer.toString(totalChecksExecuted));
        attributes.put((Object)"numberOfFailedChecks", (Object)Integer.toString(totalFailedChecks));
        attributes.put((Object)"unsuccessfulChecksAsWarning", checksWithStatusWarning);
        attributes.put((Object)"unsuccessfulChecksAsBlocking", checksWithStatusBlocked);
        attributes.put((Object)"unsuccessfulChecksAsCheckExecutionError", checksWithStatusCheckExecutionError);
        attributes.put((Object)"unsuccessfulChecksWithCSVContent", unsuccessfulChecksWithCsvContent);
        attributes.put((Object)"checksWithException", checksWithException);
        attributes.put((Object)"checksWithTimeout", checksWithTimeout);
        attributes.put((Object)"checksWithCsvTruncation", checksWithCsvTruncation);
        this.addCommonAttributesInPreflightCheck(checkResult.success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(EXECUTED)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject("appVendorCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightAppWebhookEndpointCheck(boolean success, int apps, long totalTime) {
        return this.buildPreflightAppsDefault("appWebhookEndpointCheck", success, apps, totalTime);
    }

    public EventDto buildSpaceExportStepTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, Step step, ExportType exportType) {
        return this.buildSpaceExportStepTimerEvent(stepSuccessful, totalTime, spaceKey, step, exportType, Collections.emptyMap());
    }

    public EventDto buildSpaceExportStepTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, Step step, ExportType exportType, Map<String, Object> attributes) {
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        eventAttributes.put(SPACE_EXPORT_TYPE, exportType.name());
        eventAttributes.putAll(attributes);
        return this.buildSpaceStepTimerEvent(stepSuccessful, totalTime, SPACE_EXPORT_ACTION_NAME, spaceKey, step, null, eventAttributes);
    }

    public EventDto buildAttachmentStepTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, Step step) {
        return this.buildSpaceStepTimerEvent(stepSuccessful, totalTime, ATTACHMENT_UPLOAD_ACTION_NAME, spaceKey, step);
    }

    public EventDto buildXMLToCSVConversionTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, Step step) {
        return this.buildSpaceStepTimerEvent(stepSuccessful, totalTime, XML_TO_CSV_CONVERSION_ACTION_NAME, spaceKey, step);
    }

    public EventDto buildSpaceImportTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, Step step) {
        return this.buildSpaceStepTimerEvent(stepSuccessful, totalTime, SPACE_IMPORTED_ACTION_NAME, spaceKey, step);
    }

    public EventDto buildExportPostProcessedTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, String planId, String taskId, Boolean isGDPRReady) {
        return this.buildSpaceStepTimerEvent(stepSuccessful, totalTime, EXPORT_POST_PROCESSED_ACTION_NAME, spaceKey, planId, taskId, isGDPRReady, Collections.emptyMap());
    }

    public EventDto buildSpaceUploadStepTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, Step step, long uploadSize, UploadDestinationType uploadType) {
        return this.buildSpaceStepTimerEvent(stepSuccessful, totalTime, SPACE_UPLOADED_ACTION_NAME, spaceKey, step, (Map<String, Object>)ImmutableMap.of((Object)UPLOAD_SIZE_ATTRIBUTE_NAME, (Object)uploadSize, (Object)UPLOAD_TYPE_ATTRIBUTE_NAME, (Object)uploadType.name()));
    }

    public EventDto buildMCSFileUploadTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, Step step, long uploadSize, String filename) {
        return this.buildSpaceStepTimerEvent(stepSuccessful, totalTime, MCS_FILE_UPLOADED_ACTION_NAME, spaceKey, step, (Map<String, Object>)ImmutableMap.of((Object)UPLOAD_SIZE_ATTRIBUTE_NAME, (Object)uploadSize, (Object)FILE_NAME_ATTRIBUTE_NAME, (Object)filename));
    }

    public EventDto buildTableExportedToCSVTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, String planId, String taskId, String tableName, String query, String dbType, long timeToFirstRecord, long rowsExported, long charactersExported) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(TABLE_NAME_ATTRIBUTE_NAME, tableName);
        attributes.put(TIME_TO_FIRST_RECORD_ATTRIBUTE_NAME, timeToFirstRecord);
        attributes.put(ROWS_EXPORTED_ATTRIBUTE_NAME, rowsExported);
        attributes.put(CHARS_EXPORTED_ATTRIBUTE_NAME, charactersExported);
        attributes.put(EXPORT_QUERY_HASH_ATTRIBUTE_NAME, DigestUtils.sha256Hex((String)query));
        attributes.put(DB_TYPE, dbType);
        return this.buildSpaceStepTimerEvent(stepSuccessful, totalTime, TABLE_EXPORTED_TO_CSV_ACTION_NAME, spaceKey, planId, taskId, null, attributes);
    }

    @VisibleForTesting
    public EventDto buildSpaceStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String spaceKey, Step step) {
        return this.buildSpaceStepTimerEvent(stepSuccessful, totalTime, action, spaceKey, step, null, Collections.emptyMap());
    }

    @VisibleForTesting
    public EventDto buildSpaceStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String spaceKey, Step step, Map<String, Object> additionalAttributes) {
        return this.buildSpaceStepTimerEvent(stepSuccessful, totalTime, action, spaceKey, step, null, additionalAttributes);
    }

    @VisibleForTesting
    public EventDto buildSpaceStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String spaceKey, Step step, Boolean isGDPRReady) {
        return this.buildSpaceStepTimerEvent(stepSuccessful, totalTime, action, spaceKey, step, isGDPRReady, Collections.emptyMap());
    }

    @VisibleForTesting
    public EventDto buildSpaceStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String spaceKey, String planId, String taskId, Boolean isGDPRReady, Map<String, Object> additionalAttributes) {
        ImmutableMap.Builder<String, Object> attributes = this.getSpaceStepTimeEventCommonAttributes(stepSuccessful, totalTime, spaceKey, isGDPRReady, additionalAttributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(action)).sen(this.senSupplier.get())).actionSubject(SPACE, taskId)).withAttributes((Map)attributes.build())).contextContainer(PLAN, planId)).build();
    }

    @VisibleForTesting
    public EventDto buildSpaceStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String spaceKey, Step step, Boolean isGDPRReady, Map<String, Object> additionalAttributes) {
        String planId = step.getPlan().getId();
        String taskId = step.getTask().getId();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(STEP_ID, step.getId());
        attributes.putAll(additionalAttributes);
        return this.buildSpaceStepTimerEvent(stepSuccessful, totalTime, action, spaceKey, planId, taskId, isGDPRReady, attributes);
    }

    private ImmutableMap.Builder<String, Object> getSpaceStepTimeEventCommonAttributes(boolean stepSuccessful, long totalTime, String spaceKey, Boolean isGDPRReady, Map<String, Object> additionalAttributes) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        this.feedSpaceIdIfPresent(spaceKey, spaceId -> attributes.put((Object)SPACE_ID, (Object)Long.toString(spaceId)));
        attributes.put((Object)"stepSuccessful", (Object)stepSuccessful);
        this.feedSpaceStatsIfPresent(spaceKey, spaceStats -> {
            ContentSummary contentSummary = spaceStats.getSummary();
            attributes.put((Object)"numberOfAttachments", (Object)Long.toString(contentSummary.getNumberOfAttachments()));
            attributes.put((Object)TOTAL_ATTACHMENTS_SIZE, (Object)Long.toString(contentSummary.getAttachments().getTotalSize()));
            attributes.put((Object)NUMBER_OF_BLOGS, (Object)Long.toString(contentSummary.getNumberOfBlogs()));
            attributes.put((Object)"numberOfDrafts", (Object)Long.toString(contentSummary.getNumberOfDrafts()));
            attributes.put((Object)NUMBER_OF_PAGES, (Object)Long.toString(contentSummary.getNumberOfPages()));
        });
        attributes.put((Object)TIME_TAKEN, (Object)Long.toString(totalTime));
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        attributes.putAll(additionalAttributes);
        if (isGDPRReady != null) {
            attributes.put((Object)"isGDPRReady", (Object)Boolean.toString(isGDPRReady));
        }
        return attributes;
    }

    public EventDto buildUserDomainCountsFetchedEvent(long timeTaken, long userCount, int domainCount, boolean success) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)SUCCESS, (Object)success);
        attributes.put((Object)"totalUserDomainCount", (Object)domainCount);
        attributes.put((Object)"totalUserCount", (Object)userCount);
        attributes.put((Object)TIME_TAKEN, (Object)Long.toString(timeTaken));
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("fetched")).sen(this.senSupplier.get())).actionSubject("userDomainCounts")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildUserDomainRuleUpdatedEvent(DomainRuleBehaviour rule, boolean success) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)SUCCESS, (Object)success);
        attributes.put((Object)"rule", (Object)String.valueOf((Object)rule));
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("updated")).sen(this.senSupplier.get())).actionSubject("userDomainRule")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildUserDomainRuleDeletedEvent(boolean success) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)SUCCESS, (Object)success);
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("deleted")).sen(this.senSupplier.get())).actionSubject("userDomainRule")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildAllUserDomainRuleDeletedEvent(boolean success, int count) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)SUCCESS, (Object)success);
        attributes.put((Object)"count", (Object)count);
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("deleted-all")).sen(this.senSupplier.get())).actionSubject("userDomainRule")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildUserStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String planId, boolean scoped) {
        return this.buildUserStepTimerEvent(stepSuccessful, totalTime, action, planId, scoped, -1, -1);
    }

    public EventDto buildUserStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String planId, boolean scoped, int userCount, int groupCount) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"stepSuccessful", (Object)stepSuccessful);
        attributes.put((Object)"userCount", (Object)String.valueOf(userCount));
        attributes.put((Object)"groupCount", (Object)String.valueOf(groupCount));
        attributes.put((Object)TIME_TAKEN, (Object)Long.toString(totalTime));
        attributes.put((Object)"scoped", (Object)scoped);
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(action)).sen(this.senSupplier.get())).actionSubject(PLAN, planId)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildAttachmentMigrationEvent(long totalTime, SpaceAttachmentCount spaceAttachmentCount, UploadState uploadState) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"spaceKey", (Object)spaceAttachmentCount.spaceKey);
        attributes.put((Object)"cloudId", (Object)spaceAttachmentCount.cloudId);
        attributes.put((Object)"contentAttachmentCount", (Object)spaceAttachmentCount.contentAttachmentCount);
        attributes.put((Object)"migAttachmentCount", (Object)spaceAttachmentCount.retrievedMigAttachmentCount);
        attributes.put((Object)"unRetrievableMigAttachmentCount", (Object)spaceAttachmentCount.unRetrievableMigAttachmentCount);
        attributes.put((Object)"allAttachmentsMigrated", (Object)spaceAttachmentCount.hasAllAttachmentsMigrated());
        attributes.put((Object)"numOfAttachments", (Object)uploadState.numOfAttachments);
        attributes.put((Object)"numOfUploadedAttachments", (Object)uploadState.numOfUploadedAttachments);
        attributes.put((Object)"numOfFailedAttachments", (Object)uploadState.numOfFailedAttachments);
        attributes.put((Object)"uploadedBytes", (Object)uploadState.uploadedBytes);
        attributes.put((Object)"totalBytes", (Object)uploadState.totalBytes);
        attributes.put((Object)"numOfAttachmentsAlreadyMigrated", (Object)uploadState.numOfAttachmentsAlreadyMigrated);
        attributes.put((Object)TIME_TAKEN, (Object)totalTime);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("migrated")).sen(this.senSupplier.get())).actionSubject("attachmentMigration")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildMetricEventForConfluenceMigration(boolean success) {
        Map<String, String> tagsMap = this.buildCounterMetricCommonTags();
        tagsMap.put(RESULT, success ? SUCCESS : FAIL);
        return ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.MIGRATION_PLAN_COUNT.metricName).tags(tagsMap)).build();
    }

    public EventDto buildPlatformPlanCompletionMetricEvent(ExecutionStatus status) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        Map<String, String> tagsMap = this.buildPlatformCounterMetricCommonTags(status);
        attributes.put((Object)PLATFORM_EVENT, (Object)true);
        tagsMap.put(VERSION, this.pluginVersionManager.getPluginVersion());
        return ((CounterMetricEvent.Builder)((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.MIGRATIONS_OVERALL_SUCCESS_RATE.metricName).withAttributes((Map)attributes.build())).tags(tagsMap)).build();
    }

    public EventDto buildPlatformStepCompletionMetricEvent(String stepKey, ExecutionStatus status) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        Map<String, String> tagsMap = this.buildPlatformCounterMetricCommonTags(status);
        attributes.put((Object)PLATFORM_EVENT, (Object)true);
        tagsMap.put(COMPONENT_KEY, stepCompletionEventAttributesMap.get(stepKey).get(COMPONENT_KEY));
        tagsMap.put(PHASE_KEY, stepCompletionEventAttributesMap.get(stepKey).get(PHASE_KEY));
        return ((CounterMetricEvent.Builder)((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.MIGRATIONS_COMPONENT_LEVEL_SUCCESS_RATE.metricName).withAttributes((Map)attributes.build())).tags(tagsMap)).build();
    }

    public EventDto buildPlatformStepCompletionExtendedMetricEvent(String stepKey, ExecutionStatus status) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        Map<String, String> tagsMap = this.buildPlatformCounterMetricCommonTags(status);
        attributes.put((Object)PLATFORM_EVENT, (Object)true);
        tagsMap.put(PHASE_KEY, stepCompletionEventAttributesMap.get(stepKey).get(PHASE_KEY));
        tagsMap.put(VERSION, this.pluginVersionManager.getPluginVersion());
        String component = stepCompletionEventAttributesMap.get(stepKey).get(COMPONENT_KEY);
        String metricName = MigrationMetric.MIGRATIONS_COMPONENT_LEVEL_SUCCESS_RATE.metricName + "." + component.toLowerCase();
        return ((CounterMetricEvent.Builder)((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(metricName).withAttributes((Map)attributes.build())).tags(tagsMap)).build();
    }

    public EventDto buildFailedSpaceMigration(StepType stepType, MigrationErrorCode migrationErrorCode) {
        Map<String, String> tagsMap = this.buildCounterMetricCommonTags();
        tagsMap.put(STEP, stepType.name());
        if (migrationErrorCode.shouldBeTreatedAsGoodEventInReliabilitySlo()) {
            tagsMap.put(RESULT, SUCCESS);
            return ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.SPACE_MIGRATION_COUNT.metricName).tags(tagsMap)).build();
        }
        tagsMap.put(RESULT, FAIL);
        tagsMap.put("error_code", String.valueOf(migrationErrorCode.getCode()));
        return ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.SPACE_MIGRATION_COUNT.metricName).tags(tagsMap)).build();
    }

    public EventDto buildMigrationStepMetrics(StepType stepType, boolean success) {
        Map<String, String> tagsMap = this.buildCounterMetricCommonTags();
        tagsMap.put(STEP, stepType.name());
        tagsMap.put(RESULT, success ? SUCCESS : FAIL);
        return ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.MIGRATION_STEP.getMetricName()).tags(tagsMap)).build();
    }

    public EventDto buildExportStepCounterEvent(ExportType exportType, boolean success) {
        Map<String, String> tagsMap = this.buildCounterMetricCommonTags();
        tagsMap.put(STEP, StepType.CONFLUENCE_EXPORT.name());
        tagsMap.put(RESULT, success ? SUCCESS : FAIL);
        tagsMap.put(SPACE_EXPORT_TYPE, exportType.name());
        return ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.MIGRATION_STEP.getMetricName()).tags(tagsMap)).build();
    }

    public EventDto buildImportStepCounterEvent(ImportType importType, boolean success) {
        Map<String, String> tagsMap = this.buildCounterMetricCommonTags();
        tagsMap.put(STEP, StepType.CONFLUENCE_IMPORT.name());
        tagsMap.put(RESULT, success ? SUCCESS : FAIL);
        tagsMap.put(SPACE_IMPORT_TYPE, importType.name());
        return ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.MIGRATION_STEP.getMetricName()).tags(tagsMap)).build();
    }

    public EventDto buildUploadStepCounterEvent(UploadDestinationType uploadDestinationType, boolean success) {
        Map<String, String> tagsMap = this.buildCounterMetricCommonTags();
        tagsMap.put(STEP, StepType.DATA_UPLOAD.name());
        tagsMap.put(RESULT, success ? SUCCESS : FAIL);
        tagsMap.put(UPLOAD_TYPE_ATTRIBUTE_NAME, uploadDestinationType.name());
        return ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.MIGRATION_STEP.getMetricName()).tags(tagsMap)).build();
    }

    public EventDto buildSuccessfulSpaceMigration() {
        Map<String, String> tagsMap = this.buildCounterMetricCommonTags();
        tagsMap.put(RESULT, SUCCESS);
        return ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.SPACE_MIGRATION_COUNT.metricName).tags(tagsMap)).build();
    }

    public EventDto buildFailedUserMigration(List<Integer> errorCodes, boolean isSloGoodEvent) {
        if (isSloGoodEvent) {
            return this.buildSuccessfulUserMigration();
        }
        Map<String, String> tagsMap = this.buildCounterMetricCommonTags();
        tagsMap.put(RESULT, FAIL);
        tagsMap.put(ERROR_CODES, errorCodes.stream().map(Object::toString).collect(Collectors.joining(",")));
        return ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.USERS_MIGRATION_COUNT.metricName).tags(tagsMap)).build();
    }

    public EventDto buildSuccessfulUserMigration() {
        Map<String, String> tagsMap = this.buildCounterMetricCommonTags();
        tagsMap.put(RESULT, SUCCESS);
        return ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.USERS_MIGRATION_COUNT.metricName).tags(tagsMap)).build();
    }

    @Deprecated
    public EventDto buildMigrationErrorMetric(MigrationErrorCode migrationErrorCode) {
        Map<String, String> tagsMap = this.buildCounterMetricCommonTags();
        tagsMap.put("error_code", String.valueOf(migrationErrorCode.getCode()));
        return ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.MIGRATION_ERRORS.metricName).tags(tagsMap)).build();
    }

    private void addCommonAttributesInPreflightCheck(boolean success, long totalTime, ImmutableMap.Builder<String, Object> attributes) {
        attributes.put((Object)SUCCESS, (Object)success);
        attributes.put((Object)"totalTime", (Object)String.format(Locale.US, "%.1f", (double)totalTime / 1000.0));
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
    }

    public EventDto buildPreflightFailed(String actionSubject, String executionId, int executionErrorCode) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"executionErrorCode", (Object)executionErrorCode);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(FAILED)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject(actionSubject)).contextContainer("preflightCheck", executionId)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightMissingAttachments(boolean success, int size, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfMissingAttachments", (Object)size);
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(EXECUTED)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject("missingAttachmentsCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightTrustedDomain(boolean success, long totalTime) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        this.addCommonAttributesInPreflightCheck(success, totalTime, (ImmutableMap.Builder<String, Object>)attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(EXECUTED)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject("trustedDomainCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildMigrationLogTimerEvent(boolean success, long totalTime, String action, String migrationId) {
        return this.buildMigrationLogTimerEvent(success, totalTime, action, migrationId, null, Optional.empty(), Optional.empty());
    }

    public EventDto buildMigrationLogTimerEvent(boolean success, long totalTime, String action, String migrationId, Optional<String> errorReason) {
        return this.buildMigrationLogTimerEvent(success, totalTime, action, migrationId, null, errorReason, Optional.empty());
    }

    public EventDto buildMigrationLogTimerEvent(boolean success, long totalTime, String action, String migrationId, String cloudId, Optional<String> reason, Optional<String> fileName) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)SUCCESS, (Object)success);
        attributes.put((Object)TIME_TAKEN, (Object)Long.toString(totalTime));
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        if (StringUtils.isNotEmpty((String)cloudId)) {
            attributes.put((Object)TENANT_ID, (Object)cloudId);
        }
        if (reason.isPresent()) {
            attributes.put((Object)REASON, (Object)reason.get());
        }
        if (fileName.isPresent()) {
            attributes.put((Object)FILE_NAME_ATTRIBUTE_NAME, (Object)fileName.get());
        }
        ConfluenceInfo confluenceInfo = this.systemInformationService.getConfluenceInfo();
        attributes.put((Object)"confluenceVersion", (Object)confluenceInfo.getVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(action)).sen(this.senSupplier.get())).actionSubject(MIGRATION, migrationId)).withAttributes((Map)attributes.build())).build();
    }

    private List<String> getSpaceKeysByPlan(PlanDto planDto) {
        return planDto.getTasks().stream().filter(ConfluenceSpaceTaskDto.class::isInstance).map(taskDto -> ((ConfluenceSpaceTaskDto)taskDto).getSpace()).collect(Collectors.toList());
    }

    private long calculateSpaceMigrationTime(Collection<SpaceStats> spaceStatsCollection) {
        List<ContentSummary> spaceSummaries = spaceStatsCollection.stream().map(SpaceStats::getSummary).collect(Collectors.toList());
        return MigrationTimeEstimationUtils.estimateTotalSpaceMigrationTime(spaceSummaries).getSeconds();
    }

    private Map<String, Object> addPluginVersionInAttributes(Map<String, Object> attributes) {
        HashMap<String, Object> map = new HashMap<String, Object>(attributes);
        map.put(PLUGIN_VERSION, this.pluginVersionManager.getPluginVersion());
        return map;
    }

    private Duration getUserGroupMigrationTime(PlanDto planDto) {
        if (PlanDtoUtil.containsUsersGroupsTask(planDto)) {
            return this.getUserGroupMigrationTimeWithUserTask(planDto);
        }
        return Duration.ZERO;
    }

    private Duration getUserGroupMigrationTimeWithUserTask(PlanDto planDto) {
        if (PlanDtoUtil.hasScopedUserTask(planDto)) {
            UsersGroupsStats stats = this.statisticsService.getUsersGroupsStatistics(PlanDtoUtil.userMigrationType(planDto), PlanDtoUtil.getSpaceKeys(planDto));
            return MigrationTimeEstimationUtils.estimateTotalUserGroupMigrationTime(stats.getNumberOfUsers(), stats.getNumberOfGroups());
        }
        UsageInfo usageInfo = this.systemInformationService.getUsageInfo();
        return MigrationTimeEstimationUtils.estimateTotalUserGroupMigrationTime(usageInfo.getLocalUsers(), usageInfo.getLocalGroups());
    }

    public EventDto buildErrorOperationalEventForSpaceExport(ErrorEvent errorEvent, ExportType exportType) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)SPACE_EXPORT_TYPE, (Object)exportType);
        return this.buildErrorOperationalEvent(errorEvent, attributes);
    }

    public EventDto buildErrorOperationalEventForSpaceImport(ErrorEvent errorEvent, ImportType importType, String importTaskId) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)SPACE_IMPORT_TYPE, (Object)importType);
        attributes.put((Object)IMPORT_TASK_ID, (Object)importTaskId);
        return this.buildErrorOperationalEvent(errorEvent, attributes);
    }

    public EventDto buildErrorOperationalEventForSpaceUpload(ErrorEvent errorEvent, UploadDestinationType uploadDestinationType) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)SPACE_UPLOAD_TYPE, (Object)uploadDestinationType);
        return this.buildErrorOperationalEvent(errorEvent, attributes);
    }

    public EventDto buildErrorOperationalEventForUsersMigration(ErrorEvent errorEvent, Optional<String> importTaskId) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        if (importTaskId.isPresent()) {
            attributes.put((Object)IMPORT_TASK_ID, (Object)importTaskId.get());
        }
        return this.buildErrorOperationalEvent(errorEvent, attributes);
    }

    public EventDto buildErrorOperationalEvent(ErrorEvent errorEvent, ImmutableMap.Builder<String, Object> initialAttributes) {
        if (initialAttributes == null) {
            initialAttributes = this.getBuilderWithCommonAttributes();
        }
        ImmutableMap.Builder finalAttributes = new ImmutableMap.Builder();
        DatabaseInfo databaseInfo = this.systemInformationService.getDatabaseInfo();
        finalAttributes.putAll((Map)initialAttributes.build());
        long configuredHeapSize = Runtime.getRuntime().maxMemory();
        finalAttributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        finalAttributes.put((Object)ERROR_CODE_ATTRIBUTE_NAME, (Object)errorEvent.getErrorCode().getCode());
        finalAttributes.put((Object)REASON, (Object)AnalyticsMessageHandler.messageHandler(errorEvent.getReason()));
        finalAttributes.put((Object)CONFIGURED_HEAP_SIZE, (Object)Long.toString(configuredHeapSize));
        finalAttributes.put((Object)TYPE_ATTRIBUTE_NAME, (Object)errorEvent.getType().name());
        finalAttributes.put((Object)"database", (Object)ImmutableMap.of((Object)TYPE_ATTRIBUTE_NAME, (Object)databaseInfo.getName(), (Object)VERSION, (Object)databaseInfo.getVersion()));
        this.feedSpaceIdIfPresent(errorEvent.getSpaceKey(), spaceId -> finalAttributes.put((Object)SPACE_ID, (Object)Long.toString(spaceId)));
        ConfluenceInfo confluenceInfo = this.systemInformationService.getConfluenceInfo();
        finalAttributes.put((Object)"confluenceVersion", (Object)confluenceInfo.getVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(LOGGED_ACTION_NAME)).sen(this.senSupplier.get())).source(KNOWN_SOURCE)).cloudId(errorEvent.getCloudId())).actionSubject(OBJECT_FAILURE_SUBJECT_NAME)).contextContainer(errorEvent.getContainerType().getName(), errorEvent.getContainerId())).withAttributes((Map)finalAttributes.build())).build();
    }

    public EventDto buildFeatureFlagsOperationalEvent(String enabledMigrationFeatures, FeatureFlagActionSubject actionSubject, String actionSubjectId) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)PLUGIN_VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)FEATURE_FLAG_ATTRIBUTE_NAME, (Object)enabledMigrationFeatures);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(FEATURE_FLAG_ACTION_ITEM)).sen(this.senSupplier.get())).actionSubject(actionSubject.getValue(), actionSubjectId)).withAttributes((Map)attributes.build())).build();
    }

    private Map<String, String> buildCounterMetricCommonTags() {
        HashMap<String, String> commonTagsMap = new HashMap<String, String>();
        commonTagsMap.put(PRODUCT_FAMILY, CONFLUENCE);
        commonTagsMap.put(MIGRATION_TYPE, S2C_MIGRATION);
        commonTagsMap.put(PRODUCT, CONFLUENCE);
        commonTagsMap.put(VERSION, this.pluginVersionManager.getPluginVersion());
        commonTagsMap.put(IS_INTERNAL_SEN, this.isInternalSen());
        return commonTagsMap;
    }

    private Map<String, String> buildPlatformCounterMetricCommonTags(ExecutionStatus status) {
        HashMap<String, String> commonTagsMap = new HashMap<String, String>();
        commonTagsMap.put(STATUS, this.convertToProgressStatus(status).getStatusName());
        commonTagsMap.put(IS_INTERNAL_SEN, this.isInternalSen());
        return commonTagsMap;
    }

    public EventDto buildCreatedStepAnalyticsEvent(Step step) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderStepAnalyticsEvent(step, this.instantSupplier.get().toEpochMilli());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(CREATED)).sen(this.senSupplier.get())).actionSubject(STEP, step.getId())).contextContainer(PLAN, step.getPlan().getId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildCompletedStepAnalyticsEvent(Step step) {
        return this.buildCompletedStepAnalyticsEvent(step, Collections::emptyMap);
    }

    public EventDto buildCompletedStepAnalyticsEvent(Step step, Supplier<Map<String, String>> additionalAttributes) {
        long startTime = this.instantSupplier.get().toEpochMilli();
        Optional<Instant> optionalStartTime = step.getProgress().getStartTime();
        if (optionalStartTime.isPresent()) {
            startTime = optionalStartTime.get().toEpochMilli();
        }
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderStepAnalyticsEvent(step, startTime);
        attributes.put((Object)STATUS, (Object)step.getProgress().getStatus());
        attributes.put((Object)STOP_TIME, (Object)this.instantSupplier.get().toEpochMilli());
        additionalAttributes.get().entrySet().stream().forEach(entry -> attributes.put(entry.getKey(), entry.getValue()));
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(COMPLETED)).sen(this.senSupplier.get())).actionSubject(STEP, step.getId())).contextContainer(PLAN, step.getPlan().getId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildStepLevelHeapSizeAnalyticsEvent(Step step, long freeHeapSizeAtStart, int executorConcurrency) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        long configuredHeapSize = Runtime.getRuntime().maxMemory();
        long freeHeapSize = Runtime.getRuntime().freeMemory();
        attributes.put((Object)STEP_TYPE, (Object)step.getType());
        attributes.put((Object)MIGRATION_ID, (Object)step.getPlan().getMigrationId());
        attributes.put((Object)TASK_ID, (Object)step.getTask().getId());
        attributes.put((Object)CONFIGURED_HEAP_SIZE, (Object)Long.toString(configuredHeapSize));
        attributes.put((Object)USED_HEAP_SIZE, (Object)Long.toString(freeHeapSizeAtStart - freeHeapSize));
        attributes.put((Object)"executorConcurrency", (Object)Integer.toString(executorConcurrency));
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("fetched")).sen(this.senSupplier.get())).actionSubject("stepHeapSizeAnalytics", step.getId())).contextContainer(PLAN, step.getPlan().getId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildSpaceExportStartEvent(Step step, ExportType exportType, long spaceId, long startTime) {
        GenericOperationalEvent.Builder stepBuilder = this.getBuilderStartedEvent(step, startTime);
        stepBuilder.addAttribute(EXPORT_TYPE, (Object)exportType.name());
        stepBuilder.addAttribute(SPACE, (Object)spaceId);
        return stepBuilder.build();
    }

    public EventDto buildPlatformStepCompletionOperationalEvent(Step step, ExecutionStatus status) {
        String spaceKey;
        Space space;
        Plan plan = step.getPlan();
        boolean confluenceSpaceTask = step.getTask() instanceof ConfluenceSpaceTask;
        String stepType = step.getType();
        Optional<String> containerId = Optional.empty();
        String migrationId = plan.getMigrationId();
        if (confluenceSpaceTask && (space = this.spaceManager.getSpace(spaceKey = ((ConfluenceSpaceTask)step.getTask()).getSpaceKey())) != null) {
            containerId = Optional.of(String.valueOf(space.getId()));
        }
        String stepId = step.getId();
        String migrationScopeId = plan.getMigrationScopeId();
        String planId = plan.getId();
        String cloudId = plan.getCloudSite().getCloudId();
        return this.buildPlatformStepCompletionOperationalEventUtil(new MigrationDetailsDto(migrationId, migrationScopeId, planId, cloudId, stepId), containerId, stepType, status);
    }

    public EventDto buildPlatformStepCompletionOperationalEventUtil(MigrationDetailsDto migrationDetailsDto, Optional<String> containerId, String stepType, ExecutionStatus status) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)PRODUCT_FAMILY, (Object)CONFLUENCE_PRODUCT_FAMILY);
        attributes.put((Object)MIGRATION_TYPE, (Object)S2C_MIGRATION);
        attributes.put((Object)PLATFORM_EVENT, (Object)true);
        attributes.put((Object)MIGRATION_ID, (Object)migrationDetailsDto.getMigrationId());
        if (containerId.isPresent()) {
            attributes.put((Object)"containerId", (Object)containerId.get());
        }
        attributes.put((Object)STEP_TYPE, (Object)stepType);
        attributes.put((Object)CONTAINER_TYPE_KEY, (Object)stepCompletionEventAttributesMap.get(stepType).get(CONTAINER_TYPE_KEY));
        attributes.put((Object)"transferId", (Object)migrationDetailsDto.getStepId());
        attributes.put((Object)"migrationScopeId", (Object)migrationDetailsDto.getMigrationScopeId());
        attributes.put((Object)PLAN_ID, (Object)migrationDetailsDto.getPlanId());
        attributes.put((Object)VERSION, (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)OPERATION_KEY, (Object)stepCompletionEventAttributesMap.get(stepType).get(OPERATION_KEY));
        attributes.put((Object)COMPONENT_KEY, (Object)stepCompletionEventAttributesMap.get(stepType).get(COMPONENT_KEY));
        attributes.put((Object)PHASE_KEY, (Object)stepCompletionEventAttributesMap.get(stepType).get(PHASE_KEY));
        attributes.put((Object)STATUS, (Object)this.convertToProgressStatus(status).getStatusName());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(COMPLETED)).actionSubject("transfer", migrationDetailsDto.getStepId())).contextContainer(MIGRATION, migrationDetailsDto.getMigrationId())).cloudId(migrationDetailsDto.getCloudId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildSpaceImportStartEvent(Step step, long startTime) {
        GenericOperationalEvent.Builder stepBuilder = this.getBuilderStartedEvent(step, startTime);
        return stepBuilder.build();
    }

    public EventDto buildAttachmentMigrationStartEvent(Step step, long startTime, int batchSize, long totalCountOfAttachments, long totalSizeOfAttachments) {
        GenericOperationalEvent.Builder stepBuilder = this.getBuilderStartedEvent(step, startTime);
        stepBuilder.addAttribute("batchSize", (Object)batchSize);
        stepBuilder.addAttribute("totalCountOfAttachments", (Object)totalCountOfAttachments);
        stepBuilder.addAttribute("totalSizeOfAttachments", (Object)totalSizeOfAttachments);
        return stepBuilder.build();
    }

    public EventDto buildUserMigrationStartEvent(Step step, long startTime) {
        GenericOperationalEvent.Builder stepBuilder = this.getBuilderStartedEvent(step, startTime);
        return stepBuilder.build();
    }

    public EventDto buildSpaceUploadStartEvent(Step step, long startTime, UploadDestinationType uploadType, String fileId, String spaceKey) {
        GenericOperationalEvent.Builder stepBuilder = this.getBuilderStartedEvent(step, startTime);
        this.feedSpaceIdIfPresent(spaceKey, spaceId -> {
            GenericOperationalEvent.Builder cfr_ignored_0 = (GenericOperationalEvent.Builder)stepBuilder.addAttribute(SPACE, (Object)spaceId);
        });
        stepBuilder.addAttribute(FILE_ID, (Object)fileId);
        stepBuilder.addAttribute("uploadType", (Object)uploadType.name());
        return stepBuilder.build();
    }

    public EventDto buildPreflightNetworkHealth(boolean success, List<NetworkCheckResult> networkCheckResults, long totalTime) {
        return this.buildPreflightNetworkHealthEvent(success, networkCheckResults, totalTime, EXECUTED, NETWORK_HEALTH_CHECK_EVENT);
    }

    public EventDto buildPreMigrationPreflightNetworkHealth(boolean success, List<NetworkCheckResult> networkCheckResults, long totalTime) {
        String action = success ? EXECUTED : FAILED;
        return this.buildPreflightNetworkHealthEvent(success, networkCheckResults, totalTime, action, NETWORK_HEALTH_PRE_MIGRATION_CHECK_EVENT);
    }

    @NotNull
    private GenericOperationalEvent buildPreflightNetworkHealthEvent(boolean success, List<NetworkCheckResult> networkCheckResults, long totalTime, String action, String actionSubject) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)NUMBER_OF_FAILED_DOMAINS, (Object)Long.toString(networkCheckResults.size()));
        Map<String, List> failedUrlsByServiceNameMap = networkCheckResults.stream().collect(Collectors.toMap(NetworkCheckResult::getName, NetworkCheckResult::getFailedDomains));
        attributes.put((Object)FAILED_DOMAINS_BY_SERVICE_NAME, failedUrlsByServiceNameMap);
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(action)).sen(this.senSupplier.get())).source(CHECK_SCREEN)).actionSubject(actionSubject)).withAttributes((Map)attributes.build())).build();
    }

    private GenericOperationalEvent.Builder getBuilderStartedEvent(Step step, long startTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderStepAnalyticsEvent(step, startTime);
        return (GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(STARTED)).sen(this.senSupplier.get())).actionSubject(STEP, step.getId())).contextContainer(PLAN, step.getPlan().getId())).withAttributes((Map)attributes.build());
    }

    private ImmutableMap.Builder<String, Object> getBuilderStepAnalyticsEvent(Step step, long startTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)STEP_TYPE, (Object)step.getType());
        attributes.put((Object)TASK_ID, (Object)step.getTask().getId());
        attributes.put((Object)MIGRATION_ID, (Object)step.getPlan().getMigrationId());
        attributes.put((Object)START_TIME, (Object)startTime);
        return attributes;
    }

    private ImmutableMap.Builder<String, Object> getBuilderWithCommonAttributes() {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)PRODUCT_FAMILY, (Object)CONFLUENCE);
        attributes.put((Object)MIGRATION_TYPE, (Object)S2C_MIGRATION);
        return attributes;
    }

    private ProgressStatus convertToProgressStatus(ExecutionStatus execStatus) {
        switch (execStatus) {
            case DONE: {
                return ProgressStatus.SUCCESS;
            }
            case FAILED: {
                return ProgressStatus.FAILED;
            }
            case STOPPED: {
                return ProgressStatus.CANCELLED;
            }
            case INCOMPLETE: 
            case CREATED: 
            case VALIDATING: 
            case RUNNING: 
            case STOPPING: {
                return ProgressStatus.INCOMPLETE;
            }
        }
        throw new IllegalArgumentException("Unknown execution status " + execStatus.name());
    }

    private String isInternalSen() {
        String sen = this.senSupplier.get();
        return Boolean.toString(StringUtils.isEmpty((String)sen) || sen.equals(INTERNAL_SEN));
    }

    private void feedSpaceIdIfPresent(String spaceKey, LongConsumer spaceIdConsumer) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (Objects.nonNull(space)) {
            spaceIdConsumer.accept(space.getId());
        }
    }

    private void feedSpaceStatsIfPresent(String spaceKey, Consumer<SpaceStats> spaceStatsConsumer) {
        try {
            SpaceStats spaceStats = this.statisticsService.loadSpaceStatistics(spaceKey);
            if (Objects.nonNull(spaceStats)) {
                spaceStatsConsumer.accept(spaceStats);
            }
        }
        catch (Exception e) {
            log.error("Unable to retrieve space stats: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void feedSpaceStatsCollectionIfPresent(List<String> spaceKeys, Consumer<Collection<SpaceStats>> spaceStatsCollectionConsumer) {
        try {
            Collection<SpaceStats> spaceStatsCollection = this.statisticsService.loadSpaceStatistics(spaceKeys);
            if (Objects.nonNull(spaceStatsCollection)) {
                spaceStatsCollectionConsumer.accept(spaceStatsCollection);
            }
        }
        catch (Exception e) {
            log.error("Unable to retrieve space stats collections: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

