/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.app.AppAssessmentInfoService;
import com.atlassian.migration.agent.service.stepexecutor.space.PostprocessingIOUtil;
import com.atlassian.migration.agent.service.stepexecutor.space.XMLEventUtil;
import com.atlassian.migration.agent.service.stepexecutor.space.helper.XMLHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.jodah.failsafe.function.CheckedFunction;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class SpaceExportCustomContentEntityPostProcessor {
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceExportCustomContentEntityPostProcessor.class);
    private static final String ENTITIES_XML_ZIP_ENTRY_NAME = "entities.xml";
    private static final String CUSTOM_CONTENT_ENTITY_OBJECT_CLASS = "CustomContentEntityObject";
    private static final String PLUGIN_MODULE_KEY_ATTRIBUTE_VALUE = "pluginModuleKey";
    private final XMLInputFactory inputFactory = XMLInputFactory.newFactory();
    private final XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
    private final XMLEventFactory eventFactory = XMLEventFactory.newFactory();
    private final XMLHelper xmlHelper;

    public SpaceExportCustomContentEntityPostProcessor(AppAssessmentInfoService appAssessmentInfoService, XMLHelper xmlHelper) {
        this.inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.xmlHelper = xmlHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void postprocess(Path exportFile, List<String> excludedAppKeys) {
        Path modifiedExportFile = null;
        modifiedExportFile = Files.createTempFile(exportFile.getParent(), null, null, new FileAttribute[0]);
        try (ZipFile in = new ZipFile(exportFile.toFile());
             ZipOutputStream out = new ZipOutputStream(IOUtils.buffer((OutputStream)Files.newOutputStream(modifiedExportFile, new OpenOption[0])));){
            Enumeration<? extends ZipEntry> entries = in.entries();
            while (entries.hasMoreElements()) {
                InputStream entryInputStream;
                block38: {
                    ZipEntry entry = entries.nextElement();
                    out.putNextEntry(PostprocessingIOUtil.copyEntry(entry));
                    entryInputStream = in.getInputStream(entry);
                    try {
                        if (ENTITIES_XML_ZIP_ENTRY_NAME.equals(entry.getName())) {
                            this.processEntities(this.xmlHelper.getXmlInputStream(entryInputStream), out, excludedAppKeys);
                            break block38;
                        }
                        IOUtils.copy((InputStream)entryInputStream, (OutputStream)out);
                    }
                    catch (Throwable throwable) {
                        PostprocessingIOUtil.runQuietly(entryInputStream::close);
                        throw throwable;
                    }
                }
                PostprocessingIOUtil.runQuietly(entryInputStream::close);
                out.closeEntry();
            }
        }
        Files.move(modifiedExportFile, exportFile, StandardCopyOption.REPLACE_EXISTING);
        if (modifiedExportFile == null) return;
        try {
            Files.deleteIfExists(modifiedExportFile);
            return;
        }
        catch (IOException e) {
            log.warn("Couldn't delete temp file", (Throwable)e);
        }
        return;
        catch (Exception e) {
            try {
                log.error("Couldn't postprocess space export file for updating pluginModuleKey.", (Throwable)e);
                if (modifiedExportFile == null) return;
            }
            catch (Throwable throwable) {
                if (modifiedExportFile == null) throw throwable;
                try {
                    Files.deleteIfExists(modifiedExportFile);
                    throw throwable;
                }
                catch (IOException e2) {
                    log.warn("Couldn't delete temp file", (Throwable)e2);
                }
                throw throwable;
            }
            try {
                Files.deleteIfExists(modifiedExportFile);
                return;
            }
            catch (IOException e3) {
                log.warn("Couldn't delete temp file", (Throwable)e3);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEntities(InputStream in, OutputStream out, List<String> excludedAppKeys) throws Exception {
        XMLEventReader reader = null;
        XMLEventWriter writer = null;
        try {
            reader = this.inputFactory.createXMLEventReader(in);
            writer = this.outputFactory.createXMLEventWriter(out);
            XMLEventProcessor currentProcessor = this::processUntilCustomContentEntityObject;
            while (reader.hasNext()) {
                currentProcessor = (XMLEventProcessor)currentProcessor.apply(new ProcessingContext(reader, writer, reader.nextEvent(), excludedAppKeys));
            }
        }
        finally {
            if (reader != null) {
                PostprocessingIOUtil.runQuietly(reader::close);
            }
            if (writer != null) {
                PostprocessingIOUtil.runQuietly(writer::close);
            }
        }
    }

    private XMLEventProcessor processPluginModuleKeyValue(ProcessingContext context) throws XMLStreamException {
        if (context.event.isCharacters()) {
            String key = context.event.asCharacters().getData();
            if (context.excludedAppKeys.stream().noneMatch(key::startsWith)) {
                context.writer.add(this.eventFactory.createCData("ac:" + key));
                return this::processPluginModuleKeyValue;
            }
        } else if (context.event.isEndElement() && XMLEventUtil.hasLocalName(context.event.asEndElement(), "property")) {
            context.writer.add(context.event);
            return this::processCustomContentEntityObject;
        }
        context.writer.add(context.event);
        return this::processPluginModuleKeyValue;
    }

    private XMLEventProcessor processCustomContentEntityObject(ProcessingContext context) throws XMLStreamException {
        context.writer.add(context.event);
        if (context.event.isStartElement() && XMLEventUtil.hasLocalName(context.event.asStartElement(), "property") && XMLEventUtil.hasAttribute(context.event.asStartElement(), "name", PLUGIN_MODULE_KEY_ATTRIBUTE_VALUE)) {
            return this::processPluginModuleKeyValue;
        }
        if (context.event.isEndElement() && XMLEventUtil.hasLocalName(context.event.asEndElement(), "object")) {
            return this::processUntilCustomContentEntityObject;
        }
        return this::processCustomContentEntityObject;
    }

    private XMLEventProcessor processUntilCustomContentEntityObject(ProcessingContext context) throws XMLStreamException {
        StartElement element;
        context.writer.add(context.event);
        if (context.event.isStartElement() && XMLEventUtil.hasLocalName(element = context.event.asStartElement(), "object") && XMLEventUtil.hasAttribute(element, "class", CUSTOM_CONTENT_ENTITY_OBJECT_CLASS)) {
            return this::processCustomContentEntityObject;
        }
        return this::processUntilCustomContentEntityObject;
    }

    private static final class ProcessingContext {
        final XMLEvent event;
        final XMLEventReader reader;
        final XMLEventWriter writer;
        final List<String> excludedAppKeys;

        ProcessingContext(XMLEventReader reader, XMLEventWriter writer, XMLEvent event, List<String> excludedAppKeys) {
            this.reader = reader;
            this.writer = writer;
            this.event = event;
            this.excludedAppKeys = excludedAppKeys;
        }
    }

    private static interface XMLEventProcessor
    extends CheckedFunction<ProcessingContext, XMLEventProcessor> {
    }
}

