/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.log;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.catalogue.MigrationCatalogueStorageService;
import com.atlassian.migration.agent.service.catalogue.model.MigrationCatalogueStorageFile;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.log.MigrationLogDirManager;
import com.atlassian.migration.agent.service.log.MigrationLogException;
import java.io.File;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class MigrationLogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationLogService.class);
    private static final String SAVE_FORMATTED_LOG_ACTION = "saveFormattedLog";
    private static final String FORMAT_MIGRATION_LOG_MESSAGE_ACTION = "formatMigrationLogMessage";
    private static final String UPLOAD_LOG_ZIP_TO_MCS_ACTION = "uploadedLogZipToMcs";
    private static final String UPLOAD_TO_MCS_ACTION = "uploadedFileToMcs";
    private final MigrationLogDirManager migrationLogDirManager;
    private final MigrationCatalogueStorageService migrationCatalogueStorageService;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;

    public MigrationLogService(MigrationLogDirManager migrationLogDirManager, MigrationCatalogueStorageService migrationCatalogueStorageService, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder) {
        this(migrationLogDirManager, migrationCatalogueStorageService, Instant::now, analyticsEventService, analyticsEventBuilder);
    }

    @VisibleForTesting
    public MigrationLogService(MigrationLogDirManager migrationLogDirManager, MigrationCatalogueStorageService migrationCatalogueStorageService, Supplier<Instant> instantSupplier, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder) {
        this.migrationLogDirManager = migrationLogDirManager;
        this.migrationCatalogueStorageService = migrationCatalogueStorageService;
        this.instantSupplier = instantSupplier;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToLogFile(Step step, String reason, @Nullable Throwable exception) {
        if (!StringUtils.isEmpty((String)step.getPlan().getMigrationId())) {
            boolean success = false;
            long startTime = this.instantSupplier.get().toEpochMilli();
            try {
                String errorLogMessage = this.logMessageFormat(step, reason, exception);
                this.migrationLogDirManager.saveErrorLogsToFile(step.getPlan().getMigrationId(), errorLogMessage);
                success = true;
            }
            finally {
                long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime;
                EventDto timerEvent = this.analyticsEventBuilder.buildMigrationLogTimerEvent(success, timeTaken, SAVE_FORMATTED_LOG_ACTION, step.getPlan().getMigrationId(), null, Optional.ofNullable(reason));
                this.analyticsEventService.saveAnalyticsEventAsync(() -> timerEvent);
            }
        } else {
            log.info("MigrationId missing. Skipping saving log to the file...!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadMigrationLogZipToMCS(String cloudId, @Nullable String migrationId, String planId) {
        if (!StringUtils.isEmpty((String)migrationId) && this.logFileExists(migrationId)) {
            boolean success = false;
            long startTime = this.instantSupplier.get().toEpochMilli();
            Optional<String> errorReason = Optional.empty();
            try {
                this.migrationLogDirManager.zipMigrationFilesToUpload(migrationId, planId);
                this.uploadLogFilesToMCS(cloudId, migrationId);
                success = true;
            }
            catch (Exception e) {
                log.error("Error while zipping log file or uploading zip to MCS for migrationId: " + migrationId, (Throwable)e);
                errorReason = Optional.ofNullable(e.getMessage());
            }
            finally {
                long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime;
                EventDto timerEvent = this.analyticsEventBuilder.buildMigrationLogTimerEvent(success, timeTaken, UPLOAD_LOG_ZIP_TO_MCS_ACTION, migrationId, cloudId, errorReason);
                this.analyticsEventService.saveAnalyticsEventAsync(() -> timerEvent);
            }
        } else {
            log.info("Either MigrationId is missing or log file is not present. Skipping uploading of zip file...!!");
        }
    }

    private void uploadLogFilesToMCS(String cloudId, String migrationId) {
        boolean success = false;
        long startTime = this.instantSupplier.get().toEpochMilli();
        Path migrationErrorLogZipFile = this.migrationLogDirManager.getMigrationErrorLogZipFile(migrationId);
        Path migrationLogZipFile = this.migrationLogDirManager.getMigrationLogZipFile(migrationId);
        Optional<String> errorReason = Optional.empty();
        try {
            MigrationCatalogueStorageFile uploadedFile = this.migrationCatalogueStorageService.uploadFileToMCS(cloudId, migrationId, migrationErrorLogZipFile);
            log.info("File uploaded to MCS fileId: {}, name: {}, size: {}", new Object[]{uploadedFile.getFileId(), uploadedFile.getName(), uploadedFile.getSize()});
            if (migrationLogZipFile.toFile().exists()) {
                MigrationCatalogueStorageFile uploadedLogFile = this.migrationCatalogueStorageService.uploadFileToMCS(cloudId, migrationId, migrationLogZipFile);
                log.info("File uploaded to MCS fileId: {}, name: {}, size: {}", new Object[]{uploadedLogFile.getFileId(), uploadedLogFile.getName(), uploadedLogFile.getSize()});
            }
            success = true;
        }
        catch (Exception e) {
            errorReason = Optional.ofNullable(e.getMessage());
            throw new MigrationLogException(e.getMessage(), e);
        }
        finally {
            this.migrationLogDirManager.cleanupMigrationLogZipFile(migrationId);
            long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime;
            EventDto timerEvent = this.analyticsEventBuilder.buildMigrationLogTimerEvent(success, timeTaken, UPLOAD_TO_MCS_ACTION, migrationId, cloudId, errorReason);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> timerEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String logMessageFormat(Step step, String reason, @Nullable Throwable exception) {
        boolean success = false;
        long startTime = this.instantSupplier.get().toEpochMilli();
        try {
            String errorMessage = String.format("%s ERROR Step failed, taskName: %s | stepType: %s | message: %s", new Object[]{this.instantSupplier.get().toString(), step.getTask().getName(), StepType.valueOf(step.getType()), reason});
            if (exception != null) {
                String exceptionDetails = String.format("[Exception Details]: %s | %s", exception.getMessage(), ExceptionUtils.getStackTrace((Throwable)exception));
                errorMessage = errorMessage + System.lineSeparator() + exceptionDetails;
            }
            errorMessage = errorMessage + System.lineSeparator();
            success = true;
            String string = errorMessage;
            return string;
        }
        finally {
            long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime;
            EventDto timerEvent = this.analyticsEventBuilder.buildMigrationLogTimerEvent(success, timeTaken, FORMAT_MIGRATION_LOG_MESSAGE_ACTION, step.getPlan().getMigrationId());
            this.analyticsEventService.saveAnalyticsEventAsync(() -> timerEvent);
        }
    }

    private boolean logFileExists(String migrationId) {
        File migrationLogFile = this.migrationLogDirManager.getMigrationErrorLogFile(migrationId).toFile();
        return migrationLogFile.exists();
    }
}

