/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.log;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.log.MigrationLogException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class MigrationLogDirManager {
    public static final String MIGRATION_ERROR_LOG_SUFFIX = "-migration-error-logs";
    public static final String MIGRATION_LOG_SUFFIX = "atlassian-confluence-migrations";
    private static final Logger log = ContextLoggerFactory.getLogger(MigrationLogDirManager.class);
    private static final String MIGRATION_PATH = "migration";
    private static final String LOG_PATH = "log";
    private static final String LOG_EXTENSION = ".log";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String MIG_LOG_FILE = "atlassian-confluence-migrations.log";
    private static final String LOGS_PATH = "logs";
    private static final String MIGRATION_ERROR_LOG_ZIP = "-migration-error-logs.zip";
    private static final String MIGRATION_ERROR_LOG_FILE = "-migration-error-logs.log";
    private static final String MIGRATION_LOG_ZIP = "-atlassian-confluence-migrations.zip";
    private final ClusterInformationService clusterInformationService;
    private final BootstrapManager bootstrapManager;

    public MigrationLogDirManager(BootstrapManager bootstrapManager, ClusterInformationService clusterInformationService) {
        this.bootstrapManager = bootstrapManager;
        this.clusterInformationService = clusterInformationService;
    }

    public void saveErrorLogsToFile(String migrationId, String message) {
        log.info("Saving migration error log message for migrationId: {} to file", (Object)migrationId);
        try {
            FileUtils.writeStringToFile((File)this.getMigrationErrorLogFile(migrationId).toFile(), (String)message, (Charset)StandardCharsets.UTF_8, (boolean)true);
        }
        catch (IOException e) {
            throw new MigrationLogException("Can't save migration error logs to file for migrationId: " + migrationId, e);
        }
    }

    public void zipMigrationFilesToUpload(String migrationId, String planId) {
        this.zipMigrationErrorLogFile(migrationId);
        if (!this.clusterInformationService.isClustered()) {
            this.zipMigrationLogFiles(migrationId, planId);
        }
    }

    @VisibleForTesting
    void zipMigrationErrorLogFile(String migrationId) {
        log.info("Zipping migration error log file for migrationId: {}", (Object)migrationId);
        Path migrationLogFile = this.getMigrationErrorLogFile(migrationId);
        Path zipfilePath = this.getMigrationErrorLogZipFile(migrationId);
        ZipFile zip = new ZipFile(zipfilePath.toFile());
        try {
            zip.addFile(migrationLogFile.toFile());
        }
        catch (ZipException e) {
            throw new MigrationLogException("Can't zip migration error log file for migrationId: " + migrationId, e);
        }
        finally {
            this.cleanupMigrationErrorLogFile(migrationId);
        }
    }

    @VisibleForTesting
    void zipMigrationLogFiles(String migrationId, String planId) {
        Path zipfilePath = this.getMigrationLogZipFile(migrationId);
        ZipFile migLogZip = new ZipFile(zipfilePath.toFile());
        try {
            List<Path> migrationLogPaths = this.getMigrationLogsWithPlanId(planId);
            for (Path migrationLogPath : migrationLogPaths) {
                migLogZip.addFile(migrationLogPath.toFile());
            }
        }
        catch (IOException e) {
            throw new MigrationLogException("Can't zip migration log file for migrationId: " + migrationId, e);
        }
    }

    public Path getMigrationErrorLogZipFile(String migrationId) {
        return this.getMigrationErrorLogPath().resolve(migrationId + MIGRATION_ERROR_LOG_ZIP);
    }

    public Path getMigrationLogZipFile(String migrationId) {
        return Paths.get(this.bootstrapManager.getConfluenceHome(), LOGS_PATH, migrationId + MIGRATION_LOG_ZIP);
    }

    public void cleanupMigrationLogZipFile(String migrationId) {
        try {
            Files.delete(this.getMigrationErrorLogZipFile(migrationId));
            Files.deleteIfExists(this.getMigrationLogZipFile(migrationId));
        }
        catch (IOException e) {
            log.error("Failed to clean up migration log zip file. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    public Path getMigrationErrorLogFile(String file) {
        return this.getMigrationErrorLogPath().resolve(file + MIGRATION_ERROR_LOG_FILE);
    }

    @VisibleForTesting
    void cleanupMigrationErrorLogFile(String file) {
        try {
            Files.delete(this.getMigrationErrorLogFile(file));
        }
        catch (IOException e) {
            log.error("Failed to clean up migration error log file. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    @VisibleForTesting
    Path getMigrationErrorLogPath() {
        Path path = Paths.get(this.bootstrapManager.getSharedHome().getAbsolutePath(), MIGRATION_PATH, LOG_PATH);
        if (!path.toFile().exists()) {
            try {
                return Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MigrationLogException("Unable to create migration error logs directory", e);
            }
        }
        return path;
    }

    private Path getMigrationLogPath() {
        return Paths.get(this.bootstrapManager.getConfluenceHome(), LOGS_PATH);
    }

    @VisibleForTesting
    public List<Path> getMigrationLogsWithPlanId(String planId) throws IOException {
        int lastLogFileIndex = this.getLastLogFileIndex();
        int lastFileWithPlanIdIndex = this.getLastFileWithPlanIdIndex(planId, lastLogFileIndex);
        ArrayList<Path> files = new ArrayList<Path>();
        this.addExistingFilePathToList(MIG_LOG_FILE, files);
        for (int fileIndex = 0; fileIndex <= lastFileWithPlanIdIndex; ++fileIndex) {
            this.addExistingFilePathToList("atlassian-confluence-migrations.log." + fileIndex, files);
        }
        return files;
    }

    private void addExistingFilePathToList(String migLogFile, List<Path> files) {
        Path firstFile = this.getMigrationLogPath().resolve(migLogFile);
        if (Files.exists(firstFile, new LinkOption[0])) {
            files.add(firstFile);
        }
    }

    @VisibleForTesting
    int getLastLogFileIndex() throws IOException {
        try (Stream<Path> stream = Files.list(this.getMigrationLogPath()).filter(p -> p.getFileName().toString().matches("atlassian-confluence-migrations.log.[0-9]+"));){
            int n = stream.filter(p -> p.getFileName().toString().indexOf(".", 2) != -1).mapToInt(p -> Integer.parseInt(p.getFileName().toString().split("\\.")[2])).max().orElse(-1);
            return n;
        }
    }

    int getLastFileWithPlanIdIndex(String planId, int lastLogFileIndex) throws IOException {
        for (int fileIndex = lastLogFileIndex; fileIndex >= 0; --fileIndex) {
            Path path = this.getMigrationLogPath().resolve("atlassian-confluence-migrations.log." + fileIndex);
            if (!Files.exists(path, new LinkOption[0]) || !this.containsPlanId(path, planId)) continue;
            return fileIndex;
        }
        return -1;
    }

    private boolean containsPlanId(Path filePath, String planId) throws IOException {
        try (Stream<String> lines = Files.lines(filePath);){
            boolean bl = lines.anyMatch(line -> line.contains(planId));
            return bl;
        }
    }
}

