/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.dto.UserDomainRuleDto;
import com.atlassian.migration.agent.dto.UserDomainRulesetDto;
import com.atlassian.migration.agent.dto.util.UserDomainsDto;
import com.atlassian.migration.agent.service.impl.UserDomainService;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@ParametersAreNonnullByDefault
@Path(value="email")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class UsersResource {
    private final UserDomainService userDomainService;

    public UsersResource(UserDomainService userDomainService) {
        this.userDomainService = userDomainService;
    }

    @GET
    @Path(value="/domains")
    public Response getUserDomains() {
        return Response.ok((Object)new UserDomainsDto(this.userDomainService.getUserDomainCounts())).build();
    }

    @GET
    @Path(value="/domain-rules")
    public Response getDomainRuleset() {
        UserDomainRulesetDto ruleset = this.userDomainService.getDomainRules();
        return Response.ok((Object)ruleset).build();
    }

    @PUT
    @Path(value="/domain-rules")
    public Response updateDomainRule(UserDomainRuleDto rule) {
        this.userDomainService.upsertDomainRule(rule);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/domain-rules/{domain}")
    public Response deleteDomainRule(@PathParam(value="domain") String domain) {
        this.userDomainService.deleteDomainRule(domain);
        return Response.ok().build();
    }
}

