/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.agent.dto.ConfigDto;
import com.atlassian.migration.agent.service.impl.ConfigurationService;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.web.bind.annotation.RequestBody;

@ParametersAreNonnullByDefault
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="configuration")
public class ConfigurationResource {
    private final ConfigurationService configurationService;

    public ConfigurationResource(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @GET
    public Response getConfig() {
        ConfigDto config = this.configurationService.getConfig();
        return Response.ok((Object)config).build();
    }

    @PUT
    public Response updateConfig(@RequestBody ConfigDto config) {
        this.configurationService.upsertConfig(config);
        return Response.ok().build();
    }
}

