/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.entity;

import com.atlassian.migration.agent.entity.Task;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

@Entity
@DiscriminatorValue(value="USERS")
public class MigrateUsersTask
extends Task {
    @Column(name="scoped")
    protected Boolean scoped;

    public MigrateUsersTask() {
        this(false);
    }

    public MigrateUsersTask(boolean scoped) {
        this.scoped = scoped;
    }

    public MigrateUsersTask(MigrateUsersTask usersTask) {
        super(usersTask.getWeight(), usersTask.getIndex());
        this.scoped = usersTask.scoped;
    }

    @Override
    public Task copy() {
        return new MigrateUsersTask(this);
    }

    @Override
    public String getName() {
        return "Migrate users and groups";
    }

    @Override
    public String getAnalyticsEventType() {
        return "users-and-groups";
    }

    public Boolean isScoped() {
        if (this.scoped != null) {
            return this.scoped;
        }
        return Boolean.FALSE;
    }

    public void setScoped(Boolean scoped) {
        this.scoped = scoped;
    }
}

