/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.migration.agent.entity.Space;
import com.atlassian.migration.agent.newexport.store.JdbcConfluenceStore;
import com.atlassian.migration.agent.service.impl.SpaceTypeFilter;
import com.atlassian.migration.agent.store.impl.MigratedSpaceStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.jpa.QueryBuilder;
import com.google.common.collect.ImmutableMap;
import java.sql.Date;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class SpaceStore {
    public static final String CONTENT_ID = "select contentid from content where spaceid = :spaceid and lastmoddate > :recent";
    private final EntityManagerTemplate tmpl;
    private final MigratedSpaceStore migratedSpaceStore;
    private final JdbcConfluenceStore confluenceStore;
    private static final Map<SpaceTypeFilter, String> spaceFilterToType = ImmutableMap.of((Object)((Object)SpaceTypeFilter.PERSONAL), (Object)SpaceType.PERSONAL.toString(), (Object)((Object)SpaceTypeFilter.SITE), (Object)SpaceType.GLOBAL.toString());
    private final Map<SpaceTypeFilter, BiPredicate<Space, String>> postFiltered = ImmutableMap.of((Object)((Object)SpaceTypeFilter.TOMIGRATE), (s, c) -> this.hasNotBeenMigrated((Space)s, (String)c), (Object)((Object)SpaceTypeFilter.UNUSED30), (s, c) -> this.isOlderThan((Space)s, 30), (Object)((Object)SpaceTypeFilter.UNUSED90), (s, c) -> this.isOlderThan((Space)s, 90));

    private boolean isOlderThan(Space space, int days) {
        Instant now = Instant.now();
        Instant then = now.minus(Duration.ofDays(days));
        List<Long> ids = this.confluenceStore.findContentIds(CONTENT_ID, (Map)ImmutableMap.of((Object)"spaceid", (Object)space.getId(), (Object)"recent", (Object)new Date(then.toEpochMilli())));
        return ids.isEmpty();
    }

    private boolean hasNotBeenMigrated(Space space, String cloudId) {
        return !this.migratedSpaceStore.hasSpace(space, cloudId);
    }

    public SpaceStore(EntityManagerTemplate tmpl, MigratedSpaceStore migratedSpaceStore, JdbcConfluenceStore confluenceStore) {
        this.tmpl = tmpl;
        this.migratedSpaceStore = migratedSpaceStore;
        this.confluenceStore = confluenceStore;
    }

    public int getSpacesCount(String nameQuery, SpaceTypeFilter spaceTypeFilter) {
        String query = "select count(*) from Space s" + this.whereClause(nameQuery, spaceTypeFilter);
        QueryBuilder<Long> builder = this.tmpl.query(Long.class, query);
        this.queryParam(builder, nameQuery);
        return builder.single().intValue();
    }

    public List<Space> getSpaces(String planId) {
        String query = "select space from Task task inner join Space space on space.key = task.spaceKey where task.plan.id=:planId";
        QueryBuilder<Space> builder = this.tmpl.query(Space.class, query);
        builder.param("planId", (Object)planId);
        return builder.list();
    }

    public Map<String, String> getSpaceKeyNamePairsForSpaceTasks(String planId) {
        String query = "select task.spaceKey as spaceKey, space.name as spaceName from AbstractSpaceTask task left join Space space on task.spaceKey = space.key where task.plan.id =: planId and TYPE(task) in (SpaceAttachmentsOnlyTask,ConfluenceSpaceTask)";
        QueryBuilder<Tuple> builder = this.tmpl.query(Tuple.class, query);
        builder.param("planId", (Object)planId);
        return builder.stream().collect(HashMap::new, (map, tuple) -> map.put((String)tuple.get("spaceKey"), (String)tuple.get("spaceName")), HashMap::putAll);
    }

    public List<Space> getSpacesPaged(String cloudId, String nameQuery, SpaceTypeFilter spaceTypeFilter, int startIndex, int pageSize) {
        return this.postFiltered.containsKey((Object)spaceTypeFilter) ? this.getFilterSpaces(nameQuery, spaceTypeFilter).stream().filter(s -> this.postFiltered.get((Object)spaceTypeFilter).test((Space)s, cloudId)).skip(startIndex).limit(pageSize).collect(Collectors.toList()) : this.getFilterSpaces(nameQuery, spaceTypeFilter, startIndex, pageSize);
    }

    @VisibleForTesting
    List<Space> getFilterSpaces(String nameQuery, SpaceTypeFilter spaceTypeFilter, int startIndex, int pageSize) {
        return this.getQueryBuilder(nameQuery, spaceTypeFilter).first(startIndex).max(pageSize).list();
    }

    @VisibleForTesting
    List<Space> getFilterSpaces(String nameQuery, SpaceTypeFilter spaceTypeFilter) {
        return this.getQueryBuilder(nameQuery, spaceTypeFilter).list();
    }

    @NotNull
    private QueryBuilder<Space> getQueryBuilder(String nameQuery, SpaceTypeFilter spaceTypeFilter) {
        String query = "from Space s" + this.whereClause(nameQuery, spaceTypeFilter) + " order by s.key";
        QueryBuilder<Space> builder = this.tmpl.query(Space.class, query);
        this.queryParam(builder, nameQuery);
        return builder;
    }

    private String whereClause(String nameQuery, SpaceTypeFilter spaceTypeFilter) {
        if (StringUtils.isEmpty((CharSequence)nameQuery) && !spaceFilterToType.containsKey((Object)spaceTypeFilter)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" where ");
        if (StringUtils.isNotEmpty((CharSequence)nameQuery)) {
            sb.append("lower(s.name) like lower(:nameQuery)");
        }
        if (spaceFilterToType.containsKey((Object)spaceTypeFilter)) {
            if (StringUtils.isNotEmpty((CharSequence)nameQuery)) {
                sb.append(" and ");
            }
            sb.append("s.type = '").append(spaceFilterToType.get((Object)spaceTypeFilter)).append("'");
        }
        return sb.toString();
    }

    private void queryParam(QueryBuilder builder, String nameQuery) {
        if (StringUtils.isNotEmpty((CharSequence)nameQuery)) {
            builder.param("nameQuery", (Object)("%" + nameQuery + "%"));
        }
    }
}

