/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.app.webhook;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.migration.agent.okhttp.HttpException;
import com.atlassian.migration.agent.service.MigrationAppAggregatorResponse;
import com.atlassian.migration.agent.service.PreflightErrorCode;
import com.atlassian.migration.agent.service.check.app.CloudAppKeyFetcher;
import com.atlassian.migration.agent.service.check.app.webhook.AppWebhookEndpointCheckContext;
import com.atlassian.migration.agent.service.check.app.webhook.AppWebhookEndpointCheckRequest;
import com.atlassian.migration.agent.service.check.app.webhook.AppWebhookEndpointCheckResponse;
import com.atlassian.migration.agent.service.check.app.webhook.AppWebhookEndpointCheckResultDto;
import com.atlassian.migration.agent.service.check.app.webhook.AppWebhookEndpointCheckServiceClient;
import com.atlassian.migration.agent.service.impl.MigrationAppAggregatorService;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppWebhookEndpointChecker
implements Checker<AppWebhookEndpointCheckContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppWebhookEndpointChecker.class);
    @NonNull
    private final AppWebhookEndpointCheckServiceClient appWebhookEndpointCheckServiceClient;
    @NonNull
    private final CloudAppKeyFetcher cloudAppKeyFetcher;
    @NonNull
    private final MigrationAppAggregatorService appAggregatorService;
    public static final String MISSING_WEBHOOKS_CHECK_RESULT_DETAILS_KEY = "appKeysMissingWebhooks";

    public CheckResult check(AppWebhookEndpointCheckContext ctx) {
        Set<Object> appKeysWithMissingWebhooks = new HashSet();
        PreflightErrorCode errorCode = null;
        try {
            Set<String> cloudKeys = ctx.appKeys.stream().map(this.cloudAppKeyFetcher::getCloudAppKey).collect(Collectors.toSet());
            AppWebhookEndpointCheckRequest request = new AppWebhookEndpointCheckRequest(cloudKeys);
            AppWebhookEndpointCheckResponse appWebhookEndpointCheckResponse = this.appWebhookEndpointCheckServiceClient.retrieveRegisteredWebhooks(ctx.cloudId, request);
            Set<AppWebhookEndpointCheckResponse.AppWebhookEndpointCheckResult> appWebhookEndpointCheckResults = appWebhookEndpointCheckResponse.getAppEndpoints();
            if (appWebhookEndpointCheckResults.size() == 1 && appWebhookEndpointCheckResults.contains(new AppWebhookEndpointCheckResponse.AppWebhookEndpointCheckResult("APP_WEBHOOK_CHECK_DISABLED", true))) {
                log.warn("App webhook check is disabled in App migration service for cloud id: {}", (Object)ctx.cloudId);
                return new CheckResult(true);
            }
            appKeysWithMissingWebhooks = appWebhookEndpointCheckResults.stream().filter(appWebhookEndpointCheckResult -> !appWebhookEndpointCheckResult.isAvailable()).map(AppWebhookEndpointCheckResponse.AppWebhookEndpointCheckResult::getAppKey).collect(Collectors.toSet());
        }
        catch (HttpException e) {
            errorCode = PreflightErrorCode.APP_WEBHOOK_CHECK_ERROR;
            log.error("Error code- {}. {}", new Object[]{errorCode.getCode(), errorCode.getMessage(), e});
        }
        catch (Exception e) {
            errorCode = PreflightErrorCode.GENERIC_ERROR;
            log.error("Error executing apps webhook check.", (Throwable)e);
        }
        if (errorCode != null) {
            return Checker.buildCheckResultWithExecutionError((int)errorCode.getCode());
        }
        if (!appKeysWithMissingWebhooks.isEmpty()) {
            Set appMissingWebhookEndpointResult = appKeysWithMissingWebhooks.stream().map(appKey -> {
                MigrationAppAggregatorResponse cachedCloudAppDataResponse = this.appAggregatorService.getCachedCloudAppData((String)appKey);
                String cloudAppName = appKey;
                String contactSupportUrl = null;
                if (cachedCloudAppDataResponse != null) {
                    if (cachedCloudAppDataResponse.getName() != null) {
                        cloudAppName = cachedCloudAppDataResponse.getName();
                    }
                    if (cachedCloudAppDataResponse.getContactSupportUrl() != null) {
                        contactSupportUrl = cachedCloudAppDataResponse.getContactSupportUrl();
                    }
                }
                return new AppWebhookEndpointCheckResultDto(cloudAppName, (String)appKey, contactSupportUrl);
            }).collect(Collectors.toSet());
            return new CheckResult(false, (Map)ImmutableMap.of((Object)MISSING_WEBHOOKS_CHECK_RESULT_DETAILS_KEY, appMissingWebhookEndpointResult));
        }
        return new CheckResult(true);
    }

    @Generated
    public AppWebhookEndpointChecker(@NonNull AppWebhookEndpointCheckServiceClient appWebhookEndpointCheckServiceClient, @NonNull CloudAppKeyFetcher cloudAppKeyFetcher, @NonNull MigrationAppAggregatorService appAggregatorService) {
        if (appWebhookEndpointCheckServiceClient == null) {
            throw new NullPointerException("appWebhookEndpointCheckServiceClient is marked non-null but is null");
        }
        if (cloudAppKeyFetcher == null) {
            throw new NullPointerException("cloudAppKeyFetcher is marked non-null but is null");
        }
        if (appAggregatorService == null) {
            throw new NullPointerException("appAggregatorService is marked non-null but is null");
        }
        this.appWebhookEndpointCheckServiceClient = appWebhookEndpointCheckServiceClient;
        this.cloudAppKeyFetcher = cloudAppKeyFetcher;
        this.appAggregatorService = appAggregatorService;
    }
}

