--- SCRIPT TO GENERATE THE DROP SCRIPT OF ALL PK AND UNIQUE CONSTRAINTS.
DECLARE @TableName                 VARCHAR(256)
DECLARE @TSQLDropDefaultConstraint VARCHAR(MAX)

DECLARE CursorTables CURSOR FOR
SELECT t.name
FROM sys.tables t
WHERE t.name like 'MIG_%'
  and t.is_ms_shipped = 0

    OPEN CursorTables
FETCH NEXT FROM CursorTables INTO @TableName

    WHILE @@fetch_status = 0
BEGIN
        DECLARE DefaultConstraintCursor CURSOR FOR
SELECT 'ALTER TABLE ' + QUOTENAME(OBJECT_SCHEMA_NAME(parent_object_id)) + '.' +
       QUOTENAME(object_name(parent_object_id))
           + ' DROP CONSTRAINT ' + QUOTENAME(sdc.name) + ''
           AS Drop_Default_Constraint_Query
FROM sys.default_constraints sdc
WHERE parent_object_id = object_id(@TableName)

    OPEN DefaultConstraintCursor
        FETCH NEXT FROM DefaultConstraintCursor INTO @TSQLDropDefaultConstraint

    WHILE @@fetch_status = 0
BEGIN
EXECUTE (@TSQLDropDefaultConstraint)
    FETCH NEXT FROM DefaultConstraintCursor INTO @TSQLDropDefaultConstraint
END

CLOSE DefaultConstraintCursor
    DEALLOCATE DefaultConstraintCursor

        FETCH NEXT FROM CursorTables INTO @TableName
END

CLOSE CursorTables
    DEALLOCATE CursorTables