DECLARE @TSQLAlterColumn VARCHAR(MAX)

DECLARE CursorColumnModifications CURSOR FOR
SELECT 'ALTER TABLE [' + isnull(schema_name(syo.object_id), sysc.name) + '].[' + syo.name
           + '] ALTER COLUMN ' + '[' + syc.name + ']'
           + ' NVARCHAR(' + case syc.max_length
                                when -1 then 'MAX'
                                ELSE convert(nvarchar(10), syc.max_length) end + ') ;'
FROM sys.objects syo
         JOIN sys.columns syc ON
        syc.object_id = syo.object_id
         JOIN sys.types syt ON
        syt.system_type_id = syc.system_type_id
         JOIN sys.schemas sysc ON
        syo.schema_id = sysc.schema_id
         JOIN sys.tables t ON
        syc.object_id = t.object_id
WHERE syt.name = 'varchar'
  and syo.type = 'U'
  and syc.is_nullable = 1
  and t.name like 'MIG_%'
  and t.is_ms_shipped = 0
UNION
SELECT 'ALTER TABLE [' + isnull(schema_name(syo.object_id), sysc.name) + '].[' + syo.name
           + '] ALTER COLUMN ' + '[' + syc.name + ']'
           + ' NVARCHAR(' + case syc.max_length
                                when -1 then 'MAX'
                                ELSE convert(nvarchar(10), syc.max_length) end + ') NOT NULL;'
FROM sys.objects syo
         JOIN sys.columns syc ON
        syc.object_id = syo.object_id
         JOIN sys.types syt ON
        syt.system_type_id = syc.system_type_id
         JOIN sys.schemas sysc ON
        syo.schema_id = sysc.schema_id
         JOIN sys.tables t ON
        syc.object_id = t.object_id
WHERE syt.name = 'varchar'
  and syo.type = 'U'
  and syc.is_nullable = 0
  and t.name like 'MIG_%'
  and t.is_ms_shipped = 0

    OPEN CursorColumnModifications
FETCH NEXT
FROM CursorColumnModifications
INTO @TSQLAlterColumn

    WHILE @@fetch_status = 0
BEGIN
EXECUTE (@TSQLAlterColumn)
    FETCH NEXT FROM CursorColumnModifications INTO @TSQLAlterColumn
END

CLOSE CursorColumnModifications
    DEALLOCATE CursorColumnModifications