/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.MigrationDarkFeaturesValidator;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.dto.ConfExportStepConfig;
import com.atlassian.migration.agent.entity.ExportCacheEntry;
import com.atlassian.migration.agent.entity.ExportType;
import com.atlassian.migration.agent.entity.MigrateUsersTask;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.export.MigrationExportException;
import com.atlassian.migration.agent.export.SpaceNoAttachmentsXmlExporter;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.newexport.ConfluenceRapidExporter;
import com.atlassian.migration.agent.newexport.util.FileUtil;
import com.atlassian.migration.agent.queue.QueueConsumer;
import com.atlassian.migration.agent.queue.QueueConsumerConfiguration;
import com.atlassian.migration.agent.rest.IncompatibleDarkFeatureException;
import com.atlassian.migration.agent.service.AttachmentService;
import com.atlassian.migration.agent.service.ExportDirManager;
import com.atlassian.migration.agent.service.MigrationErrorCode;
import com.atlassian.migration.agent.service.ServiceInitializeException;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.ErrorEvent;
import com.atlassian.migration.agent.service.execution.StepExecutor;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.StepSchedulerService;
import com.atlassian.migration.agent.service.stepexecutor.export.SpaceExportCacheService;
import com.atlassian.migration.agent.service.stepexecutor.space.AtlassianAccountPostProcessor;
import com.atlassian.migration.agent.service.stepexecutor.space.CSVConverterService;
import com.atlassian.migration.agent.service.stepexecutor.space.InlineTasksPostprocessor;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceExportCustomContentEntityPostProcessor;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceExportEmailValidatorPostProcessor;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceExportPostProcessor;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class SpaceExportExecutor
implements QueueConsumer,
JobRunner,
StepExecutor {
    private static final String STEP_ID_PARAMS_KEY = "stepId";
    private static final String STEP_CONFIG_PARAMS_KEY = "stepConfig";
    @VisibleForTesting
    static final StepType EXPORT_STEP_TYPE = StepType.CONFLUENCE_EXPORT;
    @VisibleForTesting
    static final String TEMP_DIR_PROP = "struts.multipart.saveDir";
    @VisibleForTesting
    static final String LEGACY_TEMP_DIR_PROP = "webwork.multipart.saveDir";
    private static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"migration-plugin:export-executor");
    private static final String CACHE_FILENAME_SUFFIX = "_cache";
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceExportExecutor.class);
    private final SpaceNoAttachmentsXmlExporter spaceNoAttachmentsXmlExporter;
    private final StepSchedulerService stepSchedulerService;
    private final SchedulerService schedulerService;
    private final ExportDirManager exportDirManager;
    private final BootstrapManager bootstrapManager;
    private final AttachmentService attachmentService;
    private final StepStore stepStore;
    private final PluginTransactionTemplate ptx;
    private final SpaceExportPostProcessor spaceExportPostProcessor;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final SpaceExportEmailValidatorPostProcessor spaceExportEmailValidatorPostProcessor;
    private final InlineTasksPostprocessor inlineTasksPostprocessor;
    private final SpaceExportCustomContentEntityPostProcessor spaceExportCustomContentEntityPostProcessor;
    private final ConfluenceRapidExporter confluenceRapidExporter;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final MigrationDarkFeaturesValidator migrationDarkFeaturesValidator;
    private final AtlassianAccountPostProcessor aaidPopulatorPostProcessor;
    private final SpaceExportCacheService cacheService;
    private final CSVConverterService csvConverterService;
    private final SpaceManager spaceManager;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final Clock clock;
    protected File tempDirFilePath;

    public SpaceExportExecutor(SpaceNoAttachmentsXmlExporter spaceNoAttachmentsXmlExporter, StepSchedulerService stepSchedulerService, SchedulerService schedulerService, ExportDirManager exportDirManager, BootstrapManager bootstrapManager, AttachmentService attachmentService, StepStore stepStore, PluginTransactionTemplate ptx, SpaceExportPostProcessor spaceExportPostProcessor, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, SpaceExportEmailValidatorPostProcessor spaceExportEmailValidatorPostProcessor, SpaceExportCustomContentEntityPostProcessor spaceExportCustomContentEntityPostProcessor, InlineTasksPostprocessor inlineTasksPostprocessor, MigrationDarkFeaturesManager migrationDarkFeaturesManager, MigrationDarkFeaturesValidator migrationDarkFeaturesValidator, ConfluenceRapidExporter confluenceRapidExporter, AtlassianAccountPostProcessor aaidPopulatorPostProcessor, SpaceExportCacheService cacheService, CSVConverterService csvConverterService, SpaceManager spaceManager, MigrationAgentConfiguration migrationAgentConfiguration) {
        this(spaceNoAttachmentsXmlExporter, stepSchedulerService, schedulerService, exportDirManager, bootstrapManager, attachmentService, stepStore, ptx, spaceExportPostProcessor, Instant::now, analyticsEventService, analyticsEventBuilder, spaceExportEmailValidatorPostProcessor, spaceExportCustomContentEntityPostProcessor, inlineTasksPostprocessor, migrationDarkFeaturesManager, migrationDarkFeaturesValidator, confluenceRapidExporter, aaidPopulatorPostProcessor, cacheService, csvConverterService, spaceManager, migrationAgentConfiguration, Clock.systemUTC());
    }

    @VisibleForTesting
    SpaceExportExecutor(SpaceNoAttachmentsXmlExporter spaceNoAttachmentsXmlExporter, StepSchedulerService stepSchedulerService, SchedulerService schedulerService, ExportDirManager exportDirManager, BootstrapManager bootstrapManager, AttachmentService attachmentService, StepStore stepStore, PluginTransactionTemplate ptx, SpaceExportPostProcessor spaceExportPostProcessor, Supplier<Instant> instantSupplier, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, SpaceExportEmailValidatorPostProcessor spaceExportEmailValidatorPostProcessor, SpaceExportCustomContentEntityPostProcessor spaceExportCustomContentEntityPostProcessor, InlineTasksPostprocessor inlineTasksPostprocessor, MigrationDarkFeaturesManager migrationDarkFeaturesManager, MigrationDarkFeaturesValidator migrationDarkFeaturesValidator, ConfluenceRapidExporter confluenceRapidExporter, AtlassianAccountPostProcessor aaidPopulatorPostProcessor, SpaceExportCacheService cacheService, CSVConverterService converterService, SpaceManager spaceManager, MigrationAgentConfiguration migrationAgentConfiguration, Clock clock) {
        this.spaceNoAttachmentsXmlExporter = spaceNoAttachmentsXmlExporter;
        this.schedulerService = schedulerService;
        this.stepSchedulerService = stepSchedulerService;
        this.bootstrapManager = bootstrapManager;
        this.exportDirManager = exportDirManager;
        this.attachmentService = attachmentService;
        this.stepStore = stepStore;
        this.ptx = ptx;
        this.spaceExportPostProcessor = spaceExportPostProcessor;
        this.instantSupplier = instantSupplier;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.spaceExportEmailValidatorPostProcessor = spaceExportEmailValidatorPostProcessor;
        this.spaceExportCustomContentEntityPostProcessor = spaceExportCustomContentEntityPostProcessor;
        this.inlineTasksPostprocessor = inlineTasksPostprocessor;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.migrationDarkFeaturesValidator = migrationDarkFeaturesValidator;
        this.confluenceRapidExporter = confluenceRapidExporter;
        this.aaidPopulatorPostProcessor = aaidPopulatorPostProcessor;
        this.cacheService = cacheService;
        this.csvConverterService = converterService;
        this.spaceManager = spaceManager;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.clock = clock;
    }

    @PostConstruct
    public void postConstruct() {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
        this.tempDirFilePath = new File(SpaceExportExecutor.getFilePathProperty(this.bootstrapManager));
        boolean createTempDirResult = this.tempDirFilePath.mkdirs();
        log.info("Created temporary directory for export, call return {}", (Object)createTempDirResult);
        if (!this.tempDirFilePath.exists()) {
            log.error("Failed to configure temporary directory for path {}.", (Object)this.tempDirFilePath);
            throw new ServiceInitializeException("Failed to configure temporary directory for path " + this.tempDirFilePath);
        }
    }

    @PreDestroy
    public void cleanup() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
    }

    public static String getFilePathProperty(BootstrapManager bootstrapManager) {
        String filePathProperty = bootstrapManager.getFilePathProperty(TEMP_DIR_PROP);
        if (filePathProperty == null) {
            filePathProperty = bootstrapManager.getFilePathProperty(LEGACY_TEMP_DIR_PROP);
        }
        if (filePathProperty == null) {
            throw new RuntimeException(String.format("Failed to retrieve temporary directory from neither path property %s nor %s.", TEMP_DIR_PROP, LEGACY_TEMP_DIR_PROP));
        }
        return filePathProperty;
    }

    @Override
    public QueueConsumerConfiguration getConsumerConfiguration() {
        return QueueConsumerConfiguration.builder(EXPORT_STEP_TYPE.name()).withConcurrencyLevel(this.migrationAgentConfiguration.getSpaceExportExecutorConcurrency()).build();
    }

    @Override
    public void consume(String stepId, String jobId) {
        this.stepSchedulerService.consumeStep(stepId, EXPORT_STEP_TYPE, () -> {
            String stepConfig = this.ptx.read(() -> this.stepStore.getStep(stepId).getConfig());
            ImmutableMap jobParams = ImmutableMap.of((Object)STEP_CONFIG_PARAMS_KEY, (Object)stepConfig, (Object)STEP_ID_PARAMS_KEY, (Object)stepId);
            this.stepSchedulerService.scheduleStepOnce(stepId, RUNNER_KEY, JobId.of((String)jobId), EXPORT_STEP_TYPE, (Map<String, Serializable>)jobParams);
            return Optional.empty();
        });
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        String stepId = (String)request.getJobConfig().getParameters().get(STEP_ID_PARAMS_KEY);
        String config = (String)request.getJobConfig().getParameters().get(STEP_CONFIG_PARAMS_KEY);
        this.stepSchedulerService.runStep(stepId, EXPORT_STEP_TYPE, () -> this.doExport(config, stepId));
        return null;
    }

    @VisibleForTesting
    StepResult doExport(String config, String stepId) {
        try {
            this.migrationDarkFeaturesValidator.assertSpaceExportFeaturesAreValid();
        }
        catch (IncompatibleDarkFeatureException ex) {
            log.error("Space Export Dark features are not compatible: {}", (Object)ex.getMessage());
            return StepResult.failed(String.format("Space export failed due to Incompatible dark features: %s", ex.getMessage()), ex);
        }
        ExportType exportType = this.getExportType();
        long startTime = this.instantSupplier.get().toEpochMilli();
        ConfExportStepConfig exportStepConfig = Jsons.readValue(config, ConfExportStepConfig.class);
        String spaceKey = exportStepConfig.getSpaceKey();
        Step step = this.stepStore.getStep(stepId);
        String planId = step.getPlan().getId();
        String migrationId = step.getPlan().getMigrationId();
        String cloudId = exportStepConfig.getCloudId();
        log.info("Initiating space export for spaceKey: {} planId: {} migrationId: {} exportType:{}", new Object[]{spaceKey, planId, migrationId, exportType});
        if (StringUtils.isBlank((String)spaceKey)) {
            this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_NO_SPACE_KEY, exportType, migrationId, cloudId, MigrationErrorCode.SPACE_EXPORT_NO_SPACE_KEY.getMessage());
            return StepResult.failed("Attempted to perform an export, but no space key was found.");
        }
        String fileId = exportStepConfig.getFileId();
        if (StringUtils.isBlank((String)fileId)) {
            this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_NO_FILE_ID, exportType, migrationId, cloudId, MigrationErrorCode.SPACE_EXPORT_NO_FILE_ID.getMessage());
            return StepResult.failed("Attempted to perform an export, but no file ID was found.");
        }
        if (StringUtils.isBlank((String)cloudId)) {
            this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_NO_CLOUD_ID, exportType, migrationId, cloudId, MigrationErrorCode.SPACE_EXPORT_NO_CLOUD_ID.getMessage());
            return StepResult.failed("Attempted to perform an export, but no cloud ID was found.");
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_SPACE_DOES_NOT_EXIST, exportType, migrationId, cloudId, MigrationErrorCode.SPACE_EXPORT_SPACE_DOES_NOT_EXIST.getMessage());
            return StepResult.failed(String.format("Attempted to perform an export, but no space with the key '%s' was found.", spaceKey));
        }
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildSpaceExportStartEvent(step, exportType, space.getId(), startTime));
        return this.exportProcessor(step, exportStepConfig, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StepResult exportProcessor(Step step, ConfExportStepConfig exportStepConfig, long startTime) {
        StepResult stepResult;
        ExportType exportType = this.getExportType();
        String migrationId = step.getPlan().getMigrationId();
        String fileId = exportStepConfig.getFileId();
        String spaceKey = exportStepConfig.getSpaceKey();
        String cloudId = exportStepConfig.getCloudId();
        String planId = step.getPlan().getId();
        String taskId = step.getTask().getId();
        boolean containsUserMigrationTask = this.containsTask(step.getPlan(), MigrateUsersTask.class);
        boolean success = false;
        try {
            String exportedFile = this.exportedFileGenerator(spaceKey, planId, taskId, fileId, containsUserMigrationTask, cloudId);
            if (exportType.equals((Object)ExportType.ORIGINAL) || exportType.equals((Object)ExportType.XML_TO_CSV)) {
                Path exportedFilePath = Paths.get(exportedFile, new String[0]);
                this.spaceExportPostProcessor.postprocess(exportedFilePath, spaceKey, planId, taskId, containsUserMigrationTask);
                log.info("Exporting space for spaceKey: {} planId: {} migrationId: {}", new Object[]{spaceKey, planId, migrationId});
                List<String> invalidEmailsResult = this.spaceExportEmailValidatorPostProcessor.postprocess(exportedFilePath);
                if (!invalidEmailsResult.isEmpty()) {
                    String emails = String.join((CharSequence)",", invalidEmailsResult);
                    log.error("Space export failed during email validation for space key: {} with invalid emails: {} for migrationId: {}", new Object[]{spaceKey, emails, migrationId});
                    success = this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_INVALID_EMAILS, exportType, migrationId, cloudId, MigrationErrorCode.SPACE_EXPORT_INVALID_EMAILS.getMessage());
                    StepResult stepResult2 = StepResult.failed(String.format("Space export failed for %s, %d invalid email(s) found in space. Check the Confluence log file for more details.", spaceKey, invalidEmailsResult.size()));
                    return stepResult2;
                }
                this.spaceExportCustomContentEntityPostProcessor.postprocess(exportedFilePath, Collections.singletonList("com.atlassian"));
                this.aaidPopulatorPostProcessor.postprocess(planId, exportedFilePath);
                this.inlineTasksPostprocessor.postprocess(exportedFilePath, containsUserMigrationTask);
            }
            if (!this.migrationDarkFeaturesManager.isExportOnlyEnabled()) {
                if (exportType.equals((Object)ExportType.XML_TO_CSV)) {
                    long conversionStartTime = this.instantSupplier.get().toEpochMilli();
                    try {
                        log.info("Preparing to convert export files to compressed files {} for migrationId: {}", (Object)exportedFile, (Object)migrationId);
                        String xmlConversionDir = this.csvConverterService.convertXMLtoCSV(exportedFile, spaceKey);
                        log.info("XmlToCSV conversion output directory: {}", (Object)xmlConversionDir);
                        this.exportDirManager.moveCompressedFilesToSharedHome(xmlConversionDir, fileId);
                        this.buildAndSaveConversionTimerEvent(true, this.instantSupplier.get().toEpochMilli() - conversionStartTime, spaceKey, planId, taskId);
                    }
                    catch (Exception ex) {
                        log.error("Unable to convert xml to csv for migrationId: {} with ex: {}", (Object)migrationId, (Object)ex);
                        this.buildAndSaveConversionTimerEvent(false, this.instantSupplier.get().toEpochMilli() - conversionStartTime, spaceKey, planId, taskId);
                        success = this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.XML_TO_CSV_CONVERSION_ERROR, exportType, migrationId, cloudId, ex.getMessage());
                        StepResult stepResult3 = StepResult.failed(String.format("Failed to export %s. Error: %s", exportStepConfig, ex.getMessage()), ex);
                        ImmutableMap additionalAttributes = ImmutableMap.of((Object)"stepSuccessful", (Object)String.valueOf(success), (Object)"exportType", (Object)exportType.name());
                        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.lambda$exportProcessor$5(step, (Map)additionalAttributes));
                        this.buildAndSaveStepTimerEvent(success, this.instantSupplier.get().toEpochMilli() - startTime, spaceKey, planId, taskId, exportType);
                        return stepResult3;
                    }
                } else if (exportType.equals((Object)ExportType.RAPID)) {
                    log.info("Moving csv files in {} to {} inside migration exports directory for migrationId: {}", new Object[]{exportedFile, fileId, migrationId});
                    this.exportDirManager.moveCompressedFilesToSharedHome(exportedFile, fileId);
                } else {
                    log.info("Export file {} will be moved to {} for migrationId: {}", new Object[]{exportedFile, fileId, migrationId});
                    this.exportDirManager.moveExportedFileToSharedHome(exportedFile, fileId);
                }
            }
            this.buildAndSaveMetricsWhenStepSucceeds(exportType);
            success = true;
            log.info("Space export successful for spaceKey: {} planId: {} migrationId: {}", new Object[]{spaceKey, planId, migrationId});
            StepResult conversionStartTime = StepResult.succeeded("Data export successful", fileId);
            return conversionStartTime;
        }
        catch (UncheckedInterruptedException | InterruptedException ex) {
            success = this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_INTERRUPTED, exportType, migrationId, cloudId, ex.getMessage());
            if (this.migrationDarkFeaturesManager.isSchedulerFixEnabled()) {
                stepResult = StepResult.stopped();
                return stepResult;
            }
            stepResult = this.failedStepResult(ex, migrationId, exportStepConfig, MigrationErrorCode.SPACE_EXPORT_INTERRUPTED);
            return stepResult;
        }
        catch (MigrationExportException ex) {
            success = this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_FILE_EXPORT_FAILED, exportType, migrationId, cloudId, ex.getMessage());
            stepResult = this.failedStepResult(ex, migrationId, exportStepConfig, MigrationErrorCode.SPACE_EXPORT_FILE_EXPORT_FAILED);
            return stepResult;
        }
        catch (ServiceInitializeException ex) {
            success = this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_DIRECTORY_CREATION_FAILED, exportType, migrationId, cloudId, ex.getMessage());
            stepResult = this.failedStepResult(ex, migrationId, exportStepConfig, MigrationErrorCode.SPACE_EXPORT_DIRECTORY_CREATION_FAILED);
            return stepResult;
        }
        catch (Exception ex) {
            success = this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_EXECUTION_ERROR, exportType, migrationId, cloudId, ex.getMessage());
            stepResult = this.failedStepResult(ex, migrationId, exportStepConfig, MigrationErrorCode.SPACE_EXPORT_EXECUTION_ERROR);
            return stepResult;
        }
        finally {
            ImmutableMap additionalAttributes = ImmutableMap.of((Object)"stepSuccessful", (Object)String.valueOf(success), (Object)"exportType", (Object)exportType.name());
            this.analyticsEventService.saveAnalyticsEventAsync(() -> this.lambda$exportProcessor$5(step, (Map)additionalAttributes));
            this.buildAndSaveStepTimerEvent(success, this.instantSupplier.get().toEpochMilli() - startTime, spaceKey, planId, taskId, exportType);
        }
    }

    private String exportedFileGenerator(String spaceKey, String planId, String taskId, String fileId, boolean containsUserMigrationTask, String cloudId) throws ExecutionException, InterruptedException {
        ExportType exportType = this.getExportType();
        Space space = this.spaceManager.getSpace(spaceKey);
        if (this.migrationDarkFeaturesManager.exportCachingEnabled()) {
            return this.exportSpaceContentViaCache(space.getId(), spaceKey, planId, taskId, fileId, exportType, containsUserMigrationTask, cloudId);
        }
        return this.exportSpaceContentToFile(space.getId(), spaceKey, planId, taskId, fileId, exportType, containsUserMigrationTask, cloudId);
    }

    private StepResult failedStepResult(Exception ex, String migrationId, ConfExportStepConfig exportStepConfig, MigrationErrorCode errorCode) {
        log.error("{} with exception: {} for migrationId: {}", new Object[]{errorCode.getMessage(), ex, migrationId});
        if (errorCode.equals((Object)MigrationErrorCode.SPACE_EXPORT_INTERRUPTED)) {
            return StepResult.failed(String.format("Export of %s was interrupted", exportStepConfig), ex);
        }
        return StepResult.failed(String.format("Failed to export %s. Error: %s", exportStepConfig, ex.getMessage()), ex.getCause());
    }

    protected String exportSpaceContentViaCache(long spaceId, String spaceKey, String planId, String taskId, String fileId, ExportType exportType, boolean containsUserMigrationTask, String cloudId) throws ExecutionException, InterruptedException {
        Optional<ExportCacheEntry> maybeCachedValue = this.cacheService.getCacheEntry(spaceKey, exportType, containsUserMigrationTask, cloudId);
        if (maybeCachedValue.isPresent()) {
            ExportCacheEntry cachedValue = maybeCachedValue.get();
            log.info("Using cached export id: {} file: {}", (Object)cachedValue.getId(), (Object)cachedValue.getFilePath());
            return this.copyCachedFileToTmpDir(spaceKey, fileId, cachedValue.getFilePath()).toString();
        }
        return this.generateAndCacheExportFile(spaceId, spaceKey, planId, taskId, fileId, exportType, containsUserMigrationTask, cloudId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String exportSpaceContentToFile(long spaceId, String spaceKey, String planId, String taskId, String fileId, ExportType exportType, boolean containsUserMigrationTask, String cloudId) throws ExecutionException, InterruptedException {
        String exportedFile;
        if (exportType.equals((Object)ExportType.RAPID)) {
            ConfluenceRapidExporter.CSVExportTaskContext config = new ConfluenceRapidExporter.CSVExportTaskContext(spaceId, spaceKey, cloudId, planId, taskId, this.tempDirFilePath.getAbsolutePath(), containsUserMigrationTask);
            exportedFile = this.confluenceRapidExporter.export(config);
            this.createExportDirectoryIfNotExists();
        } else {
            try {
                this.attachmentService.prepareMigratedAttachmentsForExport(spaceKey, cloudId);
                exportedFile = this.spaceNoAttachmentsXmlExporter.doExport(spaceKey, fileId).get();
            }
            finally {
                this.attachmentService.cleanMigratedAttachmentsAfterExport(spaceKey, cloudId);
            }
        }
        return exportedFile;
    }

    private String generateAndCacheExportFile(long spaceId, String spaceKey, String planId, String taskId, String fileId, ExportType exportType, boolean containsUserMigrationTask, String cloudId) throws ExecutionException, InterruptedException {
        long now = Instant.now(this.clock).toEpochMilli();
        log.info("Generating export file for fileId={} spaceKey={}, exportType={}, containsUserMigrationTask={}, snapshotTime={}", new Object[]{fileId, spaceKey, exportType, containsUserMigrationTask, now});
        String localFilePath = this.exportSpaceContentToFile(spaceId, spaceKey, planId, taskId, fileId, exportType, containsUserMigrationTask, cloudId);
        String cacheFilePath = this.exportDirManager.copyExportedFileToSharedHome(localFilePath, fileId + CACHE_FILENAME_SUFFIX);
        this.cacheService.cacheExportData(now, exportType, spaceKey, cloudId, containsUserMigrationTask, cacheFilePath);
        return localFilePath;
    }

    private Path copyCachedFileToTmpDir(String spaceKey, String fileId, String cachedFile) {
        try {
            String exportDir = FileUtil.createExportDirectory(spaceKey, this.tempDirFilePath.getAbsolutePath());
            Path destinationPath = Paths.get(exportDir, new String[0]).resolve(fileId);
            Files.copy(Paths.get(cachedFile, new String[0]), destinationPath, new CopyOption[0]);
            return destinationPath;
        }
        catch (IOException e) {
            throw new MigrationExportException("Unable to copy cached file to tmp dir", e);
        }
    }

    @VisibleForTesting
    ExportType getExportType() {
        if (this.migrationDarkFeaturesManager.isEnableOriginalXMLExport()) {
            return ExportType.ORIGINAL;
        }
        if (this.migrationAgentConfiguration.isDBTypeSupportedForRapidExport() || this.migrationDarkFeaturesManager.newExportEnabled()) {
            return ExportType.RAPID;
        }
        if (this.migrationDarkFeaturesManager.isXMLToCSVAndUploadToMCSEnabled()) {
            return ExportType.XML_TO_CSV;
        }
        return ExportType.ORIGINAL;
    }

    private <T extends Task> boolean containsTask(Plan plan, Class<T> type) {
        return plan.getTasks().stream().anyMatch(type::isInstance);
    }

    private void createExportDirectoryIfNotExists() {
        Path dir = Paths.get(this.bootstrapManager.getSharedHome().getAbsolutePath(), "migration", "exports");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("Failed to create export directory: " + dir, (Throwable)e);
            throw new ServiceInitializeException("Failed to create export directory", e);
        }
    }

    private boolean checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode migrationErrorCode, ExportType exportType, String migrationId, String cloudId, String message) {
        boolean isSloGoodEvent = migrationErrorCode.shouldBeTreatedAsGoodEventInReliabilitySlo();
        ErrorEvent errorEvent = new ErrorEvent.ErrorEventBuilder(migrationErrorCode, migrationErrorCode.getContainerType(), migrationId, EXPORT_STEP_TYPE).setCloudid(cloudId).setReason(message).build();
        ImmutableList events = ImmutableList.of((Object)this.analyticsEventBuilder.buildFailedSpaceMigration(EXPORT_STEP_TYPE, migrationErrorCode), (Object)this.analyticsEventBuilder.buildExportStepCounterEvent(exportType, isSloGoodEvent), (Object)this.analyticsEventBuilder.buildErrorOperationalEvent(errorEvent));
        this.analyticsEventService.sendAnalyticsEvents(() -> SpaceExportExecutor.lambda$checkIfGoodEventAndSaveAnalyticEventsWhenStepFails$6((List)events));
        return isSloGoodEvent;
    }

    private void buildAndSaveMetricsWhenStepSucceeds(ExportType exportType) {
        this.analyticsEventService.sendAnalyticsEvents(() -> ImmutableList.of((Object)this.analyticsEventBuilder.buildExportStepCounterEvent(exportType, true)));
    }

    private void buildAndSaveConversionTimerEvent(boolean success, long duration, String spaceKey, String planId, String taskId) {
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildXMLToCSVConversionTimerEvent(success, duration, spaceKey, planId, taskId));
    }

    private void buildAndSaveStepTimerEvent(boolean success, long duration, String spaceKey, String planId, String taskId, ExportType exportType) {
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildSpaceExportStepTimerEvent(success, duration, spaceKey, planId, taskId, exportType));
    }

    @Override
    public StepType getStepType() {
        return StepType.CONFLUENCE_EXPORT;
    }

    @Override
    public StepResult runStep(String stepId) {
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        return this.doExport(step.getConfig(), step.getId());
    }

    private static /* synthetic */ Collection lambda$checkIfGoodEventAndSaveAnalyticEventsWhenStepFails$6(List events) {
        return events;
    }

    private /* synthetic */ EventDto lambda$exportProcessor$5(Step step, Map additionalAttributes) {
        return this.analyticsEventBuilder.buildCompletedStepAnalyticsEvent(step, () -> additionalAttributes);
    }
}

