/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.newexport;

import com.atlassian.migration.agent.newexport.DbType;
import com.atlassian.migration.agent.newexport.Query;
import com.atlassian.migration.agent.newexport.TemplatedQueries;
import com.atlassian.migration.agent.newexport.TemplatedQuery;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Map;

class Queries {
    private static final String CREATOR = "creator";
    private static final String LAST_MODIFIER = "lastmodifier";
    private static final String USERNAME = "username";
    static final TemplatedQuery CREATE_CONTENT_ID_TABLE_QUERY = new TemplatedQuery("create table %s(id bigint primary key);", (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.ORACLE), (Object)"create table %s(id number primary key)"));
    static final TemplatedQuery POPULATE_CONTENT_ID_TABLE_QUERY = new TemplatedQuery("insert into %s (id) select CONTENTID\nfrom CONTENT c1\nwhere c1.SPACEID = :spaceid\nunion\nselect CONTENTID\nfrom CONTENT\nwhere CONTENTTYPE = 'COMMENT'\n  and PAGEID in (select CONTENTID from CONTENT where SPACEID = :spaceid)\nunion\nselect CONTENTID\nfrom CONTENT\nwhere PAGEID in (select CONTENTID\n                 from CONTENT\n                 where CONTENTTYPE = 'COMMENT'\n                   and PAGEID in (select CONTENTID from CONTENT where SPACEID = :spaceid))\nunion\nselect CONTENTID\nfrom CONTENT\nwhere SPACEID is null\n  and PREVVER in (select CONTENTID from CONTENT where SPACEID = :spaceid)\nunion\nselect CONTENTID\nfrom CONTENT\nwhere CONTENTTYPE = 'COMMENT'\n  and PREVVER in (select CONTENTID\n                  from CONTENT\n                  where CONTENTTYPE = 'COMMENT'\n                    and PAGEID in (select CONTENTID from CONTENT where SPACEID = :spaceid))\n");
    static final TemplatedQuery DROP_CONTENT_ID_TABLE_QUERY = new TemplatedQuery("DROP TABLE IF EXISTS %s", (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.ORACLE), (Object)"DROP TABLE %s"));
    static final Query[] spaceIdQueries = new Query[]{new Query("select SPACEKEY, SPACEID, SPACENAME, CREATOR, CREATIONDATE, LOWERSPACEKEY, SPACETYPE, LASTMODIFIER, SPACESTATUS, LASTMODDATE, SPACEDESCID, HOMEPAGE\nfrom SPACES where SPACEID = :spaceid", "SPACES", "spaces", Lists.newArrayList((Object[])new String[]{"creator", "lastmodifier"})), new Query("select PERMID, SPACEID, PERMTYPE, PERMGROUPNAME, PERMUSERNAME, CREATOR, CREATIONDATE, LASTMODIFIER, LASTMODDATE, PERMALLUSERSSUBJECT, '' AS EXTERNALGROUPID from SPACEPERMISSIONS where SPACEID = :spaceid", "SPACEPERMISSIONS", "spacepermissions", Lists.newArrayList((Object[])new String[]{"permusername", "creator", "lastmodifier"})), new Query("select CREATOR, CREATIONDATE, LASTMODIFIER, PLUGINKEY, TEMPLATEID, LASTMODDATE, VERSION, MODULEKEY, CONTENT, TEMPLATEDESC, SPACEID, REFMODULEKEY, BODYTYPEID, REFPLUGINKEY, PREVVER, TEMPLATENAME, HIBERNATEVERSION\n from PAGETEMPLATES where SPACEID = :spaceid", "PAGETEMPLATES", "pagetemplates", Lists.newArrayList((Object[])new String[]{"creator", "lastmodifier"}))};
    static final TemplatedQueries spaceKeyQueries = new TemplatedQueries(new TemplatedQuery("select * from BANDANA where BANDANACONTEXT = :spaceKey", "BANDANA", "bandana"));
    static final TemplatedQueries AO187_QUERY = new TemplatedQueries(new TemplatedQuery("select * from \"AO_187CCC_SIDEBAR_LINK\" where \"SPACE_KEY\" = :spaceKey", "AO_187CCC_SIDEBAR_LINK", "AO_187CCC_SIDEBAR_LINK", Collections.emptyList(), true, (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.MYSQL), (Object)"select * from AO_187CCC_SIDEBAR_LINK where SPACE_KEY = :spaceKey")));
    private static final String defaultContentQuery = "select PROPERTYID, PROPERTYNAME, STRINGVAL, LONGVAL, DATEVAL, CONTENTID\nfrom CONTENTPROPERTIES\nwhere exists(select 1 from %s c where c.id = CONTENTID)\nunion\nselect (select max(PROPERTYID) from CONTENTPROPERTIES) + ma.attachmentId as PROPERTYID,\n       'FILESTORE_ID'                                                    as PROPERTYNAME,\n       ma.mediaId                                                        as STRINGVAL,\n       null                                                              as LONGVAL,\n       null                                                              as DATEVAL,\n       ma.attachmentId                                                   as CONTENTID\nfrom MIG_ATTACHMENT ma inner join CONTENT c on c.CONTENTID = ma.attachmentId\nwhere ma.cloudId = :cloudid\n  and c.SPACEID = :spaceid\n  and ma.mediaId is not null;";
    private static final String contentQueryForOracle = "select PROPERTYID, to_char(PROPERTYNAME) as PROPERTYNAME, to_char(STRINGVAL) AS STRINGVAL, LONGVAL, DATEVAL, CONTENTID\nfrom CONTENTPROPERTIES\nwhere exists(select 1 from %s c where c.id = CONTENTID)\nunion\nselect (select max(PROPERTYID) from CONTENTPROPERTIES) + ma.attachmentId as PROPERTYID,\n       to_char('FILESTORE_ID')                                           as PROPERTYNAME,\n       to_char(ma.mediaId)                                               as STRINGVAL,\n       null                                                              as LONGVAL,\n       null                                                              as DATEVAL,\n       ma.attachmentId                                                   as CONTENTID\nfrom MIG_ATTACHMENT ma inner join CONTENT c on c.CONTENTID = ma.attachmentId\nwhere ma.cloudId = :cloudid\n  and c.SPACEID = :spaceid\n  and ma.mediaId is not null";
    private static final String CONTENT_QUERY_FOR_MYSQL = "select PROPERTYID, PROPERTYNAME, STRINGVAL, LONGVAL, DATEVAL, CONTENTID\nfrom CONTENTPROPERTIES\nwhere CONTENTID in (select * from %s)\nunion\nselect (select max(PROPERTYID) from CONTENTPROPERTIES) + ma.attachmentId as PROPERTYID,\n       'FILESTORE_ID'                                                    as PROPERTYNAME,\n       ma.mediaId                                                        as STRINGVAL,\n       null                                                              as LONGVAL,\n       null                                                              as DATEVAL,\n       ma.attachmentId                                                   as CONTENTID\nfrom MIG_ATTACHMENT ma inner join CONTENT c on c.CONTENTID = ma.attachmentId\nwhere ma.cloudId = :cloudid\n  and c.SPACEID = :spaceid\n  and ma.mediaId is not null;";
    static final TemplatedQueries contentQueries = new TemplatedQueries(new TemplatedQuery("select PROPERTYID, PROPERTYNAME, STRINGVAL, LONGVAL, DATEVAL, CONTENTID\nfrom CONTENTPROPERTIES\nwhere exists(select 1 from %s c where c.id = CONTENTID)\nunion\nselect (select max(PROPERTYID) from CONTENTPROPERTIES) + ma.attachmentId as PROPERTYID,\n       'FILESTORE_ID'                                                    as PROPERTYNAME,\n       ma.mediaId                                                        as STRINGVAL,\n       null                                                              as LONGVAL,\n       null                                                              as DATEVAL,\n       ma.attachmentId                                                   as CONTENTID\nfrom MIG_ATTACHMENT ma inner join CONTENT c on c.CONTENTID = ma.attachmentId\nwhere ma.cloudId = :cloudid\n  and c.SPACEID = :spaceid\n  and ma.mediaId is not null;", "CONTENTPROPERTIES", "contentproperties", Collections.emptyList(), false, (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.ORACLE), (Object)"select PROPERTYID, to_char(PROPERTYNAME) as PROPERTYNAME, to_char(STRINGVAL) AS STRINGVAL, LONGVAL, DATEVAL, CONTENTID\nfrom CONTENTPROPERTIES\nwhere exists(select 1 from %s c where c.id = CONTENTID)\nunion\nselect (select max(PROPERTYID) from CONTENTPROPERTIES) + ma.attachmentId as PROPERTYID,\n       to_char('FILESTORE_ID')                                           as PROPERTYNAME,\n       to_char(ma.mediaId)                                               as STRINGVAL,\n       null                                                              as LONGVAL,\n       null                                                              as DATEVAL,\n       ma.attachmentId                                                   as CONTENTID\nfrom MIG_ATTACHMENT ma inner join CONTENT c on c.CONTENTID = ma.attachmentId\nwhere ma.cloudId = :cloudid\n  and c.SPACEID = :spaceid\n  and ma.mediaId is not null", (Object)((Object)DbType.MYSQL), (Object)"select PROPERTYID, PROPERTYNAME, STRINGVAL, LONGVAL, DATEVAL, CONTENTID\nfrom CONTENTPROPERTIES\nwhere CONTENTID in (select * from %s)\nunion\nselect (select max(PROPERTYID) from CONTENTPROPERTIES) + ma.attachmentId as PROPERTYID,\n       'FILESTORE_ID'                                                    as PROPERTYNAME,\n       ma.mediaId                                                        as STRINGVAL,\n       null                                                              as LONGVAL,\n       null                                                              as DATEVAL,\n       ma.attachmentId                                                   as CONTENTID\nfrom MIG_ATTACHMENT ma inner join CONTENT c on c.CONTENTID = ma.attachmentId\nwhere ma.cloudId = :cloudid\n  and c.SPACEID = :spaceid\n  and ma.mediaId is not null;")), new TemplatedQuery("select * from CONTENT_PERM_SET where exists (select 1 from %s c where c.id = CONTENT_ID)", "CONTENT_PERM_SET", "content_perm_set"));
    static final TemplatedQueries contentQueriesLegacyTables = new TemplatedQueries(new TemplatedQuery("select * from EXTRNLNKS where exists (select 1 from %s c where c.id = CONTENTID)", "EXTRNLNKS", "extrnlnks", Lists.newArrayList((Object[])new String[]{"creator", "lastmodifier"})), new TemplatedQuery("select * from TRACKBACKLINKS where exists (select 1 from %s c where c.id = CONTENTID)", "TRACKBACKLINKS", "trackbacklinks", Lists.newArrayList((Object[])new String[]{"creator", "lastmodifier"})));
    static final TemplatedQueries osPropertyQuery = new TemplatedQueries(new TemplatedQuery("select * from OS_PROPERTYENTRY where entity_name = 'confluence_ContentEntityObject' and exists (select 1 from %s c where c.id = entity_id)", "OS_PROPERTYENTRY", "os_propertyentry", Collections.emptyList(), false, (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.MYSQL), (Object)"select * from OS_PROPERTYENTRY where entity_name = 'confluence_ContentEntityObject' and entity_id in (select id from %s)")));
    private static final String DEFAULT_CONTENT_TABLE_QUERY = "select CREATIONDATE,\n       LASTMODIFIER,\n       CONTENT_STATUS,\n       DRAFTPAGEVERSION,\n       TITLE,\n       case when PAGEID is not null and exists(select 1 from %1$s c where c.id = PAGEID) then PAGEID end as PAGEID,\n       case when PARENTID is not null and exists(select 1 from %1$s c where c.id = PARENTID) then PARENTID end as PARENTID,\n       CHILD_POSITION,\n       case when PARENTCCID is not null and exists(select 1 from %1$s c where c.id = PARENTCCID) then PARENTCCID end as PARENTCCID,\n       case when PREVVER is not null and exists(select 1 from %1$s c where c.id = PREVVER) then PREVVER end as PREVVER,\n       HIBERNATEVERSION,\n       CREATOR,\n       DRAFTPAGEID,\n       CONTENTID,\n       case when PLUGINKEY Like 'com.atlassian%%' then PLUGINKEY when PLUGINKEY is not null then CONCAT('ac:', PLUGINKEY) else PLUGINKEY END AS PLUGINKEY,\n       LASTMODDATE,\n       VERSION,\n       CONTENTTYPE,\n       VERSIONCOMMENT,\n       SPACEID,\n       LOWERTITLE,\n       case when PARENTCOMMENTID is not null and exists(select 1 from %1$s c where c.id = PARENTCOMMENTID) then PARENTCOMMENTID end as PARENTCOMMENTID,\n       PLUGINVER,\n       DRAFTSPACEKEY,\n       DRAFTTYPE,\n       USERNAME\nfrom CONTENT\nwhere exists(select 1 from %1$s c where c.id = CONTENTID)";
    static final String CONTENT_TABLE_QUERY_FOR_MYSQL = "select CREATIONDATE,\n       LASTMODIFIER,\n       CONTENT_STATUS,\n       DRAFTPAGEVERSION,\n       TITLE,\n       case when PAGEID is not null and exists(select 1 from %1$s c where c.id = PAGEID) then PAGEID end as PAGEID,\n       case when PARENTID is not null and exists(select 1 from %1$s c where c.id = PARENTID) then PARENTID end as PARENTID,\n       CHILD_POSITION,\n       case when PARENTCCID is not null and exists(select 1 from %1$s c where c.id = PARENTCCID) then PARENTCCID end as PARENTCCID,\n       case when PREVVER is not null and exists(select 1 from %1$s c where c.id = PREVVER) then PREVVER end as PREVVER,\n       HIBERNATEVERSION,\n       CREATOR,\n       DRAFTPAGEID,\n       CONTENTID,\n       case when PLUGINKEY Like 'com.atlassian%%' then PLUGINKEY when PLUGINKEY is not null then CONCAT('ac:', PLUGINKEY) else PLUGINKEY END AS PLUGINKEY,\n       LASTMODDATE,\n       VERSION,\n       CONTENTTYPE,\n       VERSIONCOMMENT,\n       SPACEID,\n       LOWERTITLE,\n       case when PARENTCOMMENTID is not null and exists(select 1 from %1$s c where c.id = PARENTCOMMENTID) then PARENTCOMMENTID end as PARENTCOMMENTID,\n       PLUGINVER,\n       DRAFTSPACEKEY,\n       DRAFTTYPE,\n       USERNAME\nfrom CONTENT\nwhere CONTENTID in (select * from %1$s)";
    static final TemplatedQueries contentQueriesWithUserKeys = new TemplatedQueries(new TemplatedQuery("select * from LABEL where LABELID in (select LABELID from CONTENT_LABEL where exists (select 1 from %s c where c.id = CONTENTID) or PAGETEMPLATEID in (select TEMPLATEID from PAGETEMPLATES where SPACEID = :spaceid))", "LABEL", "label", Lists.newArrayList((Object[])new String[]{"owner"})), new TemplatedQuery("select SPACEID, CREATOR, CREATIONDATE, LABELID, LASTMODIFIER, CONTENTID, DIGEST, NOTIFICATIONID, LASTMODDATE, USERNAME, NETWORK, CONTENTTYPE\nfrom NOTIFICATIONS where SPACEID = :spaceid or exists (select 1 from %s c where c.id = CONTENTID)", "NOTIFICATIONS", "notifications", Lists.newArrayList((Object[])new String[]{"username", "creator", "lastmodifier"})), new TemplatedQuery("select * from LIKES where exists (select 1 from %s c where c.id = CONTENTID)", "LIKES", "likes", Lists.newArrayList((Object[])new String[]{"username"})), new TemplatedQuery("select * from USERCONTENT_RELATION where exists (select 1 from %s c where c.id = TARGETCONTENTID)", "USERCONTENT_RELATION", "usercontent_relation", Lists.newArrayList((Object[])new String[]{"sourceuser", "creator", "lastmodifier"}), false, (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.MYSQL), (Object)"select * from USERCONTENT_RELATION where TARGETCONTENTID in (select * from %s)")), new TemplatedQuery("select CONTENT_RELATION.* from CONTENT_RELATION inner join %1$s c1 on c1.id = CONTENT_RELATION.TARGETCONTENTID inner join %1$s c2 on c2.id = CONTENT_RELATION.SOURCECONTENTID", "CONTENT_RELATION", "content_relation", Lists.newArrayList((Object[])new String[]{"creator", "lastmodifier"})), new TemplatedQuery("select OWNER, CREATIONDATE, LABELID, CONTENTID, LABELABLETYPE, ID, LASTMODDATE, LABELABLEID, PAGETEMPLATEID\nfrom CONTENT_LABEL where exists (select 1 from %s c where c.id = CONTENTID) or PAGETEMPLATEID in (select TEMPLATEID from PAGETEMPLATES where SPACEID = :spaceid)", "CONTENT_LABEL", "content_label", Lists.newArrayList((Object[])new String[]{"owner"})), new TemplatedQuery("select CREATIONDATE,\n       LASTMODIFIER,\n       CONTENT_STATUS,\n       DRAFTPAGEVERSION,\n       TITLE,\n       case when PAGEID is not null and exists(select 1 from %1$s c where c.id = PAGEID) then PAGEID end as PAGEID,\n       case when PARENTID is not null and exists(select 1 from %1$s c where c.id = PARENTID) then PARENTID end as PARENTID,\n       CHILD_POSITION,\n       case when PARENTCCID is not null and exists(select 1 from %1$s c where c.id = PARENTCCID) then PARENTCCID end as PARENTCCID,\n       case when PREVVER is not null and exists(select 1 from %1$s c where c.id = PREVVER) then PREVVER end as PREVVER,\n       HIBERNATEVERSION,\n       CREATOR,\n       DRAFTPAGEID,\n       CONTENTID,\n       case when PLUGINKEY Like 'com.atlassian%%' then PLUGINKEY when PLUGINKEY is not null then CONCAT('ac:', PLUGINKEY) else PLUGINKEY END AS PLUGINKEY,\n       LASTMODDATE,\n       VERSION,\n       CONTENTTYPE,\n       VERSIONCOMMENT,\n       SPACEID,\n       LOWERTITLE,\n       case when PARENTCOMMENTID is not null and exists(select 1 from %1$s c where c.id = PARENTCOMMENTID) then PARENTCOMMENTID end as PARENTCOMMENTID,\n       PLUGINVER,\n       DRAFTSPACEKEY,\n       DRAFTTYPE,\n       USERNAME\nfrom CONTENT\nwhere exists(select 1 from %1$s c where c.id = CONTENTID)", "CONTENT", "content", Lists.newArrayList((Object[])new String[]{"creator", "lastmodifier", "username"}), false, (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.MYSQL), (Object)"select CREATIONDATE,\n       LASTMODIFIER,\n       CONTENT_STATUS,\n       DRAFTPAGEVERSION,\n       TITLE,\n       case when PAGEID is not null and exists(select 1 from %1$s c where c.id = PAGEID) then PAGEID end as PAGEID,\n       case when PARENTID is not null and exists(select 1 from %1$s c where c.id = PARENTID) then PARENTID end as PARENTID,\n       CHILD_POSITION,\n       case when PARENTCCID is not null and exists(select 1 from %1$s c where c.id = PARENTCCID) then PARENTCCID end as PARENTCCID,\n       case when PREVVER is not null and exists(select 1 from %1$s c where c.id = PREVVER) then PREVVER end as PREVVER,\n       HIBERNATEVERSION,\n       CREATOR,\n       DRAFTPAGEID,\n       CONTENTID,\n       case when PLUGINKEY Like 'com.atlassian%%' then PLUGINKEY when PLUGINKEY is not null then CONCAT('ac:', PLUGINKEY) else PLUGINKEY END AS PLUGINKEY,\n       LASTMODDATE,\n       VERSION,\n       CONTENTTYPE,\n       VERSIONCOMMENT,\n       SPACEID,\n       LOWERTITLE,\n       case when PARENTCOMMENTID is not null and exists(select 1 from %1$s c where c.id = PARENTCOMMENTID) then PARENTCOMMENTID end as PARENTCOMMENTID,\n       PLUGINVER,\n       DRAFTSPACEKEY,\n       DRAFTTYPE,\n       USERNAME\nfrom CONTENT\nwhere CONTENTID in (select * from %1$s)")), new TemplatedQuery("select * from LINKS where exists (select 1 from %s c where c.id = CONTENTID)", "LINKS", "links", Lists.newArrayList((Object[])new String[]{"creator", "lastmodifier"}), false, (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.MYSQL), (Object)"select * from LINKS where CONTENTID in (select * from %s)")), new TemplatedQuery("select * from CONTENT_PERM where CPS_ID in (select ID from CONTENT_PERM_SET where exists (select 1 from %s c where c.id = CONTENT_ID))", "CONTENT_PERM", "content_perm", Lists.newArrayList((Object[])new String[]{"username", "creator", "lastmodifier"})));
    static final TemplatedQueries AOBAF3AA_QUERY = new TemplatedQueries(new TemplatedQuery("select * from \"AO_BAF3AA_AOINLINE_TASK\" where exists (select 1 from %s c where c.id = \"CONTENT_ID\")", "AO_BAF3AA_AOINLINE_TASK", "AO_BAF3AA_AOINLINE_TASK", Lists.newArrayList((Object[])new String[]{"assignee_user_key", "complete_user_key", "creator_user_key"}), true, (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.MYSQL), (Object)"select * from AO_BAF3AA_AOINLINE_TASK where CONTENT_ID in (select * from %s)")));
    static final TemplatedQueries bodycontentQueriesWithUsersInContent = new TemplatedQueries(new TemplatedQuery("select * from BODYCONTENT where exists (select 1 from %s c where c.id = CONTENTID)", "BODYCONTENT", "bodycontent", Collections.emptyList(), false, (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.MYSQL), (Object)"select * from BODYCONTENT where CONTENTID in (select * from %s)")));
    static final String userMappingsQueryStringForSqlServer = "select user_key as lower_username,\n       user_key,\n       (select TOP 1 email_address\n        from cwd_user\n                 inner join cwd_directory cd on cd.id = cwd_user.directory_id\n        where cwd_user.lower_user_name = user_mapping.lower_username\n          and cd.active = 'T'\n        order by cwd_user.updated_date desc\n        ) as email,\n       user_key as username\nfrom user_mapping\nwhere %s";
    static final String defaultUseMappingsQueryString = "select user_key as lower_username,\n       user_key,\n       (select email_address\n        from cwd_user\n                 inner join cwd_directory cd on cd.id = cwd_user.directory_id\n        where cwd_user.lower_user_name = user_mapping.lower_username\n          and cd.active = 'T'\n        order by cwd_user.updated_date desc\n        limit 1) as email,\n       user_key as username\nfrom user_mapping\nwhere %s";
    static final String userMappingsQueryForOracle = "select user_key as lower_username,\n       user_key,\n       (select email_address\n        from cwd_user\n                 inner join cwd_directory cd on cd.id = cwd_user.directory_id\n        where cwd_user.lower_user_name = user_mapping.lower_username\n          and cd.active = 'T'\n        order by cwd_user.updated_date desc\n        FETCH FIRST 1 ROWS ONLY) as email,\n       user_key as username\nfrom user_mapping\nwhere %s";

    private Queries() {
    }

    static String userMappingsQueryString(DbType dbType) {
        switch (dbType) {
            case MSSQL: {
                return userMappingsQueryStringForSqlServer;
            }
            case ORACLE: {
                return userMappingsQueryForOracle;
            }
        }
        return defaultUseMappingsQueryString;
    }
}

