/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.media.impl;

import com.atlassian.migration.agent.media.ClientId;
import com.atlassian.migration.agent.media.CreateFileOptions;
import com.atlassian.migration.agent.media.Entity;
import com.atlassian.migration.agent.media.Etag;
import com.atlassian.migration.agent.media.MediaApiClient;
import com.atlassian.migration.agent.media.Upload;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.RetryPolicy;

public class RetryingMediaApiClient
implements MediaApiClient {
    private final MediaApiClient wrapped;
    private final RetryPolicy retryPolicy;

    RetryingMediaApiClient(MediaApiClient wrapped) {
        this(wrapped, RetryPolicyBuilder.mediaRateLimitPolicy().build());
    }

    @VisibleForTesting
    RetryingMediaApiClient(MediaApiClient wrapped, RetryPolicy baseRetryPolicy) {
        this.wrapped = wrapped;
        this.retryPolicy = baseRetryPolicy;
    }

    @Override
    @Nonnull
    public ClientId createClient(String title, String description) {
        return (ClientId)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.createClient(title, description));
    }

    @Override
    @Nonnull
    public Etag uploadChunk(ByteBuffer data, String uploadId, String partNumber) {
        return (Etag)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> {
            data.rewind();
            return this.wrapped.uploadChunk(data, uploadId, partNumber);
        });
    }

    @Override
    @Nonnull
    public Optional<Upload> createUpload() {
        RetryPolicy policy = this.retryPolicy.copy().retryIf(upload -> upload != null && !upload.isPresent());
        return (Optional)Failsafe.with((RetryPolicy)policy).get(this.wrapped::createUpload);
    }

    @Override
    public void updateUpload(String uploadId, int offset, List<Etag> etags) {
        Failsafe.with((RetryPolicy)this.retryPolicy).run(() -> this.wrapped.updateUpload(uploadId, offset, etags));
    }

    @Override
    @Nonnull
    public Entity createFileFromUpload(String uploadId, @Nullable String name, @Nullable String mimeType, CreateFileOptions options) {
        return (Entity)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.createFileFromUpload(uploadId, name, mimeType, options));
    }

    @Override
    @Nonnull
    public Entity createFileFromUpload(String uploadId, CreateFileOptions options) {
        return (Entity)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.createFileFromUpload(uploadId, options));
    }

    @Override
    @Nonnull
    public Entity createFileFromChunks(List<Etag> etags, @Nullable String name, @Nullable String mimeType, CreateFileOptions options) {
        return (Entity)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.createFileFromChunks(etags, name, mimeType, options));
    }

    @Override
    @Nonnull
    public Entity createFileFromChunks(List<Etag> etags, CreateFileOptions options) {
        return (Entity)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.createFileFromChunks(etags, options));
    }
}

