/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.entity;

import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.entity.WithId;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Table(name="MIG_STEP")
@Entity
public class Step
extends WithId {
    @ManyToOne
    @JoinColumn(name="taskId", nullable=false)
    private Task task;
    @ManyToOne
    @JoinColumn(name="planId", nullable=false)
    private Plan plan;
    @Column(name="stepType", nullable=false)
    private String type;
    @Column(name="stepIndex", nullable=false)
    private int index;
    @Column(name="stepConfig", length=4000)
    private String config;
    @Column(name="node_id")
    private String nodeId;
    @Column(name="node_heartbeat")
    private Instant nodeHeartbeat;
    @Column(name="node_execution_id")
    private String nodeExecutionId;
    @Column(name="execution_state")
    private String executionState;
    @Embedded
    private Progress progress = Progress.created();

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
        this.plan = task.getPlan();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Progress getProgress() {
        return this.progress;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public Instant getNodeHeartbeat() {
        return this.nodeHeartbeat;
    }

    public void setNodeHeartbeat(Instant nodeHeartbeat) {
        this.nodeHeartbeat = nodeHeartbeat;
    }

    public String getNodeExecutionId() {
        return this.nodeExecutionId;
    }

    public void setNodeExecutionId(String nodeExecutionId) {
        this.nodeExecutionId = nodeExecutionId;
    }

    public String getExecutionState() {
        return this.executionState;
    }

    public void setExecutionState(String executionState) {
        this.executionState = executionState;
    }
}

