/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration;

import com.atlassian.sal.api.features.DarkFeatureManager;
import com.google.common.collect.ImmutableSet;

public class MigrationDarkFeaturesManager {
    public static final String PLUGIN_FLAG_PREFIX = "migration-assistant.";
    public static final String HANDLE_INVALID_DUPLICATE_EMAIL_USERS = "migration-assistant.handle-invalid-duplicate-email-users";
    public static final String ENABLE_NEW_SPACE_EXPORT = "migration-assistant.enable.new-space-export";
    public static final String ENABLE_XML_TO_CSV_MCS_UPLOAD = "migration-assistant.enable.xml-to-csv.mcs-upload";
    public static final String APP_MIGRATION_DEV_MODE = "migration-assistant.app-migration.dev-mode";
    public static final String ENABLE_EXPORT_CACHING = "migration-assistant.enable.export-caching";
    public static final String DISABLE_MISSING_ATTACHMENTS_CHECK = "migration-assistant.disable.missing-attachments-check";
    public static final String DISABLE_APP_OUTDATED_CHECK = "migration-assistant.disable.app-outdated-check";
    public static final String ENABLE_SPACE_FILTERS = "migration-assistant.enable.space-filters";
    public static final String ENABLE_TASK_LIST_FEATURE = "migration-assistant.enable.task-list.feature";
    public static final String ENABLE_EXPORT_ONLY = "migration-assistant.enable.export-only";
    public static final String ENABLE_UPLOAD_ONLY = "migration-assistant.enable.upload-only";
    public static final String DISABLE_SCOPED_USERS_GROUPS = "migration-assistant.disable.scoped-users-groups";
    public static final String SKIP_ATTACHMENTS_UPLOAD = "migration-assistant.skip.attachments.upload";
    public static final String PLAN_EDIT_FEATURES = "migration-assistant.plan.edit.features";
    public static final String SCOPED_USERS_GROUPS_MENTIONS = "migration-assistant.enable.scoped-users-groups-mentions";
    public static final String ENABLE_MIGRATION_HTTPS_PROXY = "migration-assistant.enable.migration.https.proxy";
    public static final String ENABLE_APP_VENDOR_CHECK = "migration-assistant.enable.app-vendor-check";
    public static final String ENABLE_APP_VENDOR_CHECK_FILTER = "enable.app-vendor-check-filter";
    public static final String DISABLE_SCHEDULER_FIXES = "migration-assistant.disable.scheduler.fixes";
    public static final String ENABLE_PROXY_VIA_EG = "migration-assistant.enable.proxy-via-eg";
    public static final String DISABLE_CHECKS_BEFORE_RUN = "migration-assistant.disable.checks-before-run";
    public static final String ENABLE_ORIGINAL_XML_EXPORT = "migration-assistant.enable.original-xml-export";
    public static final String DISABLE_INVALID_EMAILS_CHECK_VIA_UMS = "migration-assistant.disable.invalid-emails-check-via-ums";
    private final DarkFeatureManager darkFeatureManager;

    public MigrationDarkFeaturesManager(DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = darkFeatureManager;
    }

    private boolean isFeatureEnabled(String key) {
        return this.darkFeatureManager.isFeatureEnabledForAllUsers(key);
    }

    public ImmutableSet<String> getAllEnabledFeatures() {
        return this.darkFeatureManager.getFeaturesEnabledForAllUsers().getFeatureKeys();
    }

    public boolean appMigrationDevMode() {
        return this.isFeatureEnabled(APP_MIGRATION_DEV_MODE);
    }

    public boolean newExportEnabled() {
        return this.isFeatureEnabled(ENABLE_NEW_SPACE_EXPORT);
    }

    public boolean exportCachingEnabled() {
        return this.isFeatureEnabled(ENABLE_EXPORT_CACHING);
    }

    public boolean missingAttachmentsCheckDisabled() {
        return this.isFeatureEnabled(DISABLE_MISSING_ATTACHMENTS_CHECK);
    }

    public boolean appOutdatedCheckDisabled() {
        return this.isFeatureEnabled(DISABLE_APP_OUTDATED_CHECK);
    }

    public boolean spaceFiltersEnabled() {
        return this.isFeatureEnabled(ENABLE_SPACE_FILTERS);
    }

    public boolean isPlanEditFeaturesEnabled() {
        return this.isFeatureEnabled(PLAN_EDIT_FEATURES);
    }

    public boolean skipAttachmentUploadEnabled() {
        return this.isFeatureEnabled(SKIP_ATTACHMENTS_UPLOAD);
    }

    public boolean scopedUsersGroupsDisabled() {
        return this.isFeatureEnabled(DISABLE_SCOPED_USERS_GROUPS);
    }

    public boolean shouldHandleInvalidAndDuplicateEmailUsers() {
        return this.isFeatureEnabled(HANDLE_INVALID_DUPLICATE_EMAIL_USERS);
    }

    public boolean isExportOnlyEnabled() {
        return this.isFeatureEnabled(ENABLE_EXPORT_ONLY);
    }

    public boolean isXMLToCSVAndUploadToMCSEnabled() {
        return this.isFeatureEnabled(ENABLE_XML_TO_CSV_MCS_UPLOAD);
    }

    public boolean isTasklistFeatureEnabled() {
        return this.isFeatureEnabled(ENABLE_TASK_LIST_FEATURE);
    }

    public boolean isScopedUsersGroupsWithMentionsEnabled() {
        return this.isFeatureEnabled(SCOPED_USERS_GROUPS_MENTIONS);
    }

    public boolean appVendorCheckEnabled() {
        return this.isFeatureEnabled(ENABLE_APP_VENDOR_CHECK);
    }

    public boolean shouldProxyHttps() {
        return this.isFeatureEnabled(ENABLE_MIGRATION_HTTPS_PROXY);
    }

    public boolean isSchedulerFixEnabled() {
        return !this.isFeatureEnabled(DISABLE_SCHEDULER_FIXES);
    }

    public boolean appVendorChecksFilterEnabled() {
        return this.isFeatureEnabled(ENABLE_APP_VENDOR_CHECK_FILTER);
    }

    public boolean isUploadOnlyEnabled() {
        return this.isFeatureEnabled(ENABLE_UPLOAD_ONLY);
    }

    public boolean isProxyViaEnterpriseGatewayEnabled() {
        return this.isFeatureEnabled(ENABLE_PROXY_VIA_EG);
    }

    public boolean isPreflightChecksDisabledBeforeRun() {
        return this.isFeatureEnabled(DISABLE_CHECKS_BEFORE_RUN);
    }

    public boolean isEnableOriginalXMLExport() {
        return this.isFeatureEnabled(ENABLE_ORIGINAL_XML_EXPORT);
    }

    public boolean isDisabledInvalidEmailsCheckViaUms() {
        return this.isFeatureEnabled(DISABLE_INVALID_EMAILS_CHECK_VIA_UMS);
    }
}

