/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public enum ExecutionStatus {
    CREATED,
    VALIDATING,
    RUNNING,
    STOPPING,
    DONE,
    STOPPED,
    INCOMPLETE,
    FAILED;

    public static final Set<ExecutionStatus> COMPLETE_STATUSES;
    public static final Set<ExecutionStatus> UNSUCCESSFUL_STATUSES;
    private static final Map<ExecutionStatus, Set<ExecutionStatus>> TRANSITION_TABLE;
    private static final Set<ExecutionStatus> NONE;

    public boolean canGo(ExecutionStatus next) {
        return TRANSITION_TABLE.getOrDefault((Object)next, NONE).contains((Object)this);
    }

    public boolean isUnsuccessful() {
        return UNSUCCESSFUL_STATUSES.contains((Object)this);
    }

    public boolean isCompleted() {
        return COMPLETE_STATUSES.contains((Object)this);
    }

    static {
        COMPLETE_STATUSES = Sets.immutableEnumSet((Enum)DONE, (Enum[])new ExecutionStatus[]{STOPPED, FAILED, INCOMPLETE});
        UNSUCCESSFUL_STATUSES = Sets.immutableEnumSet((Enum)STOPPED, (Enum[])new ExecutionStatus[]{STOPPING, FAILED, INCOMPLETE});
        NONE = Collections.emptySet();
        TRANSITION_TABLE = ImmutableMap.builder().put((Object)CREATED, (Object)Sets.immutableEnumSet((Enum)VALIDATING, (Enum[])new ExecutionStatus[0])).put((Object)VALIDATING, (Object)Sets.immutableEnumSet((Enum)CREATED, (Enum[])new ExecutionStatus[0])).put((Object)RUNNING, (Object)Sets.immutableEnumSet((Enum)CREATED, (Enum[])new ExecutionStatus[]{VALIDATING})).put((Object)STOPPING, (Object)Sets.immutableEnumSet((Enum)CREATED, (Enum[])new ExecutionStatus[]{RUNNING, VALIDATING})).put((Object)DONE, (Object)Sets.immutableEnumSet((Enum)RUNNING, (Enum[])new ExecutionStatus[]{STOPPING})).put((Object)INCOMPLETE, (Object)Sets.immutableEnumSet((Enum)RUNNING, (Enum[])new ExecutionStatus[]{STOPPING})).put((Object)STOPPED, (Object)Sets.immutableEnumSet((Enum)CREATED, (Enum[])new ExecutionStatus[]{RUNNING, STOPPING})).put((Object)FAILED, (Object)Sets.immutableEnumSet((Enum)RUNNING, (Enum[])new ExecutionStatus[]{STOPPING, CREATED, VALIDATING})).build();
    }
}

