/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.migration.agent.entity.WorkItem;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import javax.persistence.LockModeType;

public class WorkItemStore {
    private static final String GROUP_ID = "groupId";
    private final EntityManagerTemplate tmpl;

    public WorkItemStore(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    public Long createWorkItem(WorkItem workItem) {
        this.tmpl.persist(workItem);
        return workItem.getItemId();
    }

    public WorkItem getAndLockWorkItemByRefId(String refId) {
        return this.tmpl.query(WorkItem.class, "select workitem from WorkItem workitem where workitem.refId=:refId").lock(LockModeType.PESSIMISTIC_WRITE).param("refId", (Object)refId).single();
    }

    public List<WorkItem> getBatchByType(String itemType, int batchSize) {
        return this.tmpl.query(WorkItem.class, "select workitem from WorkItem workitem where workitem.itemType=:itemType order by workitem.itemId asc").param("itemType", (Object)itemType).max(batchSize).list();
    }

    public void updateWorkItem(WorkItem workItem) {
        this.tmpl.merge(workItem);
    }

    public void deleteWorkItemByRefId(String refId) {
        this.tmpl.query("delete from WorkItem w where w.refId=:refId").param("refId", (Object)refId).flush(true).update();
    }

    public List<WorkItem> getWorkItemsByGroupId(String groupId) {
        return this.tmpl.query(WorkItem.class, "select w from WorkItem w where w.groupId=:groupId").param(GROUP_ID, (Object)groupId).list();
    }

    public List<WorkItem> getWorkItemsByGroupIdWithStatus(String groupId, WorkItem.Status status) {
        return this.tmpl.query(WorkItem.class, "select w from WorkItem w where w.groupId=:groupId and w.status=:status").param(GROUP_ID, (Object)groupId).param("status", (Object)status).list();
    }

    public void deleteWorkItemsByGroupId(String groupId) {
        this.tmpl.query("delete from WorkItem w where w.groupId=:groupId").param(GROUP_ID, (Object)groupId).update();
    }

    public void deleteWorkItemsByGroupIdWithStatus(String groupId, WorkItem.Status status) {
        this.tmpl.query("delete from WorkItem w where w.groupId=:groupId and w.status=:status").param(GROUP_ID, (Object)groupId).param("status", (Object)status).update();
    }

    public boolean hasItemsInGroup(String groupId) {
        return this.tmpl.query(WorkItem.class, "select w from WorkItem w where w.groupId=:groupId").param(GROUP_ID, (Object)groupId).first().isPresent();
    }
}

