/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space.helper;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.xerces.util.XMLChar;

public class FilteringXmlInputStreamReader
extends InputStreamReader {
    private final char replacement;

    public FilteringXmlInputStreamReader(InputStream is, char replacement) {
        super(is);
        this.replacement = replacement;
    }

    public FilteringXmlInputStreamReader(InputStream is, Charset charset, char replacement) {
        super(is, charset);
        this.replacement = replacement;
    }

    public FilteringXmlInputStreamReader(InputStream is, String charsetName, char replacement) throws UnsupportedEncodingException {
        super(is, charsetName);
        this.replacement = replacement;
    }

    public FilteringXmlInputStreamReader(InputStream is, CharsetDecoder cd, char replacement) {
        super(is, cd);
        this.replacement = replacement;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        if (result == -1 || !this.shouldReplace((char)result)) {
            return result;
        }
        return this.replacement;
    }

    @Override
    public int read(char[] cbuf, int offset, int length) throws IOException {
        int count = super.read(cbuf, offset, length);
        for (int i = offset; i < offset + count; ++i) {
            if (!this.shouldReplace(cbuf[i])) continue;
            cbuf[i] = this.replacement;
        }
        return count;
    }

    private boolean shouldReplace(char ch) {
        return XMLChar.isInvalid((int)ch) && !Character.isSurrogate(ch);
    }
}

