/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space.helper;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class FilteringUnicodeEncoder
extends CharsetEncoder {
    private static final String UTF16_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-16\"?>";
    private static final int MIN_OUTPUT_BUF_SIZE = 2;
    private static final int MIN_INPUT_BUFFER_SIZE = 6;
    private static final int BIT_SHIFT_VALUE = 8;
    private static final float AVERAGE_BYTES_PER_CHAR = 2.0f;
    private static final float MAX_BYTES_PER_CHAR = 4.0f;
    private boolean declarationReplaced = false;
    private boolean hasDeclaration = false;
    private boolean hasQuestionMark = false;

    public FilteringUnicodeEncoder(Charset charset, char replacement) {
        super(charset, 2.0f, 4.0f, new byte[]{(byte)(replacement >> 8), (byte)(replacement & 0xFF)});
    }

    private void put(char c, ByteBuffer dst) {
        dst.put((byte)(c >> 8));
        dst.put((byte)(c & 0xFF));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
        Integer[] mark = new Integer[]{src.position()};
        try {
            CoderResult result = this.replaceDeclaration(src, dst, mark);
            if (result != CoderResult.UNDERFLOW) {
                CoderResult coderResult = result;
                return coderResult;
            }
            CoderResult coderResultMalformedForLength = CoderResult.malformedForLength(1);
            while (src.hasRemaining()) {
                Object object;
                char c = src.get();
                if (!Character.isSurrogate(c)) {
                    if (dst.remaining() < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    Integer[] integerArray = mark;
                    object = integerArray[0];
                    Integer n = integerArray[0] = Integer.valueOf(integerArray[0] + 1);
                    this.put(c, dst);
                    continue;
                }
                if (Character.isHighSurrogate(c)) {
                    if (!src.hasRemaining()) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    char low = src.get();
                    if (!Character.isLowSurrogate(low)) {
                        object = coderResultMalformedForLength;
                        return object;
                    }
                    if (!this.addToDstBuffer(dst, mark, c, low)) continue;
                    object = CoderResult.OVERFLOW;
                    return object;
                }
                if (!Character.isLowSurrogate(c)) continue;
                CoderResult coderResult = coderResultMalformedForLength;
                return coderResult;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(mark[0]);
        }
    }

    private boolean addToDstBuffer(ByteBuffer dst, Integer[] mark, char c, char low) {
        if (dst.remaining() < 4) {
            return true;
        }
        Integer[] integerArray = mark;
        Integer.valueOf(integerArray[0] + 2);
        this.put(c, dst);
        this.put(low, dst);
        return false;
    }

    private void addDeclaration(ByteBuffer dst) {
        for (int i = 0; i < UTF16_DECLARATION.length(); ++i) {
            this.put(UTF16_DECLARATION.charAt(i), dst);
        }
    }

    private CoderResult replaceDeclaration(CharBuffer src, ByteBuffer dst, Integer[] mark) {
        if (!this.declarationReplaced) {
            this.checkDeclaration(src, mark);
            if (this.hasDeclaration) {
                if (this.isDstOverflow(src, dst, mark)) {
                    return CoderResult.OVERFLOW;
                }
            } else {
                if (dst.remaining() < UTF16_DECLARATION.length()) {
                    return CoderResult.OVERFLOW;
                }
                this.addDeclaration(dst);
                this.declarationReplaced = true;
            }
        }
        return CoderResult.UNDERFLOW;
    }

    private void checkDeclaration(CharBuffer src, Integer[] mark) {
        if (!this.hasDeclaration && this.isDeclaration(src)) {
            for (int i = 0; i < 6; ++i) {
                Integer[] integerArray = mark;
                Integer n = integerArray[0];
                Integer n2 = integerArray[0] = Integer.valueOf(integerArray[0] + 1);
                src.get();
            }
            this.hasDeclaration = true;
        }
    }

    private boolean isDstOverflow(CharBuffer src, ByteBuffer dst, Integer[] mark) {
        while (src.hasRemaining()) {
            Integer n;
            Integer n2;
            Integer[] integerArray;
            if (this.hasQuestionMark) {
                integerArray = mark;
                n2 = integerArray[0];
                n = integerArray[0] = Integer.valueOf(integerArray[0] + 1);
                if (src.get() == '>') {
                    if (dst.remaining() < UTF16_DECLARATION.length()) {
                        return true;
                    }
                    this.addDeclaration(dst);
                    this.declarationReplaced = true;
                    this.hasQuestionMark = false;
                    break;
                }
            }
            if (!src.hasRemaining()) continue;
            integerArray = mark;
            n2 = integerArray[0];
            n = integerArray[0] = Integer.valueOf(integerArray[0] + 1);
            this.hasQuestionMark = src.get() == '?';
        }
        return false;
    }

    private boolean isDeclaration(CharBuffer src) {
        if (src.remaining() < 6) {
            throw new IllegalArgumentException("Buffer size must be >= 6 to parse XML declaration properly");
        }
        return src.get(0) == '<' && src.get(1) == '?' && Character.toLowerCase(src.get(2)) == 'x' && Character.toLowerCase(src.get(3)) == 'm' && Character.toLowerCase(src.get(4)) == 'l' && Character.isWhitespace(src.get(5));
    }

    @Override
    protected void implReset() {
        this.declarationReplaced = false;
        this.hasDeclaration = false;
        this.hasQuestionMark = false;
    }

    @Override
    public boolean isLegalReplacement(byte[] repl) {
        return true;
    }

    @Override
    public boolean canEncode(char c) {
        return !Character.isSurrogate(c);
    }
}

